/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.table;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.db.model.Run;
import fr.profi.mzdb.db.table.RunTable;
import fr.profi.mzdb.io.reader.table.AbstractTableModelReader;
import fr.profi.mzdb.io.reader.table.ParamTreeParser;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordExtraction;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunReader
extends AbstractTableModelReader<Run> {
    final Logger logger = LoggerFactory.getLogger(RunReader.class);

    public RunReader(SQLiteConnection connection) throws SQLiteException {
        super(connection);
    }

    @Override
    protected ISQLiteRecordExtraction<Run> buildRecordExtractor() {
        return new ISQLiteRecordExtraction<Run>(){

            @Override
            public Run extract(SQLiteRecord r) throws SQLiteException {
                int id = r.columnInt(RunTable.ID);
                String name = r.columnString(RunTable.NAME);
                String startTimestampAsStr = r.columnString(RunTable.START_TIMESTAMP);
                Date startTimestamp = null;
                try {
                    startTimestamp = DateUtils.parseDate((String)startTimestampAsStr, (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'"});
                }
                catch (ParseException e) {
                    RunReader.this.logger.error("can't parse START_TIMESTAMP '" + startTimestampAsStr + "'in mzDB file: return current date");
                }
                String paramTreeAsStr = r.columnString(RunTable.PARAM_TREE);
                return new Run(id, name, startTimestamp, ParamTreeParser.parseParamTree(paramTreeAsStr));
            }
        };
    }

    public Run getRun(int id) throws SQLiteException {
        return (Run)this.getRecord("run", id);
    }

    public List<Run> getRunList() throws SQLiteException {
        return this.getRecordList("run");
    }
}

