/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.writer.mgf;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.db.model.params.IsolationWindowParamTree;
import fr.profi.mzdb.db.model.params.Precursor;
import fr.profi.mzdb.db.model.params.param.CVEntry;
import fr.profi.mzdb.db.model.params.param.CVParam;
import fr.profi.mzdb.db.model.params.param.UserParam;
import fr.profi.mzdb.io.writer.mgf.IPrecursorComputation;
import fr.profi.mzdb.io.writer.mgf.MgfHeader;
import fr.profi.mzdb.io.writer.mgf.PrecursorMzComputationEnum;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import fr.profi.mzdb.util.ms.MsUtils;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPrecursorComputer
implements IPrecursorComputation {
    final Logger logger = LoggerFactory.getLogger(DefaultPrecursorComputer.class);
    private PrecursorMzComputationEnum precComp;
    private float mzTolPPM;

    protected DefaultPrecursorComputer(float mzTolPPM) {
        this.mzTolPPM = mzTolPPM;
    }

    public DefaultPrecursorComputer(PrecursorMzComputationEnum precComp, float mzTolPPM) {
        this(mzTolPPM);
        this.precComp = precComp;
    }

    @Override
    public MgfHeader getMgfHeader(MzDbReader mzDbReader, SpectrumHeader spectrumHeader, String title) throws SQLiteException {
        float time = spectrumHeader.getElutionTime();
        double precMz = this.getPrecursorMz(mzDbReader, spectrumHeader);
        int charge = this.getPrecursorCharge(mzDbReader, spectrumHeader);
        MgfHeader mgfSpectrumHeader = charge != 0 ? new MgfHeader(title, precMz, charge, time) : new MgfHeader(title, precMz, time);
        return mgfSpectrumHeader;
    }

    @Override
    public String getParamName() {
        return this.precComp.getUserParamName();
    }

    @Override
    public int getPrecursorCharge(MzDbReader mzDbReader, SpectrumHeader spectrumHeader) throws SQLiteException {
        return spectrumHeader.getPrecursorCharge();
    }

    @Override
    public double getPrecursorMz(MzDbReader mzDbReader, SpectrumHeader spectrumHeader) throws SQLiteException {
        float time = spectrumHeader.getElutionTime();
        double precMz = spectrumHeader.getPrecursorMz();
        if (this.precComp == PrecursorMzComputationEnum.SELECTED_ION_MZ) {
            try {
                Precursor precursor = spectrumHeader.getPrecursor();
                precMz = precursor.parseFirstSelectedIonMz();
            }
            catch (Exception e) {
                this.logger.error("Selected ion m/z value not found: fall back to default spectrum header precursor mz");
            }
        } else if (this.precComp == PrecursorMzComputationEnum.REFINED) {
            try {
                Precursor precursor = spectrumHeader.getPrecursor();
                precMz = precursor.parseFirstSelectedIonMz();
                precMz = this.refinePrecMz(mzDbReader, precursor, precMz, this.mzTolPPM, time, 5.0f);
            }
            catch (Exception e) {
                this.logger.error("Refined precursor m/z computation failed: fall back to default spectrum header precursor mz");
            }
        } else if (this.precComp == PrecursorMzComputationEnum.REFINED_THERMO) {
            try {
                UserParam precMzParam;
                double refinedPrecMz;
                if (spectrumHeader.getScanList() == null) {
                    spectrumHeader.loadScanList(mzDbReader.getConnection());
                }
                if ((refinedPrecMz = Double.parseDouble((precMzParam = spectrumHeader.getScanList().getScans().get(0).getUserParam("[Thermo Trailer Extra]Monoisotopic M/Z:")).getValue())) > 0.0) {
                    precMz = refinedPrecMz;
                } else {
                    this.logger.warn("[Thermo Trailer Extra]Monoisotopic M/Z found but set to 0.0 : spectrum header precursor mz will be used");
                }
            }
            catch (NullPointerException e) {
                this.logger.error("Refined thermo value not found: fall back to default spectrum header precursor mz");
            }
        }
        return precMz;
    }

    protected double extractPrecMz(MzDbReader mzDbReader, Precursor precursor, double precMz, SpectrumHeader spectrumHeader, float timeTol) throws StreamCorruptedException, SQLiteException {
        long sid = spectrumHeader.getId();
        float time = spectrumHeader.getTime();
        SpectrumSlice[] spectrumSlices = mzDbReader.getMsSpectrumSlices(precMz - 1.0, precMz + 1.0, time - timeTol, time + timeTol);
        Spectrum nearestSpectrumSlice = null;
        for (SpectrumSlice sl : spectrumSlices) {
            if (nearestSpectrumSlice == null) {
                nearestSpectrumSlice = sl;
                continue;
            }
            if (!(Math.abs(sl.getHeader().getElutionTime() - time) < Math.abs(nearestSpectrumSlice.getHeader().getElutionTime() - time))) continue;
            nearestSpectrumSlice = sl;
        }
        Peak curPeak = nearestSpectrumSlice.getNearestPeak(precMz, this.mzTolPPM);
        if (curPeak == null) {
            return precMz;
        }
        ArrayList<Peak> previousPeaks = new ArrayList<Peak>();
        for (int putativeZ = 2; putativeZ <= 4; ++putativeZ) {
            double prevPeakMz = precMz + -1.0027 / (double)putativeZ;
            Peak prevPeak = nearestSpectrumSlice.getNearestPeak(prevPeakMz, this.mzTolPPM);
            if (prevPeak == null) continue;
            prevPeak.setLcContext(nearestSpectrumSlice.getHeader());
            double prevPeakExpMz = prevPeak.getMz();
            double approxZ = 1.0 / Math.abs(precMz - prevPeakExpMz);
            double approxMass = precMz * approxZ - approxZ * MsUtils.protonMass;
            if (!(approxMass > 2000.0) || !(approxMass < 7000.0)) continue;
            float minIntRatio = (float)(1400.0 / approxMass);
            float maxIntRatio = Math.min((float)(2800.0 / approxMass), 1.0f);
            float intRatio = prevPeak.getIntensity() / curPeak.getIntensity();
            if (!(intRatio > minIntRatio) || !(intRatio < maxIntRatio)) continue;
            boolean foundInterferencePeak = false;
            double interferencePeakMz = 0.0;
            for (int interferenceZ = 1; interferenceZ <= 6; ++interferenceZ) {
                Peak interferencePeak;
                if (interferenceZ == putativeZ || (interferencePeak = nearestSpectrumSlice.getNearestPeak(interferencePeakMz = prevPeakExpMz + 1.0027 / (double)interferenceZ, this.mzTolPPM)) == null || !(interferencePeak.getIntensity() > prevPeak.getIntensity())) continue;
                foundInterferencePeak = true;
                break;
            }
            if (!foundInterferencePeak) {
                this.logger.debug("Found better m/z value for precMz=" + precMz + " at spectrum id=" + sid + " with int ratio=" + intRatio + " and z=" + putativeZ + " : " + prevPeakExpMz);
                previousPeaks.add(prevPeak);
                continue;
            }
            this.logger.debug("Found interference m/z value for precMz=" + precMz + " at spectrum id=" + sid + " : " + interferencePeakMz);
        }
        int nbPrevPeaks = previousPeaks.size();
        if (nbPrevPeaks == 0) {
            return precMz;
        }
        Collections.sort(previousPeaks, Peak.getIntensityComp());
        Peak mostIntensePrevPeak = (Peak)previousPeaks.get(previousPeaks.size() - 1);
        return mostIntensePrevPeak.getMz();
    }

    protected Double refinePrecMz(MzDbReader mzDbReader, Precursor precursor, double precMz, double mzTolPPM, float time, float timeTol) throws StreamCorruptedException, SQLiteException {
        SpectrumSlice[] spectrumSlices = this._getSpectrumSlicesInIsolationWindow(mzDbReader, precursor, time, timeTol);
        if (spectrumSlices == null) {
            return null;
        }
        ArrayList<Peak> peaks = new ArrayList<Peak>();
        for (SpectrumSlice sl : spectrumSlices) {
            Peak p = sl.getNearestPeak(precMz, mzTolPPM);
            if (p == null) continue;
            p.setLcContext(sl.getHeader());
            peaks.add(p);
        }
        if (peaks.isEmpty()) {
            return null;
        }
        if (peaks.size() == 1) {
            return ((Peak)peaks.get(0)).getMz();
        }
        Collections.sort(peaks);
        double medMz = 0.0;
        int l = peaks.size();
        medMz = l % 2 != 0 ? ((Peak)peaks.get(l / 2)).getMz() : (((Peak)peaks.get(l / 2 - 1)).getMz() + ((Peak)peaks.get(l / 2)).getMz()) / 2.0;
        return medMz;
    }

    private SpectrumSlice[] _getSpectrumSlicesInIsolationWindow(MzDbReader mzDbReader, Precursor precursor, float time, float timeTol) throws StreamCorruptedException, SQLiteException {
        IsolationWindowParamTree iw = precursor.getIsolationWindow();
        if (iw == null) {
            return null;
        }
        CVEntry[] cvEntries = new CVEntry[]{CVEntry.ISOLATION_WINDOW_LOWER_OFFSET, CVEntry.ISOLATION_WINDOW_TARGET_MZ, CVEntry.ISOLATION_WINDOW_UPPER_OFFSET};
        CVParam[] cvParams = iw.getCVParams(cvEntries);
        float lowerMzOffset = Float.parseFloat(cvParams[0].getValue());
        float targetMz = Float.parseFloat(cvParams[1].getValue());
        float upperMzOffset = Float.parseFloat(cvParams[2].getValue());
        double minmz = targetMz - lowerMzOffset;
        double maxmz = targetMz + upperMzOffset;
        float minrt = time - timeTol;
        float maxrt = time + timeTol;
        return mzDbReader.getMsSpectrumSlices(minmz, maxmz, minrt, maxrt);
    }
}

