/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.writer.mgf;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.db.table.SpectrumTable;
import fr.profi.mzdb.io.reader.iterator.SpectrumIterator;
import fr.profi.mzdb.io.writer.mgf.DefaultPrecursorComputer;
import fr.profi.mzdb.io.writer.mgf.IPrecursorComputation;
import fr.profi.mzdb.io.writer.mgf.MgfField;
import fr.profi.mzdb.io.writer.mgf.MgfHeader;
import fr.profi.mzdb.io.writer.mgf.PrecursorMzComputationEnum;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.PeakEncoding;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordOperation;
import fr.profi.mzdb.util.sqlite.SQLiteQuery;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MgfWriter {
    public static String LINE_SPERATOR = System.getProperty("line.separator");
    private static Integer precNotFound = 0;
    final Logger logger = LoggerFactory.getLogger(MgfWriter.class);
    private static String titleQuery = "SELECT id, title FROM spectrum WHERE ms_level=?";
    private final String mzDBFilePath;
    private final int msLevel;
    private MzDbReader mzDbReader;
    private Map<Long, String> titleBySpectrumId = new HashMap<Long, String>();

    public MgfWriter(String mzDBFilePath, int msLevel) throws SQLiteException, FileNotFoundException, ClassNotFoundException {
        if (msLevel < 2 || msLevel > 3) {
            throw new IllegalArgumentException("msLevel must be 2 or 3");
        }
        this.mzDBFilePath = mzDBFilePath;
        this.msLevel = msLevel;
        this.mzDbReader = new MzDbReader(this.mzDBFilePath, true);
        this._fillTitleBySpectrumId();
        this.logger.info("Number of loaded spectra titles: " + this.titleBySpectrumId.size());
    }

    public MgfWriter(String mzDBFilePath) throws SQLiteException, FileNotFoundException, ClassNotFoundException {
        this(mzDBFilePath, 2);
    }

    public MzDbReader getMzDbReader() {
        return this.mzDbReader;
    }

    private void _fillTitleBySpectrumId() throws SQLiteException {
        final class TitleByIdFiller
        implements ISQLiteRecordOperation {
            private Map<Long, String> titleById;

            TitleByIdFiller(Map<Long, String> t) {
                this.titleById = t;
            }

            @Override
            public void execute(SQLiteRecord elem, int idx) throws SQLiteException {
                long id = elem.columnLong(SpectrumTable.ID);
                String title = elem.columnString(SpectrumTable.TITLE);
                this.titleById.put(id, title);
            }
        }
        TitleByIdFiller f = new TitleByIdFiller(this.titleBySpectrumId);
        new SQLiteQuery(this.mzDbReader.getConnection(), titleQuery).bind(1, this.msLevel).forEachRecord(f);
    }

    public void write(String mgfFile, PrecursorMzComputationEnum precComp, float mzTolPPM, float intensityCutoff, boolean exportProlineTitle) throws SQLiteException, IOException {
        this.write(mgfFile, new DefaultPrecursorComputer(precComp, mzTolPPM), intensityCutoff, exportProlineTitle);
    }

    public void write(String mgfFile, IPrecursorComputation precComp, float intensityCutoff, boolean exportProlineTitle) throws SQLiteException, IOException {
        if (mgfFile.isEmpty()) {
            mgfFile = this.mzDBFilePath + ".mgf";
        }
        precNotFound = 0;
        this.mzDbReader.enablePrecursorListLoading();
        this.mzDbReader.enableScanListLoading();
        SpectrumIterator spectrumIterator = new SpectrumIterator(this.mzDbReader, this.mzDbReader.getConnection(), this.msLevel);
        PrintWriter mgfWriter = new PrintWriter(new BufferedWriter(new FileWriter(mgfFile)));
        Map<Long, DataEncoding> dataEncodingBySpectrumId = this.mzDbReader.getDataEncodingBySpectrumId();
        int spectraCount = 0;
        while (spectrumIterator.hasNext()) {
            Spectrum s = (Spectrum)spectrumIterator.next();
            long spectrumId = s.getHeader().getId();
            DataEncoding dataEnc = dataEncodingBySpectrumId.get(spectrumId);
            String spectrumAsStr = this.stringifySpectrum(s, dataEnc, precComp, intensityCutoff, exportProlineTitle);
            mgfWriter.println(spectrumAsStr);
            mgfWriter.println();
            ++spectraCount;
        }
        this.logger.info(String.format("MGF file successfully created: %d spectra exported.", spectraCount));
        this.logger.info(String.format("#Precursor not found: %d", precNotFound));
        mgfWriter.flush();
        mgfWriter.close();
    }

    protected String stringifySpectrum(Spectrum spectrum, DataEncoding dataEnc, IPrecursorComputation precComp, float intensityCutoff, boolean exportProlineTitle) throws SQLiteException, StreamCorruptedException {
        String title;
        String mzFragFormat = null;
        mzFragFormat = dataEnc.getPeakEncoding() == PeakEncoding.LOW_RES_PEAK ? "%.1f" : "%.3f";
        SpectrumHeader spectrumHeader = spectrum.getHeader();
        if (!exportProlineTitle) {
            title = this.titleBySpectrumId.get(spectrumHeader.getSpectrumId());
        } else {
            float timeInMinutes = spectrumHeader.getTime() / 60.0f;
            title = String.format("first_cycle:%d;last_cycle:%d;first_scan:%d;last_scan:%d;first_time:%.3f;last_time:%.3f;raw_file_identifier:%s;", spectrumHeader.getCycle(), spectrumHeader.getCycle(), spectrumHeader.getInitialId(), spectrumHeader.getInitialId(), Float.valueOf(timeInMinutes), Float.valueOf(timeInMinutes), this.mzDbReader.getFirstSourceFileName().split("\\.")[0]);
        }
        MgfHeader mgfSpectrumHeader = precComp.getMgfHeader(this.mzDbReader, spectrumHeader, title);
        StringBuilder spectrumStringBuilder = new StringBuilder();
        mgfSpectrumHeader.appendToStringBuilder(spectrumStringBuilder);
        SpectrumData data = spectrum.getData();
        double[] mzs = data.getMzList();
        float[] ints = data.getIntensityList();
        int intsLength = ints.length;
        for (int i = 0; i < intsLength; ++i) {
            float intensity = ints[i];
            if (!(intensity >= intensityCutoff)) continue;
            double mz = mzs[i];
            spectrumStringBuilder.append(String.format(mzFragFormat, mz)).append(" ").append(String.format("%.0f", Float.valueOf(intensity))).append(LINE_SPERATOR);
        }
        spectrumStringBuilder.append((Object)MgfField.END_IONS);
        return spectrumStringBuilder.toString();
    }
}

