/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.db.model.AbstractTableModel;
import fr.profi.mzdb.db.model.params.Precursor;
import fr.profi.mzdb.db.model.params.ScanList;
import fr.profi.mzdb.io.reader.table.ParamTreeParser;
import fr.profi.mzdb.model.ILcContext;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordOperation;
import fr.profi.mzdb.util.sqlite.SQLiteQuery;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class SpectrumHeader
extends AbstractTableModel
implements ILcContext {
    protected final long id;
    protected final int initialId;
    protected final int cycle;
    protected final float time;
    protected final int msLevel;
    protected final int peaksCount;
    protected final boolean isHighResolution;
    protected final float tic;
    protected final double basePeakMz;
    protected final float basePeakIntensity;
    protected final double precursorMz;
    protected final int precursorCharge;
    protected final int bbFirstSpectrumId;
    protected ScanList scanList = null;
    protected Precursor precursor = null;
    public static Comparator<SpectrumHeader> rtComp = new Comparator<SpectrumHeader>(){

        @Override
        public int compare(SpectrumHeader o1, SpectrumHeader o2) {
            if (o1.time < o2.time) {
                return -1;
            }
            if ((double)Math.abs(o1.time - o2.time) < 1.0E-6) {
                return 0;
            }
            return 1;
        }
    };

    public SpectrumHeader(long id, int initialId, int cycle, float time, int msLevel, int peaksCount, boolean isHighResolution, float tic, double basePeakMz, float basePeakIntensity, double precursorMz, int precursorCharge, int firstBBSpectrumId) {
        super(id, null);
        this.id = id;
        this.initialId = initialId;
        this.cycle = cycle;
        this.time = time;
        this.msLevel = msLevel;
        this.peaksCount = peaksCount;
        this.isHighResolution = isHighResolution;
        this.tic = tic;
        this.basePeakMz = basePeakMz;
        this.basePeakIntensity = basePeakIntensity;
        this.precursorMz = precursorMz;
        this.precursorCharge = precursorCharge;
        this.bbFirstSpectrumId = firstBBSpectrumId;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public int getInitialId() {
        return this.initialId;
    }

    public int getCycle() {
        return this.cycle;
    }

    public float getTime() {
        return this.time;
    }

    public int getMsLevel() {
        return this.msLevel;
    }

    public int getPeaksCount() {
        return this.peaksCount;
    }

    public boolean isHighResolution() {
        return this.isHighResolution;
    }

    public double getBasePeakMz() {
        return this.basePeakMz;
    }

    public float getBasePeakIntensity() {
        return this.basePeakIntensity;
    }

    public double getPrecursorMz() {
        return this.precursorMz;
    }

    public int getPrecursorCharge() {
        return this.precursorCharge;
    }

    @Override
    public long getSpectrumId() {
        return this.id;
    }

    @Override
    public float getElutionTime() {
        return this.time;
    }

    public int getBBFirstSpectrumId() {
        return this.bbFirstSpectrumId;
    }

    public ScanList getScanList() {
        return this.scanList;
    }

    public void setScanList(ScanList scanList) {
        this.scanList = scanList;
    }

    public Precursor getPrecursor() {
        return this.precursor;
    }

    public void setPrecursor(Precursor precursor) {
        this.precursor = precursor;
    }

    public float getTIC() {
        return this.tic;
    }

    private static Map<Long, String> _loadXmlFieldBySpectrumId(String sqlString, SQLiteConnection mzDbConnection) {
        final HashMap<Long, String> xmlFieldBySpecId = new HashMap<Long, String>();
        try {
            SQLiteQuery query = new SQLiteQuery(mzDbConnection, sqlString);
            final SQLiteStatement stmt = query.getStatement();
            query.forEachRecord(new ISQLiteRecordOperation(){

                @Override
                public void execute(SQLiteRecord elem, int idx) throws SQLiteException {
                    long id = stmt.columnLong(0);
                    String xmlField = stmt.columnString(1);
                    xmlFieldBySpecId.put(id, xmlField);
                }
            });
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
        return xmlFieldBySpecId;
    }

    public static void loadParamTrees(SpectrumHeader[] spectrumHeaders, SQLiteConnection mzDbConnection) {
        String sqlString = "SELECT id, param_tree FROM spectrum";
        Map<Long, String> paramTreeBySpecId = SpectrumHeader._loadXmlFieldBySpectrumId(sqlString, mzDbConnection);
        for (SpectrumHeader header : spectrumHeaders) {
            String paramTreeAsStr;
            if (header.hasParamTree() || (paramTreeAsStr = paramTreeBySpecId.get(header.getId())) == null) continue;
            header.paramTree = ParamTreeParser.parseParamTree(paramTreeAsStr);
        }
    }

    public static void loadScanLists(SpectrumHeader[] spectrumHeaders, SQLiteConnection mzDbConnection) {
        String sqlString = "SELECT id, scan_list FROM spectrum";
        Map<Long, String> scanListBySpecId = SpectrumHeader._loadXmlFieldBySpectrumId(sqlString, mzDbConnection);
        for (SpectrumHeader header : spectrumHeaders) {
            String scanListAsStr;
            if (header.scanList != null || (scanListAsStr = scanListBySpecId.get(header.getId())) == null) continue;
            header.scanList = ParamTreeParser.parseScanList(scanListAsStr);
        }
    }

    public static void loadPrecursors(SpectrumHeader[] spectrumHeaders, SQLiteConnection mzDbConnection) {
        String sqlString = "SELECT id, precursor_list FROM spectrum";
        Map<Long, String> precursorBySpecId = SpectrumHeader._loadXmlFieldBySpectrumId(sqlString, mzDbConnection);
        for (SpectrumHeader header : spectrumHeaders) {
            String precursorAsStr;
            if (header.precursor != null || (precursorAsStr = precursorBySpecId.get(header.getId())) == null) continue;
            header.precursor = ParamTreeParser.parsePrecursor(precursorAsStr);
        }
    }

    @Override
    public void loadParamTree(SQLiteConnection mzDbConnection) throws SQLiteException {
        if (!this.hasParamTree()) {
            String paramTreeAsStr = this.getParamTreeAsString(mzDbConnection);
            this.paramTree = ParamTreeParser.parseParamTree(paramTreeAsStr);
        }
    }

    @Override
    public String getParamTreeAsString(SQLiteConnection mzDbConnection) throws SQLiteException {
        String sqlString = "SELECT param_tree FROM spectrum WHERE id = ?";
        return new SQLiteQuery(mzDbConnection, sqlString).bind(1, this.getId()).extractSingleString();
    }

    public void loadScanList(SQLiteConnection mzDbConnection) throws SQLiteException {
        if (this.scanList == null) {
            String scanListAsStr = this.getScanListAsString(mzDbConnection);
            this.scanList = ParamTreeParser.parseScanList(scanListAsStr);
        }
    }

    public String getScanListAsString(SQLiteConnection mzDbConnection) throws SQLiteException {
        String sqlString = "SELECT scan_list FROM spectrum WHERE id = ?";
        return new SQLiteQuery(mzDbConnection, sqlString).bind(1, this.getId()).extractSingleString();
    }

    public void loadPrecursorList(SQLiteConnection mzDbConnection) throws SQLiteException {
        if (this.precursor == null) {
            String precursorListAsStr = this.getPrecursorListAsString(mzDbConnection);
            this.precursor = ParamTreeParser.parsePrecursor(precursorListAsStr);
        }
    }

    public String getPrecursorListAsString(SQLiteConnection mzDbConnection) throws SQLiteException {
        String sqlString = "SELECT precursor_list FROM spectrum WHERE id = ?";
        String precursorListAsStr = new SQLiteQuery(mzDbConnection, sqlString).bind(1, this.getId()).extractSingleString();
        return precursorListAsStr;
    }
}

