/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.util.threading;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class Executor {
    private ExecutorService pool;
    private Callable<Object>[] callables = null;
    private Runnable[] runnables = null;
    private List<Future<Object>> futures = new ArrayList<Future<Object>>();

    public Executor(Callable<Object>[] r, int core) {
        this.pool = Executors.newFixedThreadPool(core);
        this.callables = r;
    }

    public Executor(Runnable[] r, int core) {
        this.pool = Executors.newFixedThreadPool(core);
        this.runnables = r;
    }

    public List<Object> getResults() throws InterruptedException, ExecutionException {
        for (Callable<Object> t : this.callables) {
            Future<Object> f = this.pool.submit(t);
            this.futures.add(f);
        }
        this.pool.shutdown();
        ArrayList<Object> r = new ArrayList<Object>(this.futures.size());
        for (Future<Object> future : this.futures) {
            r.add(future.get());
        }
        return r;
    }

    public void start() throws InterruptedException {
        for (Runnable t : this.runnables) {
            this.pool.execute(t);
        }
        this.pool.shutdown();
        while (!this.pool.awaitTermination(1L, TimeUnit.SECONDS)) {
            System.out.println("Waiting for tasks to shutdown");
        }
    }
}

