/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.Bundle;
import org.openide.loaders.DataFolder;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class OpenProjectFolderAction
extends AbstractAction
implements ContextAwareAction {
    private static final RequestProcessor RP = new RequestProcessor(OpenProjectFolderAction.class);

    public OpenProjectFolderAction() {
        super(Bundle.OpenProjectFolderAction_LBL_action());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup context) {
        return new ContextAction(context);
    }

    private static final class ContextAction
    extends AbstractAction {
        private final Lookup context;

        public ContextAction(Lookup context) {
            super(Bundle.OpenProjectFolderAction_LBL_action());
            this.context = context;
            boolean foundProject = false;
            for (DataFolder d : context.lookupAll(DataFolder.class)) {
                if (!ProjectManager.getDefault().isProject(d.getPrimaryFile())) continue;
                foundProject = true;
                break;
            }
            if (!foundProject) {
                this.putValue("hideWhenDisabled", true);
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    HashSet<Project> projects = new HashSet<Project>();
                    for (DataFolder d : ContextAction.this.context.lookupAll(DataFolder.class)) {
                        try {
                            Project p = ProjectManager.getDefault().findProject(d.getPrimaryFile());
                            if (p == null) continue;
                            projects.add(p);
                        }
                        catch (IOException x) {
                            Logger.getLogger(OpenProjectFolderAction.class.getName()).log(Level.INFO, null, x);
                        }
                    }
                    OpenProjectList.getDefault().open(projects.toArray(new Project[projects.size()]), false, true);
                }
            });
        }
    }
}

