/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq;

import fr.proline.core.orm.uds.ExternalDb;
import fr.proline.core.orm.uds.repository.ExternalDbRepository;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.module.seq.config.DBProlineConfig;
import fr.proline.repository.ConnectionMode;
import fr.proline.repository.DatabaseConnectorFactory;
import fr.proline.repository.DatabaseUpgrader;
import fr.proline.repository.DriverType;
import fr.proline.repository.IDataStoreConnectorFactory;
import fr.proline.repository.IDatabaseConnector;
import fr.proline.repository.ProlineDatabaseType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseAccess {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseAccess.class);
    private static final String SEQ_DB_NAME = "seq_db";
    private static final Object INITIALIZATION_LOCK = new Object();
    private static IDataStoreConnectorFactory connectorFactory;
    private static IDatabaseConnector seqDatabaseConnector;

    private DatabaseAccess() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDataStoreConnectorFactory() {
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            DStoreCustomPoolConnectorFactory result = DStoreCustomPoolConnectorFactory.getInstance();
            if (!result.isInitialized()) {
                DBProlineConfig.forcePropertiesFileReload();
                Map<Object, Object> udsDbConfigProperties = DBProlineConfig.getInstance().getUDSProperties();
                if (udsDbConfigProperties.isEmpty()) {
                    throw new IllegalArgumentException("No valid UDS Db Properties");
                }
                Integer maxPoolConnection = DBProlineConfig.getInstance().getMaxPoolConnection();
                udsDbConfigProperties.put("proline.project.max.pool.connection", maxPoolConnection);
                LOG.debug("Initializing DataStoreConnectorFactory using properties [{}] ", udsDbConfigProperties);
                result.initialize(udsDbConfigProperties, "SequenceRepository");
            }
            connectorFactory = result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDataStoreConnectorFactory getDataStoreConnectorFactory() {
        IDataStoreConnectorFactory result;
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            if (connectorFactory == null) {
                DatabaseAccess.initDataStoreConnectorFactory();
            }
            result = connectorFactory;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDataStoreConnectorFactory getDataStoreConnectorFactory(Map<Object, Object> udsDbProperties) {
        DStoreCustomPoolConnectorFactory result = null;
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            if (connectorFactory == null) {
                result = DStoreCustomPoolConnectorFactory.getInstance();
                if (!result.isInitialized()) {
                    if (udsDbProperties == null || udsDbProperties.isEmpty()) {
                        throw new IllegalArgumentException("No valid UDS Db Properties");
                    }
                    if (!udsDbProperties.containsKey("proline.project.max.pool.connection")) {
                        Integer maxPoolConnection = DBProlineConfig.getInstance().getMaxPoolConnection();
                        udsDbProperties.put("proline.project.max.pool.connection", maxPoolConnection);
                    }
                    LOG.debug("Initializing DataStoreConnectorFactory from [{}] properties", udsDbProperties);
                    result.initialize(udsDbProperties, "SequenceRepository");
                } else {
                    LOG.warn("DataStoreConnectorFactory was already initialized. Properties [{}] was ignore", udsDbProperties);
                }
                connectorFactory = result;
            } else {
                LOG.warn("DataStoreConnectorFactory was already initialized. Properties [{}] was ignore", udsDbProperties);
                result = connectorFactory;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeSEQDatabaseConnector() {
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            if (seqDatabaseConnector != null) {
                seqDatabaseConnector.close();
                seqDatabaseConnector = null;
                connectorFactory = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDatabaseConnector getSEQDatabaseConnector(boolean allowCreateUpdateDB) {
        IDatabaseConnector result = null;
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            if (seqDatabaseConnector == null) {
                seqDatabaseConnector = result = DatabaseAccess.createSEQDatabaseConnector(allowCreateUpdateDB, null);
            } else {
                result = seqDatabaseConnector;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDatabaseConnector getSEQDatabaseConnector(boolean allowCreateUpdateDB, Map<Object, Object> udsDbProperties) {
        IDatabaseConnector result = null;
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            if (seqDatabaseConnector == null) {
                seqDatabaseConnector = result = DatabaseAccess.createSEQDatabaseConnector(allowCreateUpdateDB, udsDbProperties);
            } else {
                result = seqDatabaseConnector;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDatabaseConnector createSEQDatabaseConnector(boolean allowCreateUpdateDB, Map<Object, Object> udsDbProperties) {
        IDatabaseConnector seqDbConnector;
        block13: {
            seqDbConnector = null;
            IDataStoreConnectorFactory dataStoreConnectorFactory = null;
            dataStoreConnectorFactory = udsDbProperties != null && !udsDbProperties.isEmpty() ? DatabaseAccess.getDataStoreConnectorFactory(udsDbProperties) : DatabaseAccess.getDataStoreConnectorFactory();
            IDatabaseConnector udsDbConnector = dataStoreConnectorFactory.getUdsDbConnector();
            EntityManager udsEM = udsDbConnector.createEntityManager();
            try {
                int retDBUpgrade;
                ExternalDb seqDb = ExternalDbRepository.findExternalByType((EntityManager)udsEM, (ProlineDatabaseType)ProlineDatabaseType.SEQ);
                if (seqDb == null) {
                    if (allowCreateUpdateDB) {
                        LOG.info("No ExternalDb for SEQ Db creating a new one");
                        try {
                            seqDbConnector = DatabaseAccess.createSEQDatabase(udsDbConnector, udsEM);
                            break block13;
                        }
                        catch (SQLException e) {
                            throw new RuntimeException("Error creating SEQ Db " + e);
                        }
                    }
                    throw new RuntimeException("SEQ Db does not exist");
                }
                boolean cheksumrepair = false;
                Map dbProperties = seqDb.toPropertiesMap(udsDbConnector.getDriverType(), (String)udsDbConnector.getProperty((Object)"javax.persistence.jdbc.user"), (String)udsDbConnector.getProperty((Object)"javax.persistence.jdbc.password"));
                Integer maxPoolConnection = DBProlineConfig.getInstance().getMaxPoolConnection();
                dbProperties.put("proline.project.max.pool.connection", maxPoolConnection);
                seqDbConnector = DatabaseConnectorFactory.createDatabaseConnectorInstance((ProlineDatabaseType)ProlineDatabaseType.SEQ, (Map)dbProperties);
                if (allowCreateUpdateDB && (retDBUpgrade = DatabaseUpgrader.upgradeDatabase((IDatabaseConnector)seqDbConnector, (boolean)cheksumrepair)) < 0) {
                    throw new RuntimeException("Error accessing Seq DB for upgrade");
                }
            }
            finally {
                if (udsEM != null) {
                    try {
                        udsEM.close();
                    }
                    catch (Exception exClose) {
                        LOG.error("Error closing UDS Db EntityManager", (Throwable)exClose);
                    }
                }
            }
        }
        return seqDbConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDatabaseConnector createSEQDatabase(IDatabaseConnector udsDbConnector, EntityManager udsEM) throws SQLException {
        ExternalDb seqDb = null;
        EntityTransaction udsTransac = null;
        boolean transacOK = false;
        try {
            udsTransac = udsEM.getTransaction();
            udsTransac.begin();
            transacOK = false;
            DriverType udsDriverType = udsDbConnector.getDriverType();
            if (udsDriverType == DriverType.H2) {
                ConnectionMode mode = DBProlineConfig.getInstance().getUDSConnectionMode();
                String path = "";
                switch (mode) {
                    case FILE: {
                        path = DBProlineConfig.getInstance().getDbPath();
                    }
                }
                seqDb = DatabaseAccess.createSEQDb(udsEM, path + SEQ_DB_NAME);
            } else if (udsDriverType == DriverType.POSTGRESQL) {
                boolean success = DatabaseAccess.createPgSEQDatabase(udsDbConnector);
                if (success) {
                    seqDb = DatabaseAccess.createSEQDb(udsEM, SEQ_DB_NAME);
                } else {
                    LOG.error("Unable to create Postgres SEQ Databank");
                }
            } else {
                LOG.error("Unsupported SGBD type {}", (Object)udsDriverType);
            }
            udsTransac.commit();
            transacOK = true;
        }
        finally {
            if (udsTransac != null && !transacOK) {
                try {
                    udsTransac.rollback();
                }
                catch (Exception ex) {
                    LOG.error("Error rollbacking UDS Db EntityManager Transaction", (Throwable)ex);
                }
            }
        }
        IDatabaseConnector seqDbConnector = null;
        boolean cheksumrepair = false;
        if (transacOK && seqDb != null) {
            Map dbProperties = seqDb.toPropertiesMap((String)udsDbConnector.getProperty((Object)"javax.persistence.jdbc.user"), (String)udsDbConnector.getProperty((Object)"javax.persistence.jdbc.password"));
            Integer maxPoolConnection = DBProlineConfig.getInstance().getMaxPoolConnection();
            dbProperties.put("proline.project.max.pool.connection", maxPoolConnection);
            seqDbConnector = DatabaseConnectorFactory.createDatabaseConnectorInstance((ProlineDatabaseType)ProlineDatabaseType.SEQ, (Map)dbProperties);
            DatabaseUpgrader.upgradeDatabase((IDatabaseConnector)seqDbConnector, (boolean)cheksumrepair);
        }
        return seqDbConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createPgSEQDatabase(IDatabaseConnector udsDbConnector) throws SQLException {
        boolean success = false;
        Connection sqlCon = null;
        try {
            DataSource ds = udsDbConnector.getDataSource();
            sqlCon = ds.getConnection();
            long count = DatabaseAccess.countExistingSEQDb(sqlCon);
            if (count > 0L) {
                LOG.info("{} already existing", (Object)SEQ_DB_NAME);
                success = true;
            } else {
                Statement stmt = sqlCon.createStatement();
                int result = stmt.executeUpdate("CREATE DATABASE seq_db");
                stmt.close();
                if (result >= 0) {
                    LOG.info("New Postgres {} database created", (Object)SEQ_DB_NAME);
                    success = true;
                } else {
                    LOG.error("Error creating Postgres SEQ Databank : {}", (Object)result);
                }
            }
        }
        finally {
            if (sqlCon != null) {
                try {
                    sqlCon.close();
                }
                catch (SQLException exClose) {
                    success = false;
                    LOG.error("Error closing UDS Db SQL Connection", (Throwable)exClose);
                }
            }
        }
        return success;
    }

    private static ExternalDb createSEQDb(EntityManager udsEM, String dbName) {
        ExternalDb seqDb = DBProlineConfig.getInstance().getExternalDBTemplate();
        seqDb.setDbName(dbName);
        seqDb.setDbVersion("V0.2");
        seqDb.setType(ProlineDatabaseType.SEQ);
        udsEM.persist((Object)seqDb);
        LOG.debug("New SEQ ExternalDb persisted");
        return seqDb;
    }

    private static long countExistingSEQDb(Connection sqlCon) throws SQLException {
        Object obj;
        long result = -1L;
        PreparedStatement stmt = sqlCon.prepareStatement("SELECT COUNT (*) FROM pg_database WHERE UPPER(datname) = ?");
        stmt.setString(1, SEQ_DB_NAME.toUpperCase());
        ResultSet rs = stmt.executeQuery();
        if (rs.next() && (obj = rs.getObject(1)) instanceof Number) {
            result = ((Number)obj).longValue();
        }
        stmt.close();
        return result;
    }
}

