/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.jms;

import fr.profi.util.ThreadLogger;
import fr.proline.jms.ServiceRegistry;
import fr.proline.jms.ServiceRunner;
import fr.proline.jms.service.api.IRemoteServiceIdentity;
import fr.proline.jms.util.IServiceMonitoringNotifier;
import fr.proline.jms.util.JMSConstants;
import fr.proline.jms.util.MonitoringTopicPublisherRunner;
import fr.proline.jms.util.NodeConfig;
import fr.proline.module.seq.DatabaseAccess;
import fr.proline.module.seq.jms.service.RetrieveJMSService;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.jms.HornetQJMSClient;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunNode {
    private static Integer EXECUTOR_SHUTDOWN_TIMEOUT = 30;
    private static final Logger LOG = LoggerFactory.getLogger(RunNode.class);
    private static final Object m_lock = new Object();
    private String m_jmsServerHost = null;
    private Integer m_jmsServerPort = null;
    private Connection m_connection = null;
    private ExecutorService m_executor = null;

    public RunNode(String jmsHost, Integer jmsPort) {
        assert (jmsHost != null) : "Invalid JMS Server Host name or address";
        assert (0 < jmsPort && jmsPort <= JMSConstants.MAX_JMS_SERVER_PORT()) : "Invalid JMS Server port";
        this.m_jmsServerHost = jmsHost;
        this.m_jmsServerPort = jmsPort;
    }

    public static void main(String[] args) {
        Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadLogger(LOG.getName()));
        RunNode runner = new RunNode(NodeConfig.getJMSServerHost(), NodeConfig.getJMSServerPort());
        runner.addShutdownHook(runner);
        runner.startJMSConsumers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startJMSConsumers() {
        Object object = m_lock;
        synchronized (object) {
            if (this.m_connection != null) {
                throw new IllegalStateException("JMS Consumers already started !");
            }
            try {
                Queue serviceRequestQueue = HornetQJMSClient.createQueue((String)NodeConfig.PROLINE_SERVICE_REQUEST_QUEUE_NAME());
                LOG.debug("JMS Queue : " + serviceRequestQueue);
                HashMap<String, Object> connectionParams = new HashMap<String, Object>();
                connectionParams.put("host", this.m_jmsServerHost);
                connectionParams.put("port", this.m_jmsServerPort);
                TransportConfiguration transportConfiguration = new TransportConfiguration(NettyConnectorFactory.class.getName(), connectionParams);
                HornetQConnectionFactory cf = HornetQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
                this.m_connection = cf.createConnection();
                ExceptionListener exceptionListener = new ExceptionListener(){

                    public void onException(JMSException exception) {
                        LOG.error("Asynchronous JMS Connection problem", (Throwable)exception);
                    }
                };
                this.m_connection.setExceptionListener(exceptionListener);
                LOG.info("This Node Id : " + NodeConfig.NODE_ID());
                DatabaseAccess.initDataStoreConnectorFactory();
                DatabaseAccess.getSEQDatabaseConnector(true);
                this.initServices();
                this.m_executor = Executors.newCachedThreadPool();
                MonitoringTopicPublisherRunner serviceMonitoringNotifier = new MonitoringTopicPublisherRunner(this.m_connection);
                this.m_executor.submit((Runnable)serviceMonitoringNotifier);
                LOG.debug("Starting " + NodeConfig.SERVICE_THREAD_POOL_SIZE() + " Parallelizable ServiceRunners");
                for (int i = 0; i < NodeConfig.SERVICE_THREAD_POOL_SIZE(); ++i) {
                    ServiceRunner parallelizableSeviceRunner = new ServiceRunner(serviceRequestQueue, this.m_connection, (IServiceMonitoringNotifier)serviceMonitoringNotifier, true);
                    this.m_executor.submit((Runnable)parallelizableSeviceRunner);
                }
                this.m_connection.start();
                LOG.debug("JMS Connection : " + this.m_connection + "  started");
            }
            catch (Exception ex) {
                LOG.error("Error starting JMS Consumers", (Throwable)ex);
                this.stopJMSConsumers();
            }
        }
    }

    private void addShutdownHook(final RunNode server) {
        assert (server != null) : "addShutdownHook() server is null";
        Runnable target = new Runnable(){

            @Override
            public void run() {
                LOG.debug("Stopping JMS Consumers for SeqRepository");
                server.stopJMSConsumers();
            }
        };
        Thread thr = new Thread(target, "Thread-shutdownJMSConsumers");
        thr.setPriority(5);
        thr.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadLogger(LOG.getName()));
        Runtime.getRuntime().addShutdownHook(thr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopJMSConsumers() {
        Object object = m_lock;
        synchronized (object) {
            if (this.m_connection != null) {
                LOG.debug("Closing JMS Connection");
                try {
                    this.m_connection.close();
                    LOG.info("JMS Connection closed");
                }
                catch (JMSException exClose) {
                    LOG.error("Error closing JMS Connection", (Throwable)exClose);
                }
            }
            if (this.m_executor != null) {
                LOG.debug("Stopping JMS Consumers Executor");
                this.m_executor.shutdown();
                LOG.debug("Waiting " + EXECUTOR_SHUTDOWN_TIMEOUT + " seconds for Executor termination...");
                try {
                    if (this.m_executor.awaitTermination(EXECUTOR_SHUTDOWN_TIMEOUT.intValue(), TimeUnit.SECONDS)) {
                        LOG.info("JMS Consumers Executor terminated");
                    } else {
                        List<Runnable> remainingRunnables = this.m_executor.shutdownNow();
                        LOG.info("JMS Consumers Executor terminated remain " + remainingRunnables.size() + " never commenced Runnable(s)");
                    }
                }
                catch (InterruptedException intEx) {
                    LOG.warn("ExecutorService.awaitTermination() interrupted", (Throwable)intEx);
                }
            }
            LOG.info("JMS Consumers stopped");
        }
    }

    private void initServices() {
        ServiceRegistry.addService((IRemoteServiceIdentity)new RetrieveJMSService());
    }
}

