/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.orm.dao;

import fr.profi.util.StringUtils;
import fr.proline.module.seq.orm.Databank;
import fr.proline.module.seq.orm.DatabankInstance;
import fr.proline.module.seq.orm.ParsingRule;
import fr.proline.module.seq.util.DatabankInstanceComparator;
import fr.proline.repository.util.JPAUtils;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;

public final class DatabankDao {
    public static Databank findSEDbByName(EntityManager seqEM, String name) {
        JPAUtils.checkEntityManager((EntityManager)seqEM);
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Invalid name");
        }
        Databank result = null;
        TypedQuery query = seqEM.createNamedQuery("findSEDbByName", Databank.class);
        query.setParameter("name", (Object)name);
        List seDbs = query.getResultList();
        if (seDbs != null && !seDbs.isEmpty()) {
            if (seDbs.size() == 1) {
                result = (Databank)seDbs.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one Databank for given name");
            }
        }
        return result;
    }

    public static ParsingRule findParsingRuleByName(EntityManager seqEM, String name) {
        JPAUtils.checkEntityManager((EntityManager)seqEM);
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Invalid name");
        }
        ParsingRule result = null;
        TypedQuery query = seqEM.createNamedQuery("findParsingRuleByName", ParsingRule.class);
        query.setParameter("name", (Object)name);
        List rules = query.getResultList();
        if (rules != null && !rules.isEmpty()) {
            if (rules.size() == 1) {
                result = (ParsingRule)rules.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one ParsingRule for given name");
            }
        }
        return result;
    }

    public static List<DatabankInstance> findSEDbInstanceBySEDbName(EntityManager seqEM, String seDbName) {
        JPAUtils.checkEntityManager((EntityManager)seqEM);
        if (StringUtils.isEmpty((String)seDbName)) {
            throw new IllegalArgumentException("Invalid seDbName");
        }
        List<DatabankInstance> result = null;
        TypedQuery query = seqEM.createNamedQuery("findSEDbInstanceBySEDbName", DatabankInstance.class);
        query.setParameter("seDbName", (Object)seDbName);
        List seDbInstances = query.getResultList();
        if (seDbInstances != null && !seDbInstances.isEmpty()) {
            DatabankInstance[] sortedInstances = seDbInstances.toArray(new DatabankInstance[seDbInstances.size()]);
            DatabankInstanceComparator comparator = new DatabankInstanceComparator();
            Arrays.sort(sortedInstances, comparator);
            result = Arrays.asList(sortedInstances);
        }
        return result;
    }

    public static List<DatabankInstance> findSEDbInstanceByNameAndSourcePath(EntityManager seqEM, String seDbName, String sourcePath) {
        JPAUtils.checkEntityManager((EntityManager)seqEM);
        if (StringUtils.isEmpty((String)seDbName)) {
            throw new IllegalArgumentException("Invalid seDbName");
        }
        if (StringUtils.isEmpty((String)sourcePath)) {
            throw new IllegalArgumentException("Invalid sourcePath");
        }
        List<DatabankInstance> result = null;
        TypedQuery query = seqEM.createNamedQuery("findSEDbInstanceByNameAndSourcePath", DatabankInstance.class);
        query.setParameter("seDbName", (Object)seDbName);
        query.setParameter("sourcePath", (Object)sourcePath);
        List seDbInstances = query.getResultList();
        if (seDbInstances != null && !seDbInstances.isEmpty()) {
            DatabankInstance[] sortedInstances = seDbInstances.toArray(new DatabankInstance[seDbInstances.size()]);
            DatabankInstanceComparator comparator = new DatabankInstanceComparator();
            Arrays.sort(sortedInstances, comparator);
            result = Arrays.asList(sortedInstances);
        }
        return result;
    }

    public static DatabankInstance findSEDbInstanceByNameAndRelease(EntityManager seqEM, String seDbName, String release) {
        JPAUtils.checkEntityManager((EntityManager)seqEM);
        if (StringUtils.isEmpty((String)seDbName)) {
            throw new IllegalArgumentException("Invalid seDbName");
        }
        if (StringUtils.isEmpty((String)release)) {
            throw new IllegalArgumentException("Invalid release");
        }
        DatabankInstance result = null;
        TypedQuery query = seqEM.createNamedQuery("findSEDbInstanceByNameAndRelease", DatabankInstance.class);
        query.setParameter("seDbName", (Object)seDbName);
        query.setParameter("release", (Object)release);
        List seDbInstances = query.getResultList();
        if (seDbInstances != null && !seDbInstances.isEmpty()) {
            if (seDbInstances.size() == 1) {
                result = (DatabankInstance)seDbInstances.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one ParsingRule for given name");
            }
        }
        return result;
    }
}

