/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.util;

import java.util.HashMap;
import org.slf4j.Logger;

public class Counters {
    private HashMap<String, int[]> intCounters = new HashMap();
    private String name;

    public Counters(String name) {
        this.name = name;
    }

    public void inc(String a) {
        int[] valueWrapper = this.intCounters.get(a);
        if (valueWrapper == null) {
            this.intCounters.put(a, new int[]{1});
        } else {
            valueWrapper[0] = valueWrapper[0] + 1;
        }
    }

    public void append(String a, int v) {
        int[] valueWrapper = this.intCounters.get(a);
        if (valueWrapper == null) {
            this.intCounters.put(a, new int[]{v});
        } else {
            valueWrapper[0] = valueWrapper[0] + v;
        }
    }

    public void dec(String a) {
        int[] valueWrapper = this.intCounters.get(a);
        if (valueWrapper == null) {
            this.intCounters.put(a, new int[]{1});
        } else {
            valueWrapper[0] = valueWrapper[0] - 1;
        }
    }

    public int get(String a) {
        int[] valueWrapper = this.intCounters.get(a);
        if (valueWrapper == null) {
            return 0;
        }
        return valueWrapper[0];
    }

    public void initialize() {
        for (String counterName : this.intCounters.keySet()) {
            int[] valueWrapper = this.intCounters.get(counterName);
            if (valueWrapper == null) continue;
            valueWrapper[0] = 0;
        }
    }

    public void report(Logger log) {
        log.info("Counters {}:", (Object)this.name);
        for (String counterName : this.intCounters.keySet()) {
            log.info("{}.{}: {}", new Object[]{this.name, counterName, this.get(counterName)});
        }
    }

    public int sum(String keyword) {
        int count = 0;
        for (String counterName : this.intCounters.keySet()) {
            count += counterName.contains(keyword) ? this.get(counterName) : 0;
        }
        return count;
    }
}

