/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.util;

import fr.proline.module.seq.orm.DatabankInstance;
import java.sql.Timestamp;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabankInstanceComparator
implements Comparator<DatabankInstance> {
    private static final Logger LOG = LoggerFactory.getLogger(DatabankInstanceComparator.class);

    @Override
    public int compare(DatabankInstance instance1, DatabankInstance instance2) {
        if (instance1 == null) {
            throw new IllegalArgumentException("Instance1 is null");
        }
        if (instance2 == null) {
            throw new IllegalArgumentException("Instance2 is null");
        }
        String release1 = instance1.getRelease();
        String release2 = instance2.getRelease();
        int releaseOrder = release1.compareTo(release2);
        Timestamp time1 = instance1.getSourceLastModifiedTime();
        Timestamp time2 = instance2.getSourceLastModifiedTime();
        int timeOrder = time1.compareTo(time2);
        if (DatabankInstanceComparator.signum(releaseOrder) != DatabankInstanceComparator.signum(timeOrder)) {
            LOG.warn("Inconsistent DatabankInstance order 1.[{}] 2.[{}]  1.{} 2.{}", new Object[]{release1, release2, time1, time2});
        }
        return releaseOrder;
    }

    private static int signum(int value) {
        int result = 0;
        if (value > 0) {
            result = 1;
        } else if (value < 0) {
            result = -1;
        }
        return result;
    }
}

