/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.util;

import fr.profi.util.StringUtils;
import java.security.MessageDigest;
import java.util.Formatter;
import jonelo.jacksum.JacksumAPI;
import jonelo.jacksum.algorithm.AbstractChecksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HashUtil.class);
    private static final String SHA_256 = "SHA-256";
    private static final int HASH_LENGTH = 64;
    private static final int CRC64_LENGTH = 32;

    public static String calculateSHA256(String sequence) {
        if (StringUtils.isEmpty((String)sequence)) {
            throw new IllegalArgumentException("Invalid sequence");
        }
        String result = null;
        try {
            MessageDigest md = MessageDigest.getInstance(SHA_256);
            byte[] sequenceBytes = sequence.getBytes("ISO-8859-1");
            md.update(sequenceBytes);
            byte[] digest = md.digest();
            StringBuilder buff = new StringBuilder(64);
            Formatter formatter = new Formatter(buff);
            for (byte b : digest) {
                formatter.format("%02X", b);
            }
            result = buff.toString();
        }
        catch (Exception ex) {
            LOG.error("Error computing SHA-256 hash", (Throwable)ex);
        }
        return result;
    }

    public static String calculateCRC64(String sequence) {
        if (StringUtils.isEmpty((String)sequence)) {
            throw new IllegalArgumentException("Invalid sequence");
        }
        String result = null;
        try {
            AbstractChecksum checksum = JacksumAPI.getChecksumInstance((String)"crc64");
            byte[] sequenceBytes = sequence.getBytes("ISO-8859-1");
            checksum.update(sequenceBytes);
            byte[] digest = checksum.getByteArray();
            StringBuilder buff = new StringBuilder(32);
            Formatter formatter = new Formatter(buff);
            for (byte b : digest) {
                formatter.format("%02X", b);
            }
            result = buff.toString();
        }
        catch (Exception ex) {
            LOG.error("Error computing SHA-256 hash", (Throwable)ex);
        }
        return result;
    }
}

