/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;
import org.forester.ws.seqdb.SequenceDbWsTools;

public class gene_tree_preprocess {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String PRG_NAME = "gene_tree_preprocess";
    private static final String PRG_DESC = "gene tree preprocessing for SDI analysis";
    private static final String PRG_VERSION = "1.01";
    private static final String PRG_DATE = "2012.06.07";
    private static final String E_MAIL = "phylosoft@gmail.com";
    private static final String WWW = "www.phylosoft.org/forester";
    private static final int DEFAULT_LINES_TO_RETURN = 50;

    public static void main(String[] args) {
        try {
            BufferedWriter out;
            CommandLineArguments cla = new CommandLineArguments(args);
            if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2) || args.length != 1) {
                gene_tree_preprocess.printHelp();
                System.exit(0);
            }
            File in = cla.getFile(0);
            Phylogeny phy = null;
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            try {
                phy = factory.create(in, ParserUtils.createParserDependingOnFileType(in, true))[0];
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read phylogeny from [" + in + "]: " + e.getLocalizedMessage());
            }
            File outtree = new File(ForesterUtil.removeSuffix(in.toString()) + "_preprocessed_gene_tree.phylo.xml");
            File removed_nodes = new File(ForesterUtil.removeSuffix(in.toString()) + "_removed_nodes.txt");
            File present_species = new File(ForesterUtil.removeSuffix(in.toString()) + "_species_present.txt");
            gene_tree_preprocess.checkForOutputFileWriteability(outtree);
            gene_tree_preprocess.checkForOutputFileWriteability(removed_nodes);
            gene_tree_preprocess.checkForOutputFileWriteability(present_species);
            if (phy.getNumberOfExternalNodes() < 2) {
                ForesterUtil.fatalError(PRG_NAME, "phylogeny has " + phy.getNumberOfExternalNodes() + " external node(s), aborting");
            }
            SortedSet<String> not_found = SequenceDbWsTools.obtainSeqInformation(phy, true, false, 50);
            for (String remove_me : not_found) {
                phy.deleteSubtree(phy.getNode(remove_me), true);
            }
            phy.clearHashIdToNodeMap();
            phy.externalNodesHaveChanged();
            if (phy.getNumberOfExternalNodes() < 2) {
                ForesterUtil.fatalError(PRG_NAME, "after removal of unresolvable external nodes, phylogeny has " + phy.getNumberOfExternalNodes() + " external node(s), aborting");
            }
            try {
                PhylogenyWriter writer = new PhylogenyWriter();
                writer.toPhyloXML(phy, 0, outtree);
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, "failed to write to [" + outtree + "]: " + e.getLocalizedMessage());
            }
            ForesterUtil.programMessage(PRG_NAME, "wrote output phylogeny to: " + outtree);
            TreeSet<String> species_set = new TreeSet<String>();
            PhylogenyNodeIterator iter = phy.iteratorExternalForward();
            while (iter.hasNext()) {
                String sn;
                PhylogenyNode node = iter.next();
                if (!node.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(sn = node.getNodeData().getTaxonomy().getScientificName())) continue;
                species_set.add(sn);
            }
            try {
                out = new BufferedWriter(new FileWriter(present_species));
                for (String species : species_set) {
                    out.write(species);
                    out.newLine();
                }
                out.close();
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, "failed to write to [" + present_species + "]: " + e.getLocalizedMessage());
            }
            ForesterUtil.programMessage(PRG_NAME, "wrote present species to: " + present_species);
            try {
                out = new BufferedWriter(new FileWriter(removed_nodes));
                for (String remove_me : not_found) {
                    out.write(remove_me);
                    out.newLine();
                }
                out.close();
            }
            catch (IOException e) {
                ForesterUtil.fatalError(PRG_NAME, "failed to write to [" + removed_nodes + "]: " + e.getLocalizedMessage());
            }
            ForesterUtil.programMessage(PRG_NAME, "wrote removed external nodes labels to: " + removed_nodes);
            ForesterUtil.programMessage(PRG_NAME, "OK");
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
    }

    private static void checkForOutputFileWriteability(File outfile) {
        String error = ForesterUtil.isWritableFile(outfile);
        if (!ForesterUtil.isEmpty(error)) {
            ForesterUtil.fatalError(PRG_NAME, error);
        }
    }

    private static void printHelp() {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_DESC, PRG_VERSION, PRG_DATE, E_MAIL, WWW, ForesterUtil.getForesterLibraryInformation());
        System.out.print("Usage: ");
        System.out.println("gene_tree_preprocess <input phylogeny file>");
        System.out.println();
    }
}

