/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.FileInputStream;
import org.forester.io.parsers.FastaParser;
import org.forester.io.parsers.GeneralMsaParser;
import org.forester.msa.Msa;
import org.forester.msa.MsaMethods;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.CommandLineArguments;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class mcc {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String FROM_OPTION = "f";
    private static final String TO_OPTION = "t";
    private static final String STEP_OPTION = "s";
    private static final String WINDOW_OPTION = "w";
    private static final String PRG_NAME = "mcc";
    private static final String PRG_DESC = "msa consensus conservation";
    private static final String PRG_VERSION = "1.00";
    private static final String PRG_DATE = "2012.05.18";
    private static final String E_MAIL = "phylosoft@gmail.com";
    private static final String WWW = "www.phylosoft.org/forester/";

    public static void main(String[] args) {
        try {
            CommandLineArguments cla = new CommandLineArguments(args);
            if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2) || args.length != 3) {
                mcc.printHelp();
                System.exit(0);
            }
            File in = cla.getFile(0);
            int from = 0;
            int to = 0;
            int window = 0;
            int step = 0;
            if (cla.isOptionSet(FROM_OPTION) && cla.isOptionSet(TO_OPTION)) {
                from = cla.getOptionValueAsInt(FROM_OPTION);
                to = cla.getOptionValueAsInt(TO_OPTION);
            } else if (cla.isOptionSet(STEP_OPTION) && cla.isOptionSet(WINDOW_OPTION)) {
                step = cla.getOptionValueAsInt(STEP_OPTION);
                window = cla.getOptionValueAsInt(WINDOW_OPTION);
            } else {
                mcc.printHelp();
                System.exit(0);
            }
            Msa msa = null;
            FileInputStream is = new FileInputStream(in);
            msa = FastaParser.isLikelyFasta(in) ? FastaParser.parseMsa(is) : GeneralMsaParser.parse(is);
            if (cla.isOptionSet(FROM_OPTION)) {
                mcc.singleCalc(in, from, to, msa);
            } else {
                mcc.windowedCalcs(window, step, msa);
            }
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
    }

    private static void printHelp() {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_DESC, PRG_VERSION, PRG_DATE, E_MAIL, WWW, ForesterUtil.getForesterLibraryInformation());
        System.out.println("Usage:");
        System.out.println();
        System.out.println("mcc <options> <msa input file>");
        System.out.println();
        System.out.println(" options: ");
        System.out.println();
        System.out.println("   -f=<integer>: from (msa column)");
        System.out.println("   -t=<integer>: to (msa column)");
        System.out.println("    or");
        System.out.println("   -w=<integer>: window size (msa columns)");
        System.out.println("   -s=<integer>: step size (msa columns)");
        System.out.println();
        System.out.println();
        System.out.println();
    }

    private static void windowedCalcs(int window, int step, Msa msa) {
        if (window < 1) {
            window = 1;
        }
        if (step < 1) {
            step = 1;
        }
        double[] id_ratios = new double[msa.getLength()];
        for (int i = 0; i <= msa.getLength() - 1; ++i) {
            id_ratios[i] = MsaMethods.calculateIdentityRatio(msa, i);
        }
        String min_pos = "";
        String max_pos = "";
        double min = 1.0;
        double max = 0.0;
        for (int i = 0; i <= msa.getLength() - 1; i += step) {
            int to = i + window - 1;
            if (to > msa.getLength() - 1) {
                to = msa.getLength() - 1;
            }
            DescriptiveStatistics stats = mcc.calc(i, to, id_ratios);
            double mean = stats.arithmeticMean();
            String pos = i + "-" + to;
            System.out.print(pos);
            System.out.print(":\t");
            System.out.print(mean);
            if (stats.getN() > 2) {
                System.out.print("\t");
                System.out.print(stats.median());
                System.out.print("\t");
                System.out.print(stats.sampleStandardDeviation());
            }
            System.out.println();
            if (mean > max) {
                max = mean;
                max_pos = pos;
            }
            if (!(mean < min)) continue;
            min = mean;
            min_pos = pos;
        }
        System.out.println("Min: " + min_pos + ": " + min);
        System.out.println("Max: " + max_pos + ": " + max);
    }

    private static void singleCalc(File in, int from, int to, Msa msa) {
        if (from < 0) {
            from = 0;
        }
        if (to > msa.getLength() - 1) {
            to = msa.getLength() - 1;
        }
        DescriptiveStatistics stats = mcc.calc(from, to, msa);
        System.out.println(in.toString() + ": " + from + "-" + to + ":");
        System.out.println();
        System.out.println(stats.toString());
    }

    private static DescriptiveStatistics calc(int from, int to, Msa msa) {
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        for (int c = from; c <= to; ++c) {
            stats.addValue(MsaMethods.calculateIdentityRatio(msa, c));
        }
        return stats;
    }

    private static DescriptiveStatistics calc(int from, int to, double[] id_ratios) {
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        for (int c = from; c <= to; ++c) {
            stats.addValue(id_ratios[c]);
        }
        return stats;
    }
}

