/*
 * Decompiled with CFR 0.152.
 */
package org.forester.applications;

import java.io.File;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class reinv_count {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println();
            System.err.println("reinv_count: wrong number of arguments");
            System.err.println("Usage: \"reinv_count <intree> <name>");
            System.err.println();
            System.exit(-1);
        }
        File infile = new File(args[0]);
        String node_name = args[1];
        Phylogeny phy = null;
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            phy = factory.create(infile, ParserUtils.createParserDependingOnFileType(infile, true))[0];
        }
        catch (Exception e) {
            System.err.println(e + "\nCould not read " + infile + "\n");
            System.exit(-1);
        }
        PhylogenyNodeIterator ite = phy.iteratorExternalForward();
        while (ite.hasNext()) {
            PhylogenyNode target_node = ite.next();
            SortedSet<String> target_dcs = reinv_count.getAllExternalPresentAndGainedCharacters(target_node);
            int counter = 0;
            TreeSet<String> reinv = new TreeSet<String>();
            for (String target_dc : target_dcs) {
                int c = 0;
                PhylogenyNodeIterator it = phy.iteratorPreorder();
                while (it.hasNext()) {
                    PhylogenyNode n = it.next();
                    SortedSet<String> n_gained_dcs = n.getNodeData().getBinaryCharacters().getGainedCharacters();
                    if (!n_gained_dcs.contains(target_dc)) continue;
                    ++c;
                }
                if (c <= true) continue;
                ++counter;
                reinv.add(target_dc);
            }
            double ratio = (double)counter / (double)target_dcs.size();
            System.out.println(target_node.getName() + "\t" + counter + "/" + target_dcs.size() + "\t" + ratio);
        }
    }

    private static SortedSet<String> getAllExternalPresentAndGainedCharacters(PhylogenyNode node) {
        TreeSet<String> chars = new TreeSet<String>();
        List<PhylogenyNode> descs = node.getAllExternalDescendants();
        for (PhylogenyNode desc : descs) {
            chars.addAll(desc.getNodeData().getBinaryCharacters().getGainedCharacters());
            chars.addAll(desc.getNodeData().getBinaryCharacters().getPresentCharacters());
        }
        return chars;
    }
}

