/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.ArchaeopteryxA;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MainPanelApplets;
import org.forester.archaeopteryx.Options;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.ForesterUtil;

public final class MainFrameApplet
extends MainFrame {
    private static final long serialVersionUID = 1941019292746717053L;
    private static final int DEFAULT_FRAME_X_SIZE = 640;
    private static final int DEFAULT_FRAME_Y_SIZE = 580;
    private final ArchaeopteryxA _applet;
    private ButtonGroup _radio_group_1;

    MainFrameApplet(ArchaeopteryxA parent_applet, Configuration configuration, String species_tree_url_str) {
        this.setTitle("ArchaeopteryxA");
        this._applet = parent_applet;
        this.setConfiguration(configuration);
        this.setOptions(Options.createInstance(configuration));
        this._mainpanel = new MainPanelApplets(this._configuration, this);
        if (!ForesterUtil.isEmpty(species_tree_url_str)) {
            try {
                this.readSpeciesTree(configuration, species_tree_url_str);
            }
            catch (Exception e) {
                ForesterUtil.printErrorMessage("ArchaeopteryxA", "failed to read species tree from " + species_tree_url_str);
                ForesterUtil.printErrorMessage("ArchaeopteryxA", e.toString());
            }
        }
        this._jmenubar = new JMenuBar();
        this.buildFileMenu();
        if (!this._configuration.isUseNativeUI()) {
            this._jmenubar.setBackground(this._configuration.getGuiMenuBackgroundColor());
        }
        this.buildAnalysisMenu();
        this.buildToolsMenu();
        this.buildViewMenu();
        this.buildFontSizeMenu();
        this.buildOptionsMenu();
        this.buildTypeMenu();
        this.buildHelpMenu();
        this.setJMenuBar(this._jmenubar);
        this._contentpane = this.getContentPane();
        this._contentpane.setLayout(new BorderLayout());
        this._contentpane.add((Component)this._mainpanel, "Center");
        this.setSize(this.getConfiguration().getFrameXSize() > 40 ? this.getConfiguration().getFrameXSize() : 640, this.getConfiguration().getFrameYSize() > 40 ? this.getConfiguration().getFrameYSize() : 580);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrameApplet.this.close();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (MainFrameApplet.this._mainpanel.getCurrentTreePanel() != null) {
                    MainFrameApplet.this._mainpanel.getCurrentTreePanel().calcParametersForPainting(MainFrameApplet.this._mainpanel.getCurrentTreePanel().getWidth(), MainFrameApplet.this._mainpanel.getCurrentTreePanel().getHeight());
                }
            }
        });
        this.setFocusable(true);
        this.requestFocus();
        this.requestFocusInWindow();
        this.setVisible(true);
        System.gc();
    }

    @Override
    public MainPanel getMainPanel() {
        return this._mainpanel;
    }

    private void readSpeciesTree(Configuration configuration, String species_tree_url_str) throws MalformedURLException, FileNotFoundException, IOException {
        URL species_tree_url = new URL(species_tree_url_str);
        Phylogeny[] species_trees = AptxUtil.readPhylogeniesFromUrl(species_tree_url, configuration.isValidatePhyloXmlAgainstSchema(), configuration.isReplaceUnderscoresInNhParsing(), false, NHXParser.TAXONOMY_EXTRACTION.NO, false);
        if (species_trees != null && species_trees.length > 0) {
            AptxUtil.printAppletMessage("ArchaeopteryxA", "successfully read species tree");
            if (species_trees[0].isEmpty()) {
                ForesterUtil.printErrorMessage("ArchaeopteryxA", "species tree is empty");
            } else if (!species_trees[0].isRooted()) {
                ForesterUtil.printErrorMessage("ArchaeopteryxA", "species tree is not rooted");
            } else {
                this.setSpeciesTree(species_trees[0]);
                AptxUtil.printAppletMessage("ArchaeopteryxA", "species tree OK");
            }
        } else {
            ForesterUtil.printErrorMessage("ArchaeopteryxA", "failed to read species tree from " + species_tree_url_str);
        }
    }

    void buildAnalysisMenu() {
        this._analysis_menu = MainFrame.createMenu("Analysis", this.getConfiguration());
        if (this.getSpeciesTree() != null) {
            this._gsdi_item = new JMenuItem("GSDI (Generalized Speciation Duplication Inference)");
            this._analysis_menu.add(this._gsdi_item);
            this._gsdir_item = new JMenuItem("GSDIR (GSDI with re-rooting)");
            this._analysis_menu.add(this._gsdir_item);
            this.customizeJMenuItem(this._gsdi_item);
            this.customizeJMenuItem(this._gsdir_item);
            this._analysis_menu.addSeparator();
        }
        this._lineage_inference = new JMenuItem("Infer Ancestor Taxonomies");
        this._analysis_menu.add(this._lineage_inference);
        this.customizeJMenuItem(this._lineage_inference);
        this._lineage_inference.setToolTipText("Inference of ancestor taxonomies/lineages");
        this._jmenubar.add(this._analysis_menu);
    }

    void buildOptionsMenu() {
        this._options_jmenu = MainFrame.createMenu("Options", this.getConfiguration());
        this._options_jmenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainFrame.setOvPlacementColorChooseMenuItem(MainFrameApplet.this._overview_placment_mi, MainFrameApplet.this.getOptions());
                MainFrame.setTextColorChooseMenuItem(MainFrameApplet.this._switch_colors_mi, MainFrameApplet.this.getCurrentTreePanel());
                MainFrame.setTextMinSupportMenuItem(MainFrameApplet.this._choose_minimal_confidence_mi, MainFrameApplet.this.getOptions(), MainFrameApplet.this.getCurrentTreePanel());
                MainFrame.setTextForFontChooserMenuItem(MainFrameApplet.this._choose_font_mi, MainFrame.createCurrentFontDesc(MainFrameApplet.this.getMainPanel().getTreeFontSet()));
                MainFrame.setTextForGraphicsSizeChooserMenuItem(MainFrameApplet.this._print_size_mi, MainFrameApplet.this.getOptions());
                MainFrame.setTextForPdfLineWidthChooserMenuItem(MainFrameApplet.this._choose_pdf_width_mi, MainFrameApplet.this.getOptions());
                MainFrame.setCycleNodeFillMenuItem(MainFrameApplet.this._cycle_node_fill_mi, MainFrameApplet.this.getOptions());
                MainFrame.setCycleNodeShapeMenuItem(MainFrameApplet.this._cycle_node_shape_mi, MainFrameApplet.this.getOptions());
                MainFrame.setTextNodeSizeMenuItem(MainFrameApplet.this._choose_node_size_mi, MainFrameApplet.this.getOptions());
                try {
                    MainFrameApplet.this.getMainPanel().getControlPanel().setVisibilityOfDomainStrucureCB();
                    MainFrameApplet.this.getMainPanel().getControlPanel().setVisibilityOfX();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._options_jmenu.add(MainFrame.customizeMenuItemAsLabel(new JMenuItem("Display:"), this.getConfiguration()));
        this._ext_node_dependent_cladogram_rbmi = new JRadioButtonMenuItem("External Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._ext_node_dependent_cladogram_rbmi);
        this._uniform_cladograms_rbmi = new JRadioButtonMenuItem("Total Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._uniform_cladograms_rbmi);
        this._non_lined_up_cladograms_rbmi = new JRadioButtonMenuItem("Non-Lined Up Cladograms");
        this._options_jmenu.add(this._non_lined_up_cladograms_rbmi);
        this._radio_group_1 = new ButtonGroup();
        this._radio_group_1.add(this._ext_node_dependent_cladogram_rbmi);
        this._radio_group_1.add(this._uniform_cladograms_rbmi);
        this._radio_group_1.add(this._non_lined_up_cladograms_rbmi);
        this._show_overview_cbmi = new JCheckBoxMenuItem("Overview");
        this._options_jmenu.add(this._show_overview_cbmi);
        this._show_scale_cbmi = new JCheckBoxMenuItem("Scale");
        this._options_jmenu.add(this._show_scale_cbmi);
        this._show_default_node_shapes_internal_cbmi = new JCheckBoxMenuItem("Shapes for Internal Nodes");
        this._options_jmenu.add(this._show_default_node_shapes_internal_cbmi);
        this._show_default_node_shapes_external_cbmi = new JCheckBoxMenuItem("Shapes for External Nodes");
        this._options_jmenu.add(this._show_default_node_shapes_external_cbmi);
        this._show_default_node_shapes_for_marked_cbmi = new JCheckBoxMenuItem("Shapes for Nodes with Visual Data");
        this._options_jmenu.add(this._show_default_node_shapes_for_marked_cbmi);
        this._line_up_renderable_data_cbmi = new JCheckBoxMenuItem("Line Up Diagrams (such as Domain Architectures)");
        this._options_jmenu.add(this._line_up_renderable_data_cbmi);
        if (this.getConfiguration().doDisplayOption(10)) {
            this._right_line_up_domains_cbmi = new JCheckBoxMenuItem("Right-align Domain Architectures");
            this._options_jmenu.add(this._right_line_up_domains_cbmi);
            this._show_domain_labels = new JCheckBoxMenuItem("Domain Labels");
            this._options_jmenu.add(this._show_domain_labels);
        }
        this._show_annotation_ref_source = new JCheckBoxMenuItem("Seq Annotation Ref Sources");
        this._options_jmenu.add(this._show_annotation_ref_source);
        this._show_confidence_stddev_cbmi = new JCheckBoxMenuItem("Confidence Standard Deviations");
        this._options_jmenu.add(this._show_confidence_stddev_cbmi);
        this._color_by_taxonomic_group_cbmi = new JCheckBoxMenuItem("Colorize by Taxonomic Group");
        this._options_jmenu.add(this._color_by_taxonomic_group_cbmi);
        this._color_labels_same_as_parent_branch = new JCheckBoxMenuItem("Colorize Labels Same as Parent Branch");
        this._options_jmenu.add(this._color_labels_same_as_parent_branch);
        this._color_labels_same_as_parent_branch.setToolTipText("To use parent branch colors for node labels as well, need to turn off taxonomy dependent colorization and turn on branch colorization for this to become apparent");
        this._abbreviate_scientific_names = new JCheckBoxMenuItem("Abbreviate Scientific Taxonomic Names");
        this._options_jmenu.add(this._abbreviate_scientific_names);
        this._label_direction_cbmi = new JCheckBoxMenuItem("Radial Labels");
        this._options_jmenu.add(this._label_direction_cbmi);
        this._label_direction_cbmi.setToolTipText("To use radial node labels in radial and unrooted display types");
        this._screen_antialias_cbmi = new JCheckBoxMenuItem("Antialias");
        this._options_jmenu.add(this._screen_antialias_cbmi);
        this._background_gradient_cbmi = new JCheckBoxMenuItem("Background Color Gradient");
        this._options_jmenu.add(this._background_gradient_cbmi);
        this._cycle_node_shape_mi = new JMenuItem("Cycle Node Shapes");
        this._options_jmenu.add(this._cycle_node_shape_mi);
        this._cycle_node_fill_mi = new JMenuItem("Cycle Node Fill Type");
        this._options_jmenu.add(this._cycle_node_fill_mi);
        this._choose_node_size_mi = new JMenuItem("Choose Node Shape Size");
        this._options_jmenu.add(this._choose_node_size_mi);
        this._choose_minimal_confidence_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_minimal_confidence_mi);
        this._overview_placment_mi = new JMenuItem("");
        this._options_jmenu.add(this._overview_placment_mi);
        this._switch_colors_mi = new JMenuItem("");
        this._options_jmenu.add(this._switch_colors_mi);
        this._choose_font_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_font_mi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrame.customizeMenuItemAsLabel(new JMenuItem("Search:"), this.getConfiguration()));
        this._search_case_senstive_cbmi = new JCheckBoxMenuItem("Case Sensitive");
        this._options_jmenu.add(this._search_case_senstive_cbmi);
        this._search_whole_words_only_cbmi = new JCheckBoxMenuItem("Match Complete Terms Only");
        this._options_jmenu.add(this._search_whole_words_only_cbmi);
        this._search_with_regex_cbmi = new JCheckBoxMenuItem("Search with Regular Expressions");
        this._options_jmenu.add(this._search_with_regex_cbmi);
        this._search_with_regex_cbmi.setToolTipText("To search using regular expressions (~Java/Perl syntax). For example, use \"^B.+\\d{2,}$\" to search for everything starting with a B and ending with at least two digits.");
        this._inverse_search_result_cbmi = new JCheckBoxMenuItem("Negate Result");
        this._options_jmenu.add(this._inverse_search_result_cbmi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrameApplet.customizeMenuItemAsLabel(new JMenuItem("Graphics Export & Printing:"), this.getConfiguration()));
        this._antialias_print_cbmi = new JCheckBoxMenuItem("Antialias");
        this._options_jmenu.add(this._antialias_print_cbmi);
        this._print_black_and_white_cbmi = new JCheckBoxMenuItem("Export in Black and White");
        this._options_jmenu.add(this._print_black_and_white_cbmi);
        this._print_using_actual_size_cbmi = new JCheckBoxMenuItem("Use Current Image Size for PDF export and Printing");
        this._options_jmenu.add(this._print_using_actual_size_cbmi);
        this._graphics_export_using_actual_size_cbmi = new JCheckBoxMenuItem("Use Current Image Size for PNG, JPG, and GIF export");
        this._options_jmenu.add(this._graphics_export_using_actual_size_cbmi);
        this._graphics_export_visible_only_cbmi = new JCheckBoxMenuItem("Limit to Visible ('Screenshot') for PNG, JPG, and GIF export");
        this._options_jmenu.add(this._graphics_export_visible_only_cbmi);
        this._print_size_mi = new JMenuItem("");
        this._options_jmenu.add(this._print_size_mi);
        this._choose_pdf_width_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_pdf_width_mi);
        this.customizeCheckBoxMenuItem(this._antialias_print_cbmi, this.getOptions().isAntialiasPrint());
        this.customizeCheckBoxMenuItem(this._print_black_and_white_cbmi, this.getOptions().isPrintBlackAndWhite());
        this.customizeCheckBoxMenuItem(this._graphics_export_visible_only_cbmi, this.getOptions().isGraphicsExportVisibleOnly());
        this.customizeCheckBoxMenuItem(this._print_using_actual_size_cbmi, this.getOptions().isPrintUsingActualSize());
        this.customizeCheckBoxMenuItem(this._graphics_export_using_actual_size_cbmi, this.getOptions().isGraphicsExportUsingActualSize());
        this.customizeJMenuItem(this._print_size_mi);
        this.customizeJMenuItem(this._choose_pdf_width_mi);
        this.customizeJMenuItem(this._choose_font_mi);
        this.customizeJMenuItem(this._switch_colors_mi);
        this.customizeJMenuItem(this._choose_minimal_confidence_mi);
        this.customizeJMenuItem(this._overview_placment_mi);
        this.customizeCheckBoxMenuItem(this._show_default_node_shapes_internal_cbmi, this.getOptions().isShowDefaultNodeShapesInternal());
        this.customizeCheckBoxMenuItem(this._show_default_node_shapes_external_cbmi, this.getOptions().isShowDefaultNodeShapesExternal());
        this.customizeCheckBoxMenuItem(this._show_default_node_shapes_for_marked_cbmi, this.getOptions().isShowDefaultNodeShapesForMarkedNodes());
        this.customizeJMenuItem(this._cycle_node_shape_mi);
        this.customizeJMenuItem(this._cycle_node_fill_mi);
        this.customizeJMenuItem(this._choose_node_size_mi);
        this.customizeCheckBoxMenuItem(this._color_by_taxonomic_group_cbmi, this.getOptions().isColorByTaxonomicGroup());
        this.customizeCheckBoxMenuItem(this._color_labels_same_as_parent_branch, this.getOptions().isColorLabelsSameAsParentBranch());
        this.customizeCheckBoxMenuItem(this._screen_antialias_cbmi, this.getOptions().isAntialiasScreen());
        this.customizeCheckBoxMenuItem(this._background_gradient_cbmi, this.getOptions().isBackgroundColorGradient());
        this.customizeCheckBoxMenuItem(this._show_domain_labels, this.getOptions().isShowDomainLabels());
        this.customizeCheckBoxMenuItem(this._show_annotation_ref_source, this.getOptions().isShowAnnotationRefSource());
        this.customizeCheckBoxMenuItem(this._abbreviate_scientific_names, this.getOptions().isAbbreviateScientificTaxonNames());
        this.customizeCheckBoxMenuItem(this._search_case_senstive_cbmi, this.getOptions().isSearchCaseSensitive());
        this.customizeCheckBoxMenuItem(this._show_scale_cbmi, this.getOptions().isShowScale());
        this.customizeRadioButtonMenuItem(this._non_lined_up_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP);
        this.customizeRadioButtonMenuItem(this._uniform_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
        this.customizeRadioButtonMenuItem(this._ext_node_dependent_cladogram_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
        this.customizeCheckBoxMenuItem(this._show_overview_cbmi, this.getOptions().isShowOverview());
        this.customizeCheckBoxMenuItem(this._label_direction_cbmi, this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL);
        this.customizeCheckBoxMenuItem(this._search_with_regex_cbmi, this.getOptions().isSearchWithRegex());
        this.customizeCheckBoxMenuItem(this._search_whole_words_only_cbmi, this.getOptions().isMatchWholeTermsOnly());
        this.customizeCheckBoxMenuItem(this._inverse_search_result_cbmi, this.getOptions().isInverseSearchResult());
        this.customizeCheckBoxMenuItem(this._show_confidence_stddev_cbmi, this.getOptions().isShowConfidenceStddev());
        this.customizeCheckBoxMenuItem(this._line_up_renderable_data_cbmi, this.getOptions().isLineUpRendarableNodeData());
        this.customizeCheckBoxMenuItem(this._right_line_up_domains_cbmi, this.getOptions().isRightLineUpDomains());
        this._jmenubar.add(this._options_jmenu);
    }

    void buildToolsMenu() {
        this._tools_menu = MainFrame.createMenu("Tools", this.getConfiguration());
        this._confcolor_item = new JMenuItem("Colorize Branches Depending on Confidence");
        this._tools_menu.add(this._confcolor_item);
        this.customizeJMenuItem(this._confcolor_item);
        this._taxcolor_item = new JMenuItem("Taxonomy Colorize Branches");
        this._tools_menu.add(this._taxcolor_item);
        this.customizeJMenuItem(this._taxcolor_item);
        this._tools_menu.addSeparator();
        this._remove_visual_styles_item = new JMenuItem("Delete All Visual Styles From Nodes");
        this._tools_menu.add(this._remove_visual_styles_item);
        this._remove_visual_styles_item.setToolTipText("To remove all node visual styles (fonts, colors) from the current phylogeny.");
        this.customizeJMenuItem(this._remove_visual_styles_item);
        this._remove_branch_color_item = new JMenuItem("Delete All Colors From Branches");
        this._tools_menu.add(this._remove_branch_color_item);
        this._remove_branch_color_item.setToolTipText("To remove all branch color values from the current phylogeny.");
        this.customizeJMenuItem(this._remove_branch_color_item);
        this._tools_menu.addSeparator();
        this._midpoint_root_item = new JMenuItem("Midpoint-Root");
        this._tools_menu.add(this._midpoint_root_item);
        this.customizeJMenuItem(this._midpoint_root_item);
        this._tools_menu.addSeparator();
        this._collapse_species_specific_subtrees = new JMenuItem("Collapse Species-Specific Subtrees");
        this._tools_menu.add(this._collapse_species_specific_subtrees);
        this.customizeJMenuItem(this._collapse_species_specific_subtrees);
        this._jmenubar.add(this._tools_menu);
    }

    JApplet getApplet() {
        return this._applet;
    }
}

