/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.SortedSet;
import javax.swing.JOptionPane;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.tools.RunnableProcess;
import org.forester.phylogeny.Phylogeny;
import org.forester.ws.seqdb.SequenceDbWsTools;

public final class SequenceDataRetriver
extends RunnableProcess {
    private final Phylogeny _phy;
    private final MainFrameApplication _mf;
    private final TreePanel _treepanel;
    public static final boolean DEBUG = false;

    public SequenceDataRetriver(MainFrameApplication mf, TreePanel treepanel, Phylogeny phy) {
        this._phy = phy;
        this._mf = mf;
        this._treepanel = treepanel;
    }

    @Override
    public void run() {
        this.execute();
    }

    private void execute() {
        this.start(this._mf, "sequence data");
        SortedSet<String> not_found = null;
        try {
            not_found = SequenceDbWsTools.obtainSeqInformation(this._phy, false, true, 4000);
        }
        catch (UnknownHostException e) {
            JOptionPane.showMessageDialog(this._mf, e.getLocalizedMessage(), "Network error during sequence data gathering", 0);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this._mf, e.toString(), "Failed to obtain sequence data", 0);
            return;
        }
        finally {
            this.end(this._mf);
        }
        this._treepanel.setTree(this._phy);
        this._mf.showWhole();
        this._treepanel.setEdited(true);
        if (not_found != null && not_found.size() > 0) {
            int max = not_found.size();
            boolean more = false;
            if (max > 20) {
                more = true;
                max = 20;
            }
            StringBuffer sb = new StringBuffer();
            if (not_found.size() == 1) {
                sb.append("For the following node no data was found:\n");
            } else {
                sb.append("For the following nodes no data was found (total: " + not_found.size() + "):\n");
            }
            int i = 0;
            for (String string : not_found) {
                if (i > 19) break;
                sb.append(string);
                sb.append("\n");
                ++i;
            }
            if (more) {
                sb.append("...");
            }
            try {
                JOptionPane.showMessageDialog(this._mf, sb.toString(), "Sequence Tool Completed", 2);
            }
            catch (Exception exception) {}
        } else {
            try {
                JOptionPane.showMessageDialog(this._mf, "Sequence tool successfully completed", "Sequence Tool Completed", 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

