/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference;

import java.io.File;
import java.io.FileInputStream;
import java.io.StringWriter;
import java.util.Date;
import java.util.Set;
import org.forester.evoinference.distance.NeighborJoining;
import org.forester.evoinference.distance.NeighborJoiningF;
import org.forester.evoinference.distance.NeighborJoiningR;
import org.forester.evoinference.distance.PairwiseDistanceCalculator;
import org.forester.evoinference.distance.Sarray;
import org.forester.evoinference.distance.Sset;
import org.forester.evoinference.matrix.character.BasicCharacterStateMatrix;
import org.forester.evoinference.matrix.character.CharacterStateMatrix;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.matrix.distance.DistanceMatrix;
import org.forester.evoinference.parsimony.DolloParsimony;
import org.forester.evoinference.parsimony.FitchParsimony;
import org.forester.io.parsers.GeneralMsaParser;
import org.forester.io.parsers.SymmetricalDistanceMatrixParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.msa.Msa;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.util.ForesterUtil;

public class TestPhylogenyReconstruction {
    private static final double ZERO_DIFF = 1.0E-9;
    private static final boolean VERBOSE = false;

    public static boolean isEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-9;
    }

    public static boolean isUnequal(double a, double b) {
        return !TestPhylogenyReconstruction.isEqual(a, b);
    }

    public static void main(String[] args) {
        System.out.println("NJ");
        if (TestPhylogenyReconstruction.testNeighborJoining(false)) {
            System.out.println("  OK.");
        } else {
            System.out.println("  failed.");
        }
        System.out.println("S");
        if (TestPhylogenyReconstruction.testS()) {
            System.out.println("  OK.");
        } else {
            System.out.println("  failed.");
        }
        System.out.println("Sarray");
        if (TestPhylogenyReconstruction.testSarray()) {
            System.out.println("  OK.");
        } else {
            System.out.println("  failed.");
        }
        System.out.println("NJR");
        if (TestPhylogenyReconstruction.testNeighborJoiningR()) {
            System.out.println("  OK.");
        } else {
            System.out.println("  failed.");
        }
        TestPhylogenyReconstruction.timeNeighborJoining();
    }

    public static boolean test(File test_dir) {
        System.out.print("  Basic symmetrical distance matrix: ");
        if (!TestPhylogenyReconstruction.testBasicSymmetricalDistanceMatrix()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic character state matrix: ");
        if (!TestPhylogenyReconstruction.testBasicCharacterStateMatrix()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Symmetrical distance matrix parser: ");
        if (!TestPhylogenyReconstruction.testSymmetricalDistanceMatrixParser()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Distance Calculation: ");
        if (!TestPhylogenyReconstruction.testDistanceCalculationMethods(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Datastructure S: ");
        if (!TestPhylogenyReconstruction.testS()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Neighbor Joining: ");
        if (!TestPhylogenyReconstruction.testNeighborJoining(false)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Dollo Parsimony: ");
        if (!TestPhylogenyReconstruction.testDolloParsimony()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Dollo Parsimony on non binary trees: ");
        if (!TestPhylogenyReconstruction.testDolloParsimonyOnNonBinaryTree()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Fitch Parsimony: ");
        if (!TestPhylogenyReconstruction.testFitchParsimony()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        return true;
    }

    private static boolean testBasicCharacterStateMatrix() {
        try {
            BasicCharacterStateMatrix<String> matrix_0 = new BasicCharacterStateMatrix<String>(4, 8);
            BasicCharacterStateMatrix<String> matrix_00 = new BasicCharacterStateMatrix<String>(4, 8);
            matrix_0.setIdentifier(0, "A");
            matrix_0.setIdentifier(1, "B");
            matrix_0.setIdentifier(2, "C");
            matrix_0.setIdentifier(3, "D");
            matrix_0.setCharacter(0, "0");
            matrix_0.setCharacter(1, "1");
            matrix_0.setCharacter(2, "2");
            matrix_0.setCharacter(3, "3");
            matrix_0.setCharacter(4, "4");
            matrix_0.setCharacter(5, "5");
            matrix_0.setCharacter(6, "6");
            matrix_0.setCharacter(7, "7");
            matrix_00.setIdentifier(0, "A");
            matrix_00.setIdentifier(1, "B");
            matrix_00.setIdentifier(2, "C");
            matrix_00.setIdentifier(3, "D");
            matrix_00.setCharacter(3, "3");
            matrix_00.setCharacter(4, "4");
            if (!matrix_0.getCharacter(1).equals("1")) {
                return false;
            }
            if (!matrix_0.getIdentifier(0).equals("A")) {
                return false;
            }
            matrix_0.setState(0, 0, "00");
            matrix_00.setState(0, 0, "00");
            if (!((String)matrix_0.getState(0, 0)).equals("00")) {
                return false;
            }
            matrix_0.setState(0, 1, "01");
            matrix_00.setState(0, 1, "01");
            if (!((String)matrix_0.getState(0, 1)).equals("01")) {
                return false;
            }
            matrix_0.setState(1, 1, "11");
            matrix_00.setState(1, 1, "11");
            if (!((String)matrix_0.getState(1, 1)).equals("11")) {
                return false;
            }
            matrix_0.setState(1, 0, "10");
            matrix_00.setState(1, 0, "10");
            if (!((String)matrix_0.getState(1, 0)).equals("10")) {
                return false;
            }
            matrix_0.setState(1, 2, "12");
            matrix_00.setState(1, 2, "12");
            if (!((String)matrix_0.getState(1, 2)).equals("12")) {
                return false;
            }
            matrix_0.setState(3, 7, "37");
            matrix_00.setState(3, 7, "37");
            if (!((String)matrix_0.getState(3, 7)).equals("37")) {
                return false;
            }
            matrix_0.setState(2, 6, "26");
            matrix_00.setState(2, 6, "26");
            if (!((String)matrix_0.getState(2, 6)).equals("26")) {
                return false;
            }
            matrix_0.setState("D", "3", "33");
            matrix_00.setState("D", "3", "33");
            if (!((String)matrix_0.getState(3, 3)).equals("33")) {
                return false;
            }
            if (!((String)matrix_0.getState("D", "3")).equals("33")) {
                return false;
            }
            matrix_0.setState("C", "4", "24");
            matrix_00.setState("C", "4", "24");
            if (!((String)matrix_0.getState(2, 4)).equals("24")) {
                return false;
            }
            if (!((String)matrix_0.getState("C", "4")).equals("24")) {
                return false;
            }
            if (matrix_0.isEmpty()) {
                return false;
            }
            if (matrix_0.getNumberOfIdentifiers() != 4) {
                return false;
            }
            if (matrix_0.getNumberOfCharacters() != 8) {
                return false;
            }
            if (!((Object)matrix_0).equals(matrix_0)) {
                return false;
            }
            if (!((Object)matrix_0).equals(matrix_00)) {
                return false;
            }
            matrix_00.setState("C", "4", "123");
            if (((Object)matrix_0).equals(matrix_00)) {
                return false;
            }
            Integer[][] ints = new Integer[][]{{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}};
            BasicCharacterStateMatrix<Integer> matrix_000 = new BasicCharacterStateMatrix<Integer>(ints);
            matrix_000.toString();
            if (matrix_000.getNumberOfCharacters() != 4) {
                return false;
            }
            if (matrix_000.getNumberOfIdentifiers() != 3) {
                return false;
            }
            if ((Integer)matrix_000.getState(0, 1) != 2) {
                return false;
            }
            if ((Integer)matrix_000.getState(2, 3) != 12) {
                return false;
            }
            Integer[][] ints0 = new Integer[][]{{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}};
            BasicCharacterStateMatrix<Integer> matrix_0000 = new BasicCharacterStateMatrix<Integer>(ints0);
            if (!((Object)matrix_000).equals(matrix_0000)) {
                return false;
            }
            Integer[][] ints00 = new Integer[][]{{1, 2, 3, -4}, {5, 6, 7, 8}, {9, 10, 11, 12}};
            BasicCharacterStateMatrix<Integer> matrix_00000 = new BasicCharacterStateMatrix<Integer>(ints00);
            if (((Object)matrix_000).equals(matrix_00000)) {
                return false;
            }
            CharacterStateMatrix clone0 = matrix_0.copy();
            CharacterStateMatrix clone00 = matrix_00.copy();
            if (!clone0.equals(matrix_0)) {
                return false;
            }
            if (!clone00.equals(matrix_00)) {
                return false;
            }
            if (clone00.equals(clone0)) {
                return false;
            }
            CharacterStateMatrix pivot0 = matrix_0.pivot();
            CharacterStateMatrix pivot00 = matrix_00.pivot();
            if (!((String)pivot0.getState(1, 0)).equals("01")) {
                return false;
            }
            if (!((String)pivot0.getState(6, 2)).equals("26")) {
                return false;
            }
            if (!((String)matrix_0.getState(2, 6)).equals("26")) {
                return false;
            }
            CharacterStateMatrix pivotpivot00 = pivot00.pivot();
            if (!pivotpivot00.equals(matrix_00)) {
                return false;
            }
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> nex = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(4, 3);
            nex.setIdentifier(0, "amphioxus");
            nex.setIdentifier(1, "sponge");
            nex.setIdentifier(2, "sea_anemone");
            nex.setIdentifier(3, "cobra");
            nex.setCharacter(0, "notch");
            nex.setCharacter(1, "homeobox");
            nex.setCharacter(2, "wnt");
            nex.setState(0, 0, CharacterStateMatrix.BinaryStates.ABSENT);
            nex.setState(0, 1, CharacterStateMatrix.BinaryStates.ABSENT);
            nex.setState(0, 2, CharacterStateMatrix.BinaryStates.ABSENT);
            nex.setState(1, 0, CharacterStateMatrix.BinaryStates.PRESENT);
            nex.setState(1, 1, CharacterStateMatrix.BinaryStates.PRESENT);
            nex.setState(1, 2, CharacterStateMatrix.BinaryStates.ABSENT);
            nex.setState(2, 0, CharacterStateMatrix.BinaryStates.PRESENT);
            nex.setState(2, 1, CharacterStateMatrix.BinaryStates.PRESENT);
            nex.setState(2, 2, CharacterStateMatrix.BinaryStates.PRESENT);
            nex.setState(3, 0, CharacterStateMatrix.BinaryStates.PRESENT);
            nex.setState(3, 1, CharacterStateMatrix.BinaryStates.ABSENT);
            nex.setState(3, 2, CharacterStateMatrix.BinaryStates.ABSENT);
            StringWriter w = new StringWriter();
            nex.toWriter(w, CharacterStateMatrix.Format.NEXUS_BINARY);
            w = new StringWriter();
            nex.pivot().toWriter(w, CharacterStateMatrix.Format.NEXUS_BINARY);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testBasicSymmetricalDistanceMatrix() {
        try {
            BasicSymmetricalDistanceMatrix matrix_0 = new BasicSymmetricalDistanceMatrix(4);
            matrix_0.setIdentifier(0, "A");
            matrix_0.setIdentifier(1, "B");
            matrix_0.setIdentifier(2, "C");
            matrix_0.setIdentifier(3, "0123456789012");
            matrix_0.setValue(1, 0, 1.0E-5);
            matrix_0.setValue(0, 2, 9.0E-7);
            matrix_0.setValue(3, 0, 3.0);
            matrix_0.setValue(1, 2, 4.0);
            matrix_0.setValue(3, 1, 5.0);
            matrix_0.setValue(2, 3, 6.0);
            if (!matrix_0.getIdentifier(0).equals("A")) {
                return false;
            }
            if (!matrix_0.getIdentifier(1).equals("B")) {
                return false;
            }
            if (!matrix_0.getIdentifier(2).equals("C")) {
                return false;
            }
            if (!matrix_0.getIdentifier(3).equals("0123456789012")) {
                return false;
            }
            if (matrix_0.getSize() != 4) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(matrix_0.getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(matrix_0.getValue(3, 3), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(matrix_0.getValue(0, 1), 1.0E-5)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(matrix_0.getValue(0, 2), 9.0E-7)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(matrix_0.getValue(0, 3), 3.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(matrix_0.getValue(1, 0), 1.0E-5)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(matrix_0.getValue(1, 2), 4.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(matrix_0.getValue(1, 3), 5.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(matrix_0.getValue(2, 0), 9.0E-7)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(matrix_0.getValue(2, 1), 4.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(matrix_0.getValue(2, 3), 6.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(matrix_0.getValue(3, 0), 3.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(matrix_0.getValue(3, 1), 5.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(matrix_0.getValue(3, 2), 6.0)) {
                return false;
            }
            StringBuffer matrix_0_phylip = new StringBuffer();
            matrix_0_phylip.append("    4");
            matrix_0_phylip.append(ForesterUtil.LINE_SEPARATOR);
            matrix_0_phylip.append("A           0.000000  0.000010  0.000001  3.000000");
            matrix_0_phylip.append(ForesterUtil.LINE_SEPARATOR);
            matrix_0_phylip.append("B           0.000010  0.000000  4.000000  5.000000");
            matrix_0_phylip.append(ForesterUtil.LINE_SEPARATOR);
            matrix_0_phylip.append("C           0.000001  4.000000  0.000000  6.000000");
            matrix_0_phylip.append(ForesterUtil.LINE_SEPARATOR);
            matrix_0_phylip.append("0123456789  3.000000  5.000000  6.000000  0.000000");
            if (!matrix_0_phylip.toString().equals(matrix_0.toStringBuffer(DistanceMatrix.Format.PHYLIP).toString())) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDistanceCalculationMethods(File test_dir) {
        try {
            Msa msa0 = GeneralMsaParser.parse(new FileInputStream(test_dir + ForesterUtil.FILE_SEPARATOR + "bcl.aln"));
            BasicSymmetricalDistanceMatrix pwd0 = PairwiseDistanceCalculator.calcKimuraDistances(msa0);
            if (pwd0.getSize() != 120) {
                return false;
            }
            for (int i = 0; i < pwd0.getSize(); ++i) {
                if (TestPhylogenyReconstruction.isEqual(pwd0.getValue(i, i), 0.0)) continue;
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDolloParsimony() {
        try {
            CharacterStateMatrix.BinaryStates PRESENT = CharacterStateMatrix.BinaryStates.PRESENT;
            CharacterStateMatrix.BinaryStates ABSENT = CharacterStateMatrix.BinaryStates.ABSENT;
            CharacterStateMatrix.GainLossStates UNCHANGED_PRESENT = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
            DolloParsimony dollo1 = DolloParsimony.createInstance();
            PhylogenyFactory factory1 = ParserBasedPhylogenyFactory.getInstance();
            String p1_str = "((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r";
            Phylogeny p1 = factory1.create("((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m1 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(9, 1);
            m1.setIdentifier(0, "a");
            m1.setIdentifier(1, "b");
            m1.setIdentifier(2, "c");
            m1.setIdentifier(3, "d");
            m1.setIdentifier(4, "e");
            m1.setIdentifier(5, "f");
            m1.setIdentifier(6, "g");
            m1.setIdentifier(7, "h");
            m1.setIdentifier(8, "i");
            m1.setCharacter(0, "0");
            m1.setState("a", "0", PRESENT);
            m1.setState("b", "0", ABSENT);
            m1.setState("c", "0", PRESENT);
            m1.setState("d", "0", ABSENT);
            m1.setState("e", "0", ABSENT);
            m1.setState("f", "0", ABSENT);
            m1.setState("g", "0", ABSENT);
            m1.setState("h", "0", ABSENT);
            m1.setState("i", "0", ABSENT);
            dollo1.execute(p1, m1);
            if (dollo1.getTotalGains() != 1) {
                return false;
            }
            if (dollo1.getTotalLosses() != 1) {
                return false;
            }
            if (dollo1.getTotalUnchanged() != 15) {
                return false;
            }
            m1.setState("b", "0", PRESENT);
            dollo1.execute(p1, m1);
            if (dollo1.getTotalGains() != 1) {
                return false;
            }
            if (dollo1.getTotalLosses() != 0) {
                return false;
            }
            if (dollo1.getTotalUnchanged() != 16) {
                return false;
            }
            m1.setState("b", "0", ABSENT);
            m1.setState("e", "0", PRESENT);
            dollo1.execute(p1, m1);
            if (dollo1.getTotalGains() != 1) {
                return false;
            }
            if (dollo1.getTotalLosses() != 3) {
                return false;
            }
            if (dollo1.getTotalUnchanged() != 13) {
                return false;
            }
            m1.setState("a", "0", ABSENT);
            m1.setState("c", "0", ABSENT);
            m1.setState("g", "0", PRESENT);
            dollo1.setReturnInternalStates(true);
            dollo1.setReturnGainLossMatrix(true);
            dollo1.execute(p1, m1);
            if (dollo1.getTotalGains() != 1) {
                return false;
            }
            if (dollo1.getTotalLosses() != 3) {
                return false;
            }
            if (dollo1.getTotalUnchanged() != 13) {
                return false;
            }
            DolloParsimony dollo2 = DolloParsimony.createInstance();
            PhylogenyFactory factory2 = ParserBasedPhylogenyFactory.getInstance();
            String p2_str = "((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h,i)gi)ai,((j,k,l)jl,(m,n,o)mo,(p,q,r)pr)jr)root";
            Phylogeny p2 = factory2.create("((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h,i)gi)ai,((j,k,l)jl,(m,n,o)mo,(p,q,r)pr)jr)root", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m2 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(18, 4);
            m2.setIdentifier(0, "a");
            m2.setIdentifier(1, "b");
            m2.setIdentifier(2, "c");
            m2.setIdentifier(3, "d");
            m2.setIdentifier(4, "e");
            m2.setIdentifier(5, "f");
            m2.setIdentifier(6, "g");
            m2.setIdentifier(7, "h");
            m2.setIdentifier(8, "i");
            m2.setIdentifier(9, "j");
            m2.setIdentifier(10, "k");
            m2.setIdentifier(11, "l");
            m2.setIdentifier(12, "m");
            m2.setIdentifier(13, "n");
            m2.setIdentifier(14, "o");
            m2.setIdentifier(15, "p");
            m2.setIdentifier(16, "q");
            m2.setIdentifier(17, "r");
            m2.setCharacter(0, "0");
            m2.setCharacter(1, "1");
            m2.setCharacter(2, "2");
            m2.setCharacter(3, "3");
            m2.setState("a", "0", PRESENT);
            m2.setState("b", "0", ABSENT);
            m2.setState("c", "0", PRESENT);
            m2.setState("d", "0", ABSENT);
            m2.setState("e", "0", ABSENT);
            m2.setState("f", "0", ABSENT);
            m2.setState("g", "0", ABSENT);
            m2.setState("h", "0", ABSENT);
            m2.setState("i", "0", ABSENT);
            m2.setState("j", "0", ABSENT);
            m2.setState("k", "0", ABSENT);
            m2.setState("l", "0", ABSENT);
            m2.setState("m", "0", ABSENT);
            m2.setState("n", "0", ABSENT);
            m2.setState("o", "0", ABSENT);
            m2.setState("p", "0", ABSENT);
            m2.setState("q", "0", ABSENT);
            m2.setState("r", "0", ABSENT);
            m2.setState("a", "1", PRESENT);
            m2.setState("b", "1", ABSENT);
            m2.setState("c", "1", PRESENT);
            m2.setState("d", "1", ABSENT);
            m2.setState("e", "1", ABSENT);
            m2.setState("f", "1", ABSENT);
            m2.setState("g", "1", PRESENT);
            m2.setState("h", "1", ABSENT);
            m2.setState("i", "1", ABSENT);
            m2.setState("j", "1", PRESENT);
            m2.setState("k", "1", ABSENT);
            m2.setState("l", "1", ABSENT);
            m2.setState("m", "1", PRESENT);
            m2.setState("n", "1", ABSENT);
            m2.setState("o", "1", ABSENT);
            m2.setState("p", "1", ABSENT);
            m2.setState("q", "1", ABSENT);
            m2.setState("r", "1", ABSENT);
            m2.setState("a", "2", ABSENT);
            m2.setState("b", "2", ABSENT);
            m2.setState("c", "2", ABSENT);
            m2.setState("d", "2", ABSENT);
            m2.setState("e", "2", ABSENT);
            m2.setState("f", "2", ABSENT);
            m2.setState("g", "2", ABSENT);
            m2.setState("h", "2", ABSENT);
            m2.setState("i", "2", ABSENT);
            m2.setState("j", "2", PRESENT);
            m2.setState("k", "2", ABSENT);
            m2.setState("l", "2", ABSENT);
            m2.setState("m", "2", PRESENT);
            m2.setState("n", "2", ABSENT);
            m2.setState("o", "2", ABSENT);
            m2.setState("p", "2", PRESENT);
            m2.setState("q", "2", ABSENT);
            m2.setState("r", "2", ABSENT);
            m2.setState("a", "3", ABSENT);
            m2.setState("b", "3", ABSENT);
            m2.setState("c", "3", PRESENT);
            m2.setState("d", "3", ABSENT);
            m2.setState("e", "3", ABSENT);
            m2.setState("f", "3", ABSENT);
            m2.setState("g", "3", PRESENT);
            m2.setState("h", "3", ABSENT);
            m2.setState("i", "3", ABSENT);
            m2.setState("j", "3", ABSENT);
            m2.setState("k", "3", ABSENT);
            m2.setState("l", "3", ABSENT);
            m2.setState("m", "3", ABSENT);
            m2.setState("n", "3", ABSENT);
            m2.setState("o", "3", ABSENT);
            m2.setState("p", "3", ABSENT);
            m2.setState("q", "3", ABSENT);
            m2.setState("r", "3", ABSENT);
            dollo2.setReturnInternalStates(true);
            dollo2.setReturnGainLossMatrix(true);
            dollo2.execute(p2, m2);
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> i_m = dollo2.getInternalStatesMatrix();
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m = dollo2.getGainLossMatrix();
            if (dollo2.getTotalGains() != 3) {
                return false;
            }
            if (dollo2.getTotalLosses() != 22) {
                return false;
            }
            if (dollo2.getTotalUnchanged() != 95) {
                return false;
            }
            if (i_m.getState("ab", "0") != PRESENT) {
                return false;
            }
            if (i_m.getState("ac", "0") != PRESENT) {
                return false;
            }
            if (i_m.getState("ad", "0") != ABSENT) {
                return false;
            }
            if (i_m.getState("af", "0") != ABSENT) {
                return false;
            }
            if (i_m.getState("ef", "0") != ABSENT) {
                return false;
            }
            if (i_m.getState("ai", "0") != ABSENT) {
                return false;
            }
            if (i_m.getState("gi", "0") != ABSENT) {
                return false;
            }
            if (i_m.getState("jl", "0") != ABSENT) {
                return false;
            }
            if (i_m.getState("mo", "0") != ABSENT) {
                return false;
            }
            if (i_m.getState("pr", "0") != ABSENT) {
                return false;
            }
            if (i_m.getState("jr", "0") != ABSENT) {
                return false;
            }
            if (i_m.getState("root", "0") != ABSENT) {
                return false;
            }
            if (i_m.getState("ab", "1") != PRESENT) {
                return false;
            }
            if (i_m.getState("ac", "1") != PRESENT) {
                return false;
            }
            if (i_m.getState("ad", "1") != PRESENT) {
                return false;
            }
            if (i_m.getState("af", "1") != PRESENT) {
                return false;
            }
            if (i_m.getState("ef", "1") != ABSENT) {
                return false;
            }
            if (i_m.getState("ai", "1") != PRESENT) {
                return false;
            }
            if (i_m.getState("gi", "1") != PRESENT) {
                return false;
            }
            if (i_m.getState("jl", "1") != PRESENT) {
                return false;
            }
            if (i_m.getState("mo", "1") != PRESENT) {
                return false;
            }
            if (i_m.getState("pr", "1") != ABSENT) {
                return false;
            }
            if (i_m.getState("jr", "1") != PRESENT) {
                return false;
            }
            if (i_m.getState("root", "1") != PRESENT) {
                return false;
            }
            if (i_m.getState("ab", "2") != ABSENT) {
                return false;
            }
            if (i_m.getState("ac", "2") != ABSENT) {
                return false;
            }
            if (i_m.getState("ad", "2") != ABSENT) {
                return false;
            }
            if (i_m.getState("af", "2") != ABSENT) {
                return false;
            }
            if (i_m.getState("ef", "2") != ABSENT) {
                return false;
            }
            if (i_m.getState("ai", "2") != ABSENT) {
                return false;
            }
            if (i_m.getState("gi", "2") != ABSENT) {
                return false;
            }
            if (i_m.getState("jl", "2") != PRESENT) {
                return false;
            }
            if (i_m.getState("mo", "2") != PRESENT) {
                return false;
            }
            if (i_m.getState("pr", "2") != PRESENT) {
                return false;
            }
            if (i_m.getState("jr", "2") != PRESENT) {
                return false;
            }
            if (i_m.getState("root", "2") != ABSENT) {
                return false;
            }
            if (i_m.getState("ab", "3") != ABSENT) {
                return false;
            }
            if (i_m.getState("ac", "3") != PRESENT) {
                return false;
            }
            if (i_m.getState("ad", "3") != PRESENT) {
                return false;
            }
            if (i_m.getState("af", "3") != PRESENT) {
                return false;
            }
            if (i_m.getState("ef", "3") != ABSENT) {
                return false;
            }
            if (i_m.getState("ai", "3") != PRESENT) {
                return false;
            }
            if (i_m.getState("gi", "3") != PRESENT) {
                return false;
            }
            if (i_m.getState("jl", "3") != ABSENT) {
                return false;
            }
            if (i_m.getState("mo", "3") != ABSENT) {
                return false;
            }
            if (i_m.getState("pr", "3") != ABSENT) {
                return false;
            }
            if (i_m.getState("jr", "3") != ABSENT) {
                return false;
            }
            if (i_m.getState("root", "3") != ABSENT) {
                return false;
            }
            if (gl_m.getState("a", "0") != UNCHANGED_PRESENT) {
                return false;
            }
            DolloParsimony dollo9 = DolloParsimony.createInstance();
            PhylogenyFactory factory9 = ParserBasedPhylogenyFactory.getInstance();
            String p9_str = "((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r";
            Phylogeny p9 = factory9.create("((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r", new NHXParser())[0];
            m1 = new BasicCharacterStateMatrix(9, 3);
            m1.setIdentifier(0, "a");
            m1.setIdentifier(1, "b");
            m1.setIdentifier(2, "c");
            m1.setIdentifier(3, "d");
            m1.setIdentifier(4, "e");
            m1.setIdentifier(5, "f");
            m1.setIdentifier(6, "g");
            m1.setIdentifier(7, "h");
            m1.setIdentifier(8, "i");
            m1.setState(0, 0, PRESENT);
            m1.setState(1, 0, ABSENT);
            m1.setState(2, 0, PRESENT);
            m1.setState(3, 0, ABSENT);
            m1.setState(4, 0, ABSENT);
            m1.setState(5, 0, ABSENT);
            m1.setState(6, 0, ABSENT);
            m1.setState(7, 0, ABSENT);
            m1.setState(8, 0, ABSENT);
            m1.setState(0, 1, PRESENT);
            m1.setState(1, 1, PRESENT);
            m1.setState(2, 1, PRESENT);
            m1.setState(3, 1, PRESENT);
            m1.setState(4, 1, ABSENT);
            m1.setState(5, 1, ABSENT);
            m1.setState(6, 1, ABSENT);
            m1.setState(7, 1, ABSENT);
            m1.setState(8, 1, ABSENT);
            m1.setState(0, 2, PRESENT);
            m1.setState(1, 2, ABSENT);
            m1.setState(2, 2, ABSENT);
            m1.setState(3, 2, ABSENT);
            m1.setState(4, 2, ABSENT);
            m1.setState(5, 2, ABSENT);
            m1.setState(6, 2, ABSENT);
            m1.setState(7, 2, PRESENT);
            m1.setState(8, 2, ABSENT);
            dollo9.execute(p9, m1);
            if (dollo9.getTotalGains() != 3) {
                return false;
            }
            if (dollo9.getTotalLosses() != 6) {
                return false;
            }
            DolloParsimony dollo10 = DolloParsimony.createInstance();
            PhylogenyFactory factory10 = ParserBasedPhylogenyFactory.getInstance();
            String p10_str = "((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r";
            Phylogeny p10 = factory10.create("((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m10 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(9, 1);
            m10.setIdentifier(0, "a");
            m10.setIdentifier(1, "b");
            m10.setIdentifier(2, "c");
            m10.setIdentifier(3, "d");
            m10.setIdentifier(4, "e");
            m10.setIdentifier(5, "f");
            m10.setIdentifier(6, "g");
            m10.setIdentifier(7, "h");
            m10.setIdentifier(8, "i");
            m10.setState(0, 0, PRESENT);
            m10.setState(1, 0, ABSENT);
            m10.setState(2, 0, PRESENT);
            m10.setState(3, 0, ABSENT);
            m10.setState(4, 0, ABSENT);
            m10.setState(5, 0, ABSENT);
            m10.setState(6, 0, ABSENT);
            m10.setState(7, 0, ABSENT);
            m10.setState(8, 0, ABSENT);
            dollo10.execute(p10, m10);
            if (dollo10.getTotalGains() != 1) {
                return false;
            }
            if (dollo10.getTotalLosses() != 1) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDolloParsimonyOnNonBinaryTree() {
        try {
            CharacterStateMatrix.BinaryStates PRESENT = CharacterStateMatrix.BinaryStates.PRESENT;
            CharacterStateMatrix.BinaryStates ABSENT = CharacterStateMatrix.BinaryStates.ABSENT;
            DolloParsimony dollo1 = DolloParsimony.createInstance();
            PhylogenyFactory factory1 = ParserBasedPhylogenyFactory.getInstance();
            String p1_str = "((((((a,b,y)aby,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r";
            Phylogeny p1 = factory1.create("((((((a,b,y)aby,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m1 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(10, 1);
            m1.setIdentifier(0, "a");
            m1.setIdentifier(1, "b");
            m1.setIdentifier(2, "y");
            m1.setIdentifier(3, "c");
            m1.setIdentifier(4, "d");
            m1.setIdentifier(5, "e");
            m1.setIdentifier(6, "f");
            m1.setIdentifier(7, "g");
            m1.setIdentifier(8, "h");
            m1.setIdentifier(9, "i");
            m1.setCharacter(0, "0");
            m1.setState("a", "0", PRESENT);
            m1.setState("b", "0", ABSENT);
            m1.setState("y", "0", PRESENT);
            m1.setState("c", "0", PRESENT);
            m1.setState("d", "0", ABSENT);
            m1.setState("e", "0", ABSENT);
            m1.setState("f", "0", ABSENT);
            m1.setState("g", "0", ABSENT);
            m1.setState("h", "0", ABSENT);
            m1.setState("i", "0", ABSENT);
            dollo1.execute(p1, m1);
            if (dollo1.getTotalGains() != 1) {
                return false;
            }
            if (dollo1.getTotalLosses() != 1) {
                return false;
            }
            if (dollo1.getTotalUnchanged() != 16) {
                return false;
            }
            m1.setState("b", "0", PRESENT);
            dollo1.execute(p1, m1);
            if (dollo1.getTotalGains() != 1) {
                return false;
            }
            if (dollo1.getTotalLosses() != 0) {
                return false;
            }
            if (dollo1.getTotalUnchanged() != 17) {
                return false;
            }
            m1.setState("a", "0", ABSENT);
            m1.setState("b", "0", ABSENT);
            dollo1.execute(p1, m1);
            if (dollo1.getTotalGains() != 1) {
                return false;
            }
            if (dollo1.getTotalLosses() != 2) {
                return false;
            }
            if (dollo1.getTotalUnchanged() != 15) {
                return false;
            }
            m1.setState("y", "0", ABSENT);
            dollo1.execute(p1, m1);
            if (dollo1.getTotalGains() != 1) {
                return false;
            }
            if (dollo1.getTotalLosses() != 0) {
                return false;
            }
            if (dollo1.getTotalUnchanged() != 17) {
                return false;
            }
            DolloParsimony dollo2 = DolloParsimony.createInstance();
            PhylogenyFactory factory2 = ParserBasedPhylogenyFactory.getInstance();
            String p2_str = "((((((a,b,y)aby,c,d)cad,e,f)af,(g,h)gh)ah,i))r";
            Phylogeny p2 = factory2.create("((((((a,b,y)aby,c,d)cad,e,f)af,(g,h)gh)ah,i))r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m2 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(10, 1);
            m2.setIdentifier(0, "a");
            m2.setIdentifier(1, "b");
            m2.setIdentifier(2, "y");
            m2.setIdentifier(3, "c");
            m2.setIdentifier(4, "d");
            m2.setIdentifier(5, "e");
            m2.setIdentifier(6, "f");
            m2.setIdentifier(7, "g");
            m2.setIdentifier(8, "h");
            m2.setIdentifier(9, "i");
            m2.setCharacter(0, "0");
            m2.setState("a", "0", PRESENT);
            m2.setState("b", "0", ABSENT);
            m2.setState("y", "0", PRESENT);
            m2.setState("c", "0", PRESENT);
            m2.setState("d", "0", ABSENT);
            m2.setState("e", "0", ABSENT);
            m2.setState("f", "0", ABSENT);
            m2.setState("g", "0", ABSENT);
            m2.setState("h", "0", ABSENT);
            m2.setState("i", "0", ABSENT);
            dollo2.setReturnInternalStates(true);
            dollo2.execute(p2, m2);
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> i_m2 = dollo2.getInternalStatesMatrix();
            if (i_m2.getState("aby", "0") != PRESENT) {
                return false;
            }
            if (i_m2.getState("cad", "0") != PRESENT) {
                return false;
            }
            if (i_m2.getState("af", "0") != ABSENT) {
                return false;
            }
            if (i_m2.getState("gh", "0") != ABSENT) {
                return false;
            }
            if (i_m2.getState("ah", "0") != ABSENT) {
                return false;
            }
            if (i_m2.getState("r", "0") != ABSENT) {
                return false;
            }
            if (dollo2.getTotalGains() != 1) {
                return false;
            }
            if (dollo2.getTotalLosses() != 2) {
                return false;
            }
            if (dollo2.getTotalUnchanged() != 14) {
                return false;
            }
            m2.setState("b", "0", PRESENT);
            dollo2.execute(p2, m2);
            if (dollo2.getTotalGains() != 1) {
                return false;
            }
            if (dollo2.getTotalLosses() != 1) {
                return false;
            }
            if (dollo2.getTotalUnchanged() != 15) {
                return false;
            }
            m2.setState("a", "0", ABSENT);
            m2.setState("b", "0", ABSENT);
            dollo2.execute(p2, m2);
            if (dollo2.getTotalGains() != 1) {
                return false;
            }
            if (dollo2.getTotalLosses() != 3) {
                return false;
            }
            if (dollo2.getTotalUnchanged() != 13) {
                return false;
            }
            m2.setState("y", "0", ABSENT);
            dollo2.execute(p2, m2);
            if (dollo2.getTotalGains() != 1) {
                return false;
            }
            if (dollo2.getTotalLosses() != 0) {
                return false;
            }
            if (dollo2.getTotalUnchanged() != 16) {
                return false;
            }
            m2.setState("c", "0", ABSENT);
            dollo2.execute(p2, m2);
            if (dollo2.getTotalGains() != 0) {
                return false;
            }
            if (dollo2.getTotalLosses() != 0) {
                return false;
            }
            if (dollo2.getTotalUnchanged() != 17) {
                return false;
            }
            m2.setState("y", "0", PRESENT);
            m2.setState("e", "0", PRESENT);
            dollo2.execute(p2, m2);
            if (dollo2.getTotalGains() != 1) {
                return false;
            }
            if (dollo2.getTotalLosses() != 5) {
                return false;
            }
            if (dollo2.getTotalUnchanged() != 11) {
                return false;
            }
            i_m2 = dollo2.getInternalStatesMatrix();
            if (i_m2.getState("aby", "0") != PRESENT) {
                return false;
            }
            if (i_m2.getState("cad", "0") != PRESENT) {
                return false;
            }
            if (i_m2.getState("af", "0") != PRESENT) {
                return false;
            }
            if (i_m2.getState("gh", "0") != ABSENT) {
                return false;
            }
            if (i_m2.getState("ah", "0") != ABSENT) {
                return false;
            }
            if (i_m2.getState("r", "0") != ABSENT) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testFitchParsimony() {
        try {
            CharacterStateMatrix.BinaryStates PRESENT = CharacterStateMatrix.BinaryStates.PRESENT;
            CharacterStateMatrix.BinaryStates ABSENT = CharacterStateMatrix.BinaryStates.ABSENT;
            CharacterStateMatrix.GainLossStates GAIN = CharacterStateMatrix.GainLossStates.GAIN;
            CharacterStateMatrix.GainLossStates LOSS = CharacterStateMatrix.GainLossStates.LOSS;
            CharacterStateMatrix.GainLossStates UNCHANGED_PRESENT = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
            CharacterStateMatrix.GainLossStates UNCHANGED_ABSENT = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
            FitchParsimony fitch1 = new FitchParsimony();
            PhylogenyFactory factory1 = ParserBasedPhylogenyFactory.getInstance();
            String p1_str = "((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h,i)gi)ai,((j,k,l)jl,(m,n,o)mo,(p,q,r)pr)jr)root";
            Phylogeny p1 = factory1.create("((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h,i)gi)ai,((j,k,l)jl,(m,n,o)mo,(p,q,r)pr)jr)root", new NHXParser())[0];
            BasicCharacterStateMatrix<String> m1 = new BasicCharacterStateMatrix<String>(18, 1);
            m1.setIdentifier(0, "a");
            m1.setIdentifier(1, "b");
            m1.setIdentifier(2, "c");
            m1.setIdentifier(3, "d");
            m1.setIdentifier(4, "e");
            m1.setIdentifier(5, "f");
            m1.setIdentifier(6, "g");
            m1.setIdentifier(7, "h");
            m1.setIdentifier(8, "i");
            m1.setIdentifier(9, "j");
            m1.setIdentifier(10, "k");
            m1.setIdentifier(11, "l");
            m1.setIdentifier(12, "m");
            m1.setIdentifier(13, "n");
            m1.setIdentifier(14, "o");
            m1.setIdentifier(15, "p");
            m1.setIdentifier(16, "q");
            m1.setIdentifier(17, "r");
            m1.setCharacter(0, "0");
            m1.setState("a", "0", "A");
            m1.setState("b", "0", "A");
            m1.setState("c", "0", "B");
            m1.setState("d", "0", "C");
            m1.setState("e", "0", "D");
            m1.setState("f", "0", "A");
            m1.setState("g", "0", "A");
            m1.setState("h", "0", "B");
            m1.setState("i", "0", "C");
            m1.setState("j", "0", "A");
            m1.setState("k", "0", "B");
            m1.setState("l", "0", "C");
            m1.setState("m", "0", "B");
            m1.setState("n", "0", "B");
            m1.setState("o", "0", "B");
            m1.setState("p", "0", "A");
            m1.setState("q", "0", "C");
            m1.setState("r", "0", "D");
            fitch1.setReturnInternalStates(true);
            fitch1.setReturnGainLossMatrix(false);
            fitch1.setRandomize(false);
            fitch1.execute(p1, m1);
            CharacterStateMatrix i_m = fitch1.getInternalStatesMatrix();
            CharacterStateMatrix i_m_all = fitch1.getInternalStatesMatrixPriorToTraceback();
            if (fitch1.getCost() != 10) {
                return false;
            }
            if (!((String)i_m.getState("ab", "0")).equals("A")) {
                return false;
            }
            if (!((String)i_m.getState("ac", "0")).equals("A")) {
                return false;
            }
            if (!((String)i_m.getState("ad", "0")).equals("A")) {
                return false;
            }
            if (!((String)i_m.getState("ef", "0")).equals("A")) {
                return false;
            }
            if (!((String)i_m.getState("ai", "0")).equals("A")) {
                return false;
            }
            if (!((String)i_m.getState("gi", "0")).equals("A")) {
                return false;
            }
            if (!((String)i_m.getState("jl", "0")).equals("A")) {
                return false;
            }
            if (!((String)i_m.getState("mo", "0")).equals("B")) {
                return false;
            }
            if (!((String)i_m.getState("pr", "0")).equals("A")) {
                return false;
            }
            if (i_m_all.getState("ab", "0").size() != 1) {
                return false;
            }
            if (!i_m_all.getState("ab", "0").contains("A")) {
                return false;
            }
            if (i_m_all.getState("ac", "0").size() != 2) {
                return false;
            }
            if (!i_m_all.getState("ac", "0").contains("A")) {
                return false;
            }
            if (!i_m_all.getState("ac", "0").contains("B")) {
                return false;
            }
            if (i_m_all.getState("ad", "0").size() != 3) {
                return false;
            }
            if (!i_m_all.getState("ad", "0").contains("A")) {
                return false;
            }
            if (!i_m_all.getState("ad", "0").contains("B")) {
                return false;
            }
            if (!i_m_all.getState("ad", "0").contains("C")) {
                return false;
            }
            if (i_m_all.getState("af", "0").size() != 1) {
                return false;
            }
            if (!i_m_all.getState("af", "0").contains("A")) {
                return false;
            }
            if (i_m_all.getState("ef", "0").size() != 2) {
                return false;
            }
            if (!i_m_all.getState("ef", "0").contains("A")) {
                return false;
            }
            if (!i_m_all.getState("ef", "0").contains("D")) {
                return false;
            }
            if (i_m_all.getState("gi", "0").size() != 3) {
                return false;
            }
            if (!i_m_all.getState("gi", "0").contains("A")) {
                return false;
            }
            if (!i_m_all.getState("gi", "0").contains("B")) {
                return false;
            }
            if (!i_m_all.getState("gi", "0").contains("C")) {
                return false;
            }
            if (i_m_all.getState("ai", "0").size() != 1) {
                return false;
            }
            if (!i_m_all.getState("ai", "0").contains("A")) {
                return false;
            }
            if (i_m_all.getState("jl", "0").size() != 3) {
                return false;
            }
            if (!i_m_all.getState("jl", "0").contains("A")) {
                return false;
            }
            if (!i_m_all.getState("jl", "0").contains("B")) {
                return false;
            }
            if (!i_m_all.getState("jl", "0").contains("C")) {
                return false;
            }
            if (i_m_all.getState("mo", "0").size() != 1) {
                return false;
            }
            if (!i_m_all.getState("mo", "0").contains("B")) {
                return false;
            }
            if (i_m_all.getState("pr", "0").size() != 3) {
                return false;
            }
            if (!i_m_all.getState("pr", "0").contains("A")) {
                return false;
            }
            if (!i_m_all.getState("pr", "0").contains("C")) {
                return false;
            }
            if (!i_m_all.getState("pr", "0").contains("D")) {
                return false;
            }
            if (i_m_all.getState("jr", "0").size() != 4) {
                return false;
            }
            if (!i_m_all.getState("jr", "0").contains("A")) {
                return false;
            }
            if (!i_m_all.getState("jr", "0").contains("B")) {
                return false;
            }
            if (!i_m_all.getState("jr", "0").contains("C")) {
                return false;
            }
            if (!i_m_all.getState("jr", "0").contains("D")) {
                return false;
            }
            FitchParsimony fitch2 = new FitchParsimony();
            PhylogenyFactory factory2 = ParserBasedPhylogenyFactory.getInstance();
            String p2_str = "((a,b)ab,(c,(d,e)de)cde)r";
            Phylogeny p2 = factory2.create("((a,b)ab,(c,(d,e)de)cde)r", new NHXParser())[0];
            BasicCharacterStateMatrix<String> m2 = new BasicCharacterStateMatrix<String>(5, 1);
            m2.setIdentifier(0, "a");
            m2.setIdentifier(1, "b");
            m2.setIdentifier(2, "c");
            m2.setIdentifier(3, "d");
            m2.setIdentifier(4, "e");
            m2.setCharacter(0, "0");
            m2.setState("a", "0", "C");
            m2.setState("b", "0", "A");
            m2.setState("c", "0", "C");
            m2.setState("d", "0", "A");
            m2.setState("e", "0", "G");
            fitch2.setReturnInternalStates(true);
            fitch2.setReturnGainLossMatrix(false);
            fitch2.execute(p2, m2);
            CharacterStateMatrix i_m2 = fitch2.getInternalStatesMatrix();
            CharacterStateMatrix i_m_all2 = fitch2.getInternalStatesMatrixPriorToTraceback();
            if (fitch2.getCost() != 3) {
                return false;
            }
            if (!((String)i_m2.getState("ab", "0")).equals("A")) {
                return false;
            }
            if (!((String)i_m2.getState("de", "0")).equals("A")) {
                return false;
            }
            if (!((String)i_m2.getState("cde", "0")).equals("A")) {
                return false;
            }
            if (!((String)i_m2.getState("r", "0")).equals("A")) {
                return false;
            }
            if (i_m_all2.getState("cde", "0").size() != 3) {
                return false;
            }
            if (!i_m_all2.getState("cde", "0").contains("A")) {
                return false;
            }
            if (!i_m_all2.getState("cde", "0").contains("C")) {
                return false;
            }
            if (!i_m_all2.getState("cde", "0").contains("G")) {
                return false;
            }
            if (i_m_all2.getState("ab", "0").size() != 2) {
                return false;
            }
            if (!i_m_all2.getState("ab", "0").contains("A")) {
                return false;
            }
            if (!i_m_all2.getState("ab", "0").contains("C")) {
                return false;
            }
            fitch2.setReturnInternalStates(true);
            fitch2.setReturnGainLossMatrix(false);
            fitch2.setUseLast(true);
            fitch2.execute(p2, m2);
            CharacterStateMatrix i_m21 = fitch2.getInternalStatesMatrix();
            CharacterStateMatrix i_m_all21 = fitch2.getInternalStatesMatrixPriorToTraceback();
            if (fitch2.getCost() != 3) {
                return false;
            }
            if (!((String)i_m21.getState("ab", "0")).equals("C")) {
                return false;
            }
            if (!((String)i_m21.getState("de", "0")).equals("G")) {
                return false;
            }
            if (!((String)i_m21.getState("cde", "0")).equals("C")) {
                return false;
            }
            if (!((String)i_m21.getState("r", "0")).equals("C")) {
                return false;
            }
            if (i_m_all21.getState("cde", "0").size() != 3) {
                return false;
            }
            if (!i_m_all21.getState("cde", "0").contains("A")) {
                return false;
            }
            if (!i_m_all21.getState("cde", "0").contains("C")) {
                return false;
            }
            if (!i_m_all21.getState("cde", "0").contains("G")) {
                return false;
            }
            FitchParsimony fitch3 = new FitchParsimony();
            PhylogenyFactory factory3 = ParserBasedPhylogenyFactory.getInstance();
            String p3_str = "(((a,b)ab,((c,d)cd,e)cde)abcde,f)r";
            Phylogeny p3 = factory3.create("(((a,b)ab,((c,d)cd,e)cde)abcde,f)r", new NHXParser())[0];
            BasicCharacterStateMatrix<String> m3 = new BasicCharacterStateMatrix<String>(6, 1);
            m3.setIdentifier(0, "a");
            m3.setIdentifier(1, "b");
            m3.setIdentifier(2, "c");
            m3.setIdentifier(3, "d");
            m3.setIdentifier(4, "e");
            m3.setIdentifier(5, "f");
            m3.setCharacter(0, "0");
            m3.setState("a", "0", "C");
            m3.setState("b", "0", "U");
            m3.setState("c", "0", "G");
            m3.setState("d", "0", "U");
            m3.setState("e", "0", "A");
            m3.setState("f", "0", "A");
            fitch3.setReturnInternalStates(true);
            fitch3.setReturnGainLossMatrix(false);
            fitch3.execute(p3, m3);
            CharacterStateMatrix i_m3 = fitch3.getInternalStatesMatrix();
            CharacterStateMatrix i_m_all3 = fitch3.getInternalStatesMatrixPriorToTraceback();
            if (fitch3.getCost() != 4) {
                return false;
            }
            if (!((String)i_m3.getState("ab", "0")).equals("U")) {
                return false;
            }
            if (!((String)i_m3.getState("cd", "0")).equals("U")) {
                return false;
            }
            if (!((String)i_m3.getState("cde", "0")).equals("U")) {
                return false;
            }
            if (!((String)i_m3.getState("abcde", "0")).equals("U")) {
                return false;
            }
            if (!((String)i_m3.getState("r", "0")).equals("A")) {
                return false;
            }
            if (i_m_all3.getState("cde", "0").size() != 3) {
                return false;
            }
            if (!i_m_all3.getState("cde", "0").contains("A")) {
                return false;
            }
            if (!i_m_all3.getState("cde", "0").contains("G")) {
                return false;
            }
            if (!i_m_all3.getState("cde", "0").contains("U")) {
                return false;
            }
            if (i_m_all3.getState("ab", "0").size() != 2) {
                return false;
            }
            if (!i_m_all3.getState("ab", "0").contains("C")) {
                return false;
            }
            if (!i_m_all3.getState("ab", "0").contains("U")) {
                return false;
            }
            if (i_m_all3.getState("cd", "0").size() != 2) {
                return false;
            }
            if (!i_m_all3.getState("cd", "0").contains("G")) {
                return false;
            }
            if (!i_m_all3.getState("cd", "0").contains("U")) {
                return false;
            }
            if (i_m_all3.getState("abcde", "0").size() != 1) {
                return false;
            }
            if (!i_m_all3.getState("abcde", "0").contains("U")) {
                return false;
            }
            if (i_m_all3.getState("r", "0").size() != 2) {
                return false;
            }
            if (!i_m_all3.getState("r", "0").contains("A")) {
                return false;
            }
            if (!i_m_all3.getState("r", "0").contains("U")) {
                return false;
            }
            FitchParsimony fitch4 = new FitchParsimony();
            PhylogenyFactory factory4 = ParserBasedPhylogenyFactory.getInstance();
            String p4_str = "(((a,b)ab,((c,d)cd,e)cde)abcde,f)r";
            Phylogeny p4 = factory4.create("(((a,b)ab,((c,d)cd,e)cde)abcde,f)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m4 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(6, 1);
            m4.setIdentifier(0, "a");
            m4.setIdentifier(1, "b");
            m4.setIdentifier(2, "c");
            m4.setIdentifier(3, "d");
            m4.setIdentifier(4, "e");
            m4.setIdentifier(5, "f");
            m4.setCharacter(0, "0");
            m4.setState("a", "0", PRESENT);
            m4.setState("b", "0", ABSENT);
            m4.setState("c", "0", PRESENT);
            m4.setState("d", "0", PRESENT);
            m4.setState("e", "0", ABSENT);
            m4.setState("f", "0", ABSENT);
            fitch4.setReturnInternalStates(true);
            fitch4.setReturnGainLossMatrix(true);
            fitch4.execute(p4, m4);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_4 = fitch4.getGainLossMatrix();
            if (fitch4.getCost() != 2) {
                return false;
            }
            if (fitch4.getTotalLosses() != 0) {
                return false;
            }
            if (fitch4.getTotalGains() != 2) {
                return false;
            }
            if (fitch4.getTotalUnchanged() != 9) {
                return false;
            }
            if (gl_m_4.getState("a", "0") != GAIN) {
                return false;
            }
            if (gl_m_4.getState("b", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            if (gl_m_4.getState("ab", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            if (gl_m_4.getState("cd", "0") != GAIN) {
                return false;
            }
            if (gl_m_4.getState("r", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            FitchParsimony fitch5 = new FitchParsimony();
            PhylogenyFactory factory5 = ParserBasedPhylogenyFactory.getInstance();
            String p5_str = "(((a,b)ab,((c,d)cd,e)cde)abcde,f)r";
            Phylogeny p5 = factory5.create("(((a,b)ab,((c,d)cd,e)cde)abcde,f)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m5 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(6, 1);
            m5.setIdentifier(0, "a");
            m5.setIdentifier(1, "b");
            m5.setIdentifier(2, "c");
            m5.setIdentifier(3, "d");
            m5.setIdentifier(4, "e");
            m5.setIdentifier(5, "f");
            m5.setCharacter(0, "0");
            m5.setState("a", "0", PRESENT);
            m5.setState("b", "0", ABSENT);
            m5.setState("c", "0", PRESENT);
            m5.setState("d", "0", ABSENT);
            m5.setState("e", "0", PRESENT);
            m5.setState("f", "0", ABSENT);
            fitch5.setReturnInternalStates(true);
            fitch5.setReturnGainLossMatrix(true);
            fitch5.execute(p5, m5);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_5 = fitch5.getGainLossMatrix();
            if (fitch5.getCost() != 3) {
                return false;
            }
            if (fitch5.getTotalLosses() != 2) {
                return false;
            }
            if (fitch5.getTotalGains() != 1) {
                return false;
            }
            if (fitch5.getTotalUnchanged() != 8) {
                return false;
            }
            if (gl_m_5.getState("abcde", "0") != GAIN) {
                return false;
            }
            if (gl_m_5.getState("a", "0") != UNCHANGED_PRESENT) {
                return false;
            }
            if (gl_m_5.getState("b", "0") != LOSS) {
                return false;
            }
            if (gl_m_5.getState("d", "0") != LOSS) {
                return false;
            }
            if (gl_m_5.getState("r", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            FitchParsimony fitch6 = new FitchParsimony();
            PhylogenyFactory factory6 = ParserBasedPhylogenyFactory.getInstance();
            String p6_str = "(((a,b)ab,((c,d)cd,e)cde)abcde,f)r";
            Phylogeny p6 = factory6.create("(((a,b)ab,((c,d)cd,e)cde)abcde,f)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m6 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(6, 1);
            m6.setIdentifier(0, "a");
            m6.setIdentifier(1, "b");
            m6.setIdentifier(2, "c");
            m6.setIdentifier(3, "d");
            m6.setIdentifier(4, "e");
            m6.setIdentifier(5, "f");
            m6.setCharacter(0, "0");
            m6.setState("a", "0", PRESENT);
            m6.setState("b", "0", ABSENT);
            m6.setState("c", "0", PRESENT);
            m6.setState("d", "0", PRESENT);
            m6.setState("e", "0", ABSENT);
            m6.setState("f", "0", PRESENT);
            fitch6.setReturnInternalStates(true);
            fitch6.setReturnGainLossMatrix(true);
            fitch6.execute(p6, m6);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_6 = fitch6.getGainLossMatrix();
            if (fitch6.getCost() != 2) {
                return false;
            }
            if (fitch6.getTotalLosses() != 2) {
                return false;
            }
            if (fitch6.getTotalGains() != 0) {
                return false;
            }
            if (fitch6.getTotalUnchanged() != 9) {
                return false;
            }
            if (gl_m_6.getState("abcde", "0") != UNCHANGED_PRESENT) {
                return false;
            }
            if (gl_m_6.getState("r", "0") != UNCHANGED_PRESENT) {
                return false;
            }
            if (gl_m_6.getState("b", "0") != LOSS) {
                return false;
            }
            if (gl_m_6.getState("e", "0") != LOSS) {
                return false;
            }
            FitchParsimony fitch7 = new FitchParsimony();
            PhylogenyFactory factory7 = ParserBasedPhylogenyFactory.getInstance();
            String p7_str = "(((a,b)ab,(c,d)cd)abcd,((e,f)ef,(g,h)gh)efgh)r";
            Phylogeny p7 = factory7.create("(((a,b)ab,(c,d)cd)abcd,((e,f)ef,(g,h)gh)efgh)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m7 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(8, 1);
            m7.setIdentifier(0, "a");
            m7.setIdentifier(1, "b");
            m7.setIdentifier(2, "c");
            m7.setIdentifier(3, "d");
            m7.setIdentifier(4, "e");
            m7.setIdentifier(5, "f");
            m7.setIdentifier(6, "g");
            m7.setIdentifier(7, "h");
            m7.setCharacter(0, "0");
            m7.setState("a", "0", PRESENT);
            m7.setState("b", "0", ABSENT);
            m7.setState("c", "0", PRESENT);
            m7.setState("d", "0", ABSENT);
            m7.setState("e", "0", PRESENT);
            m7.setState("f", "0", ABSENT);
            m7.setState("g", "0", PRESENT);
            m7.setState("h", "0", ABSENT);
            fitch7.setReturnInternalStates(true);
            fitch7.setReturnGainLossMatrix(true);
            fitch7.execute(p7, m7);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_7 = fitch7.getGainLossMatrix();
            if (fitch7.getCost() != 4) {
                return false;
            }
            if (fitch7.getTotalLosses() != 0) {
                return false;
            }
            if (fitch7.getTotalGains() != 4) {
                return false;
            }
            if (fitch7.getTotalUnchanged() != 11) {
                return false;
            }
            if (gl_m_7.getState("a", "0") != GAIN) {
                return false;
            }
            if (gl_m_7.getState("c", "0") != GAIN) {
                return false;
            }
            if (gl_m_7.getState("e", "0") != GAIN) {
                return false;
            }
            if (gl_m_7.getState("g", "0") != GAIN) {
                return false;
            }
            if (gl_m_7.getState("r", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            fitch7.setReturnInternalStates(true);
            fitch7.setReturnGainLossMatrix(true);
            fitch7.setUseLast(true);
            fitch7.execute(p7, m7);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_71 = fitch7.getGainLossMatrix();
            if (fitch7.getCost() != 4) {
                return false;
            }
            if (fitch7.getTotalLosses() != 4) {
                return false;
            }
            if (fitch7.getTotalGains() != 0) {
                return false;
            }
            if (fitch7.getTotalUnchanged() != 11) {
                return false;
            }
            if (gl_m_71.getState("b", "0") != LOSS) {
                return false;
            }
            if (gl_m_71.getState("d", "0") != LOSS) {
                return false;
            }
            if (gl_m_71.getState("f", "0") != LOSS) {
                return false;
            }
            if (gl_m_71.getState("h", "0") != LOSS) {
                return false;
            }
            if (gl_m_71.getState("r", "0") != UNCHANGED_PRESENT) {
                return false;
            }
            FitchParsimony fitch8 = new FitchParsimony();
            PhylogenyFactory factory8 = ParserBasedPhylogenyFactory.getInstance();
            String p8_str = "(((a,b)ab,(c,d)cd)abcd,((e,f)ef,(g,h)gh)efgh)r";
            Phylogeny p8 = factory8.create("(((a,b)ab,(c,d)cd)abcd,((e,f)ef,(g,h)gh)efgh)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m8 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(8, 1);
            m8.setIdentifier(0, "a");
            m8.setIdentifier(1, "b");
            m8.setIdentifier(2, "c");
            m8.setIdentifier(3, "d");
            m8.setIdentifier(4, "e");
            m8.setIdentifier(5, "f");
            m8.setIdentifier(6, "g");
            m8.setIdentifier(7, "h");
            m8.setCharacter(0, "0");
            m8.setState("a", "0", PRESENT);
            m8.setState("b", "0", PRESENT);
            m8.setState("c", "0", PRESENT);
            m8.setState("d", "0", ABSENT);
            m8.setState("e", "0", ABSENT);
            m8.setState("f", "0", ABSENT);
            m8.setState("g", "0", ABSENT);
            m8.setState("h", "0", ABSENT);
            fitch8.setReturnInternalStates(true);
            fitch8.setReturnGainLossMatrix(true);
            fitch8.execute(p8, m8);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_8 = fitch8.getGainLossMatrix();
            if (fitch8.getCost() != 2) {
                return false;
            }
            if (fitch8.getTotalLosses() != 1) {
                return false;
            }
            if (fitch8.getTotalGains() != 1) {
                return false;
            }
            if (fitch8.getTotalUnchanged() != 13) {
                return false;
            }
            if (gl_m_8.getState("d", "0") != LOSS) {
                return false;
            }
            if (gl_m_8.getState("abcd", "0") != GAIN) {
                return false;
            }
            FitchParsimony fitch9 = new FitchParsimony();
            PhylogenyFactory factory9 = ParserBasedPhylogenyFactory.getInstance();
            String p9_str = "(((a,b)ab,c)abc,d)abcd";
            Phylogeny p9 = factory9.create("(((a,b)ab,c)abc,d)abcd", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m9 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(4, 1);
            m9.setIdentifier(0, "a");
            m9.setIdentifier(1, "b");
            m9.setIdentifier(2, "c");
            m9.setIdentifier(3, "d");
            m9.setCharacter(0, "0");
            m9.setState("a", "0", PRESENT);
            m9.setState("b", "0", ABSENT);
            m9.setState("c", "0", PRESENT);
            m9.setState("d", "0", ABSENT);
            fitch9.setReturnInternalStates(true);
            fitch9.setReturnGainLossMatrix(true);
            fitch9.setUseLast(false);
            fitch9.execute(p9, m9);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_9a = fitch9.getGainLossMatrix();
            if (fitch9.getCost() != 2) {
                return false;
            }
            if (fitch9.getTotalLosses() != 1) {
                return false;
            }
            if (fitch9.getTotalGains() != 1) {
                return false;
            }
            if (fitch9.getTotalUnchanged() != 5) {
                return false;
            }
            if (gl_m_9a.getState("a", "0") != UNCHANGED_PRESENT) {
                return false;
            }
            if (gl_m_9a.getState("b", "0") != LOSS) {
                return false;
            }
            if (gl_m_9a.getState("c", "0") != UNCHANGED_PRESENT) {
                return false;
            }
            if (gl_m_9a.getState("d", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            if (gl_m_9a.getState("ab", "0") != UNCHANGED_PRESENT) {
                return false;
            }
            if (gl_m_9a.getState("abc", "0") != GAIN) {
                return false;
            }
            if (gl_m_9a.getState("abcd", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            fitch9.setUseLast(true);
            fitch9.execute(p9, m9);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_9b = fitch9.getGainLossMatrix();
            if (fitch9.getCost() != 2) {
                return false;
            }
            if (fitch9.getTotalLosses() != 2) {
                return false;
            }
            if (fitch9.getTotalGains() != 0) {
                return false;
            }
            if (fitch9.getTotalUnchanged() != 5) {
                return false;
            }
            if (gl_m_9b.getState("a", "0") != UNCHANGED_PRESENT) {
                return false;
            }
            if (gl_m_9b.getState("b", "0") != LOSS) {
                return false;
            }
            if (gl_m_9b.getState("c", "0") != UNCHANGED_PRESENT) {
                return false;
            }
            if (gl_m_9b.getState("d", "0") != LOSS) {
                return false;
            }
            if (gl_m_9b.getState("ab", "0") != UNCHANGED_PRESENT) {
                return false;
            }
            if (gl_m_9b.getState("abc", "0") != UNCHANGED_PRESENT) {
                return false;
            }
            if (gl_m_9b.getState("abcd", "0") != UNCHANGED_PRESENT) {
                return false;
            }
            fitch9.setUseLast(false);
            fitch9.setRandomize(true);
            fitch9.setRandomNumberSeed(8722445L);
            fitch9.execute(p9, m9);
            fitch9.getGainLossMatrix();
            if (fitch9.getCost() != 2) {
                return false;
            }
            if (fitch9.getTotalLosses() != 1) {
                return false;
            }
            if (fitch9.getTotalGains() != 1) {
                return false;
            }
            if (fitch9.getTotalUnchanged() != 5) {
                return false;
            }
            FitchParsimony fitch10 = new FitchParsimony();
            PhylogenyFactory factory10 = ParserBasedPhylogenyFactory.getInstance();
            String p10_str = "((((a,b)ab,c)abc,d)abcd,e)abcde";
            Phylogeny p10 = factory10.create("((((a,b)ab,c)abc,d)abcd,e)abcde", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m10 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(5, 1);
            m10.setIdentifier(0, "a");
            m10.setIdentifier(1, "b");
            m10.setIdentifier(2, "c");
            m10.setIdentifier(3, "d");
            m10.setIdentifier(4, "e");
            m10.setCharacter(0, "0");
            m10.setState("a", "0", PRESENT);
            m10.setState("b", "0", ABSENT);
            m10.setState("c", "0", ABSENT);
            m10.setState("d", "0", PRESENT);
            m10.setState("e", "0", ABSENT);
            fitch10.setReturnInternalStates(true);
            fitch10.setReturnGainLossMatrix(true);
            fitch10.setUseLast(false);
            fitch10.execute(p10, m10);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_10a = fitch10.getGainLossMatrix();
            if (fitch10.getCost() != 2) {
                return false;
            }
            if (fitch10.getTotalLosses() != 0) {
                return false;
            }
            if (fitch10.getTotalGains() != 2) {
                return false;
            }
            if (fitch10.getTotalUnchanged() != 7) {
                return false;
            }
            if (gl_m_10a.getState("a", "0") != GAIN) {
                return false;
            }
            if (gl_m_10a.getState("b", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            if (gl_m_10a.getState("c", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            if (gl_m_10a.getState("d", "0") != GAIN) {
                return false;
            }
            if (gl_m_10a.getState("e", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            if (gl_m_10a.getState("ab", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            if (gl_m_10a.getState("abc", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            if (gl_m_10a.getState("abcd", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            if (gl_m_10a.getState("abcde", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            fitch10.setUseLast(true);
            fitch10.execute(p10, m10);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_10b = fitch10.getGainLossMatrix();
            if (fitch10.getCost() != 2) {
                return false;
            }
            if (fitch10.getTotalLosses() != 0) {
                return false;
            }
            if (fitch10.getTotalGains() != 2) {
                return false;
            }
            if (fitch10.getTotalUnchanged() != 7) {
                return false;
            }
            if (gl_m_10b.getState("a", "0") != GAIN) {
                return false;
            }
            if (gl_m_10b.getState("b", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            if (gl_m_10b.getState("c", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            if (gl_m_10b.getState("d", "0") != GAIN) {
                return false;
            }
            if (gl_m_10b.getState("e", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            if (gl_m_10b.getState("ab", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            if (gl_m_10b.getState("abc", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            if (gl_m_10b.getState("abcd", "0") != UNCHANGED_ABSENT) {
                return false;
            }
            if (gl_m_10b.getState("abcde", "0") != UNCHANGED_ABSENT) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testNeighborJoining(boolean verbose) {
        try {
            NeighborJoining nj2 = NeighborJoining.createInstance();
            BasicSymmetricalDistanceMatrix m0 = new BasicSymmetricalDistanceMatrix(4);
            m0.setIdentifier(0, "A");
            m0.setIdentifier(1, "B");
            m0.setIdentifier(2, "C");
            m0.setIdentifier(3, "D");
            m0.setRow("5 ", 1);
            m0.setRow("3 6 ", 2);
            m0.setRow("7.5 10.5 5.5", 3);
            Phylogeny p0 = nj2.execute(m0);
            p0.reRoot(p0.getNode("D"));
            if (TestPhylogenyReconstruction.isUnequal(p0.getNode("A").getDistanceToParent(), 1.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p0.getNode("B").getDistanceToParent(), 4.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p0.getNode("C").getDistanceToParent(), 0.5)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p0.getNode("D").getDistanceToParent(), 2.5)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p0.getNode("A").getParent().getDistanceToParent(), 1.5)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p0.getNode("A").getParent().getParent().getDistanceToParent(), 2.5)) {
                return false;
            }
            nj2 = NeighborJoining.createInstance();
            BasicSymmetricalDistanceMatrix m00 = new BasicSymmetricalDistanceMatrix(4);
            m00.setIdentifier(0, "A");
            m00.setIdentifier(1, "B");
            m00.setIdentifier(2, "C");
            m00.setIdentifier(3, "D");
            m00.setRow("2.01 ", 1);
            m00.setRow("3 3.01 ", 2);
            m00.setRow("3.01 3.02 1.01", 3);
            Phylogeny p00 = nj2.execute(m00);
            p00.reRoot(p00.getNode("D"));
            if (TestPhylogenyReconstruction.isUnequal(p00.getNode("A").getDistanceToParent(), 1.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p00.getNode("B").getDistanceToParent(), 1.01)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p00.getNode("C").getDistanceToParent(), 0.5)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p00.getNode("D").getDistanceToParent(), 0.255)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p00.getNode("A").getParent().getDistanceToParent(), 1.5)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p00.getNode("A").getParent().getParent().getDistanceToParent(), 0.255)) {
                return false;
            }
            BasicSymmetricalDistanceMatrix m = new BasicSymmetricalDistanceMatrix(6);
            m.setRow("5", 1);
            m.setRow("4 7", 2);
            m.setRow("7 10 7", 3);
            m.setRow("6 9 6 5", 4);
            m.setRow("8 11 8 9 8", 5);
            m.setIdentifier(0, "A");
            m.setIdentifier(1, "B");
            m.setIdentifier(2, "C");
            m.setIdentifier(3, "D");
            m.setIdentifier(4, "E");
            m.setIdentifier(5, "F");
            nj2 = NeighborJoining.createInstance();
            Phylogeny p1 = nj2.execute(m);
            p1.reRoot(p1.getNode("F"));
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("A").getDistanceToParent(), 1.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("B").getDistanceToParent(), 4.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("C").getDistanceToParent(), 2.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("D").getDistanceToParent(), 3.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("E").getDistanceToParent(), 2.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("F").getDistanceToParent(), 2.5)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("A").getParent().getDistanceToParent(), 1.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("A").getParent().getParent().getDistanceToParent(), 1.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("A").getParent().getParent().getParent().getDistanceToParent(), 2.5)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("B").getParent().getDistanceToParent(), 1.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("D").getParent().getDistanceToParent(), 1.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("E").getParent().getDistanceToParent(), 1.0)) {
                return false;
            }
            m = new BasicSymmetricalDistanceMatrix(7);
            m.setIdentifier(0, "Bovine");
            m.setIdentifier(1, "Mouse");
            m.setIdentifier(2, "Gibbon");
            m.setIdentifier(3, "Orang");
            m.setIdentifier(4, "Gorilla");
            m.setIdentifier(5, "Chimp");
            m.setIdentifier(6, "Human");
            m.setRow("0.00000 1.68660 1.71980 1.66060 1.52430 1.60430 1.59050", 0);
            m.setRow("1.68660 0.00000 1.52320 1.48410 1.44650 1.43890 1.46290", 1);
            m.setRow("1.71980 1.52320 0.00000 0.71150 0.59580 0.61790 0.55830", 2);
            m.setRow("1.66060 1.48410 0.71150 0.00000 0.46310 0.50610 0.47100", 3);
            m.setRow("1.52430 1.44650 0.59580 0.46310 0.00000 0.34840 0.30830", 4);
            m.setRow("1.60430 1.43890 0.61790 0.50610 0.34840 0.00000 0.26920", 5);
            m.setRow("1.59050 1.46290 0.55830 0.47100 0.30830 0.26920 0.00000", 6);
            nj2 = NeighborJoining.createInstance(verbose, 6);
            Phylogeny p2 = nj2.execute(m);
            p2.reRoot(p2.getNode("Bovine"));
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Chimp").getDistanceToParent(), 0.151675)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Human").getDistanceToParent(), 0.117525)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Gorilla").getDistanceToParent(), 0.153932)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Orang").getDistanceToParent(), 0.284694)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Gibbon").getDistanceToParent(), 0.357931)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Mouse").getDistanceToParent(), 0.76891)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Bovine").getDistanceToParent(), 0.458845)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Chimp").getParent().getDistanceToParent(), 0.039819)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Human").getParent().getDistanceToParent(), 0.039819)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Chimp").getParent().getParent().getDistanceToParent(), 0.026956)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Chimp").getParent().getParent().getParent().getDistanceToParent(), 0.046481)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Chimp").getParent().getParent().getParent().getParent().getDistanceToParent(), 0.420269)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Chimp").getParent().getParent().getParent().getParent().getParent().getDistanceToParent(), 0.458845)) {
                return false;
            }
            m = new BasicSymmetricalDistanceMatrix(4);
            m.setIdentifier(0, "A");
            m.setIdentifier(1, "B");
            m.setIdentifier(2, "C");
            m.setIdentifier(3, "D");
            m.setRow("0.00 0.95 0.17 0.98", 0);
            m.setRow("0.95 0.00 1.02 1.83", 1);
            m.setRow("0.17 1.02 0.00 1.01", 2);
            m.setRow("0.98 1.83 1.01 0.00", 3);
            Phylogeny p3 = nj2.execute(m);
            p3.reRoot(p3.getNode("C"));
            if (TestPhylogenyReconstruction.isUnequal(p3.getNode("A").getDistanceToParent(), 0.05)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p3.getNode("B").getDistanceToParent(), 0.9)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(p3.getNode("C").getDistanceToParent(), 0.05)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(p3.getNode("D").getDistanceToParent(), 0.91)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p3.getNode("A").getParent().getDistanceToParent(), 0.02)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p3.getNode("A").getParent().getParent().getDistanceToParent(), 0.05)) {
                return false;
            }
            NeighborJoiningF njf = NeighborJoiningF.createInstance();
            BasicSymmetricalDistanceMatrix m0f = new BasicSymmetricalDistanceMatrix(4);
            m0f.setIdentifier(0, "A");
            m0f.setIdentifier(1, "B");
            m0f.setIdentifier(2, "C");
            m0f.setIdentifier(3, "D");
            m0f.setRow("5 ", 1);
            m0f.setRow("3 6 ", 2);
            m0f.setRow("7.5 10.5 5.5", 3);
            Phylogeny p0f = njf.execute(m0f);
            p0f.reRoot(p0f.getNode("D"));
            if (TestPhylogenyReconstruction.isUnequal(p0f.getNode("A").getDistanceToParent(), 1.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p0f.getNode("B").getDistanceToParent(), 4.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p0f.getNode("C").getDistanceToParent(), 0.5)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p0f.getNode("D").getDistanceToParent(), 2.5)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p0f.getNode("A").getParent().getDistanceToParent(), 1.5)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p0f.getNode("A").getParent().getParent().getDistanceToParent(), 2.5)) {
                return false;
            }
            m = new BasicSymmetricalDistanceMatrix(7);
            m.setIdentifier(0, "Bovine");
            m.setIdentifier(1, "Mouse");
            m.setIdentifier(2, "Gibbon");
            m.setIdentifier(3, "Orang");
            m.setIdentifier(4, "Gorilla");
            m.setIdentifier(5, "Chimp");
            m.setIdentifier(6, "Human");
            m.setRow("0.00000 1.68660 1.71980 1.66060 1.52430 1.60430 1.59050", 0);
            m.setRow("1.68660 0.00000 1.52320 1.48410 1.44650 1.43890 1.46290", 1);
            m.setRow("1.71980 1.52320 0.00000 0.71150 0.59580 0.61790 0.55830", 2);
            m.setRow("1.66060 1.48410 0.71150 0.00000 0.46310 0.50610 0.47100", 3);
            m.setRow("1.52430 1.44650 0.59580 0.46310 0.00000 0.34840 0.30830", 4);
            m.setRow("1.60430 1.43890 0.61790 0.50610 0.34840 0.00000 0.26920", 5);
            m.setRow("1.59050 1.46290 0.55830 0.47100 0.30830 0.26920 0.00000", 6);
            njf = NeighborJoiningF.createInstance(verbose, 5);
            Phylogeny p2f = njf.execute(m);
            p2f.reRoot(p2f.getNode("Bovine"));
            if (TestPhylogenyReconstruction.isUnequal(p2f.getNode("Chimp").getDistanceToParent(), 0.15168)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2f.getNode("Human").getDistanceToParent(), 0.11752)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2f.getNode("Gorilla").getDistanceToParent(), 0.15393)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2f.getNode("Orang").getDistanceToParent(), 0.28469)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2f.getNode("Gibbon").getDistanceToParent(), 0.35793)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2f.getNode("Mouse").getDistanceToParent(), 0.76891)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2f.getNode("Bovine").getDistanceToParent(), 0.458845)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2f.getNode("Chimp").getParent().getDistanceToParent(), 0.03982)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2f.getNode("Human").getParent().getDistanceToParent(), 0.03982)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2f.getNode("Chimp").getParent().getParent().getDistanceToParent(), 0.02696)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2f.getNode("Chimp").getParent().getParent().getParent().getDistanceToParent(), 0.04648)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2f.getNode("Chimp").getParent().getParent().getParent().getParent().getDistanceToParent(), 0.42027)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2f.getNode("Chimp").getParent().getParent().getParent().getParent().getParent().getDistanceToParent(), 0.458845)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testS() {
        try {
            Sset s0 = new Sset();
            s0.initialize(1);
            s0.addPairing(0, 1, 0);
            s0.addPairing(7, 8, 0);
            s0.addPairing(4, 55, 0);
            s0.addPairing(2, 3, 0);
            s0.addPairing(4, 5, 0);
            s0.addPairing(5, 6666, 0);
            s0.addPairing(5, 666, 0);
            s0.addPairing(5, 66, 0);
            s0.addPairing(5, 6, 0);
            s0.addPairing(6, 7, 0);
            s0.addPairing(3, 4, 0);
            s0.addPairing(1, 2, 0);
            if (s0.size() != 1) {
                return false;
            }
            if (s0.getS(0).size() != 8) {
                return false;
            }
            if (s0.getValues(0, 0).size() != 1) {
                return false;
            }
            if (s0.getValues(1, 0).size() != 1) {
                return false;
            }
            if (s0.getValues(2, 0).size() != 1) {
                return false;
            }
            if (s0.getValues(3, 0).size() != 1) {
                return false;
            }
            if (s0.getValues(4, 0).size() != 2) {
                return false;
            }
            if (s0.getValues(5, 0).size() != 4) {
                return false;
            }
            if (s0.getValues(6, 0).size() != 1) {
                return false;
            }
            if (s0.getValues(7, 0).size() != 1) {
                return false;
            }
            if (!s0.getValues(0, 0).contains(1)) {
                return false;
            }
            if (!s0.getValues(5, 0).contains(6)) {
                return false;
            }
            if (!s0.getValues(5, 0).contains(66)) {
                return false;
            }
            if (!s0.getValues(5, 0).contains(666)) {
                return false;
            }
            if (!s0.getValues(5, 0).contains(6666)) {
                return false;
            }
            s0.removePairing(5, 6666, 0);
            if (s0.getValues(5, 0).contains(6666)) {
                return false;
            }
            s0.removePairing(5, 666, 0);
            if (s0.getValues(5, 0).contains(666)) {
                return false;
            }
            s0.removePairing(5, 66, 0);
            if (s0.getValues(5, 0).contains(66)) {
                return false;
            }
            if (s0.getValues(5, 0).size() != 1) {
                return false;
            }
            if (s0.getS(0).size() != 8) {
                return false;
            }
            s0.removePairing(5, 6, 0);
            if (s0.getS(0).size() != 7) {
                return false;
            }
            s0.addPairing(5, 6, 0);
            if (s0.getS(0).size() != 8) {
                return false;
            }
            if (s0.getValues(5, 0).size() != 1) {
                return false;
            }
            if (!s0.getValues(5, 0).contains(6)) {
                return false;
            }
            s0.addPairing(5, 403, 0);
            if (s0.getValues(5, 0).size() != 2) {
                return false;
            }
            if (!s0.getValues(5, 0).contains(403)) {
                return false;
            }
            s0.addPairing(693, 100, 0);
            s0.addPairing(693, 101, 0);
            if (s0.getValues(693, 0).size() != 2) {
                return false;
            }
            s0.addPairing(2, 33, 0);
            s0.addPairing(2, 333, 0);
            Set<Integer>[] a = s0.toArray(0);
            if (!a[0].contains(1)) {
                return false;
            }
            if (a[0].size() != 1) {
                return false;
            }
            if (!a[1].contains(2)) {
                return false;
            }
            if (a[1].size() != 1) {
                return false;
            }
            if (!a[2].contains(3)) {
                return false;
            }
            if (!a[2].contains(33)) {
                return false;
            }
            if (!a[2].contains(333)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testSarray() {
        try {
            Sarray s0 = new Sarray();
            s0.initialize(1);
            s0.addPairing(0, 1, 0);
            s0.addPairing(7, 8, 0);
            s0.addPairing(4, 55, 0);
            s0.addPairing(2, 3, 0);
            s0.addPairing(4, 5, 0);
            s0.addPairing(5, 6666, 0);
            s0.addPairing(5, 666, 0);
            s0.addPairing(5, 66, 0);
            s0.addPairing(5, 6, 0);
            s0.addPairing(6, 7, 0);
            s0.addPairing(3, 4, 0);
            s0.addPairing(1, 2, 0);
            if (s0.size() != 1) {
                return false;
            }
            if (s0.getS(0).size() != 8) {
                return false;
            }
            if (s0.getValues(0, 0).length != 1) {
                return false;
            }
            if (s0.getValues(1, 0).length != 1) {
                return false;
            }
            if (s0.getValues(2, 0).length != 1) {
                return false;
            }
            if (s0.getValues(3, 0).length != 1) {
                return false;
            }
            if (s0.getValues(4, 0).length != 2) {
                return false;
            }
            if (s0.getValues(5, 0).length != 4) {
                return false;
            }
            if (s0.getValues(6, 0).length != 1) {
                return false;
            }
            if (s0.getValues(7, 0).length != 1) {
                return false;
            }
            if (s0.getValues(0, 0)[0] != 1) {
                return false;
            }
            if (s0.getValues(5, 0)[3] != 6) {
                return false;
            }
            if (s0.getValues(5, 0)[2] != 66) {
                return false;
            }
            if (s0.getValues(5, 0)[1] != 666) {
                return false;
            }
            if (s0.getValues(5, 0)[0] != 6666) {
                return false;
            }
            s0.removePairing(5, 6666, 0);
            if (s0.getValues(5, 0).length != 3) {
                System.out.println(s0.getValues(5, 0).length);
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testNeighborJoiningR() {
        try {
            NeighborJoiningR nj0 = NeighborJoiningR.createInstance();
            BasicSymmetricalDistanceMatrix m0 = new BasicSymmetricalDistanceMatrix(4);
            m0.setIdentifier(0, "A");
            m0.setIdentifier(1, "B");
            m0.setIdentifier(2, "C");
            m0.setIdentifier(3, "D");
            m0.setRow("5 ", 1);
            m0.setRow("3 6 ", 2);
            m0.setRow("7.5 10.5 5.5", 3);
            Phylogeny p0 = nj0.execute(m0);
            p0.reRoot(p0.getNode("D"));
            if (TestPhylogenyReconstruction.isUnequal(p0.getNode("A").getDistanceToParent(), 1.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p0.getNode("B").getDistanceToParent(), 4.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p0.getNode("C").getDistanceToParent(), 0.5)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p0.getNode("D").getDistanceToParent(), 2.5)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p0.getNode("A").getParent().getDistanceToParent(), 1.5)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p0.getNode("A").getParent().getParent().getDistanceToParent(), 2.5)) {
                return false;
            }
            BasicSymmetricalDistanceMatrix m1 = new BasicSymmetricalDistanceMatrix(6);
            m1.setRow("5", 1);
            m1.setRow("4 7", 2);
            m1.setRow("7 10 7", 3);
            m1.setRow("6 9 6 5", 4);
            m1.setRow("8 11 8 9 8", 5);
            m1.setIdentifier(0, "A");
            m1.setIdentifier(1, "B");
            m1.setIdentifier(2, "C");
            m1.setIdentifier(3, "D");
            m1.setIdentifier(4, "E");
            m1.setIdentifier(5, "F");
            NeighborJoiningR nj1 = NeighborJoiningR.createInstance();
            Phylogeny p1 = nj1.execute(m1);
            p1.reRoot(p1.getNode("F"));
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("A").getDistanceToParent(), 1.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("B").getDistanceToParent(), 4.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("C").getDistanceToParent(), 2.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("D").getDistanceToParent(), 3.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("E").getDistanceToParent(), 2.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("F").getDistanceToParent(), 2.5)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("A").getParent().getDistanceToParent(), 1.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("A").getParent().getParent().getDistanceToParent(), 1.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("A").getParent().getParent().getParent().getDistanceToParent(), 2.5)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("B").getParent().getDistanceToParent(), 1.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("D").getParent().getDistanceToParent(), 1.0)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p1.getNode("E").getParent().getDistanceToParent(), 1.0)) {
                return false;
            }
            BasicSymmetricalDistanceMatrix m2 = new BasicSymmetricalDistanceMatrix(7);
            m2.setIdentifier(0, "Bovine");
            m2.setIdentifier(1, "Mouse");
            m2.setIdentifier(2, "Gibbon");
            m2.setIdentifier(3, "Orang");
            m2.setIdentifier(4, "Gorilla");
            m2.setIdentifier(5, "Chimp");
            m2.setIdentifier(6, "Human");
            m2.setRow("0.00000 1.68660 1.71980 1.66060 1.52430 1.60430 1.59050", 0);
            m2.setRow("1.68660 0.00000 1.52320 1.48410 1.44650 1.43890 1.46290", 1);
            m2.setRow("1.71980 1.52320 0.00000 0.71150 0.59580 0.61790 0.55830", 2);
            m2.setRow("1.66060 1.48410 0.71150 0.00000 0.46310 0.50610 0.47100", 3);
            m2.setRow("1.52430 1.44650 0.59580 0.46310 0.00000 0.34840 0.30830", 4);
            m2.setRow("1.60430 1.43890 0.61790 0.50610 0.34840 0.00000 0.26920", 5);
            m2.setRow("1.59050 1.46290 0.55830 0.47100 0.30830 0.26920 0.00000", 6);
            NeighborJoiningR nj2 = NeighborJoiningR.createInstance(true, 6);
            Phylogeny p2 = nj2.execute(m2);
            p2.reRoot(p2.getNode("Bovine"));
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Chimp").getDistanceToParent(), 0.151675)) {
                System.out.println(p2.getNode("Chimp").getDistanceToParent());
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Human").getDistanceToParent(), 0.117525)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Gorilla").getDistanceToParent(), 0.153931)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Orang").getDistanceToParent(), 0.284694)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Gibbon").getDistanceToParent(), 0.357931)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Mouse").getDistanceToParent(), 0.76891)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Bovine").getDistanceToParent(), 0.458845)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Chimp").getParent().getDistanceToParent(), 0.039819)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Human").getParent().getDistanceToParent(), 0.039819)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Chimp").getParent().getParent().getDistanceToParent(), 0.026956)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Chimp").getParent().getParent().getParent().getDistanceToParent(), 0.046481)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Chimp").getParent().getParent().getParent().getParent().getDistanceToParent(), 0.420269)) {
                return false;
            }
            if (TestPhylogenyReconstruction.isUnequal(p2.getNode("Chimp").getParent().getParent().getParent().getParent().getParent().getDistanceToParent(), 0.458845)) {
                return false;
            }
            BasicSymmetricalDistanceMatrix m3 = new BasicSymmetricalDistanceMatrix(20);
            m3.setIdentifier(0, "F_MOUSE");
            m3.setIdentifier(1, "11_RAT");
            m3.setIdentifier(2, "A_CAVPO");
            m3.setIdentifier(3, "D_HUMAN");
            m3.setIdentifier(4, "E_HUMAN");
            m3.setIdentifier(5, "F_HUMAN");
            m3.setIdentifier(6, "C_HUMAN");
            m3.setIdentifier(7, "6_FELCA");
            m3.setIdentifier(8, "D_MOUSE");
            m3.setIdentifier(9, "E_MOUSE");
            m3.setIdentifier(10, "E_RAT ");
            m3.setIdentifier(11, "C_MOUSE");
            m3.setIdentifier(12, "10_RAT");
            m3.setIdentifier(13, "3_TAEGU");
            m3.setIdentifier(14, "2_SACKO");
            m3.setIdentifier(15, "2_PANTR");
            m3.setIdentifier(16, "3_CANFA");
            m3.setIdentifier(17, "9_HUMAN");
            m3.setIdentifier(18, "A_HUMAN");
            m3.setIdentifier(19, "B_HUMAN");
            m3.setRow("0.000000  0.000010  0.020875  0.010376  0.010376  0.010376  0.010376  0.010368  0.000010  0.000010  0.000010  0.000010  0.000010  0.087165  0.743570  0.010376  0.010376  0.010376  0.010376  0.010376 ", 0);
            m3.setRow("0.000010  0.000000  0.020875  0.010376  0.010376  0.010376  0.010376  0.010368  0.000010  0.000010  0.000010  0.000010  0.000010  0.087165  0.743570  0.010376  0.010376  0.010376  0.010376  0.010376", 1);
            m3.setRow("0.020875  0.020875  0.000000  0.031503  0.031503  0.031503  0.031503  0.031477  0.020875  0.020875  0.020875  0.020875  0.020875  0.096983  0.768150  0.031503  0.031503  0.031503  0.031503  0.031503", 2);
            m3.setRow("0.010376  0.010376  0.031503  0.000000  0.000010  0.000010  0.000010  0.010375  0.010376  0.010376  0.010376  0.010376  0.010376  0.098678  0.741282  0.000010  0.000010  0.000010  0.000010  0.000010", 3);
            m3.setRow("0.010376  0.010376  0.031503  0.000010  0.000000  0.000010  0.000010  0.010375  0.010376  0.010376  0.010376  0.010376  0.010376  0.098678  0.741282  0.000010  0.000010  0.000010  0.000010  0.000010", 4);
            m3.setRow("0.010376  0.010376  0.031503  0.000010  0.000010  0.000000  0.000010  0.010375  0.010376  0.010376  0.010376  0.010376  0.010376  0.098678  0.741282  0.000010  0.000010  0.000010  0.000010  0.000010", 5);
            m3.setRow("0.010376  0.010376  0.031503  0.000010  0.000010  0.000010  0.000000  0.010375  0.010376  0.010376  0.010376  0.010376  0.010376  0.098678  0.741282  0.000010  0.000010  0.000010  0.000010  0.000010", 6);
            m3.setRow("0.010368  0.010368  0.031477  0.010375  0.010375  0.010375  0.010375  0.000000  0.010368  0.010368  0.010368  0.010368  0.010368  0.098591  0.745047  0.010375  0.010375  0.010375  0.010375  0.010375", 7);
            m3.setRow("0.000010  0.000010  0.020875  0.010376  0.010376  0.010376  0.010376  0.010368  0.000000  0.000010  0.000010  0.000010  0.000010  0.087165  0.743570  0.010376  0.010376  0.010376  0.010376  0.010376", 8);
            m3.setRow("0.000010  0.000010  0.020875  0.010376  0.010376  0.010376  0.010376  0.010368  0.000010  0.000000  0.000010  0.000010  0.000010  0.087165  0.743570  0.010376  0.010376  0.010376  0.010376  0.010376", 9);
            m3.setRow("0.000010  0.000010  0.020875  0.010376  0.010376  0.010376  0.010376  0.010368  0.000010  0.000010  0.000000  0.000010  0.000010  0.087165  0.743570  0.010376  0.010376  0.010376  0.010376  0.010376", 10);
            m3.setRow("0.000010  0.000010  0.020875  0.010376  0.010376  0.010376  0.010376  0.010368  0.000010  0.000010  0.000010  0.000000  0.000010  0.087165  0.743570  0.010376  0.010376  0.010376  0.010376  0.010376", 11);
            m3.setRow("0.000010  0.000010  0.020875  0.010376  0.010376  0.010376  0.010376  0.010368  0.000010  0.000010  0.000010  0.000010  0.000000  0.087165  0.743570  0.010376  0.010376  0.010376  0.010376  0.010376", 12);
            m3.setRow("0.087165  0.087165  0.096983  0.098678  0.098678  0.098678  0.098678  0.098591  0.087165  0.087165  0.087165  0.087165  0.087165  0.000000  0.720387  0.098678  0.098678  0.098678  0.098678  0.098678", 13);
            m3.setRow("0.743570  0.743570  0.768150  0.741282  0.741282  0.741282  0.741282  0.745047  0.743570  0.743570  0.743570  0.743570  0.743570  0.720387  0.000000  0.741282  0.741282  0.741282  0.741282  0.741282", 14);
            m3.setRow("0.010376  0.010376  0.031503  0.000010  0.000010  0.000010  0.000010  0.010375  0.010376  0.010376  0.010376  0.010376  0.010376  0.098678  0.741282  0.000000  0.000010  0.000010  0.000010  0.000010", 15);
            m3.setRow("0.010376  0.010376  0.031503  0.000010  0.000010  0.000010  0.000010  0.010375  0.010376  0.010376  0.010376  0.010376  0.010376  0.098678  0.741282  0.000010  0.000000  0.000010  0.000010  0.000010", 16);
            m3.setRow("0.010376  0.010376  0.031503  0.000010  0.000010  0.000010  0.000010  0.010375  0.010376  0.010376  0.010376  0.010376  0.010376  0.098678  0.741282  0.000010  0.000010  0.000000  0.000010  0.000010", 17);
            m3.setRow("0.010376  0.010376  0.031503  0.000010  0.000010  0.000010  0.000010  0.010375  0.010376  0.010376  0.010376  0.010376  0.010376  0.098678  0.741282  0.000010  0.000010  0.000010  0.000000  0.000010", 18);
            m3.setRow("0.010376  0.010376  0.031503  0.000010  0.000010  0.000010  0.000010  0.010375  0.010376  0.010376  0.010376  0.010376  0.010376  0.098678  0.741282  0.000010  0.000010  0.000010  0.000010  0.000000", 19);
            NeighborJoiningR nj3 = NeighborJoiningR.createInstance(false, 6);
            Phylogeny p3 = nj3.execute(m3);
            int size = 10;
            for (int n = 0; n <= 100; ++n) {
                NeighborJoiningR njn = NeighborJoiningR.createInstance(false, 6);
                BasicSymmetricalDistanceMatrix mt = new BasicSymmetricalDistanceMatrix(10);
                mt.randomize(new Date().getTime());
                long start_time = new Date().getTime();
                njn.execute(mt);
                System.out.println("Size: 10 -> " + (new Date().getTime() - start_time) + "ms");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testSymmetricalDistanceMatrixParser() {
        try {
            String l = ForesterUtil.getLineSeparator();
            StringBuffer source = new StringBuffer();
            source.append(" 4" + l);
            source.append("A 0 0 0 0" + l);
            source.append("B 1 0 0 0" + l);
            source.append("C 2 4 0 0" + l);
            source.append("D 3 5 6 0" + l);
            source.append(l);
            source.append(" 4" + l);
            source.append("A 0   11  12  13" + l);
            source.append("B 11  0   14  15" + l);
            source.append("C 12  14  0   16" + l);
            source.append("D 13  15  16  0" + l);
            source.append(l);
            source.append(l);
            source.append("     " + l);
            source.append(" 4" + l);
            source.append(" A        0     " + l);
            source.append(" B            21 0" + l);
            source.append(" C            22 24    0  " + l);
            source.append(" # 2 222 2 2 " + l);
            source.append(" D            23 25 26 0" + l);
            source.append(l);
            source.append(l);
            source.append("     " + l);
            SymmetricalDistanceMatrixParser p0 = SymmetricalDistanceMatrixParser.createInstance();
            DistanceMatrix[] ma0 = p0.parse(source.toString());
            if (ma0.length != 3) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[0].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[0].getValue(1, 0), 1.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[0].getValue(2, 0), 2.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[0].getValue(3, 0), 3.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[0].getValue(0, 1), 1.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[0].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[0].getValue(2, 1), 4.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[0].getValue(3, 1), 5.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[1].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[1].getValue(1, 0), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[1].getValue(2, 0), 12.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[1].getValue(3, 0), 13.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[1].getValue(0, 1), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[1].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[1].getValue(2, 1), 14.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[1].getValue(3, 1), 15.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[2].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[2].getValue(1, 0), 21.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[2].getValue(2, 0), 22.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[2].getValue(3, 0), 23.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[2].getValue(0, 1), 21.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[2].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[2].getValue(2, 1), 24.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma0[2].getValue(3, 1), 25.0)) {
                return false;
            }
            source = new StringBuffer();
            source.append("A 0 0 0 0" + l);
            source.append("B 1 0 0 0" + l);
            source.append("C 2 4 0 0" + l);
            source.append("D 3 5 6 0" + l);
            source.append(" " + l);
            source.append("A 0   11  12  13" + l);
            source.append("B 11  0   14  15" + l);
            source.append("C 12  14  0   16" + l);
            source.append("D 13  15  16  0" + l);
            source.append(l);
            source.append(" A        0     " + l);
            source.append(" B            21 0" + l);
            source.append(" C            22 24    0  " + l);
            source.append(" # 2 222 2 2 " + l);
            source.append(" D            23 25 26 0" + l);
            DistanceMatrix[] ma1 = p0.parse(source.toString());
            if (ma1.length != 3) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[0].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[0].getValue(1, 0), 1.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[0].getValue(2, 0), 2.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[0].getValue(3, 0), 3.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[0].getValue(0, 1), 1.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[0].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[0].getValue(2, 1), 4.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[0].getValue(3, 1), 5.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[1].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[1].getValue(1, 0), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[1].getValue(2, 0), 12.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[1].getValue(3, 0), 13.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[1].getValue(0, 1), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[1].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[1].getValue(2, 1), 14.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[1].getValue(3, 1), 15.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[2].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[2].getValue(1, 0), 21.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[2].getValue(2, 0), 22.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[2].getValue(3, 0), 23.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[2].getValue(0, 1), 21.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[2].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[2].getValue(2, 1), 24.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma1[2].getValue(3, 1), 25.0)) {
                return false;
            }
            source = new StringBuffer();
            source.append("A 0" + l);
            source.append("B 10 0" + l);
            DistanceMatrix[] ma2 = p0.parse(source.toString());
            if (ma2.length != 1) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma2[0].getValue(0, 1), 10.0)) {
                return false;
            }
            source = new StringBuffer();
            source.append(" " + l);
            source.append("#" + l);
            DistanceMatrix[] ma3 = p0.parse(source.toString());
            if (ma3.length != 0) {
                return false;
            }
            source = new StringBuffer();
            source.append(" " + l);
            source.append("A 0   11  12  13" + l);
            source.append("B     0   14  15" + l);
            source.append("C         0   16" + l);
            source.append("D              0" + l);
            source.append(l);
            source.append("A 0 21  22  23" + l);
            source.append("B 0 24  25" + l);
            source.append("C 0 26" + l);
            source.append("D 0" + l);
            p0.setInputMatrixType(SymmetricalDistanceMatrixParser.InputMatrixType.UPPER_TRIANGLE);
            DistanceMatrix[] ma4 = p0.parse(source);
            if (ma4.length != 2) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(1, 0), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(2, 0), 12.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(3, 0), 13.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(0, 1), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(2, 1), 14.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(3, 1), 15.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(0, 2), 12.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(1, 2), 14.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(2, 2), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(3, 2), 16.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(0, 3), 13.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(1, 3), 15.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(2, 3), 16.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma4[0].getValue(3, 3), 0.0)) {
                return false;
            }
            source = new StringBuffer();
            source.append(" 4 " + l);
            source.append("A 0   11  12  13" + l);
            source.append("B     0   14  15" + l);
            source.append("C         0   16" + l);
            source.append("D              0" + l);
            source.append(" 4" + l);
            source.append("A 0 21  22  23" + l);
            source.append("B 0 24  25" + l);
            source.append("C 0 26" + l);
            source.append("D 0" + l);
            source.append("     " + l);
            source.append(" 4" + l);
            source.append("A 0 21  22  23" + l);
            source.append("B 0 24  25" + l);
            source.append("C 0 26" + l);
            source.append("D 0" + l);
            source.append(l);
            source.append("A 0 21  22  23" + l);
            source.append("B 0 24  25" + l);
            source.append("C 0 26" + l);
            source.append("D 0" + l);
            p0.setInputMatrixType(SymmetricalDistanceMatrixParser.InputMatrixType.UPPER_TRIANGLE);
            DistanceMatrix[] ma5 = p0.parse(source);
            if (ma5.length != 4) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(0, 0), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(1, 0), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(2, 0), 12.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(3, 0), 13.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(0, 1), 11.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(1, 1), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(2, 1), 14.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(3, 1), 15.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(0, 2), 12.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(1, 2), 14.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(2, 2), 0.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(3, 2), 16.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(0, 3), 13.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(1, 3), 15.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(2, 3), 16.0)) {
                return false;
            }
            if (!TestPhylogenyReconstruction.isEqual(ma5[0].getValue(3, 3), 0.0)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static void timeNeighborJoining() {
        NeighborJoiningR njr = NeighborJoiningR.createInstance();
        for (int n = 3; n <= 10; ++n) {
            int x = (int)Math.pow(2.0, n);
            BasicSymmetricalDistanceMatrix mt = new BasicSymmetricalDistanceMatrix(x);
            mt.randomize(new Date().getTime());
            long start_time = new Date().getTime();
            njr.execute(mt);
            System.out.println("Size: " + x + " -> " + (new Date().getTime() - start_time) + "ms");
        }
        NeighborJoiningF njf = NeighborJoiningF.createInstance();
        for (int n = 3; n <= 10; ++n) {
            int x = (int)Math.pow(2.0, n);
            BasicSymmetricalDistanceMatrix mt = new BasicSymmetricalDistanceMatrix(x);
            mt.randomize(new Date().getTime());
            long start_time = new Date().getTime();
            njf.execute(mt);
            System.out.println("Size: " + x + " -> " + (new Date().getTime() - start_time) + "ms");
        }
        NeighborJoining nj2 = NeighborJoining.createInstance();
        for (int n = 3; n <= 10; ++n) {
            int x = (int)Math.pow(2.0, n);
            BasicSymmetricalDistanceMatrix mt = new BasicSymmetricalDistanceMatrix(x);
            mt.randomize(new Date().getTime());
            long start_time = new Date().getTime();
            nj2.execute(mt);
            System.out.println("Size: " + x + " -> " + (new Date().getTime() - start_time) + "ms");
        }
    }
}

