/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.matrix.distance;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;
import java.util.StringTokenizer;
import org.forester.evoinference.matrix.distance.DistanceMatrix;
import org.forester.util.ForesterUtil;
import org.forester.util.IllegalFormatUseException;

public final class BasicSymmetricalDistanceMatrix
implements DistanceMatrix {
    private static final NumberFormat PHYLIP_FORMATTER = new DecimalFormat("0.000000");
    final String[] _identifiers;
    final double[][] _values;

    public BasicSymmetricalDistanceMatrix(int size) {
        this._values = new double[size][size];
        this._identifiers = new String[size];
    }

    @Override
    public final String getIdentifier(int i) {
        return this._identifiers[i];
    }

    @Override
    public final int getIndex(String identifier) {
        for (int i = 0; i < this._identifiers.length; ++i) {
            if (!this.getIdentifier(i).equals(identifier)) continue;
            return i;
        }
        throw new IllegalArgumentException("identifier [" + identifier + "] not found in distance matrix");
    }

    @Override
    public final int getSize() {
        return this._values.length;
    }

    @Override
    public final double getValue(int col, int row) {
        if (col == row) {
            if (col >= this._values.length) {
                throw new IndexOutOfBoundsException("");
            }
            return 0.0;
        }
        if (col > row) {
            return this._values[row][col];
        }
        return this._values[col][row];
    }

    public final double[][] getValues() {
        return this._values;
    }

    public final void randomize(long seed) {
        Random r = new Random(seed);
        for (int j = 0; j < this.getSize(); ++j) {
            for (int i = 0; i < j; ++i) {
                this.setValue(i, j, r.nextDouble());
            }
        }
    }

    @Override
    public final void setIdentifier(int i, String identifier) {
        this._identifiers[i] = identifier;
    }

    public final void setRow(String s, int row) {
        StringTokenizer tk = new StringTokenizer(s);
        int i = 0;
        while (tk.hasMoreElements()) {
            this.setValue(i, row, new Double(tk.nextToken()));
            ++i;
        }
    }

    @Override
    public final void setValue(int col, int row, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("negative distance value");
        }
        if (col == row && d != 0.0) {
            throw new IllegalArgumentException("attempt to set a non-zero value on the diagonal of a symmetrical distance matrix");
        }
        if (col > row) {
            this._values[row][col] = d;
        }
        this._values[col][row] = d;
    }

    public final String toString() {
        return this.toPhylip().toString();
    }

    @Override
    public final StringBuffer toStringBuffer(DistanceMatrix.Format format) {
        switch (format) {
            case PHYLIP: {
                return this.toPhylip();
            }
        }
        throw new IllegalArgumentException("Unknown format:" + (Object)((Object)format));
    }

    public final void write(Writer w) throws IOException {
        w.write("    ");
        w.write(this.getSize() + "");
        w.write(ForesterUtil.LINE_SEPARATOR);
        for (int row = 0; row < this.getSize(); ++row) {
            if (ForesterUtil.isEmpty(this.getIdentifier(row))) {
                throw new IllegalFormatUseException("Phylip format does not allow empty identifiers");
            }
            w.write(ForesterUtil.pad(this.getIdentifier(row), 10, ' ', false).toString());
            w.write(32);
            w.write(32);
            for (int col = 0; col < this.getSize(); ++col) {
                w.write(PHYLIP_FORMATTER.format(this.getValue(col, row)));
                if (col >= this.getSize() - 1) continue;
                w.write(32);
                w.write(32);
            }
            if (row >= this.getSize() - 1) continue;
            w.write(ForesterUtil.LINE_SEPARATOR);
        }
    }

    private final StringBuffer toPhylip() {
        StringBuffer sb = new StringBuffer();
        sb.append(' ');
        sb.append(' ');
        sb.append(' ');
        sb.append(' ');
        sb.append(this.getSize());
        sb.append(ForesterUtil.LINE_SEPARATOR);
        for (int row = 0; row < this.getSize(); ++row) {
            if (ForesterUtil.isEmpty(this.getIdentifier(row))) {
                throw new IllegalFormatUseException("Phylip format does not allow empty identifiers");
            }
            sb.append(ForesterUtil.pad(this.getIdentifier(row), 10, ' ', false));
            sb.append(' ');
            sb.append(' ');
            for (int col = 0; col < this.getSize(); ++col) {
                sb.append(PHYLIP_FORMATTER.format(this.getValue(col, row)));
                if (col >= this.getSize() - 1) continue;
                sb.append(' ');
                sb.append(' ');
            }
            if (row >= this.getSize() - 1) continue;
            sb.append(ForesterUtil.LINE_SEPARATOR);
        }
        return sb;
    }
}

