/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go.etc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.forester.go.GoId;
import org.forester.util.ForesterUtil;

public class OntologizerResult
implements Comparable<OntologizerResult> {
    private final GoId _goid;
    private final int _pop_total;
    private final int _pop_term;
    private final int _study_total;
    private final int _study_term;
    private final int _pop_family;
    private final int _study_family;
    private final int _nparents;
    private final boolean _is_trivial;
    private final double _p;
    private final double _p_adjusted;
    private final double _p_min;
    private final TYPE _type;

    private OntologizerResult(String s) {
        if (ForesterUtil.isEmpty(s)) {
            throw new IllegalArgumentException("result string is null or empty");
        }
        String[] tokens = s.split("\t");
        if (tokens.length != 9 && tokens.length != 11 && tokens.length != 12) {
            throw new IllegalArgumentException("result string [" + s + "] has unexpected format");
        }
        this._goid = new GoId(tokens[0]);
        this._pop_total = Integer.parseInt(tokens[1]);
        this._pop_term = Integer.parseInt(tokens[2]);
        this._study_total = Integer.parseInt(tokens[3]);
        this._study_term = Integer.parseInt(tokens[4]);
        if (tokens.length == 11) {
            this._type = TYPE.TOPOLOGY;
            this._pop_family = Integer.parseInt(tokens[5]);
            this._study_family = Integer.parseInt(tokens[6]);
            this._is_trivial = Boolean.parseBoolean(tokens[7]);
            this._p = Double.parseDouble(tokens[8]);
            this._p_adjusted = Double.parseDouble(tokens[9]);
            this._p_min = Double.parseDouble(tokens[10]);
            this._nparents = -1;
        } else if (tokens.length == 9) {
            this._type = TYPE.TERM_FOR_TERM;
            this._pop_family = -1;
            this._study_family = -1;
            this._nparents = -1;
            this._is_trivial = false;
            this._p = Double.parseDouble(tokens[5]);
            this._p_adjusted = Double.parseDouble(tokens[6]);
            this._p_min = Double.parseDouble(tokens[7]);
        } else {
            this._type = TYPE.PARENT_CHILD;
            this._pop_family = Integer.parseInt(tokens[5]);
            this._study_family = Integer.parseInt(tokens[6]);
            this._nparents = Integer.parseInt(tokens[7]);
            this._is_trivial = Boolean.parseBoolean(tokens[8]);
            this._p = Double.parseDouble(tokens[9]);
            this._p_adjusted = Double.parseDouble(tokens[10]);
            this._p_min = Double.parseDouble(tokens[11]);
        }
    }

    @Override
    public int compareTo(OntologizerResult o) {
        if (this == o) {
            return 0;
        }
        if (this.getPAdjusted() < o.getPAdjusted()) {
            return -1;
        }
        if (this.getPAdjusted() > o.getPAdjusted()) {
            return 1;
        }
        return 0;
    }

    public GoId getGoId() {
        return this._goid;
    }

    public int getNParents() {
        return this._nparents;
    }

    public double getP() {
        return this._p;
    }

    public double getPAdjusted() {
        return this._p_adjusted;
    }

    public double getPMin() {
        return this._p_min;
    }

    public int getPopFamily() {
        return this._pop_family;
    }

    public int getPopTerm() {
        return this._pop_term;
    }

    public int getPopTotal() {
        return this._pop_total;
    }

    public int getStudyFamily() {
        return this._study_family;
    }

    public int getStudyTerm() {
        return this._study_term;
    }

    public int getStudyTotal() {
        return this._study_total;
    }

    public TYPE getType() {
        return this._type;
    }

    public boolean isTrivial() {
        return this._is_trivial;
    }

    public static List<OntologizerResult> parse(File input) throws IOException {
        String error = ForesterUtil.isReadableFile(input);
        if (!ForesterUtil.isEmpty(error)) {
            throw new IOException(error);
        }
        BufferedReader br = new BufferedReader(new FileReader(input));
        ArrayList<OntologizerResult> results = new ArrayList<OntologizerResult>();
        int line_number = 0;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                ++line_number;
                if (!(line = line.trim()).startsWith("GO:")) continue;
                results.add(new OntologizerResult(line));
            }
        }
        catch (Exception e) {
            throw new IOException("parsing problem [at line " + line_number + "] in [" + input + "]: " + e.getMessage());
        }
        return results;
    }

    public static enum TYPE {
        TOPOLOGY,
        TERM_FOR_TERM,
        PARENT_CHILD;

    }
}

