/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.BinaryCharactersParser;
import org.forester.io.parsers.phyloxml.data.BranchWidthParser;
import org.forester.io.parsers.phyloxml.data.ColorParser;
import org.forester.io.parsers.phyloxml.data.ConfidenceParser;
import org.forester.io.parsers.phyloxml.data.DateParser;
import org.forester.io.parsers.phyloxml.data.DistributionParser;
import org.forester.io.parsers.phyloxml.data.EventParser;
import org.forester.io.parsers.phyloxml.data.IdentifierParser;
import org.forester.io.parsers.phyloxml.data.PropertyParser;
import org.forester.io.parsers.phyloxml.data.ReferenceParser;
import org.forester.io.parsers.phyloxml.data.SequenceParser;
import org.forester.io.parsers.phyloxml.data.SequenceRelationParser;
import org.forester.io.parsers.phyloxml.data.TaxonomyParser;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.BranchWidth;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Date;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.NodeVisualData;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.Reference;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.SequenceRelation;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.FailedConditionCheckException;
import org.forester.util.ForesterUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PhyloXmlHandler
extends DefaultHandler {
    private static final String PHYLOXML = "phyloxml";
    private String _current_element_name;
    private Phylogeny _current_phylogeny;
    private List<Phylogeny> _phylogenies;
    private XmlElement _current_xml_element;
    private PhylogenyNode _current_node;
    private static Map<Phylogeny, HashMap<String, Sequence>> phylogenySequencesById = new HashMap<Phylogeny, HashMap<String, Sequence>>();

    PhyloXmlHandler() {
    }

    private void addNode() {
        PhylogenyNode new_node = new PhylogenyNode();
        this.getCurrentNode().addAsChild(new_node);
        this.setCurrentNode(new_node);
    }

    @Override
    public void characters(char[] chars, int start_index, int end_index) {
        if (this.getCurrentXmlElement() != null && this.getCurrentElementName() != null && !this.getCurrentElementName().equals("clade") && !this.getCurrentElementName().equals("phylogeny")) {
            if (!ForesterUtil.isEmpty(this.getCurrentXmlElement().getValueAsString())) {
                this.getCurrentXmlElement().appendValue(new String(chars, start_index, end_index));
            } else {
                this.getCurrentXmlElement().setValue(new String(chars, start_index, end_index));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void endElement(String namespace_uri, String local_name, String qualified_name) throws SAXException {
        if (ForesterUtil.isEmpty(namespace_uri) || namespace_uri.startsWith("http://www.phyloxml.org")) {
            if (local_name.equals("clade")) {
                try {
                    this.mapElementToPhylogenyNode(this.getCurrentXmlElement(), this.getCurrentNode());
                    if (!this.getCurrentNode().isRoot()) {
                        this.setCurrentNode(this.getCurrentNode().getParent());
                    }
                    this.getCurrentXmlElement().setValue(null);
                    this.setCurrentXmlElement(this.getCurrentXmlElement().getParent());
                }
                catch (PhylogenyParserException ex) {
                    throw new SAXException(ex.getMessage());
                }
                catch (PhyloXmlDataFormatException e) {
                    throw new SAXException(e.getMessage());
                }
            }
            if (local_name.equals("sequence_relation")) {
                try {
                    if (this.getCurrentPhylogeny() == null) ** GOTO lbl60
                    seqRelation = (SequenceRelation)SequenceRelationParser.getInstance(this.getCurrentPhylogeny()).parse(this.getCurrentXmlElement());
                    sequencesById = PhyloXmlHandler.getSequenceMapByIdForPhylogeny(this.getCurrentPhylogeny());
                    ref0 = sequencesById.get(seqRelation.getRef0().getSourceId());
                    ref1 = sequencesById.get(seqRelation.getRef1().getSourceId());
                    if (ref0 != null) {
                        fFoundReverse = false;
                        for (SequenceRelation sr : ref0.getSequenceRelations()) {
                            if (!sr.getType().equals((Object)seqRelation.getType()) || (!sr.getRef0().isEqual(ref1) || !sr.getRef1().isEqual(ref0)) && (!sr.getRef0().isEqual(ref0) || !sr.getRef1().isEqual(ref1))) continue;
                            fFoundReverse = true;
                            if (sr.getConfidence() != null || seqRelation.getConfidence() == null) continue;
                            sr.setConfidence(seqRelation.getConfidence());
                        }
                        if (!fFoundReverse) {
                            ref0.addSequenceRelation(seqRelation);
                        }
                    }
                    if (ref1 != null) {
                        fFoundReverse = false;
                        for (SequenceRelation sr : ref1.getSequenceRelations()) {
                            if (!sr.getType().equals((Object)seqRelation.getType()) || (!sr.getRef0().isEqual(ref1) || !sr.getRef1().isEqual(ref0)) && (!sr.getRef0().isEqual(ref0) || !sr.getRef1().isEqual(ref1))) continue;
                            fFoundReverse = true;
                            if (sr.getConfidence() != null || seqRelation.getConfidence() == null) continue;
                            sr.setConfidence(seqRelation.getConfidence());
                        }
                        if (!fFoundReverse) {
                            ref1.addSequenceRelation(seqRelation);
                        }
                    }
                    if ((relationTypesForCurrentPhylogeny = this.getCurrentPhylogeny().getRelevantSequenceRelationTypes()).contains((Object)seqRelation.getType())) ** GOTO lbl60
                    relationTypesForCurrentPhylogeny.add(seqRelation.getType());
                }
                catch (PhyloXmlDataFormatException ex) {
                    throw new SAXException(ex.getMessage());
                }
            } else if (local_name.equals("phylogeny")) {
                try {
                    PhyloXmlHandler.mapElementToPhylogeny(this.getCurrentXmlElement(), this.getCurrentPhylogeny());
                }
                catch (PhylogenyParserException e) {
                    throw new SAXException(e.getMessage());
                }
                catch (PhyloXmlDataFormatException e) {
                    throw new SAXException(e.getMessage());
                }
                this.finishPhylogeny();
                this.reset();
            } else if (!local_name.equals("phyloxml") && this.getCurrentPhylogeny() != null && this.getCurrentXmlElement().getParent() != null) {
                this.setCurrentXmlElement(this.getCurrentXmlElement().getParent());
            }
lbl60:
            // 8 sources

            this.setCurrentElementName(null);
        }
    }

    private void finishPhylogeny() throws SAXException {
        this.getCurrentPhylogeny().recalculateNumberOfExternalDescendants(false);
        this.getPhylogenies().add(this.getCurrentPhylogeny());
        HashMap<String, Sequence> phyloSequences = phylogenySequencesById.get(this.getCurrentPhylogeny());
        if (phyloSequences != null) {
            this.getCurrentPhylogeny().setSequenceRelationQueries(phyloSequences.values());
            phylogenySequencesById.remove(this.getCurrentPhylogeny());
        }
    }

    private String getCurrentElementName() {
        return this._current_element_name;
    }

    private PhylogenyNode getCurrentNode() {
        return this._current_node;
    }

    private Phylogeny getCurrentPhylogeny() {
        return this._current_phylogeny;
    }

    private XmlElement getCurrentXmlElement() {
        return this._current_xml_element;
    }

    List<Phylogeny> getPhylogenies() {
        return this._phylogenies;
    }

    private void init() {
        this.reset();
        this.setPhylogenies(new ArrayList<Phylogeny>());
    }

    private void initCurrentNode() {
        if (this.getCurrentNode() != null) {
            throw new FailedConditionCheckException("attempt to create new current node when current node already exists");
        }
        if (this.getCurrentPhylogeny() == null) {
            throw new FailedConditionCheckException("attempt to create new current node for non-existing phylogeny");
        }
        PhylogenyNode node = new PhylogenyNode();
        this.getCurrentPhylogeny().setRoot(node);
        this.setCurrentNode(this.getCurrentPhylogeny().getRoot());
    }

    private void mapElementToPhylogenyNode(XmlElement xml_element, PhylogenyNode node) throws PhylogenyParserException, PhyloXmlDataFormatException {
        String collapse_str;
        if (xml_element.isHasAttribute("branch_length")) {
            double d = 0.0;
            try {
                d = Double.parseDouble(xml_element.getAttribute("branch_length"));
            }
            catch (NumberFormatException e) {
                throw new PhylogenyParserException("ill formatted distance in clade attribute [" + xml_element.getAttribute("branch_length") + "]: " + e.getMessage());
            }
            node.setDistanceToParent(d);
        }
        if (xml_element.isHasAttribute("collapse") && !ForesterUtil.isEmpty(collapse_str = xml_element.getAttribute("collapse")) && collapse_str.trim().equalsIgnoreCase("true")) {
            node.setCollapse(true);
        }
        for (int i = 0; i < xml_element.getNumberOfChildElements(); ++i) {
            XmlElement element = xml_element.getChildElement(i);
            String qualified_name = element.getQualifiedName();
            if (qualified_name.equals("branch_length")) {
                if (node.getDistanceToParent() != -1024.0) {
                    throw new PhylogenyParserException("ill advised attempt to set distance twice for the same clade (probably via element and via attribute)");
                }
                node.setDistanceToParent(element.getValueAsDouble());
            }
            if (qualified_name.equals("name")) {
                node.setName(element.getValueAsString());
                continue;
            }
            if (qualified_name.equals("taxonomy")) {
                node.getNodeData().addTaxonomy((Taxonomy)TaxonomyParser.getInstance().parse(element));
                continue;
            }
            if (qualified_name.equals("sequence")) {
                Sequence sequence = (Sequence)SequenceParser.getInstance().parse(element);
                node.getNodeData().addSequence(sequence);
                String sourceId = sequence.getSourceId();
                if (this.getCurrentPhylogeny() == null || ForesterUtil.isEmpty(sourceId)) continue;
                PhyloXmlHandler.getSequenceMapByIdForPhylogeny(this.getCurrentPhylogeny()).put(sourceId, sequence);
                continue;
            }
            if (qualified_name.equals("distribution")) {
                node.getNodeData().addDistribution((Distribution)DistributionParser.getInstance().parse(element));
                continue;
            }
            if (qualified_name.equals("date")) {
                node.getNodeData().setDate((Date)DateParser.getInstance().parse(element));
                continue;
            }
            if (qualified_name.equals("reference")) {
                node.getNodeData().addReference((Reference)ReferenceParser.getInstance().parse(element));
                continue;
            }
            if (qualified_name.equals("binary_characters")) {
                node.getNodeData().setBinaryCharacters((BinaryCharacters)BinaryCharactersParser.getInstance().parse(element));
                continue;
            }
            if (qualified_name.equals("color")) {
                node.getBranchData().setBranchColor((BranchColor)ColorParser.getInstance().parse(element));
                continue;
            }
            if (qualified_name.equals("confidence")) {
                node.getBranchData().addConfidence((Confidence)ConfidenceParser.getInstance().parse(element));
                continue;
            }
            if (qualified_name.equals("width")) {
                node.getBranchData().setBranchWidth((BranchWidth)BranchWidthParser.getInstance().parse(element));
                continue;
            }
            if (qualified_name.equals("events")) {
                node.getNodeData().setEvent((Event)EventParser.getInstance().parse(element));
                continue;
            }
            if (!qualified_name.equals("property")) continue;
            Property prop = (Property)PropertyParser.getInstance().parse(element);
            if (prop.getRef().startsWith("style:") && prop.getAppliesTo() == Property.AppliesTo.NODE) {
                if (node.getNodeData().getNodeVisualData() == null) {
                    node.getNodeData().setNodeVisualData(new NodeVisualData());
                }
                node.getNodeData().getNodeVisualData().parseProperty(prop);
                continue;
            }
            if (!node.getNodeData().isHasProperties()) {
                node.getNodeData().setProperties(new PropertiesMap());
            }
            node.getNodeData().getProperties().addProperty(prop);
        }
    }

    private void newClade() {
        if (this.getCurrentNode() == null) {
            this.initCurrentNode();
        } else {
            this.addNode();
        }
    }

    private void newPhylogeny() {
        this.setCurrentPhylogeny(new Phylogeny());
    }

    private void reset() {
        this.setCurrentPhylogeny(null);
        this.setCurrentNode(null);
        this.setCurrentElementName(null);
        this.setCurrentXmlElement(null);
    }

    private void setCurrentElementName(String element_name) {
        this._current_element_name = element_name;
    }

    private void setCurrentNode(PhylogenyNode current_node) {
        this._current_node = current_node;
    }

    private void setCurrentPhylogeny(Phylogeny phylogeny) {
        this._current_phylogeny = phylogeny;
    }

    private void setCurrentXmlElement(XmlElement element) {
        this._current_xml_element = element;
    }

    private void setPhylogenies(List<Phylogeny> phylogenies) {
        this._phylogenies = phylogenies;
    }

    @Override
    public void startDocument() throws SAXException {
        this.init();
    }

    @Override
    public void startElement(String namespace_uri, String local_name, String qualified_name, Attributes attributes) throws SAXException {
        if (ForesterUtil.isEmpty(namespace_uri) || namespace_uri.startsWith("http://www.phyloxml.org")) {
            this.setCurrentElementName(local_name);
            if (local_name.equals("clade")) {
                XmlElement element = new XmlElement(namespace_uri, local_name, local_name, attributes);
                this.getCurrentXmlElement().addChildElement(element);
                this.setCurrentXmlElement(element);
                this.newClade();
            } else if (local_name.equals("phylogeny")) {
                this.setCurrentXmlElement(new XmlElement("", "", "", null));
                this.newPhylogeny();
                XmlElement element = new XmlElement(namespace_uri, local_name, local_name, attributes);
                if (element.isHasAttribute("rerootable")) {
                    this.getCurrentPhylogeny().setRerootable(Boolean.parseBoolean(element.getAttribute("rerootable")));
                }
                if (element.isHasAttribute("branch_length_unit")) {
                    this.getCurrentPhylogeny().setDistanceUnit(element.getAttribute("branch_length_unit"));
                }
                if (element.isHasAttribute("rooted")) {
                    this.getCurrentPhylogeny().setRooted(Boolean.parseBoolean(element.getAttribute("rooted")));
                }
                if (element.isHasAttribute("type")) {
                    this.getCurrentPhylogeny().setType(element.getAttribute("type"));
                }
            } else if (!local_name.equals(PHYLOXML) && this.getCurrentPhylogeny() != null) {
                XmlElement element = new XmlElement(namespace_uri, local_name, local_name, attributes);
                this.getCurrentXmlElement().addChildElement(element);
                this.setCurrentXmlElement(element);
            }
        }
    }

    public static boolean attributeEqualsValue(XmlElement element, String attributeName, String attributeValue) {
        String attr = element.getAttribute(attributeName);
        return attr != null && attr.equals(attributeValue);
    }

    public static String getAtttributeValue(XmlElement element, String attributeName) {
        String attr = element.getAttribute(attributeName);
        if (attr != null) {
            return attr;
        }
        return "";
    }

    public static Map<String, Sequence> getSequenceMapByIdForPhylogeny(Phylogeny ph) {
        HashMap<String, Sequence> seqMap = phylogenySequencesById.get(ph);
        if (seqMap == null) {
            seqMap = new HashMap();
            phylogenySequencesById.put(ph, seqMap);
        }
        return seqMap;
    }

    private static void mapElementToPhylogeny(XmlElement xml_element, Phylogeny phylogeny) throws PhylogenyParserException, PhyloXmlDataFormatException {
        for (int i = 0; i < xml_element.getNumberOfChildElements(); ++i) {
            XmlElement element = xml_element.getChildElement(i);
            String qualified_name = element.getQualifiedName();
            if (qualified_name.equals("name")) {
                phylogeny.setName(element.getValueAsString());
                continue;
            }
            if (qualified_name.equals("description")) {
                phylogeny.setDescription(element.getValueAsString());
                continue;
            }
            if (qualified_name.equals("id")) {
                phylogeny.setIdentifier((Identifier)IdentifierParser.getInstance().parse(element));
                continue;
            }
            if (!qualified_name.equals("confidence")) continue;
            phylogeny.setConfidence((Confidence)ConfidenceParser.getInstance().parse(element));
        }
    }
}

