/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import java.math.BigDecimal;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.data.Date;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.util.ForesterUtil;

public class DateParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private DateParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement element) throws PhyloXmlDataFormatException {
        String unit = "";
        if (element.isHasAttribute("unit")) {
            unit = element.getAttribute("unit");
        }
        String val = null;
        String min = null;
        String max = null;
        String desc = "";
        for (int j = 0; j < element.getNumberOfChildElements(); ++j) {
            XmlElement e = element.getChildElement(j);
            if (e.getQualifiedName().equals("value")) {
                val = e.getValueAsString();
                continue;
            }
            if (e.getQualifiedName().equals("minimum")) {
                min = e.getValueAsString();
                continue;
            }
            if (e.getQualifiedName().equals("maximum")) {
                max = e.getValueAsString();
                continue;
            }
            if (!e.getQualifiedName().equals("desc")) continue;
            desc = e.getValueAsString();
        }
        BigDecimal val_bd = null;
        BigDecimal min_bd = null;
        BigDecimal max_bd = null;
        if (!ForesterUtil.isEmpty(val)) {
            val_bd = new BigDecimal(val);
        }
        if (!ForesterUtil.isEmpty(min)) {
            min_bd = new BigDecimal(min);
        }
        if (!ForesterUtil.isEmpty(max)) {
            max_bd = new BigDecimal(max);
        }
        return new Date(desc, val_bd, min_bd, max_bd, unit);
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new DateParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

