/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import java.util.ArrayList;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.phyloxml.data.PointParser;
import org.forester.io.parsers.phyloxml.data.PolygonParser;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Point;
import org.forester.phylogeny.data.Polygon;

public class DistributionParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private DistributionParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement element) throws PhyloXmlDataFormatException {
        String desc = "";
        ArrayList<Point> points = null;
        ArrayList<Polygon> polygons = null;
        for (int i = 0; i < element.getNumberOfChildElements(); ++i) {
            XmlElement child_element = element.getChildElement(i);
            if (child_element.getQualifiedName().equals("desc")) {
                desc = child_element.getValueAsString();
                continue;
            }
            if (child_element.getQualifiedName().equals("point")) {
                if (points == null) {
                    points = new ArrayList<Point>();
                }
                points.add((Point)PointParser.getInstance().parse(child_element));
                continue;
            }
            if (!child_element.getQualifiedName().equals("polygon")) continue;
            if (polygons == null) {
                polygons = new ArrayList<Polygon>();
            }
            polygons.add((Polygon)PolygonParser.getInstance().parse(child_element));
        }
        return new Distribution(desc, points, polygons);
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new DistributionParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

