/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.phyloxml.data.ProteinDomainParser;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.ProteinDomain;

public class DomainArchitectureParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private DomainArchitectureParser() {
    }

    @Override
    public DomainArchitecture parse(XmlElement element) throws PhyloXmlDataFormatException {
        DomainArchitecture architecure = new DomainArchitecture();
        if (!element.isHasAttribute("length")) {
            throw new PhyloXmlDataFormatException("length attribute is required for domain architecture");
        }
        String lenght_str = element.getAttribute("length");
        try {
            architecure.setTotalLength(Integer.parseInt(lenght_str));
        }
        catch (NumberFormatException e) {
            throw new PhyloXmlDataFormatException("could not extract domain architecture length from [" + lenght_str + "]: " + e.getMessage());
        }
        for (int i = 0; i < element.getNumberOfChildElements(); ++i) {
            XmlElement child_element = element.getChildElement(i);
            if (!child_element.getQualifiedName().equals("domain")) continue;
            architecure.addDomain((ProteinDomain)ProteinDomainParser.getInstance().parse(child_element));
        }
        return architecure;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new DomainArchitectureParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

