/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import java.math.BigDecimal;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Point;
import org.forester.util.ForesterUtil;

public class PointParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private PointParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement element) throws PhyloXmlDataFormatException {
        String alt_unit = "";
        String geo_datum = "";
        if (element.isHasAttribute("alt_unit")) {
            alt_unit = element.getAttribute("alt_unit");
        }
        if (element.isHasAttribute("geodetic_datum")) {
            geo_datum = element.getAttribute("geodetic_datum");
        }
        String lat_str = null;
        String lon_str = null;
        String alt_str = null;
        for (int j = 0; j < element.getNumberOfChildElements(); ++j) {
            XmlElement e = element.getChildElement(j);
            if (e.getQualifiedName().equals("lat")) {
                lat_str = e.getValueAsString();
                continue;
            }
            if (e.getQualifiedName().equals("long")) {
                lon_str = e.getValueAsString();
                continue;
            }
            if (!e.getQualifiedName().equals("alt")) continue;
            alt_str = e.getValueAsString();
        }
        BigDecimal lat = null;
        BigDecimal lon = null;
        BigDecimal alt = null;
        if (!ForesterUtil.isEmpty(lat_str)) {
            lat = new BigDecimal(lat_str);
        }
        if (!ForesterUtil.isEmpty(lon_str)) {
            lon = new BigDecimal(lon_str);
        }
        if (!ForesterUtil.isEmpty(alt_str)) {
            alt = new BigDecimal(alt_str);
        }
        return new Point(geo_datum, lat, lon, alt, alt_unit);
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new PointParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

