/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Property;
import org.forester.util.ForesterUtil;

public final class NodeVisualData
implements PhylogenyData {
    public static final String APTX_VISUALIZATION_REF = "style:";
    public static final int DEFAULT_SIZE = -1;
    public static final String FONT_COLOR_REF = "style:font_color";
    public static final String FONT_COLOR_TYPE = "xsd:token";
    public static final String FONT_REF = "style:font";
    public static final String FONT_SIZE_REF = "style:font_size";
    public static final String FONT_SIZE_TYPE = "xsd:unsignedByte";
    public static final String FONT_STYLE_BOLD = "bold";
    public static final String FONT_STYLE_BOLD_ITALIC = "bold_italic";
    public static final String FONT_STYLE_ITALIC = "italic";
    public static final String FONT_STYLE_PLAIN = "plain";
    public static final String FONT_STYLE_REF = "style:font_style";
    public static final String FONT_STYLE_TYPE = "xsd:token";
    public static final String FONT_TYPE = "xsd:token";
    public static final String NODE_COLOR_REF = "style:node_color";
    public static final String NODE_COLOR_TYPE = "xsd:token";
    public static final String NODE_FILL_GRADIENT = "gradient";
    public static final String NODE_FILL_NONE = "none";
    public static final String NODE_FILL_SOLID = "solid";
    public static final String NODE_FILL_TYPE_REF = "style:node_fill_type";
    public static final String NODE_FILL_TYPE_TYPE = "xsd:token";
    public static final String NODE_SHAPE_CIRCLE = "circle";
    public static final String NODE_SHAPE_RECTANGLE = "rectangle";
    public static final String NODE_SHAPE_REF = "style:node_shape";
    public static final String NODE_SHAPE_TYPE = "xsd:token";
    public static final String NODE_SIZE_REF = "style:node_size";
    public static final String NODE_SIZE_TYPE = "xsd:float";
    public static final String NODE_TRANSPARENCY_REF = "style:node_transparency";
    public static final String NODE_TRANSPARENCY_TYPE = "xsd:float";
    private static final byte DEFAULT_FONT_SIZE = -1;
    private static final int DEFAULT_TRANSPARENCY = -1;
    private NodeFill _fill_type;
    private Font _font;
    private Color _font_color;
    private String _font_name;
    private byte _font_size;
    private FontType _font_style;
    private Color _node_color;
    private NodeShape _shape;
    private float _size;
    private float _transparency;

    public NodeVisualData() {
        this.init();
    }

    public NodeVisualData(String font_name, FontType font_style, byte font_size, Color font_color, NodeShape shape, NodeFill fill_type, Color node_color, float size, float transparency) {
        this.setFontName(font_name);
        this.setFontStyle(font_style);
        this.setFontSize(font_size);
        this.setFontColor(font_color);
        this.setShape(shape);
        this.setFillType(fill_type);
        this.setNodeColor(node_color);
        this.setSize(size);
        this.setTransparency(transparency);
    }

    @Override
    public final StringBuffer asSimpleText() {
        return this.asText();
    }

    @Override
    public final StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        return sb;
    }

    @Override
    public final PhylogenyData copy() {
        return new NodeVisualData(!ForesterUtil.isEmpty(this.getFontName()) ? new String(this.getFontName()) : null, this.getFontStyle(), this.getFontSize(), this.getFontColor() != null ? new Color(this.getFontColor().getRed(), this.getFontColor().getGreen(), this.getFontColor().getBlue()) : null, this.getShape(), this.getFillType(), this.getNodeColor() != null ? new Color(this.getNodeColor().getRed(), this.getNodeColor().getGreen(), this.getNodeColor().getBlue()) : null, this.getSize(), this.getTransparency());
    }

    public final NodeFill getFillType() {
        return this._fill_type;
    }

    public final Font getFont() {
        if (this._font != null) {
            return this._font;
        }
        if (!ForesterUtil.isEmpty(this.getFontName())) {
            this._font = new Font(this.getFontName(), this.getFontStyleInt(), this.getFontSize());
            return this._font;
        }
        return null;
    }

    public final Color getFontColor() {
        return this._font_color;
    }

    public final String getFontName() {
        return this._font_name;
    }

    public final byte getFontSize() {
        return this._font_size;
    }

    public final FontType getFontStyle() {
        return this._font_style;
    }

    public final int getFontStyleInt() {
        if (this.getFontStyle() == FontType.BOLD) {
            return 1;
        }
        if (this.getFontStyle() == FontType.ITALIC) {
            return 2;
        }
        if (this.getFontStyle() == FontType.BOLD_ITALIC) {
            return 3;
        }
        return 0;
    }

    public final Color getNodeColor() {
        return this._node_color;
    }

    public final NodeShape getShape() {
        return this._shape;
    }

    public final float getSize() {
        return this._size;
    }

    public final float getTransparency() {
        return this._transparency;
    }

    public final boolean isEmpty() {
        return ForesterUtil.isEmpty(this.getFontName()) && this.getFontStyle() == FontType.PLAIN && this.getFontSize() == -1 && this.getFontColor() == null && this.getShape() == NodeShape.DEFAULT && this.getFillType() == NodeFill.DEFAULT && this.getNodeColor() == null && this.getSize() == -1.0f && this.getTransparency() == -1.0f;
    }

    @Override
    public final boolean isEqual(PhylogenyData data) {
        throw new UnsupportedOperationException();
    }

    public void parseProperty(Property prop) {
        if (prop.getRef().equals(FONT_REF)) {
            this.setFontName(prop.getValue().trim());
        } else if (prop.getRef().equals(FONT_SIZE_REF)) {
            int s = -1;
            try {
                s = Integer.parseInt(prop.getValue());
            }
            catch (NumberFormatException e) {
                return;
            }
            if (s >= 0 && s < 127) {
                this.setFontSize(s);
            }
        } else if (prop.getRef().equals(FONT_STYLE_REF)) {
            this.setFontStyle(prop.getValue());
        } else {
            if (prop.getRef().equals(FONT_COLOR_REF)) {
                try {
                    this.setFontColor(Color.decode(prop.getValue()));
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            if (prop.getRef().equals(NODE_SIZE_REF)) {
                float s = -1.0f;
                try {
                    s = Float.parseFloat(prop.getValue());
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (s >= 0.0f) {
                    this.setSize(s);
                }
            } else if (prop.getRef().equals(NODE_COLOR_REF)) {
                try {
                    this.setNodeColor(Color.decode(prop.getValue()));
                }
                catch (NumberFormatException e) {
                    return;
                }
            } else if (prop.getRef().equals(NODE_SHAPE_REF)) {
                this.setShape(prop.getValue());
            } else if (prop.getRef().equals(NODE_FILL_TYPE_REF)) {
                this.setFillType(prop.getValue());
            }
        }
    }

    public final void setFillType(NodeFill fill_type) {
        this._fill_type = fill_type;
    }

    public final void setFillType(String fill) {
        if (fill.equalsIgnoreCase(NODE_FILL_NONE)) {
            this.setFillType(NodeFill.NONE);
        } else if (fill.equalsIgnoreCase(NODE_FILL_SOLID)) {
            this.setFillType(NodeFill.SOLID);
        } else if (fill.equalsIgnoreCase(NODE_FILL_GRADIENT)) {
            this.setFillType(NodeFill.GRADIENT);
        } else {
            this.setFillType(NodeFill.DEFAULT);
        }
    }

    public final void setFontColor(Color font_color) {
        this._font_color = font_color;
    }

    public final void setFontName(String font_name) {
        this._font_name = !ForesterUtil.isEmpty(font_name) ? font_name : null;
        this._font = null;
    }

    public final void setFontSize(int font_size) {
        if (font_size != -1 && font_size < 0) {
            throw new IllegalArgumentException("negative font size: " + font_size);
        }
        if (font_size > 127) {
            throw new IllegalArgumentException("font size is too large: " + font_size);
        }
        this._font_size = (byte)font_size;
        this._font = null;
    }

    public final void setFontStyle(FontType font_style) {
        this._font_style = font_style;
        this._font = null;
    }

    public final void setFontStyle(int font_style) {
        if (font_style == 3) {
            this.setFontStyle(FontType.BOLD_ITALIC);
        } else if (font_style == 2) {
            this.setFontStyle(FontType.ITALIC);
        } else if (font_style == 1) {
            this.setFontStyle(FontType.BOLD);
        } else {
            this.setFontStyle(FontType.PLAIN);
        }
    }

    public final void setFontStyle(String font_style) {
        if (font_style.equalsIgnoreCase(FONT_STYLE_BOLD)) {
            this.setFontStyle(FontType.BOLD);
        } else if (font_style.equalsIgnoreCase(FONT_STYLE_ITALIC)) {
            this.setFontStyle(FontType.ITALIC);
        } else if (font_style.equalsIgnoreCase(FONT_STYLE_BOLD_ITALIC)) {
            this.setFontStyle(FontType.BOLD_ITALIC);
        } else {
            this.setFontStyle(FontType.PLAIN);
        }
    }

    public final void setNodeColor(Color node_color) {
        this._node_color = node_color;
    }

    public final void setShape(NodeShape shape) {
        this._shape = shape;
    }

    public final void setShape(String shape) {
        if (shape.equalsIgnoreCase(NODE_SHAPE_CIRCLE)) {
            this.setShape(NodeShape.CIRCLE);
        } else if (shape.equalsIgnoreCase(NODE_SHAPE_RECTANGLE)) {
            this.setShape(NodeShape.RECTANGLE);
        } else {
            this.setShape(NodeShape.DEFAULT);
        }
    }

    public final void setSize(float size) {
        if (size != -1.0f && size < 0.0f) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        this._size = size;
    }

    public final void setTransparency(float transparency) {
        this._transparency = transparency;
    }

    @Override
    public final StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        for (Property p : this.toProperties()) {
            p.toPhyloXML(writer, level, indentation);
        }
    }

    public final String toString() {
        return this.asText().toString();
    }

    private String colorToHex(Color c) {
        return String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }

    private final void init() {
        this.setFontName(null);
        this.setFontStyle(FontType.PLAIN);
        this.setFontSize(-1);
        this.setFontColor(null);
        this.setShape(NodeShape.DEFAULT);
        this.setFillType(NodeFill.DEFAULT);
        this.setNodeColor(null);
        this.setSize(-1.0f);
        this.setTransparency(-1.0f);
        this._font = null;
    }

    private final List<Property> toProperties() {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (!ForesterUtil.isEmpty(this.getFontName())) {
            properties.add(new Property(FONT_REF, this.getFontName(), "", "xsd:token", Property.AppliesTo.NODE));
        }
        if (this.getFontSize() != -1) {
            properties.add(new Property(FONT_SIZE_REF, String.valueOf(this.getFontSize()), "", FONT_SIZE_TYPE, Property.AppliesTo.NODE));
        }
        if (this.getFontStyle() != FontType.PLAIN) {
            String font_style = "";
            if (this.getFontStyle() == FontType.ITALIC) {
                font_style = FONT_STYLE_ITALIC;
            } else if (this.getFontStyle() == FontType.BOLD) {
                font_style = FONT_STYLE_BOLD;
            } else if (this.getFontStyle() == FontType.BOLD_ITALIC) {
                font_style = FONT_STYLE_BOLD_ITALIC;
            } else {
                throw new RuntimeException("unknown font style" + (Object)((Object)this.getShape()));
            }
            properties.add(new Property(FONT_STYLE_REF, font_style, "", "xsd:token", Property.AppliesTo.NODE));
        }
        if (this.getFontColor() != null) {
            properties.add(new Property(FONT_COLOR_REF, this.colorToHex(this.getFontColor()), "", "xsd:token", Property.AppliesTo.NODE));
        }
        if (this.getShape() != NodeShape.DEFAULT) {
            String shape = null;
            if (this.getShape() == NodeShape.RECTANGLE) {
                shape = NODE_SHAPE_RECTANGLE;
            } else if (this.getShape() == NodeShape.CIRCLE) {
                shape = NODE_SHAPE_CIRCLE;
            } else {
                throw new RuntimeException("unknown node shape" + (Object)((Object)this.getShape()));
            }
            properties.add(new Property(NODE_SHAPE_REF, shape, "", "xsd:token", Property.AppliesTo.NODE));
        }
        if (this.getSize() != -1.0f) {
            properties.add(new Property(NODE_SIZE_REF, String.valueOf(this.getSize()), "", "xsd:float", Property.AppliesTo.NODE));
        }
        if (this.getNodeColor() != null) {
            properties.add(new Property(NODE_COLOR_REF, this.colorToHex(this.getNodeColor()), "", "xsd:token", Property.AppliesTo.NODE));
        }
        if (this.getFillType() != NodeFill.DEFAULT) {
            String fill = null;
            if (this.getFillType() == NodeFill.GRADIENT) {
                fill = NODE_FILL_GRADIENT;
            } else if (this.getFillType() == NodeFill.NONE) {
                fill = NODE_FILL_NONE;
            } else if (this.getFillType() == NodeFill.SOLID) {
                fill = NODE_FILL_SOLID;
            } else {
                throw new RuntimeException("unknown fill type " + (Object)((Object)this.getFillType()));
            }
            properties.add(new Property(NODE_FILL_TYPE_REF, fill, "", "xsd:token", Property.AppliesTo.NODE));
        }
        if (this.getTransparency() != -1.0f) {
            properties.add(new Property(NODE_TRANSPARENCY_REF, String.valueOf(this.getTransparency()), "", "xsd:float", Property.AppliesTo.NODE));
        }
        return properties;
    }

    public static enum NodeShape {
        CIRCLE,
        DEFAULT,
        RECTANGLE;

    }

    public static enum NodeFill {
        DEFAULT,
        GRADIENT,
        NONE,
        SOLID;

    }

    public static enum FontType {
        BOLD,
        BOLD_ITALIC,
        ITALIC,
        PLAIN;

    }
}

