/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlUtil;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.MultipleUris;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.Uri;
import org.forester.util.ForesterUtil;

public class Taxonomy
implements PhylogenyData,
MultipleUris,
Comparable<Taxonomy> {
    private String _scientific_name;
    private String _common_name;
    private List<String> _synonyms;
    private String _authority;
    private Identifier _identifier;
    private String _taxonomy_code;
    private String _rank;
    private List<Uri> _uris;
    private List<String> _lineage;

    public Taxonomy() {
        this.init();
    }

    @Override
    public StringBuffer asSimpleText() {
        return this.asText();
    }

    @Override
    public Uri getUri(int index) {
        return this.getUris().get(index);
    }

    @Override
    public void addUri(Uri uri) {
        if (this.getUris() == null) {
            this.setUris(new ArrayList<Uri>());
        }
        this.getUris().add(uri);
    }

    @Override
    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        if (this.getIdentifier() != null) {
            sb.append("[");
            sb.append(this.getIdentifier().asSimpleText());
            sb.append("]");
        }
        if (!ForesterUtil.isEmpty(this.getTaxonomyCode())) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("[");
            sb.append(this.getTaxonomyCode());
            sb.append("]");
        }
        if (!ForesterUtil.isEmpty(this.getScientificName())) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(this.getScientificName());
            if (!ForesterUtil.isEmpty(this.getAuthority())) {
                sb.append(" (");
                sb.append(this.getAuthority());
                sb.append(")");
            }
        }
        if (!ForesterUtil.isEmpty(this.getCommonName())) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(this.getCommonName());
        }
        return sb;
    }

    @Override
    public PhylogenyData copy() {
        Taxonomy t = new Taxonomy();
        try {
            t.setTaxonomyCode(this.getTaxonomyCode());
        }
        catch (PhyloXmlDataFormatException e) {
            e.printStackTrace();
        }
        t.setScientificName(this.getScientificName());
        t.setCommonName(this.getCommonName());
        t.setAuthority(this.getAuthority());
        for (String syn : this.getSynonyms()) {
            t.getSynonyms().add(syn);
        }
        if (this.getIdentifier() != null) {
            t.setIdentifier((Identifier)this.getIdentifier().copy());
        } else {
            t.setIdentifier(null);
        }
        try {
            t.setRank(new String(this.getRank()));
        }
        catch (PhyloXmlDataFormatException e) {
            e.printStackTrace();
        }
        if (this.getUris() != null) {
            t.setUris(new ArrayList<Uri>());
            for (Uri uri : this.getUris()) {
                if (uri == null) continue;
                t.getUris().add(uri);
            }
        }
        if (this.getLineage() != null) {
            t.setLineage(new ArrayList<String>());
            for (String l : this.getLineage()) {
                if (l == null) continue;
                t.getLineage().add(l);
            }
        }
        return t;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + o + " [" + o.getClass() + "]");
        }
        return this.isEqual((Taxonomy)o);
    }

    public String getAuthority() {
        return this._authority;
    }

    public String getCommonName() {
        return this._common_name;
    }

    public Identifier getIdentifier() {
        return this._identifier;
    }

    public String getRank() {
        return this._rank;
    }

    public String getScientificName() {
        return this._scientific_name;
    }

    public List<String> getSynonyms() {
        if (this._synonyms == null) {
            this._synonyms = new ArrayList<String>();
        }
        return this._synonyms;
    }

    public String getTaxonomyCode() {
        return this._taxonomy_code;
    }

    @Override
    public List<Uri> getUris() {
        return this._uris;
    }

    public int hashCode() {
        if (this.getIdentifier() != null && !ForesterUtil.isEmpty(this.getIdentifier().getValue())) {
            return this.getIdentifier().hashCode();
        }
        if (!ForesterUtil.isEmpty(this.getTaxonomyCode())) {
            return this.getTaxonomyCode().hashCode();
        }
        if (!ForesterUtil.isEmpty(this.getScientificName())) {
            if (!ForesterUtil.isEmpty(this.getAuthority())) {
                return (this.getScientificName().toLowerCase() + this.getAuthority().toLowerCase()).hashCode();
            }
            return this.getScientificName().toLowerCase().hashCode();
        }
        return this.getCommonName().toLowerCase().hashCode();
    }

    public void init() {
        this.setScientificName("");
        this.setCommonName("");
        this.setIdentifier(null);
        try {
            this.setRank("");
        }
        catch (PhyloXmlDataFormatException e) {
            e.printStackTrace();
        }
        try {
            this.setTaxonomyCode("");
        }
        catch (PhyloXmlDataFormatException e) {
            e.printStackTrace();
        }
        this.setAuthority("");
        this.setSynonyms(null);
        this.setUris(null);
        this.setLineage(null);
    }

    public boolean isEmpty() {
        return this.getIdentifier() == null && ForesterUtil.isEmpty(this.getTaxonomyCode()) && ForesterUtil.isEmpty(this.getCommonName()) && ForesterUtil.isEmpty(this.getScientificName()) && ForesterUtil.isEmpty(this._lineage);
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        if (this == data) {
            return true;
        }
        Taxonomy tax = (Taxonomy)data;
        if (this.getIdentifier() != null && tax.getIdentifier() != null && !ForesterUtil.isEmpty(this.getIdentifier().getValue()) && !ForesterUtil.isEmpty(tax.getIdentifier().getValue())) {
            return this.getIdentifier().isEqual(tax.getIdentifier());
        }
        if (!ForesterUtil.isEmpty(this.getTaxonomyCode()) && !ForesterUtil.isEmpty(tax.getTaxonomyCode())) {
            return this.getTaxonomyCode().equals(tax.getTaxonomyCode());
        }
        if (!ForesterUtil.isEmpty(this.getScientificName()) && !ForesterUtil.isEmpty(tax.getScientificName())) {
            if (!ForesterUtil.isEmpty(this.getAuthority()) && !ForesterUtil.isEmpty(tax.getAuthority())) {
                return this.getScientificName().equalsIgnoreCase(tax.getScientificName()) && this.getAuthority().equalsIgnoreCase(tax.getAuthority());
            }
            return this.getScientificName().equalsIgnoreCase(tax.getScientificName());
        }
        if (!ForesterUtil.isEmpty(this.getCommonName()) && !ForesterUtil.isEmpty(tax.getCommonName())) {
            return this.getCommonName().equalsIgnoreCase(tax.getCommonName());
        }
        return false;
    }

    public void setAuthority(String authority) {
        this._authority = authority;
    }

    public void setCommonName(String common_name) {
        this._common_name = common_name;
    }

    public void setIdentifier(Identifier identifier) {
        this._identifier = identifier;
    }

    public void setRank(String rank) throws PhyloXmlDataFormatException {
        if (!ForesterUtil.isEmpty(rank) && !PhyloXmlUtil.TAXONOMY_RANKS_SET.contains(rank)) {
            throw new PhyloXmlDataFormatException("illegal rank: [" + rank + "]");
        }
        this._rank = rank;
    }

    public void setScientificName(String scientific_name) {
        this._scientific_name = scientific_name;
    }

    private void setSynonyms(List<String> synonyms) {
        this._synonyms = synonyms;
    }

    public void setTaxonomyCode(String taxonomy_code) throws PhyloXmlDataFormatException {
        if (!ForesterUtil.isEmpty(taxonomy_code) && !PhyloXmlUtil.TAXOMONY_CODE_PATTERN.matcher(taxonomy_code).matches()) {
            throw new PhyloXmlDataFormatException("illegal taxonomy code: [" + taxonomy_code + "]");
        }
        if (taxonomy_code.equals("ACIBL")) {
            taxonomy_code = "KORVE";
        } else if (taxonomy_code.equals("PYRKO")) {
            taxonomy_code = "THEKO";
        }
        this._taxonomy_code = taxonomy_code;
    }

    @Override
    public void setUris(List<Uri> uris) {
        this._uris = uris;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        if (this.getIdentifier() != null) {
            sb.append(":T=");
            sb.append(ForesterUtil.replaceIllegalNhxCharacters(this.getIdentifier().getValue()));
        }
        StringBuffer species = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getTaxonomyCode())) {
            species.append(ForesterUtil.replaceIllegalNhxCharacters(this.getTaxonomyCode()));
        }
        if (!ForesterUtil.isEmpty(this.getScientificName())) {
            ForesterUtil.appendSeparatorIfNotEmpty(species, '|');
            species.append(ForesterUtil.replaceIllegalNhxCharacters(this.getScientificName()));
        }
        if (!ForesterUtil.isEmpty(this.getCommonName())) {
            ForesterUtil.appendSeparatorIfNotEmpty(species, '|');
            species.append(ForesterUtil.replaceIllegalNhxCharacters(this.getCommonName()));
        }
        if (species.length() > 0) {
            sb.append(":S=");
            sb.append(species);
        }
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendOpen(writer, "taxonomy");
        if (this.getIdentifier() != null && !ForesterUtil.isEmpty(this.getIdentifier().getValue())) {
            this.getIdentifier().toPhyloXML(writer, level, indentation);
        }
        if (!ForesterUtil.isEmpty(this.getTaxonomyCode())) {
            PhylogenyDataUtil.appendElement(writer, "code", this.getTaxonomyCode(), indentation);
        }
        if (!ForesterUtil.isEmpty(this.getScientificName())) {
            PhylogenyDataUtil.appendElement(writer, "scientific_name", this.getScientificName(), indentation);
        }
        if (!ForesterUtil.isEmpty(this.getAuthority())) {
            PhylogenyDataUtil.appendElement(writer, "authority", this.getAuthority(), indentation);
        }
        if (!ForesterUtil.isEmpty(this.getCommonName())) {
            PhylogenyDataUtil.appendElement(writer, "common_name", this.getCommonName(), indentation);
        }
        if (this._synonyms != null) {
            for (String syn : this.getSynonyms()) {
                if (ForesterUtil.isEmpty(syn)) continue;
                PhylogenyDataUtil.appendElement(writer, "synonym", syn, indentation);
            }
        }
        if (!ForesterUtil.isEmpty(this.getRank())) {
            PhylogenyDataUtil.appendElement(writer, "rank", this.getRank(), indentation);
        }
        if (this.getUris() != null) {
            for (Uri uri : this.getUris()) {
                if (uri == null) continue;
                uri.toPhyloXML(writer, level, indentation);
            }
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendClose(writer, "taxonomy");
    }

    public String toString() {
        return this.asText().toString();
    }

    @Override
    public int compareTo(Taxonomy o) {
        int x;
        if (this.equals(o)) {
            return 0;
        }
        if (this.getIdentifier() != null && o.getIdentifier() != null && !ForesterUtil.isEmpty(this.getIdentifier().getValue()) && !ForesterUtil.isEmpty(o.getIdentifier().getValue()) && (x = this.getIdentifier().getValuePlusProvider().compareTo(o.getIdentifier().getValuePlusProvider())) != 0) {
            return x;
        }
        if (!ForesterUtil.isEmpty(this.getScientificName()) && !ForesterUtil.isEmpty(o.getScientificName())) {
            return this.getScientificName().compareToIgnoreCase(o.getScientificName());
        }
        if (!ForesterUtil.isEmpty(this.getCommonName()) && !ForesterUtil.isEmpty(o.getCommonName())) {
            return this.getCommonName().compareToIgnoreCase(o.getCommonName());
        }
        if (!ForesterUtil.isEmpty(this.getTaxonomyCode()) && !ForesterUtil.isEmpty(o.getTaxonomyCode())) {
            return this.getTaxonomyCode().compareToIgnoreCase(o.getTaxonomyCode());
        }
        if (this.getIdentifier() != null && o.getIdentifier() != null && !ForesterUtil.isEmpty(this.getIdentifier().getValue()) && !ForesterUtil.isEmpty(o.getIdentifier().getValue())) {
            return this.getIdentifier().getValuePlusProvider().compareTo(o.getIdentifier().getValuePlusProvider());
        }
        return 1;
    }

    public void setLineage(List<String> lineage) {
        this._lineage = lineage;
    }

    public List<String> getLineage() {
        return this._lineage;
    }
}

