/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;

public class Uri
implements PhylogenyData {
    private final URI _uri;
    private final String _description;
    private final String _type;

    public Uri(String uri_str, String description, String type) {
        if (uri_str == null) {
            throw new IllegalArgumentException("attempt to create Uri from null");
        }
        this._uri = URI.create(uri_str);
        this._description = description;
        this._type = type;
    }

    public Uri(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("attempt to create Uri from null URI");
        }
        this._uri = uri;
        this._description = "";
        this._type = "";
    }

    public Uri(URI uri, String description, String type) {
        if (uri == null) {
            throw new IllegalArgumentException("attempt to create Uri from null URI");
        }
        this._uri = uri;
        this._description = description;
        this._type = type;
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getValue().toString());
    }

    @Override
    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.getDescription());
        sb.append(" ");
        sb.append(this.getType());
        sb.append("] ");
        sb.append(this.getValue().toString());
        return sb;
    }

    @Override
    public PhylogenyData copy() {
        return new Uri(this.getValue().toString(), new String(this.getDescription()), new String(this.getType()));
    }

    public String getDescription() {
        return this._description;
    }

    public String getType() {
        return this._type;
    }

    public URI getValue() {
        return this._uri;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        PhylogenyDataUtil.appendElement(writer, "uri", this.getValue().toString(), "type", this.getType(), "desc", this.getDescription(), indentation);
    }

    public String toString() {
        return this.asSimpleText().toString();
    }
}

