/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.go.GoId;
import org.forester.protein.BinaryDomainCombination;
import org.forester.protein.Domain;
import org.forester.protein.Protein;
import org.forester.species.Species;
import org.forester.surfacing.AdjactantDirectedCombinableDomains;
import org.forester.surfacing.BasicCombinableDomains;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.DirectedCombinableDomains;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class BasicGenomeWideCombinableDomains
implements GenomeWideCombinableDomains {
    private static final Comparator<CombinableDomains> DESCENDING_COMBINATIONS_COUNT_ORDER = new Comparator<CombinableDomains>(){

        @Override
        public int compare(CombinableDomains d1, CombinableDomains d2) {
            if (d1.getNumberOfCombinableDomains() < d2.getNumberOfCombinableDomains()) {
                return 1;
            }
            if (d1.getNumberOfCombinableDomains() > d2.getNumberOfCombinableDomains()) {
                return -1;
            }
            return d1.getKeyDomain().compareTo(d2.getKeyDomain());
        }
    };
    private static final Comparator<CombinableDomains> DESCENDING_KEY_DOMAIN_COUNT_ORDER = new Comparator<CombinableDomains>(){

        @Override
        public int compare(CombinableDomains d1, CombinableDomains d2) {
            if (d1.getKeyDomainCount() < d2.getKeyDomainCount()) {
                return 1;
            }
            if (d1.getKeyDomainCount() > d2.getKeyDomainCount()) {
                return -1;
            }
            return d1.getKeyDomain().compareTo(d2.getKeyDomain());
        }
    };
    private static final Comparator<CombinableDomains> DESCENDING_KEY_DOMAIN_PROTEINS_COUNT_ORDER = new Comparator<CombinableDomains>(){

        @Override
        public int compare(CombinableDomains d1, CombinableDomains d2) {
            if (d1.getKeyDomainProteinsCount() < d2.getKeyDomainProteinsCount()) {
                return 1;
            }
            if (d1.getKeyDomainProteinsCount() > d2.getKeyDomainProteinsCount()) {
                return -1;
            }
            return d1.getKeyDomain().compareTo(d2.getKeyDomain());
        }
    };
    private final SortedMap<String, CombinableDomains> _combinable_domains_map = new TreeMap<String, CombinableDomains>();
    private final BinaryDomainCombination.DomainCombinationType _dc_type;
    private final Species _species;

    private BasicGenomeWideCombinableDomains(Species species, BinaryDomainCombination.DomainCombinationType dc_type) {
        this._species = species;
        this._dc_type = dc_type;
    }

    @Override
    public boolean contains(String key_id) {
        return this._combinable_domains_map.containsKey(key_id);
    }

    @Override
    public CombinableDomains get(String key_id) {
        return (CombinableDomains)this._combinable_domains_map.get(key_id);
    }

    @Override
    public SortedMap<String, CombinableDomains> getAllCombinableDomainsIds() {
        return this._combinable_domains_map;
    }

    @Override
    public SortedSet<String> getAllDomainIds() {
        TreeSet<String> domains = new TreeSet<String>();
        for (String key : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains cb = (CombinableDomains)this.getAllCombinableDomainsIds().get(key);
            List<String> ds = cb.getAllDomains();
            for (String d : ds) {
                domains.add(d);
            }
        }
        return domains;
    }

    @Override
    public BinaryDomainCombination.DomainCombinationType getDomainCombinationType() {
        return this._dc_type;
    }

    @Override
    public SortedSet<String> getMostPromiscuosDomain() {
        TreeSet<String> doms = new TreeSet<String>();
        int max = (int)this.getPerGenomeDomainPromiscuityStatistics().getMax();
        for (String key : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains cb = (CombinableDomains)this.getAllCombinableDomainsIds().get(key);
            if (cb.getNumberOfCombinableDomains() != max) continue;
            doms.add(key);
        }
        return doms;
    }

    @Override
    public DescriptiveStatistics getPerGenomeDomainPromiscuityStatistics() {
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        for (String key : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains cb = (CombinableDomains)this.getAllCombinableDomainsIds().get(key);
            stats.addValue(cb.getNumberOfCombinableDomains());
        }
        return stats;
    }

    @Override
    public int getSize() {
        return this._combinable_domains_map.size();
    }

    @Override
    public Species getSpecies() {
        return this._species;
    }

    @Override
    public SortedSet<BinaryDomainCombination> toBinaryDomainCombinations() {
        TreeSet<BinaryDomainCombination> binary_combinations = new TreeSet<BinaryDomainCombination>();
        for (String key : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains cb = (CombinableDomains)this.getAllCombinableDomainsIds().get(key);
            for (BinaryDomainCombination b : cb.toBinaryDomainCombinations()) {
                binary_combinations.add(b);
            }
        }
        return binary_combinations;
    }

    public String toString() {
        return this.toStringBuilder(GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.ALPHABETICAL_KEY_ID).toString();
    }

    @Override
    public StringBuilder toStringBuilder(GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder sort_order) {
        StringBuilder sb = new StringBuilder();
        ArrayList<CombinableDomains> combinable_domains = new ArrayList<CombinableDomains>();
        for (String key : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains cb = (CombinableDomains)this.getAllCombinableDomainsIds().get(key);
            combinable_domains.add(cb);
        }
        if (sort_order == GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_COUNT) {
            Collections.sort(combinable_domains, DESCENDING_KEY_DOMAIN_COUNT_ORDER);
        } else if (sort_order == GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_PROTEINS_COUNT) {
            Collections.sort(combinable_domains, DESCENDING_KEY_DOMAIN_PROTEINS_COUNT_ORDER);
        } else if (sort_order == GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.COMBINATIONS_COUNT) {
            Collections.sort(combinable_domains, DESCENDING_COMBINATIONS_COUNT_ORDER);
        }
        for (CombinableDomains cb : combinable_domains) {
            sb.append(ForesterUtil.pad(new StringBuffer(cb.getKeyDomain().toString()), 18, ' ', false));
            sb.append(ForesterUtil.pad(new StringBuffer("" + cb.getKeyDomainCount()), 8, ' ', false));
            sb.append(ForesterUtil.pad(new StringBuffer("" + cb.getKeyDomainProteinsCount()), 8, ' ', false));
            sb.append(ForesterUtil.pad(new StringBuffer("" + cb.getNumberOfCombinableDomains()), 8, ' ', false));
            sb.append((CharSequence)cb.getCombiningDomainIdsAsStringBuilder());
            sb.append(ForesterUtil.getLineSeparator());
        }
        return sb;
    }

    private void add(String key, CombinableDomains cdc) {
        this._combinable_domains_map.put(key, cdc);
    }

    public static BasicGenomeWideCombinableDomains createInstance(List<Protein> protein_list, boolean ignore_combination_with_same_domain, Species species) {
        return BasicGenomeWideCombinableDomains.createInstance(protein_list, ignore_combination_with_same_domain, species, null, BinaryDomainCombination.DomainCombinationType.BASIC, null, null);
    }

    public static BasicGenomeWideCombinableDomains createInstance(List<Protein> protein_list, boolean ignore_combination_with_same_domain, Species species, BinaryDomainCombination.DomainCombinationType dc_type) {
        return BasicGenomeWideCombinableDomains.createInstance(protein_list, ignore_combination_with_same_domain, species, null, dc_type, null, null);
    }

    public static BasicGenomeWideCombinableDomains createInstance(List<Protein> protein_list, boolean ignore_combination_with_same_domain, Species species, Map<String, List<GoId>> domain_id_to_go_ids_map, BinaryDomainCombination.DomainCombinationType dc_type, Map<String, DescriptiveStatistics> protein_length_stats_by_dc, Map<String, DescriptiveStatistics> domain_number_stats_by_dc) {
        BasicGenomeWideCombinableDomains instance = new BasicGenomeWideCombinableDomains(species, dc_type);
        HashMap<String, Integer> domain_counts = new HashMap<String, Integer>();
        for (Protein protein : protein_list) {
            if (!protein.getSpecies().equals(species)) {
                throw new IllegalArgumentException("species (" + protein.getSpecies() + ") does not match species of combinable domains collection (" + species + ")");
            }
            HashSet<String> saw_i = new HashSet<String>();
            HashSet<String> saw_c = new HashSet<String>();
            for (int i = 0; i < protein.getProteinDomains().size(); ++i) {
                String dc_str;
                Domain pd_i = protein.getProteinDomain(i);
                String id_i = pd_i.getDomainId();
                int current_start = pd_i.getFrom();
                BasicGenomeWideCombinableDomains.countDomains(domain_counts, saw_c, id_i);
                if (saw_i.contains(id_i)) continue;
                if (dc_type == BinaryDomainCombination.DomainCombinationType.BASIC) {
                    saw_i.add(id_i);
                }
                CombinableDomains domain_combination = null;
                if (instance.contains(id_i)) {
                    domain_combination = instance.get(id_i);
                } else {
                    domain_combination = dc_type == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT ? new AdjactantDirectedCombinableDomains(pd_i.getDomainId(), species) : (dc_type == BinaryDomainCombination.DomainCombinationType.DIRECTED ? new DirectedCombinableDomains(pd_i.getDomainId(), species) : new BasicCombinableDomains(pd_i.getDomainId(), species));
                    instance.add(id_i, domain_combination);
                }
                domain_combination.addKeyDomainProtein(protein.getProteinId().getId());
                HashSet<String> saw_j = new HashSet<String>();
                if (ignore_combination_with_same_domain) {
                    saw_j.add(id_i);
                }
                Domain closest = null;
                for (int j = 0; j < protein.getNumberOfProteinDomains(); ++j) {
                    String id;
                    if (dc_type != BinaryDomainCombination.DomainCombinationType.BASIC && current_start >= protein.getProteinDomain(j).getFrom() || i == j || saw_j.contains(id = protein.getProteinDomain(j).getDomainId())) continue;
                    saw_j.add(id);
                    if (dc_type != BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT) {
                        domain_combination.addCombinableDomain(protein.getProteinDomain(j).getDomainId());
                        continue;
                    }
                    if (closest == null) {
                        closest = protein.getProteinDomain(j);
                        continue;
                    }
                    if (protein.getProteinDomain(j).getFrom() >= closest.getFrom()) continue;
                    closest = protein.getProteinDomain(j);
                }
                if (dc_type == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT && closest != null) {
                    domain_combination.addCombinableDomain(closest.getDomainId());
                }
                if (protein_length_stats_by_dc != null) {
                    List<BinaryDomainCombination> dcs = domain_combination.toBinaryDomainCombinations();
                    for (BinaryDomainCombination dc : dcs) {
                        dc_str = dc.toString();
                        if (!protein_length_stats_by_dc.containsKey(dc_str)) {
                            protein_length_stats_by_dc.put(dc_str, new BasicDescriptiveStatistics());
                        }
                        protein_length_stats_by_dc.get(dc_str).addValue(protein.getLength());
                    }
                }
                if (domain_number_stats_by_dc == null) continue;
                List<BinaryDomainCombination> dcs = domain_combination.toBinaryDomainCombinations();
                for (BinaryDomainCombination dc : dcs) {
                    dc_str = dc.toString();
                    if (!domain_number_stats_by_dc.containsKey(dc_str)) {
                        domain_number_stats_by_dc.put(dc_str, new BasicDescriptiveStatistics());
                    }
                    domain_number_stats_by_dc.get(dc_str).addValue(protein.getNumberOfProteinDomains());
                }
            }
        }
        for (String key_id : domain_counts.keySet()) {
            instance.get(key_id).setKeyDomainCount((Integer)domain_counts.get(key_id));
        }
        return instance;
    }

    private static void countDomains(Map<String, Integer> domain_counts, Set<String> saw_c, String id_i) {
        if (domain_counts.containsKey(id_i)) {
            domain_counts.put(id_i, 1 + domain_counts.get(id_i));
        } else {
            domain_counts.put(id_i, 1);
        }
        saw_c.add(id_i);
    }
}

