/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.HashMap;
import java.util.Map;
import org.forester.protein.BasicDomain;
import org.forester.protein.BinaryDomainCombination;
import org.forester.surfacing.BasicBinaryDomainCombination;

public class DirectedBinaryDomainCombination
extends BasicBinaryDomainCombination {
    private static final Map<Integer, DirectedBinaryDomainCombination> DDC_POOL = new HashMap<Integer, DirectedBinaryDomainCombination>();

    private DirectedBinaryDomainCombination(String n_terminal, String c_terminal) {
        if (n_terminal == null || c_terminal == null) {
            throw new IllegalArgumentException("attempt to create binary domain combination using null");
        }
        this._id0 = BasicDomain.obtainIdAsShort(n_terminal);
        this._id1 = BasicDomain.obtainIdAsShort(c_terminal);
    }

    public static final BinaryDomainCombination obtainInstance(String ids) {
        if (ids.indexOf("=") < 1) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + ids + "]");
        }
        String[] ids_ary = ids.split("=");
        if (ids_ary.length != 2) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + ids + "]");
        }
        return DirectedBinaryDomainCombination.obtainInstance(ids_ary[0], ids_ary[1]);
    }

    public static final DirectedBinaryDomainCombination obtainInstance(String n_terminal, String c_terminal) {
        int code = DirectedBinaryDomainCombination.calcCode(BasicDomain.obtainIdAsShort(n_terminal), BasicDomain.obtainIdAsShort(c_terminal));
        if (DDC_POOL.containsKey(code)) {
            return DDC_POOL.get(code);
        }
        DirectedBinaryDomainCombination dc = new DirectedBinaryDomainCombination(n_terminal, c_terminal);
        DDC_POOL.put(code, dc);
        return dc;
    }
}

