/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.protein.Domain;
import org.forester.protein.Protein;
import org.forester.species.Species;
import org.forester.surfacing.DomainLengths;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class DomainLengthsTable {
    private static final DecimalFormat DF = new DecimalFormat("#.0");
    final SortedMap<String, DomainLengths> _domain_lengths = new TreeMap<String, DomainLengths>();
    final List<Species> _species = new ArrayList<Species>();

    public void addLengths(List<Protein> protein_list) {
        for (Protein protein : protein_list) {
            Species species = protein.getSpecies();
            if (!this._species.contains(species)) {
                this._species.add(species);
            }
            for (Domain domain : protein.getProteinDomains()) {
                this.addLength(domain.getDomainId(), species, domain.getTo() - domain.getFrom() + 1);
            }
        }
    }

    public DescriptiveStatistics calculateMeanBasedStatisticsForAllSpecies() {
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        for (Species species : this.getSpecies()) {
            DescriptiveStatistics stats_per_species = this.calculateMeanBasedStatisticsForSpecies(species);
            stats.addValue(stats_per_species.arithmeticMean());
        }
        return stats;
    }

    public DescriptiveStatistics calculateMeanBasedStatisticsForDomain(String domain_id) {
        return this.getDomainLengths(domain_id).calculateMeanBasedStatistics();
    }

    public DescriptiveStatistics calculateMeanBasedStatisticsForSpecies(Species species) {
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        for (DomainLengths l : this.getDomainLengths().values()) {
            if (!l.isHasLengthStatistic(species)) continue;
            stats.addValue(l.getLengthStatistic(species).arithmeticMean());
        }
        return stats;
    }

    public StringBuilder createMeanBasedStatisticsPerSpeciesTable() {
        StringBuilder sb = new StringBuilder();
        sb.append("SPECIES");
        sb.append("\t");
        sb.append("MEAN");
        sb.append("\t");
        sb.append("SD");
        sb.append("\t");
        sb.append("MIN");
        sb.append("\t");
        sb.append("MAX");
        sb.append("\t");
        sb.append("MEDIAN");
        sb.append(ForesterUtil.LINE_SEPARATOR);
        for (Species species : this.getSpecies()) {
            DescriptiveStatistics stats = this.calculateMeanBasedStatisticsForSpecies(species);
            sb.append(species);
            sb.append("\t");
            sb.append(DF.format(stats.arithmeticMean()));
            sb.append("\t");
            try {
                sb.append(DF.format(stats.sampleStandardDeviation()));
            }
            catch (ArithmeticException e) {
                sb.append("");
            }
            sb.append("\t");
            sb.append(DF.format(stats.getMin()));
            sb.append("\t");
            sb.append(DF.format(stats.getMax()));
            sb.append("\t");
            try {
                sb.append(DF.format(stats.median()));
            }
            catch (ArithmeticException e) {
                sb.append("");
            }
            sb.append(ForesterUtil.LINE_SEPARATOR);
        }
        return sb;
    }

    public DomainLengths getDomainLengths(String domain_id) {
        return (DomainLengths)this.getDomainLengths().get(domain_id);
    }

    public List<DomainLengths> getDomainLengthsList() {
        ArrayList<DomainLengths> list = new ArrayList<DomainLengths>();
        for (DomainLengths l : this.getDomainLengths().values()) {
            list.add(l);
        }
        return list;
    }

    public DescriptiveStatistics getLengthStatistic(String domain_id, Species species) {
        return this.getDomainLengths(domain_id).getLengthStatistic(species);
    }

    public List<Species> getSpecies() {
        return this._species;
    }

    private void addDomainLengths(DomainLengths domain_lengths) {
        if (this.getDomainLengths().containsKey(domain_lengths.getDomainId())) {
            throw new IllegalArgumentException("domain lengths for [" + domain_lengths.getDomainId() + "] already added");
        }
        this.getDomainLengths().put(domain_lengths.getDomainId(), domain_lengths);
    }

    private void addLength(String domain_id, Species species, int domain_length) {
        if (!this.getDomainLengths().containsKey(domain_id)) {
            this.addDomainLengths(new DomainLengths(domain_id));
        }
        ((DomainLengths)this.getDomainLengths().get(domain_id)).addLength(species, domain_length);
    }

    private SortedMap<String, DomainLengths> getDomainLengths() {
        return this._domain_lengths;
    }
}

