/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.application.surfacing;
import org.forester.evoinference.distance.NeighborJoining;
import org.forester.evoinference.matrix.character.BasicCharacterStateMatrix;
import org.forester.evoinference.matrix.character.CharacterStateMatrix;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.matrix.distance.DistanceMatrix;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoTerm;
import org.forester.go.PfamToGoMapping;
import org.forester.io.parsers.phyloxml.PhyloXmlUtil;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.protein.BasicDomain;
import org.forester.protein.BasicProtein;
import org.forester.protein.BinaryDomainCombination;
import org.forester.protein.Domain;
import org.forester.protein.Protein;
import org.forester.species.Species;
import org.forester.surfacing.AdjactantDirectedBinaryDomainCombination;
import org.forester.surfacing.BasicBinaryDomainCombination;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.DirectedBinaryDomainCombination;
import org.forester.surfacing.DomainCountsDifferenceUtil;
import org.forester.surfacing.DomainLengths;
import org.forester.surfacing.DomainLengthsTable;
import org.forester.surfacing.DomainParsimonyCalculator;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.MappingResults;
import org.forester.surfacing.SurfacingConstants;
import org.forester.util.AsciiHistogram;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;
import org.forester.util.TaxonomyColors;

public final class SurfacingUtil {
    public static final Pattern PATTERN_SP_STYLE_TAXONOMY = Pattern.compile("^[A-Z0-9]{3,5}$");
    private static final Map<String, String> _TAXCODE_HEXCOLORSTRING_MAP = new HashMap<String, String>();
    private static final Map<String, String> _TAXCODE_TAXGROUP_MAP = new HashMap<String, String>();
    private static final Comparator<Domain> ASCENDING_CONFIDENCE_VALUE_ORDER = new Comparator<Domain>(){

        @Override
        public int compare(Domain d1, Domain d2) {
            if (d1.getPerDomainEvalue() < d2.getPerDomainEvalue()) {
                return -1;
            }
            if (d1.getPerDomainEvalue() > d2.getPerDomainEvalue()) {
                return 1;
            }
            return d1.compareTo(d2);
        }
    };
    private static final NumberFormat FORMATTER_3 = new DecimalFormat("0.000");

    private SurfacingUtil() {
    }

    public static void addAllBinaryDomainCombinationToSet(GenomeWideCombinableDomains genome, SortedSet<BinaryDomainCombination> binary_domain_combinations) {
        SortedMap<String, CombinableDomains> all_cd = genome.getAllCombinableDomainsIds();
        for (String domain_id : all_cd.keySet()) {
            binary_domain_combinations.addAll(((CombinableDomains)all_cd.get(domain_id)).toBinaryDomainCombinations());
        }
    }

    public static void addAllDomainIdsToSet(GenomeWideCombinableDomains genome, SortedSet<String> domain_ids) {
        SortedSet<String> domains = genome.getAllDomainIds();
        for (String domain : domains) {
            domain_ids.add(domain);
        }
    }

    public static DescriptiveStatistics calculateDescriptiveStatisticsForMeanValues(Set<DomainSimilarity> similarities) {
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        for (DomainSimilarity similarity : similarities) {
            stats.addValue(similarity.getMeanSimilarityScore());
        }
        return stats;
    }

    public static void checkForOutputFileWriteability(File outfile) {
        String error = ForesterUtil.isWritableFile(outfile);
        if (!ForesterUtil.isEmpty(error)) {
            ForesterUtil.fatalError("surfacing", error);
        }
    }

    public static void checkWriteabilityForPairwiseComparisons(DomainSimilarity.PRINT_OPTION domain_similarity_print_option, String[][] input_file_properties, String automated_pairwise_comparison_suffix, File outdir) {
        for (int i = 0; i < input_file_properties.length; ++i) {
            for (int j = 0; j < i; ++j) {
                String species_i = input_file_properties[i][1];
                String species_j = input_file_properties[j][1];
                String pairwise_similarities_output_file_str = "pwc_" + species_i + "_" + species_j + automated_pairwise_comparison_suffix;
                switch (domain_similarity_print_option) {
                    case HTML: {
                        if (pairwise_similarities_output_file_str.endsWith(".html")) break;
                        pairwise_similarities_output_file_str = pairwise_similarities_output_file_str + ".html";
                    }
                }
                String error = ForesterUtil.isWritableFile(new File(outdir == null ? pairwise_similarities_output_file_str : outdir + ForesterUtil.FILE_SEPARATOR + pairwise_similarities_output_file_str));
                if (ForesterUtil.isEmpty(error)) continue;
                ForesterUtil.fatalError("surfacing", error);
            }
        }
    }

    public static void collectChangedDomainCombinationsFromBinaryStatesMatrixAsListToFile(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> matrix, BinaryDomainCombination.DomainCombinationType dc_type, List<BinaryDomainCombination> all_binary_domains_combination_gained, boolean get_gains) {
        TreeSet<String> sorted_ids = new TreeSet<String>();
        for (int i = 0; i < matrix.getNumberOfIdentifiers(); ++i) {
            sorted_ids.add(matrix.getIdentifier(i));
        }
        for (String id : sorted_ids) {
            for (int c = 0; c < matrix.getNumberOfCharacters(); ++c) {
                if ((!get_gains || matrix.getState(id, c) != CharacterStateMatrix.GainLossStates.GAIN) && (get_gains || matrix.getState(id, c) != CharacterStateMatrix.GainLossStates.LOSS)) continue;
                if (dc_type == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT) {
                    all_binary_domains_combination_gained.add(AdjactantDirectedBinaryDomainCombination.obtainInstance(matrix.getCharacter(c)));
                    continue;
                }
                if (dc_type == BinaryDomainCombination.DomainCombinationType.DIRECTED) {
                    all_binary_domains_combination_gained.add(DirectedBinaryDomainCombination.obtainInstance(matrix.getCharacter(c)));
                    continue;
                }
                all_binary_domains_combination_gained.add(BasicBinaryDomainCombination.obtainInstance(matrix.getCharacter(c)));
            }
        }
    }

    public static Map<String, List<GoId>> createDomainIdToGoIdMap(List<PfamToGoMapping> pfam_to_go_mappings) {
        HashMap<String, List<GoId>> domain_id_to_go_ids_map = new HashMap<String, List<GoId>>(pfam_to_go_mappings.size());
        for (PfamToGoMapping pfam_to_go : pfam_to_go_mappings) {
            if (!domain_id_to_go_ids_map.containsKey(pfam_to_go.getKey())) {
                domain_id_to_go_ids_map.put(pfam_to_go.getKey(), new ArrayList());
            }
            ((List)domain_id_to_go_ids_map.get(pfam_to_go.getKey())).add(pfam_to_go.getValue());
        }
        return domain_id_to_go_ids_map;
    }

    public static Map<String, Set<String>> createDomainIdToSecondaryFeaturesMap(File secondary_features_map_file) throws IOException {
        BasicTable<String> primary_table = BasicTableParser.parse(secondary_features_map_file, '\t');
        TreeMap<String, Set<String>> map = new TreeMap<String, Set<String>>();
        for (int r = 0; r < primary_table.getNumberOfRows(); ++r) {
            String domain_id = primary_table.getValue(0, r);
            if (!map.containsKey(domain_id)) {
                map.put(domain_id, new HashSet());
            }
            ((Set)map.get(domain_id)).add(primary_table.getValue(1, r));
        }
        return map;
    }

    public static Phylogeny createNjTreeBasedOnMatrixToFile(File nj_tree_outfile, DistanceMatrix distance) {
        SurfacingUtil.checkForOutputFileWriteability(nj_tree_outfile);
        NeighborJoining nj2 = NeighborJoining.createInstance();
        Phylogeny phylogeny = nj2.execute((BasicSymmetricalDistanceMatrix)distance);
        phylogeny.setName(nj_tree_outfile.getName());
        SurfacingUtil.writePhylogenyToFile(phylogeny, nj_tree_outfile.toString());
        return phylogeny;
    }

    public static StringBuilder createParametersAsString(boolean ignore_dufs, double ie_value_max, double fs_e_value_max, int max_allowed_overlap, boolean no_engulfing_overlaps, File cutoff_scores_file, BinaryDomainCombination.DomainCombinationType dc_type) {
        StringBuilder parameters_sb = new StringBuilder();
        parameters_sb.append("iE-value: " + ie_value_max);
        parameters_sb.append(", FS E-value: " + fs_e_value_max);
        if (cutoff_scores_file != null) {
            parameters_sb.append(", Cutoff-scores-file: " + cutoff_scores_file);
        } else {
            parameters_sb.append(", Cutoff-scores-file: not-set");
        }
        if (max_allowed_overlap != -1) {
            parameters_sb.append(", Max-overlap: " + max_allowed_overlap);
        } else {
            parameters_sb.append(", Max-overlap: not-set");
        }
        if (no_engulfing_overlaps) {
            parameters_sb.append(", Engulfing-overlaps: not-allowed");
        } else {
            parameters_sb.append(", Engulfing-overlaps: allowed");
        }
        if (ignore_dufs) {
            parameters_sb.append(", Ignore-dufs: true");
        } else {
            parameters_sb.append(", Ignore-dufs: false");
        }
        parameters_sb.append(", DC type (if applicable): " + (Object)((Object)dc_type));
        return parameters_sb;
    }

    public static void createSplitWriters(File out_dir, String my_outfile, Map<Character, Writer> split_writers) throws IOException {
        split_writers.put(Character.valueOf('a'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_A.html")));
        split_writers.put(Character.valueOf('b'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_B.html")));
        split_writers.put(Character.valueOf('c'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_C.html")));
        split_writers.put(Character.valueOf('d'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_D.html")));
        split_writers.put(Character.valueOf('e'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_E.html")));
        split_writers.put(Character.valueOf('f'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_F.html")));
        split_writers.put(Character.valueOf('g'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_G.html")));
        split_writers.put(Character.valueOf('h'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_H.html")));
        split_writers.put(Character.valueOf('i'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_I.html")));
        split_writers.put(Character.valueOf('j'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_J.html")));
        split_writers.put(Character.valueOf('k'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_K.html")));
        split_writers.put(Character.valueOf('l'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_L.html")));
        split_writers.put(Character.valueOf('m'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_M.html")));
        split_writers.put(Character.valueOf('n'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_N.html")));
        split_writers.put(Character.valueOf('o'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_O.html")));
        split_writers.put(Character.valueOf('p'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_P.html")));
        split_writers.put(Character.valueOf('q'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_Q.html")));
        split_writers.put(Character.valueOf('r'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_R.html")));
        split_writers.put(Character.valueOf('s'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_S.html")));
        split_writers.put(Character.valueOf('t'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_T.html")));
        split_writers.put(Character.valueOf('u'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_U.html")));
        split_writers.put(Character.valueOf('v'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_V.html")));
        split_writers.put(Character.valueOf('w'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_W.html")));
        split_writers.put(Character.valueOf('x'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_X.html")));
        split_writers.put(Character.valueOf('y'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_Y.html")));
        split_writers.put(Character.valueOf('z'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_Z.html")));
        split_writers.put(Character.valueOf('0'), new BufferedWriter(new FileWriter(out_dir + ForesterUtil.FILE_SEPARATOR + my_outfile + "_domains_0.html")));
    }

    public static Map<String, Integer> createTaxCodeToIdMap(Phylogeny phy) {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        PhylogenyNodeIterator iter = phy.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode n = iter.next();
            if (n.getNodeData().isHasTaxonomy()) {
                int iid;
                String id;
                Taxonomy t = n.getNodeData().getTaxonomy();
                String c = t.getTaxonomyCode();
                if (ForesterUtil.isEmpty(c)) continue;
                if (n.getNodeData().getTaxonomy() == null) {
                    ForesterUtil.fatalError("surfacing", "no taxonomy id for node " + n);
                }
                if (ForesterUtil.isEmpty(id = n.getNodeData().getTaxonomy().getIdentifier().getValue())) {
                    ForesterUtil.fatalError("surfacing", "no taxonomy id for node " + n);
                }
                if (m.containsKey(c)) {
                    ForesterUtil.fatalError("surfacing", "taxonomy code " + c + " is not unique");
                }
                if (m.containsValue(iid = Integer.valueOf(id).intValue())) {
                    ForesterUtil.fatalError("surfacing", "taxonomy id " + iid + " is not unique");
                }
                m.put(c, iid);
                continue;
            }
            ForesterUtil.fatalError("surfacing", "no taxonomy for node " + n);
        }
        return m;
    }

    public static void decoratePrintableDomainSimilarities(SortedSet<DomainSimilarity> domain_similarities, DomainSimilarityCalculator.Detailedness detailedness) {
        for (DomainSimilarity domain_similarity : domain_similarities) {
            if (!(domain_similarity instanceof DomainSimilarity)) continue;
            DomainSimilarity printable_domain_similarity = domain_similarity;
            printable_domain_similarity.setDetailedness(detailedness);
        }
    }

    public static void doit(List<Protein> proteins, List<String> query_domain_ids_nc_order, Writer out, String separator, String limit_to_species, Map<String, List<Integer>> average_protein_lengths_by_dc) throws IOException {
        for (Protein protein : proteins) {
            if (!ForesterUtil.isEmpty(limit_to_species) && !protein.getSpecies().getSpeciesId().equalsIgnoreCase(limit_to_species) || !protein.contains(query_domain_ids_nc_order, true)) continue;
            out.write(protein.getSpecies().getSpeciesId());
            out.write(separator);
            out.write(protein.getProteinId().getId());
            out.write(separator);
            out.write("[");
            HashSet<String> visited_domain_ids = new HashSet<String>();
            boolean first = true;
            for (Domain domain : protein.getProteinDomains()) {
                if (visited_domain_ids.contains(domain.getDomainId())) continue;
                visited_domain_ids.add(domain.getDomainId());
                if (first) {
                    first = false;
                } else {
                    out.write(" ");
                }
                out.write(domain.getDomainId());
                out.write(" {");
                out.write("" + domain.getTotalCount());
                out.write("}");
            }
            out.write("]");
            out.write(separator);
            if (!ForesterUtil.isEmpty(protein.getDescription()) && !protein.getDescription().equals("[none]")) {
                out.write(protein.getDescription());
            }
            out.write(separator);
            if (!ForesterUtil.isEmpty(protein.getAccession()) && !protein.getAccession().equals("[none]")) {
                out.write(protein.getAccession());
            }
            out.write(SurfacingConstants.NL);
        }
        out.flush();
    }

    public static void domainsPerProteinsStatistics(String genome, List<Protein> protein_list, DescriptiveStatistics all_genomes_domains_per_potein_stats, SortedMap<Integer, Integer> all_genomes_domains_per_potein_histo, SortedSet<String> domains_which_are_always_single, SortedSet<String> domains_which_are_sometimes_single_sometimes_not, SortedSet<String> domains_which_never_single, Writer writer) {
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        for (Protein protein : protein_list) {
            int domains = protein.getNumberOfProteinDomains();
            stats.addValue(domains);
            all_genomes_domains_per_potein_stats.addValue(domains);
            if (!all_genomes_domains_per_potein_histo.containsKey(domains)) {
                all_genomes_domains_per_potein_histo.put(domains, 1);
            } else {
                all_genomes_domains_per_potein_histo.put(domains, 1 + (Integer)all_genomes_domains_per_potein_histo.get(domains));
            }
            if (domains == 1) {
                String domain = protein.getProteinDomain(0).getDomainId();
                if (domains_which_are_sometimes_single_sometimes_not.contains(domain)) continue;
                if (domains_which_never_single.contains(domain)) {
                    domains_which_never_single.remove(domain);
                    domains_which_are_sometimes_single_sometimes_not.add(domain);
                    continue;
                }
                domains_which_are_always_single.add(domain);
                continue;
            }
            if (domains <= 1) continue;
            for (Domain d : protein.getProteinDomains()) {
                String domain = d.getDomainId();
                if (domains_which_are_sometimes_single_sometimes_not.contains(domain)) continue;
                if (domains_which_are_always_single.contains(domain)) {
                    domains_which_are_always_single.remove(domain);
                    domains_which_are_sometimes_single_sometimes_not.add(domain);
                    continue;
                }
                domains_which_never_single.add(domain);
            }
        }
        try {
            writer.write(genome);
            writer.write("\t");
            if (stats.getN() >= 1) {
                writer.write(stats.arithmeticMean() + "");
                writer.write("\t");
                if (stats.getN() >= 2) {
                    writer.write(stats.sampleStandardDeviation() + "");
                } else {
                    writer.write("");
                }
                writer.write("\t");
                writer.write(stats.median() + "");
                writer.write("\t");
                writer.write(stats.getN() + "");
                writer.write("\t");
                writer.write(stats.getMin() + "");
                writer.write("\t");
                writer.write(stats.getMax() + "");
            } else {
                writer.write("\t");
                writer.write("\t");
                writer.write("\t");
                writer.write("0");
                writer.write("\t");
                writer.write("\t");
            }
            writer.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void executeDomainLengthAnalysis(String[][] input_file_properties, int number_of_genomes, DomainLengthsTable domain_lengths_table, File outfile) throws IOException {
        DecimalFormat df = new DecimalFormat("#.00");
        SurfacingUtil.checkForOutputFileWriteability(outfile);
        BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
        out.write("MEAN BASED STATISTICS PER SPECIES");
        out.write(ForesterUtil.LINE_SEPARATOR);
        out.write(domain_lengths_table.createMeanBasedStatisticsPerSpeciesTable().toString());
        out.write(ForesterUtil.LINE_SEPARATOR);
        out.write(ForesterUtil.LINE_SEPARATOR);
        List<DomainLengths> domain_lengths_list = domain_lengths_table.getDomainLengthsList();
        out.write("OUTLIER SPECIES PER DOMAIN (Z>=1.5)");
        out.write(ForesterUtil.LINE_SEPARATOR);
        for (DomainLengths domain_lengths : domain_lengths_list) {
            List<Species> species_list = domain_lengths.getMeanBasedOutlierSpecies(1.5);
            if (species_list.size() <= 0) continue;
            out.write(domain_lengths.getDomainId() + "\t");
            for (Species species : species_list) {
                out.write(species + "\t");
            }
            out.write(ForesterUtil.LINE_SEPARATOR);
        }
        out.write(ForesterUtil.LINE_SEPARATOR);
        out.write(ForesterUtil.LINE_SEPARATOR);
        out.write("OUTLIER SPECIES (Z 1.0)");
        out.write(ForesterUtil.LINE_SEPARATOR);
        DescriptiveStatistics stats_for_all_species = domain_lengths_table.calculateMeanBasedStatisticsForAllSpecies();
        out.write(stats_for_all_species.asSummary());
        out.write(ForesterUtil.LINE_SEPARATOR);
        AsciiHistogram histo = new AsciiHistogram(stats_for_all_species);
        out.write(histo.toStringBuffer(40, '=', 60, 4).toString());
        out.write(ForesterUtil.LINE_SEPARATOR);
        double population_sd = stats_for_all_species.sampleStandardDeviation();
        double population_mean = stats_for_all_species.arithmeticMean();
        for (Species species : domain_lengths_table.getSpecies()) {
            double x = domain_lengths_table.calculateMeanBasedStatisticsForSpecies(species).arithmeticMean();
            double z = (x - population_mean) / population_sd;
            out.write(species + "\t" + z);
            out.write(ForesterUtil.LINE_SEPARATOR);
        }
        out.write(ForesterUtil.LINE_SEPARATOR);
        for (Species species : domain_lengths_table.getSpecies()) {
            DescriptiveStatistics stats_for_species = domain_lengths_table.calculateMeanBasedStatisticsForSpecies(species);
            double x = stats_for_species.arithmeticMean();
            double z = (x - population_mean) / population_sd;
            if (!(z <= -1.0) && !(z >= 1.0)) continue;
            out.write(species + "\t" + df.format(z) + "\t" + stats_for_species.asSummary());
            out.write(ForesterUtil.LINE_SEPARATOR);
        }
        out.close();
        System.gc();
    }

    public static void executeFitchGainsAnalysis(File output_file, List<BinaryDomainCombination> all_bin_domain_combinations_changed, int sum_of_all_domains_encountered, SortedSet<BinaryDomainCombination> all_bin_domain_combinations_encountered, boolean is_gains_analysis) throws IOException {
        SurfacingUtil.checkForOutputFileWriteability(output_file);
        BufferedWriter out = ForesterUtil.createBufferedWriter(output_file);
        SortedMap<Object, Integer> bdc_to_counts = ForesterUtil.listToSortedCountsMap(all_bin_domain_combinations_changed);
        TreeSet<String> all_domains_in_combination_changed_more_than_once = new TreeSet<String>();
        TreeSet<String> all_domains_in_combination_changed_only_once = new TreeSet<String>();
        int above_one = 0;
        int one = 0;
        for (Object bdc_object : bdc_to_counts.keySet()) {
            BinaryDomainCombination bdc = (BinaryDomainCombination)bdc_object;
            int count = (Integer)bdc_to_counts.get(bdc_object);
            if (count < 1) {
                ForesterUtil.unexpectedFatalError("surfacing", "count < 1 ");
            }
            out.write(bdc + "\t" + count + ForesterUtil.LINE_SEPARATOR);
            if (count > 1) {
                all_domains_in_combination_changed_more_than_once.add(bdc.getId0());
                all_domains_in_combination_changed_more_than_once.add(bdc.getId1());
                ++above_one;
                continue;
            }
            if (count != 1) continue;
            all_domains_in_combination_changed_only_once.add(bdc.getId0());
            all_domains_in_combination_changed_only_once.add(bdc.getId1());
            ++one;
        }
        int all = all_bin_domain_combinations_encountered.size();
        int never_lost = -1;
        if (!is_gains_analysis) {
            all_bin_domain_combinations_encountered.removeAll(all_bin_domain_combinations_changed);
            never_lost = all_bin_domain_combinations_encountered.size();
            for (BinaryDomainCombination bdc : all_bin_domain_combinations_encountered) {
                out.write(bdc + "\t" + "0" + ForesterUtil.LINE_SEPARATOR);
            }
        }
        if (is_gains_analysis) {
            out.write("Sum of all distinct domain combinations appearing once               : " + one + ForesterUtil.LINE_SEPARATOR);
            out.write("Sum of all distinct domain combinations appearing more than once     : " + above_one + ForesterUtil.LINE_SEPARATOR);
            out.write("Sum of all distinct domains in combinations apppearing only once     : " + all_domains_in_combination_changed_only_once.size() + ForesterUtil.LINE_SEPARATOR);
            out.write("Sum of all distinct domains in combinations apppearing more than once: " + all_domains_in_combination_changed_more_than_once.size() + ForesterUtil.LINE_SEPARATOR);
        } else {
            out.write("Sum of all distinct domain combinations never lost                   : " + never_lost + ForesterUtil.LINE_SEPARATOR);
            out.write("Sum of all distinct domain combinations lost once                    : " + one + ForesterUtil.LINE_SEPARATOR);
            out.write("Sum of all distinct domain combinations lost more than once          : " + above_one + ForesterUtil.LINE_SEPARATOR);
            out.write("Sum of all distinct domains in combinations lost only once           : " + all_domains_in_combination_changed_only_once.size() + ForesterUtil.LINE_SEPARATOR);
            out.write("Sum of all distinct domains in combinations lost more than once: " + all_domains_in_combination_changed_more_than_once.size() + ForesterUtil.LINE_SEPARATOR);
        }
        out.write("All binary combinations                                              : " + all + ForesterUtil.LINE_SEPARATOR);
        out.write("All domains                                                          : " + sum_of_all_domains_encountered);
        ((Writer)out).close();
        ForesterUtil.programMessage("surfacing", "Wrote fitch domain combination dynamics counts analysis to \"" + output_file + "\"");
    }

    public static void executeParsimonyAnalysis(long random_number_seed_for_fitch_parsimony, boolean radomize_fitch_parsimony, String outfile_name, DomainParsimonyCalculator domain_parsimony, Phylogeny phylogeny, Map<String, List<GoId>> domain_id_to_go_ids_map, Map<GoId, GoTerm> go_id_to_term_map, GoNameSpace go_namespace_limit, String parameters_str, Map<String, Set<String>>[] domain_id_to_secondary_features_maps, SortedSet<String> positive_filter, boolean output_binary_domain_combinations_for_graphs, List<BinaryDomainCombination> all_binary_domains_combination_gained_fitch, List<BinaryDomainCombination> all_binary_domains_combination_lost_fitch, BinaryDomainCombination.DomainCombinationType dc_type, Map<String, DescriptiveStatistics> protein_length_stats_by_dc, Map<String, DescriptiveStatistics> domain_number_stats_by_dc, Map<String, DescriptiveStatistics> domain_length_stats_by_domain, Map<String, Integer> tax_code_to_id_map, boolean write_to_nexus, boolean use_last_in_fitch_parsimony, boolean perform_dc_fich) {
        String sep = ForesterUtil.LINE_SEPARATOR + "###################" + ForesterUtil.LINE_SEPARATOR;
        String date_time = ForesterUtil.getCurrentDateTime();
        TreeSet<String> all_pfams_encountered = new TreeSet<String>();
        TreeSet<String> all_pfams_gained_as_domains = new TreeSet<String>();
        TreeSet<String> all_pfams_lost_as_domains = new TreeSet<String>();
        TreeSet<String> all_pfams_gained_as_dom_combinations = new TreeSet<String>();
        TreeSet<String> all_pfams_lost_as_dom_combinations = new TreeSet<String>();
        if (write_to_nexus) {
            SurfacingUtil.writeToNexus(outfile_name, domain_parsimony, phylogeny);
        }
        Phylogeny local_phylogeny_l = phylogeny.copy();
        if (positive_filter != null && positive_filter.size() > 0) {
            domain_parsimony.executeDolloParsimonyOnDomainPresence(positive_filter);
        } else {
            domain_parsimony.executeDolloParsimonyOnDomainPresence();
        }
        SurfacingUtil.writeMatrixToFile(domain_parsimony.getGainLossMatrix(), outfile_name + "_dollo_gl_d", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeMatrixToFile(domain_parsimony.getGainLossCountsMatrix(), outfile_name + "_dollo_glc_d", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, outfile_name + "_dollo_gains_d", sep, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, outfile_name + "_dollo_losses_d", sep, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), null, outfile_name + "_dollo_present_d", sep, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixToList(domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, false, domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, outfile_name + "_dollo_gains_d.html", sep, ForesterUtil.LINE_SEPARATOR, "Dollo Parsimony | Gains | Domains", "+", domain_id_to_secondary_features_maps, all_pfams_encountered, all_pfams_gained_as_domains, "_dollo_gains_d", tax_code_to_id_map);
        SurfacingUtil.writeBinaryStatesMatrixToList(domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, false, domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, outfile_name + "_dollo_losses_d.html", sep, ForesterUtil.LINE_SEPARATOR, "Dollo Parsimony | Losses | Domains", "-", domain_id_to_secondary_features_maps, all_pfams_encountered, all_pfams_lost_as_domains, "_dollo_losses_d", tax_code_to_id_map);
        SurfacingUtil.preparePhylogeny(local_phylogeny_l, domain_parsimony, date_time, "Dollo parsimony on domain presence/absence", "dollo_on_domains_" + outfile_name, parameters_str);
        SurfacingUtil.writePhylogenyToFile(local_phylogeny_l, outfile_name + "_d_dollo.xml");
        try {
            SurfacingUtil.writeAllDomainsChangedOnAllSubtrees(local_phylogeny_l, true, outfile_name, "_dollo_all_gains_d");
            SurfacingUtil.writeAllDomainsChangedOnAllSubtrees(local_phylogeny_l, false, outfile_name, "_dollo_all_losses_d");
        }
        catch (IOException e) {
            e.printStackTrace();
            ForesterUtil.fatalError("surfacing", e.getLocalizedMessage());
        }
        if (perform_dc_fich && domain_parsimony.calculateNumberOfBinaryDomainCombination() > 0) {
            local_phylogeny_l = phylogeny.copy();
            String randomization = "no";
            if (radomize_fitch_parsimony) {
                domain_parsimony.executeFitchParsimonyOnBinaryDomainCombintion(random_number_seed_for_fitch_parsimony);
                randomization = "yes, seed = " + random_number_seed_for_fitch_parsimony;
            } else {
                domain_parsimony.executeFitchParsimonyOnBinaryDomainCombintion(use_last_in_fitch_parsimony);
            }
            SurfacingUtil.writeMatrixToFile(domain_parsimony.getGainLossMatrix(), outfile_name + "_fitch_gl_dc", CharacterStateMatrix.Format.FORESTER);
            SurfacingUtil.writeMatrixToFile(domain_parsimony.getGainLossCountsMatrix(), outfile_name + "_fitch_glc_dc", CharacterStateMatrix.Format.FORESTER);
            SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, outfile_name + "_fitch_gains_dc", sep, ForesterUtil.LINE_SEPARATOR, null);
            SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, outfile_name + "_fitch_losses_dc", sep, ForesterUtil.LINE_SEPARATOR, null);
            SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), null, outfile_name + "_fitch_present_dc", sep, ForesterUtil.LINE_SEPARATOR, null);
            if (all_binary_domains_combination_gained_fitch != null) {
                SurfacingUtil.collectChangedDomainCombinationsFromBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), dc_type, all_binary_domains_combination_gained_fitch, true);
            }
            if (all_binary_domains_combination_lost_fitch != null) {
                SurfacingUtil.collectChangedDomainCombinationsFromBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), dc_type, all_binary_domains_combination_lost_fitch, false);
            }
            if (output_binary_domain_combinations_for_graphs) {
                SurfacingUtil.writeBinaryStatesMatrixAsListToFileForBinaryCombinationsForGraphAnalysis(domain_parsimony.getGainLossMatrix(), null, outfile_name + "_fitch_present_dc.dot", sep, ForesterUtil.LINE_SEPARATOR, BinaryDomainCombination.OutputFormat.DOT);
            }
            SurfacingUtil.writeBinaryStatesMatrixToList(domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, true, domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, outfile_name + "_fitch_gains_dc.html", sep, ForesterUtil.LINE_SEPARATOR, "Fitch Parsimony | Gains | Domain Combinations", "+", null, all_pfams_encountered, all_pfams_gained_as_dom_combinations, "_fitch_gains_dc", tax_code_to_id_map);
            SurfacingUtil.writeBinaryStatesMatrixToList(domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, true, domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, outfile_name + "_fitch_losses_dc.html", sep, ForesterUtil.LINE_SEPARATOR, "Fitch Parsimony | Losses | Domain Combinations", "-", null, all_pfams_encountered, all_pfams_lost_as_dom_combinations, "_fitch_losses_dc", tax_code_to_id_map);
            SurfacingUtil.writeAllEncounteredPfamsToFile(domain_id_to_go_ids_map, go_id_to_term_map, outfile_name, all_pfams_encountered);
            SurfacingUtil.writePfamsToFile(outfile_name + "_all_pfams_gained_as_domains", all_pfams_gained_as_domains);
            SurfacingUtil.writePfamsToFile(outfile_name + "_all_pfams_lost_as_domains", all_pfams_lost_as_domains);
            SurfacingUtil.writePfamsToFile(outfile_name + "_all_pfams_gained_as_dc", all_pfams_gained_as_dom_combinations);
            SurfacingUtil.writePfamsToFile(outfile_name + "_all_pfams_lost_as_dc", all_pfams_lost_as_dom_combinations);
            SurfacingUtil.preparePhylogeny(local_phylogeny_l, domain_parsimony, date_time, "Fitch parsimony on binary domain combination presence/absence randomization: " + randomization, "fitch_on_binary_domain_combinations_" + outfile_name, parameters_str);
            SurfacingUtil.writePhylogenyToFile(local_phylogeny_l, outfile_name + "_dc_fitch.xml");
            SurfacingUtil.calculateIndependentDomainCombinationGains(local_phylogeny_l, outfile_name + "_indep_dc_gains_fitch_counts.txt", outfile_name + "_indep_dc_gains_fitch_lists.txt", outfile_name + "_indep_dc_gains_fitch_lists_for_go_mapping.txt", outfile_name + "_indep_dc_gains_fitch_lists_for_go_mapping_unique.txt", outfile_name + "_indep_dc_gains_fitch_lca_ranks.txt", outfile_name + "_indep_dc_gains_fitch_lca_taxonomies.txt", outfile_name + "_indep_dc_gains_fitch_protein_statistics.txt", protein_length_stats_by_dc, domain_number_stats_by_dc, domain_length_stats_by_domain);
        }
    }

    public static void executeParsimonyAnalysisForSecondaryFeatures(String outfile_name, DomainParsimonyCalculator secondary_features_parsimony, Phylogeny phylogeny, String parameters_str, Map<Species, MappingResults> mapping_results_map, boolean use_last_in_fitch_parsimony) {
        String sep = ForesterUtil.LINE_SEPARATOR + "###################" + ForesterUtil.LINE_SEPARATOR;
        String date_time = ForesterUtil.getCurrentDateTime();
        System.out.println();
        SurfacingUtil.writeToNexus(outfile_name + "_secondary_features.nex", secondary_features_parsimony.createMatrixOfSecondaryFeaturePresenceOrAbsence(null), phylogeny);
        Phylogeny local_phylogeny_copy = phylogeny.copy();
        secondary_features_parsimony.executeDolloParsimonyOnSecondaryFeatures(mapping_results_map);
        SurfacingUtil.writeMatrixToFile(secondary_features_parsimony.getGainLossMatrix(), outfile_name + "_dollo_gl_secondary_features", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeMatrixToFile(secondary_features_parsimony.getGainLossCountsMatrix(), outfile_name + "_dollo_glc_secondary_features", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(secondary_features_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, outfile_name + "_dollo_gains_secondary_features", sep, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(secondary_features_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, outfile_name + "_dollo_losses_secondary_features", sep, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(secondary_features_parsimony.getGainLossMatrix(), null, outfile_name + "_dollo_present_secondary_features", sep, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.preparePhylogeny(local_phylogeny_copy, secondary_features_parsimony, date_time, "Dollo parsimony on secondary feature presence/absence", "dollo_on_secondary_features_" + outfile_name, parameters_str);
        SurfacingUtil.writePhylogenyToFile(local_phylogeny_copy, outfile_name + "_secondary_features_dollo.xml");
        local_phylogeny_copy = phylogeny.copy();
        String randomization = "no";
        secondary_features_parsimony.executeFitchParsimonyOnBinaryDomainCombintionOnSecondaryFeatures(use_last_in_fitch_parsimony);
        SurfacingUtil.preparePhylogeny(local_phylogeny_copy, secondary_features_parsimony, date_time, "Fitch parsimony on secondary binary domain combination presence/absence randomization: no", "fitch_on_binary_domain_combinations_" + outfile_name, parameters_str);
        SurfacingUtil.writePhylogenyToFile(local_phylogeny_copy, outfile_name + "_dc_MAPPED_secondary_features_fitch.xml");
        SurfacingUtil.calculateIndependentDomainCombinationGains(local_phylogeny_copy, outfile_name + "_indep_dc_gains_fitch_counts_MAPPED.txt", outfile_name + "_indep_dc_gains_fitch_lists_MAPPED.txt", outfile_name + "_indep_dc_gains_fitch_lists_for_go_mapping_MAPPED.txt", outfile_name + "_indep_dc_gains_fitch_lists_for_go_mapping_unique_MAPPED.txt", outfile_name + "_MAPPED_indep_dc_gains_fitch_lca_ranks.txt", outfile_name + "_MAPPED_indep_dc_gains_fitch_lca_taxonomies.txt", null, null, null, null);
    }

    public static void executePlusMinusAnalysis(File output_file, List<String> plus_minus_analysis_high_copy_base, List<String> plus_minus_analysis_high_copy_target, List<String> plus_minus_analysis_low_copy, List<GenomeWideCombinableDomains> gwcd_list, SortedMap<Species, List<Protein>> protein_lists_per_species, Map<String, List<GoId>> domain_id_to_go_ids_map, Map<GoId, GoTerm> go_id_to_term_map, List<Object> plus_minus_analysis_numbers) {
        HashSet<String> all_spec = new HashSet<String>();
        for (GenomeWideCombinableDomains gwcd : gwcd_list) {
            all_spec.add(gwcd.getSpecies().getSpeciesId());
        }
        File html_out_dom = new File(output_file + "_plus_minus_dom.html");
        File plain_out_dom = new File(output_file + "_plus_minus_dom.txt");
        File html_out_dc = new File(output_file + "_plus_minus_dc.html");
        File all_domains_go_ids_out_dom = new File(output_file + "_plus_minus_go_ids_all.txt");
        File passing_domains_go_ids_out_dom = new File(output_file + "_plus_minus_go_ids_passing.txt");
        File proteins_file_base = new File(output_file + "");
        int min_diff = (Integer)plus_minus_analysis_numbers.get(0);
        double factor = (Double)plus_minus_analysis_numbers.get(1);
        try {
            DomainCountsDifferenceUtil.calculateCopyNumberDifferences(gwcd_list, protein_lists_per_species, plus_minus_analysis_high_copy_base, plus_minus_analysis_high_copy_target, plus_minus_analysis_low_copy, min_diff, factor, plain_out_dom, html_out_dom, html_out_dc, domain_id_to_go_ids_map, go_id_to_term_map, all_domains_go_ids_out_dom, passing_domains_go_ids_out_dom, proteins_file_base);
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getLocalizedMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote plus minus domain analysis results to \"" + html_out_dom + "\"");
        ForesterUtil.programMessage("surfacing", "Wrote plus minus domain analysis results to \"" + plain_out_dom + "\"");
        ForesterUtil.programMessage("surfacing", "Wrote plus minus domain analysis results to \"" + html_out_dc + "\"");
        ForesterUtil.programMessage("surfacing", "Wrote plus minus domain analysis based passing GO ids to \"" + passing_domains_go_ids_out_dom + "\"");
        ForesterUtil.programMessage("surfacing", "Wrote plus minus domain analysis based all GO ids to \"" + all_domains_go_ids_out_dom + "\"");
    }

    public static void extractProteinNames(List<Protein> proteins, List<String> query_domain_ids_nc_order, Writer out, String separator, String limit_to_species) throws IOException {
        for (Protein protein : proteins) {
            if (!ForesterUtil.isEmpty(limit_to_species) && !protein.getSpecies().getSpeciesId().equalsIgnoreCase(limit_to_species) || !protein.contains(query_domain_ids_nc_order, true)) continue;
            out.write(protein.getSpecies().getSpeciesId());
            out.write(separator);
            out.write(protein.getProteinId().getId());
            out.write(separator);
            out.write("[");
            HashSet<String> visited_domain_ids = new HashSet<String>();
            boolean first = true;
            for (Domain domain : protein.getProteinDomains()) {
                if (visited_domain_ids.contains(domain.getDomainId())) continue;
                visited_domain_ids.add(domain.getDomainId());
                if (first) {
                    first = false;
                } else {
                    out.write(" ");
                }
                out.write(domain.getDomainId());
                out.write(" {");
                out.write("" + domain.getTotalCount());
                out.write("}");
            }
            out.write("]");
            out.write(separator);
            if (!ForesterUtil.isEmpty(protein.getDescription()) && !protein.getDescription().equals("[none]")) {
                out.write(protein.getDescription());
            }
            out.write(separator);
            if (!ForesterUtil.isEmpty(protein.getAccession()) && !protein.getAccession().equals("[none]")) {
                out.write(protein.getAccession());
            }
            out.write(SurfacingConstants.NL);
        }
        out.flush();
    }

    public static void extractProteinNames(SortedMap<Species, List<Protein>> protein_lists_per_species, String domain_id, Writer out, String separator, String limit_to_species, double domain_e_cutoff) throws IOException {
        for (Species species : protein_lists_per_species.keySet()) {
            for (Protein protein : (List)protein_lists_per_species.get(species)) {
                List<Domain> domains;
                if (!ForesterUtil.isEmpty(limit_to_species) && !protein.getSpecies().getSpeciesId().equalsIgnoreCase(limit_to_species) || (domains = protein.getProteinDomains(domain_id)).size() <= 0) continue;
                out.write(protein.getSpecies().getSpeciesId());
                out.write(separator);
                out.write(protein.getProteinId().getId());
                out.write(separator);
                out.write(domain_id.toString());
                out.write(separator);
                int prev_to = -1;
                for (Domain domain : domains) {
                    if (!(domain_e_cutoff < 0.0) && !(domain.getPerDomainEvalue() <= domain_e_cutoff)) continue;
                    out.write("/");
                    out.write(domain.getFrom() + "-" + domain.getTo());
                    if (prev_to >= 0) {
                        int n = domain.getFrom() - prev_to;
                    }
                    prev_to = domain.getTo();
                }
                out.write("/");
                out.write(separator);
                ArrayList<Domain> domain_list = new ArrayList<Domain>();
                for (Domain domain3 : protein.getProteinDomains()) {
                    if (!(domain_e_cutoff < 0.0) && !(domain3.getPerDomainEvalue() <= domain_e_cutoff)) continue;
                    domain_list.add(domain3);
                }
                Domain[] domainArray = new Domain[domain_list.size()];
                for (int i = 0; i < domain_list.size(); ++i) {
                    domainArray[i] = (Domain)domain_list.get(i);
                }
                Arrays.sort(domainArray, new DomainComparator(true));
                out.write("{");
                boolean first = true;
                for (Domain domain4 : domainArray) {
                    if (first) {
                        first = false;
                    } else {
                        out.write(",");
                    }
                    out.write(domain4.getDomainId().toString());
                    out.write(":" + domain4.getFrom() + "-" + domain4.getTo());
                    out.write(":" + domain4.getPerDomainEvalue());
                }
                out.write("}");
                if (!ForesterUtil.isEmpty(protein.getDescription()) && !protein.getDescription().equals("[none]")) {
                    out.write(protein.getDescription());
                }
                out.write(separator);
                if (!ForesterUtil.isEmpty(protein.getAccession()) && !protein.getAccession().equals("[none]")) {
                    out.write(protein.getAccession());
                }
                out.write(SurfacingConstants.NL);
            }
        }
        out.flush();
    }

    public static SortedSet<String> getAllDomainIds(List<GenomeWideCombinableDomains> gwcd_list) {
        TreeSet<String> all_domains_ids = new TreeSet<String>();
        for (GenomeWideCombinableDomains gwcd : gwcd_list) {
            SortedSet<String> all_domains = gwcd.getAllDomainIds();
            all_domains_ids.addAll(all_domains);
        }
        return all_domains_ids;
    }

    public static SortedMap<String, Integer> getDomainCounts(List<Protein> protein_domain_collections) {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (Protein protein_domain_collection : protein_domain_collections) {
            for (Domain name : protein_domain_collection.getProteinDomains()) {
                BasicDomain protein_domain = (BasicDomain)name;
                String id = protein_domain.getDomainId();
                if (map.containsKey(id)) {
                    map.put(id, (Integer)map.get(id) + 1);
                    continue;
                }
                map.put(id, 1);
            }
        }
        return map;
    }

    public static int getNumberOfNodesLackingName(Phylogeny p, StringBuilder names) {
        PhylogenyNodeIterator it = p.iteratorPostorder();
        int c = 0;
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (!ForesterUtil.isEmpty(n.getName()) || n.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getScientificName()) || n.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getCommonName())) continue;
            if (n.getParent() != null) {
                names.append(" ");
                names.append(n.getParent().getName());
            }
            List<PhylogenyNode> l = n.getAllExternalDescendants();
            for (PhylogenyNode object : l) {
                System.out.println(l.toString());
            }
            ++c;
        }
        return c;
    }

    public static void log(String msg, Writer w) {
        try {
            w.write(msg);
            w.write(ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getLocalizedMessage());
        }
    }

    public static Phylogeny[] obtainAndPreProcessIntrees(File[] intree_files, int number_of_genomes, String[][] input_file_properties) {
        Phylogeny[] intrees = new Phylogeny[intree_files.length];
        int i = 0;
        for (File intree_file : intree_files) {
            StringBuilder parent_names;
            int nodes_lacking_name;
            Phylogeny intree = null;
            String error = ForesterUtil.isReadableFile(intree_file);
            if (!ForesterUtil.isEmpty(error)) {
                ForesterUtil.fatalError("surfacing", "cannot read input tree file [" + intree_file + "]: " + error);
            }
            try {
                Phylogeny[] p_array = ParserBasedPhylogenyFactory.getInstance().create(intree_file, ParserUtils.createParserDependingOnFileType(intree_file, true));
                if (p_array.length < 1) {
                    ForesterUtil.fatalError("surfacing", "file [" + intree_file + "] does not contain any phylogeny in phyloXML format");
                } else if (p_array.length > 1) {
                    ForesterUtil.fatalError("surfacing", "file [" + intree_file + "] contains more than one phylogeny in phyloXML format");
                }
                intree = p_array[0];
            }
            catch (Exception e) {
                ForesterUtil.fatalError("surfacing", "failed to read input tree from file [" + intree_file + "]: " + error);
            }
            if (intree == null || intree.isEmpty()) {
                ForesterUtil.fatalError("surfacing", "input tree [" + intree_file + "] is empty");
            }
            if (!intree.isRooted()) {
                ForesterUtil.fatalError("surfacing", "input tree [" + intree_file + "] is not rooted");
            }
            if (intree.getNumberOfExternalNodes() < number_of_genomes) {
                ForesterUtil.fatalError("surfacing", "number of external nodes [" + intree.getNumberOfExternalNodes() + "] of input tree [" + intree_file + "] is smaller than the number of genomes the be analyzed [" + number_of_genomes + "]");
            }
            if ((nodes_lacking_name = SurfacingUtil.getNumberOfNodesLackingName(intree, parent_names = new StringBuilder())) > 0) {
                ForesterUtil.fatalError("surfacing", "input tree [" + intree_file + "] has " + nodes_lacking_name + " node(s) lacking a name [parent names:" + parent_names + "]");
            }
            SurfacingUtil.preparePhylogenyForParsimonyAnalyses(intree, input_file_properties);
            if (!intree.isCompletelyBinary()) {
                ForesterUtil.printWarningMessage("surfacing", "input tree [" + intree_file + "] is not completely binary");
            }
            intrees[i++] = intree;
        }
        return intrees;
    }

    public static Phylogeny obtainFirstIntree(File intree_file) {
        Phylogeny intree = null;
        String error = ForesterUtil.isReadableFile(intree_file);
        if (!ForesterUtil.isEmpty(error)) {
            ForesterUtil.fatalError("surfacing", "cannot read input tree file [" + intree_file + "]: " + error);
        }
        try {
            Phylogeny[] phys = ParserBasedPhylogenyFactory.getInstance().create(intree_file, ParserUtils.createParserDependingOnFileType(intree_file, true));
            if (phys.length < 1) {
                ForesterUtil.fatalError("surfacing", "file [" + intree_file + "] does not contain any phylogeny in phyloXML format");
            } else if (phys.length > 1) {
                ForesterUtil.fatalError("surfacing", "file [" + intree_file + "] contains more than one phylogeny in phyloXML format");
            }
            intree = phys[0];
        }
        catch (Exception e) {
            ForesterUtil.fatalError("surfacing", "failed to read input tree from file [" + intree_file + "]: " + error);
        }
        if (intree == null || intree.isEmpty()) {
            ForesterUtil.fatalError("surfacing", "input tree [" + intree_file + "] is empty");
        }
        if (!intree.isRooted()) {
            ForesterUtil.fatalError("surfacing", "input tree [" + intree_file + "] is not rooted");
        }
        return intree;
    }

    public static String obtainHexColorStringDependingOnTaxonomyGroup(String tax_code, Phylogeny phy) throws IllegalArgumentException {
        if (!_TAXCODE_HEXCOLORSTRING_MAP.containsKey(tax_code)) {
            if (phy != null && !phy.isEmpty()) {
                String group = SurfacingUtil.obtainTaxonomyGroup(tax_code, phy);
                Color c = ForesterUtil.obtainColorDependingOnTaxonomyGroup(group);
                if (c == null) {
                    throw new IllegalArgumentException("no color found for taxonomy group \"" + group + "\" for code \"" + tax_code + "\"");
                }
                String hex = String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
                _TAXCODE_HEXCOLORSTRING_MAP.put(tax_code, hex);
            } else {
                throw new IllegalArgumentException("unable to obtain color for code " + tax_code + " (tree is null or empty and code is not in map)");
            }
        }
        return _TAXCODE_HEXCOLORSTRING_MAP.get(tax_code);
    }

    public static String obtainTaxonomyGroup(String tax_code, Phylogeny species_tree) throws IllegalArgumentException {
        if (!_TAXCODE_TAXGROUP_MAP.containsKey(tax_code)) {
            if (species_tree != null && !species_tree.isEmpty()) {
                List<PhylogenyNode> nodes = species_tree.getNodesViaTaxonomyCode(tax_code);
                if (nodes == null || nodes.isEmpty()) {
                    throw new IllegalArgumentException("code " + tax_code + " is not found");
                }
                if (nodes.size() != 1) {
                    throw new IllegalArgumentException("code " + tax_code + " is not unique");
                }
                String group = null;
                for (PhylogenyNode n = nodes.get(0); n != null; n = n.getParent()) {
                    if (n.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getScientificName())) {
                        group = ForesterUtil.obtainNormalizedTaxonomyGroup(n.getNodeData().getTaxonomy().getScientificName());
                    }
                    if (ForesterUtil.isEmpty(group) && !ForesterUtil.isEmpty(n.getName())) {
                        group = ForesterUtil.obtainNormalizedTaxonomyGroup(n.getName());
                    }
                    if (!ForesterUtil.isEmpty(group)) break;
                }
                if (ForesterUtil.isEmpty(group)) {
                    throw new IllegalArgumentException("no group found for taxonomy code \"" + tax_code + "\"");
                }
                _TAXCODE_TAXGROUP_MAP.put(tax_code, group);
            } else {
                throw new IllegalArgumentException("unable to obtain group for code " + tax_code + " (tree is null or empty and code is not in map)");
            }
        }
        return _TAXCODE_TAXGROUP_MAP.get(tax_code);
    }

    public static void performDomainArchitectureAnalysis(SortedMap<String, Set<String>> domain_architecutures, SortedMap<String, Integer> domain_architecuture_counts, int min_count, File da_counts_outfile, File unique_da_outfile) {
        SurfacingUtil.checkForOutputFileWriteability(da_counts_outfile);
        SurfacingUtil.checkForOutputFileWriteability(unique_da_outfile);
        try {
            BufferedWriter da_counts_out = new BufferedWriter(new FileWriter(da_counts_outfile));
            BufferedWriter unique_da_out = new BufferedWriter(new FileWriter(unique_da_outfile));
            for (Map.Entry<String, Integer> e : domain_architecuture_counts.entrySet()) {
                String da = e.getKey();
                int count = e.getValue();
                if (count >= min_count) {
                    da_counts_out.write(da);
                    da_counts_out.write("\t");
                    da_counts_out.write(String.valueOf(count));
                    da_counts_out.write(ForesterUtil.LINE_SEPARATOR);
                }
                if (count != 1) continue;
                for (Map.Entry<String, Set<String>> e2 : domain_architecutures.entrySet()) {
                    String genome = e2.getKey();
                    Set<String> das = e2.getValue();
                    if (!das.contains(da)) continue;
                    unique_da_out.write(genome);
                    unique_da_out.write("\t");
                    unique_da_out.write(da);
                    unique_da_out.write(ForesterUtil.LINE_SEPARATOR);
                }
            }
            unique_da_out.close();
            da_counts_out.close();
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote distance matrices to \"" + da_counts_outfile + "\"");
        ForesterUtil.programMessage("surfacing", "Wrote distance matrices to \"" + unique_da_outfile + "\"");
    }

    public static void preparePhylogeny(Phylogeny p, DomainParsimonyCalculator domain_parsimony, String date_time, String method, String name, String parameters_str) {
        domain_parsimony.decoratePhylogenyWithDomains(p);
        StringBuilder desc = new StringBuilder();
        desc.append("[Method: " + method + "] [Date: " + date_time + "] ");
        desc.append("[Cost: " + domain_parsimony.getCost() + "] ");
        desc.append("[Gains: " + domain_parsimony.getTotalGains() + "] ");
        desc.append("[Losses: " + domain_parsimony.getTotalLosses() + "] ");
        desc.append("[Unchanged: " + domain_parsimony.getTotalUnchanged() + "] ");
        desc.append("[Parameters: " + parameters_str + "]");
        p.setName(name);
        p.setDescription(desc.toString());
        p.setConfidence(new Confidence(domain_parsimony.getCost(), "parsimony"));
        p.setRerootable(false);
        p.setRooted(true);
    }

    public static void preparePhylogenyForParsimonyAnalyses(Phylogeny intree, String[][] input_file_properties) {
        String[] genomes = new String[input_file_properties.length];
        for (int i = 0; i < input_file_properties.length; ++i) {
            if (intree.getNodes(input_file_properties[i][1]).size() > 1) {
                ForesterUtil.fatalError("surfacing", "node named [" + input_file_properties[i][1] + "] is not unique in input tree " + intree.getName());
            }
            genomes[i] = input_file_properties[i][1];
        }
        PhylogenyNodeIterator it = intree.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (!ForesterUtil.isEmpty(n.getName())) continue;
            if (n.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getTaxonomyCode())) {
                n.setName(n.getNodeData().getTaxonomy().getTaxonomyCode());
                continue;
            }
            if (n.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getScientificName())) {
                n.setName(n.getNodeData().getTaxonomy().getScientificName());
                continue;
            }
            if (n.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getCommonName())) {
                n.setName(n.getNodeData().getTaxonomy().getCommonName());
                continue;
            }
            ForesterUtil.fatalError("surfacing", "node with no name, scientific name, common name, or taxonomy code present");
        }
        List<String> igns = PhylogenyMethods.deleteExternalNodesPositiveSelection(genomes, intree);
        if (igns.size() > 0) {
            System.out.println("Not using the following " + igns.size() + " nodes:");
            for (int i = 0; i < igns.size(); ++i) {
                System.out.println(" " + i + ": " + igns.get(i));
            }
            System.out.println("--");
        }
        for (String[] input_file_propertie : input_file_properties) {
            try {
                intree.getNode(input_file_propertie[1]);
            }
            catch (IllegalArgumentException e) {
                ForesterUtil.fatalError("surfacing", "node named [" + input_file_propertie[1] + "] not present/not unique in input tree");
            }
        }
    }

    public static void printOutPercentageOfMultidomainProteins(SortedMap<Integer, Integer> all_genomes_domains_per_potein_histo, Writer log_writer) {
        int sum = 0;
        for (Map.Entry<Integer, Integer> entry : all_genomes_domains_per_potein_histo.entrySet()) {
            sum += entry.getValue().intValue();
        }
        double percentage = 100.0 * (double)(sum - (Integer)all_genomes_domains_per_potein_histo.get(1)) / (double)sum;
        ForesterUtil.programMessage("surfacing", "Percentage of multidomain proteins: " + percentage + "%");
        SurfacingUtil.log("Percentage of multidomain proteins:            : " + percentage + "%", log_writer);
    }

    public static void processFilter(File filter_file, SortedSet<String> filter) {
        SortedSet<String> filter_str = null;
        try {
            filter_str = ForesterUtil.file2set(filter_file);
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        if (filter_str != null) {
            for (String string : filter_str) {
                filter.add(string);
            }
        }
    }

    public static String[][] processInputGenomesFile(File input_genomes) {
        String[][] input_file_properties = null;
        try {
            input_file_properties = ForesterUtil.file22dArray(input_genomes);
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", "genomes files is to be in the following format \"<hmmpfam output file> <species>\": " + e.getLocalizedMessage());
        }
        HashSet<String> specs = new HashSet<String>();
        HashSet<String> paths = new HashSet<String>();
        for (int i = 0; i < input_file_properties.length; ++i) {
            if (!PhyloXmlUtil.TAXOMONY_CODE_PATTERN.matcher(input_file_properties[i][1]).matches()) {
                ForesterUtil.fatalError("surfacing", "illegal format for species code: " + input_file_properties[i][1]);
            }
            if (specs.contains(input_file_properties[i][1])) {
                ForesterUtil.fatalError("surfacing", "species code " + input_file_properties[i][1] + " is not unique");
            }
            specs.add(input_file_properties[i][1]);
            if (paths.contains(input_file_properties[i][0])) {
                ForesterUtil.fatalError("surfacing", "path " + input_file_properties[i][0] + " is not unique");
            }
            paths.add(input_file_properties[i][0]);
            String error = ForesterUtil.isReadableFile(new File(input_file_properties[i][0]));
            if (ForesterUtil.isEmpty(error)) continue;
            ForesterUtil.fatalError("surfacing", error);
        }
        return input_file_properties;
    }

    public static void processPlusMinusAnalysisOption(CommandLineArguments cla, List<String> high_copy_base, List<String> high_copy_target, List<String> low_copy, List<Object> numbers) {
        if (cla.isOptionSet("plus_minus")) {
            File plus_minus_file;
            String msg;
            if (!cla.isOptionValueSet("plus_minus")) {
                ForesterUtil.fatalError("surfacing", "no value for 'plus-minus' file: -plus_minus=<file>");
            }
            if (!ForesterUtil.isEmpty(msg = ForesterUtil.isReadableFile(plus_minus_file = new File(cla.getOptionValue("plus_minus"))))) {
                ForesterUtil.fatalError("surfacing", "can not read from \"" + plus_minus_file + "\": " + msg);
            }
            SurfacingUtil.processPlusMinusFile(plus_minus_file, high_copy_base, high_copy_target, low_copy, numbers);
        }
    }

    public static void processPlusMinusFile(File plus_minus_file, List<String> high_copy_base, List<String> high_copy_target, List<String> low_copy, List<Object> numbers) {
        SortedSet<String> species_set = null;
        int min_diff = 0;
        double factor = 1.0;
        try {
            species_set = ForesterUtil.file2set(plus_minus_file);
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        if (species_set != null) {
            for (String species : species_set) {
                String species_trimmed = species.substring(1);
                if (species.startsWith("+")) {
                    if (low_copy.contains(species_trimmed)) {
                        ForesterUtil.fatalError("surfacing", "species/genome names can not appear with both '+' and '-' suffix, as appears the case for: \"" + species_trimmed + "\"");
                    }
                    high_copy_base.add(species_trimmed);
                } else if (species.startsWith("*")) {
                    if (low_copy.contains(species_trimmed)) {
                        ForesterUtil.fatalError("surfacing", "species/genome names can not appear with both '*' and '-' suffix, as appears the case for: \"" + species_trimmed + "\"");
                    }
                    high_copy_target.add(species_trimmed);
                } else if (species.startsWith("-")) {
                    if (high_copy_base.contains(species_trimmed) || high_copy_target.contains(species_trimmed)) {
                        ForesterUtil.fatalError("surfacing", "species/genome names can not appear with both '+' or '*' and '-' suffix, as appears the case for: \"" + species_trimmed + "\"");
                    }
                    low_copy.add(species_trimmed);
                } else if (species.startsWith("$D")) {
                    try {
                        min_diff = Integer.parseInt(species.substring(3));
                    }
                    catch (NumberFormatException e) {
                        ForesterUtil.fatalError("surfacing", "could not parse integer value for minimal difference from: \"" + species.substring(3) + "\"");
                    }
                } else if (species.startsWith("$F")) {
                    try {
                        factor = Double.parseDouble(species.substring(3));
                    }
                    catch (NumberFormatException e) {
                        ForesterUtil.fatalError("surfacing", "could not parse double value for factor from: \"" + species.substring(3) + "\"");
                    }
                } else if (!species.startsWith("#")) {
                    ForesterUtil.fatalError("surfacing", "species/genome names in 'plus minus' file must begin with '*' (high copy target genome), '+' (high copy base genomes), '-' (low copy genomes), '$D=<integer>' minimal Difference (default is 1), '$F=<double>' factor (default is 1.0), double), or '#' (ignore) suffix, encountered: \"" + species + "\"");
                }
                numbers.add(new Integer(min_diff + ""));
                numbers.add(new Double(factor + ""));
            }
        } else {
            ForesterUtil.fatalError("surfacing", "'plus minus' file [" + plus_minus_file + "] appears empty");
        }
    }

    public static StringBuffer proteinToDomainCombinations(Protein protein, String protein_id, String separator) {
        StringBuffer sb = new StringBuffer();
        if (protein.getSpecies() == null) {
            throw new IllegalArgumentException("species must not be null");
        }
        if (ForesterUtil.isEmpty(protein.getSpecies().getSpeciesId())) {
            throw new IllegalArgumentException("species id must not be empty");
        }
        List<Domain> domains = protein.getProteinDomains();
        if (domains.size() > 1) {
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            for (Domain domain : domains) {
                String id = domain.getDomainId();
                if (counts.containsKey(id)) {
                    counts.put(id, (Integer)counts.get(id) + 1);
                    continue;
                }
                counts.put(id, 1);
            }
            HashSet<String> dcs = new HashSet<String>();
            for (int i = 1; i < domains.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                    String dc;
                    Domain domain_n = domains.get(i);
                    Domain domain_c = domains.get(j);
                    if (domain_n.getFrom() > domain_c.getFrom()) {
                        domain_n = domains.get(j);
                        domain_c = domains.get(i);
                    }
                    if (dcs.contains(dc = domain_n.getDomainId() + domain_c.getDomainId())) continue;
                    dcs.add(dc);
                    sb.append(protein.getSpecies());
                    sb.append(separator);
                    sb.append(protein_id);
                    sb.append(separator);
                    sb.append(domain_n.getDomainId());
                    sb.append(separator);
                    sb.append(domain_c.getDomainId());
                    sb.append(separator);
                    sb.append(domain_n.getPerDomainEvalue());
                    sb.append(separator);
                    sb.append(domain_c.getPerDomainEvalue());
                    sb.append(separator);
                    sb.append(counts.get(domain_n.getDomainId()));
                    sb.append(separator);
                    sb.append(counts.get(domain_c.getDomainId()));
                    sb.append(ForesterUtil.LINE_SEPARATOR);
                }
            }
        } else if (domains.size() == 1) {
            sb.append(protein.getSpecies());
            sb.append(separator);
            sb.append(protein_id);
            sb.append(separator);
            sb.append(domains.get(0).getDomainId());
            sb.append(separator);
            sb.append(separator);
            sb.append(domains.get(0).getPerDomainEvalue());
            sb.append(separator);
            sb.append(separator);
            sb.append(1);
            sb.append(separator);
            sb.append(ForesterUtil.LINE_SEPARATOR);
        } else {
            sb.append(protein.getSpecies());
            sb.append(separator);
            sb.append(protein_id);
            sb.append(separator);
            sb.append(separator);
            sb.append(separator);
            sb.append(separator);
            sb.append(separator);
            sb.append(separator);
            sb.append(ForesterUtil.LINE_SEPARATOR);
        }
        return sb;
    }

    public static List<Domain> sortDomainsWithAscendingConfidenceValues(Protein protein) {
        ArrayList<Domain> domains = new ArrayList<Domain>();
        for (Domain d : protein.getProteinDomains()) {
            domains.add(d);
        }
        Collections.sort(domains, ASCENDING_CONFIDENCE_VALUE_ORDER);
        return domains;
    }

    public static int storeDomainArchitectures(String genome, SortedMap<String, Set<String>> domain_architecutures, List<Protein> protein_list, Map<String, Integer> distinct_domain_architecuture_counts) {
        HashSet<String> da = new HashSet<String>();
        domain_architecutures.put(genome, da);
        for (Protein protein : protein_list) {
            String da_str = ((BasicProtein)protein).toDomainArchitectureString("~", 3, "=");
            if (da.contains(da_str)) continue;
            if (!distinct_domain_architecuture_counts.containsKey(da_str)) {
                distinct_domain_architecuture_counts.put(da_str, 1);
            } else {
                distinct_domain_architecuture_counts.put(da_str, distinct_domain_architecuture_counts.get(da_str) + 1);
            }
            da.add(da_str);
        }
        return da.size();
    }

    public static void writeAllDomainsChangedOnAllSubtrees(Phylogeny p, boolean get_gains, String outdir, String suffix_for_filename) throws IOException {
        CharacterStateMatrix.GainLossStates state = CharacterStateMatrix.GainLossStates.GAIN;
        if (!get_gains) {
            state = CharacterStateMatrix.GainLossStates.LOSS;
        }
        File base_dir = SurfacingUtil.createBaseDirForPerNodeDomainFiles("PER_SUBTREE_EVENTS", false, state, outdir);
        PhylogenyNodeIterator it = p.iteratorPostorder();
        while (it.hasNext()) {
            SortedSet<String> domains;
            PhylogenyNode node = it.next();
            if (node.isExternal() || (domains = SurfacingUtil.collectAllDomainsChangedOnSubtree(node, get_gains)).size() <= 0) continue;
            BufferedWriter writer = ForesterUtil.createBufferedWriter(base_dir + ForesterUtil.FILE_SEPARATOR + node.getName() + suffix_for_filename);
            for (String domain : domains) {
                writer.write(domain);
                writer.write(ForesterUtil.LINE_SEPARATOR);
            }
            ((Writer)writer).close();
        }
    }

    public static void writeBinaryDomainCombinationsFileForGraphAnalysis(String[][] input_file_properties, File output_dir, GenomeWideCombinableDomains gwcd, int i, GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder dc_sort_order) {
        File dc_outfile_dot = new File(input_file_properties[i][1] + "_dc.dot");
        if (output_dir != null) {
            dc_outfile_dot = new File(output_dir + ForesterUtil.FILE_SEPARATOR + dc_outfile_dot);
        }
        SurfacingUtil.checkForOutputFileWriteability(dc_outfile_dot);
        SortedSet<BinaryDomainCombination> binary_combinations = SurfacingUtil.createSetOfAllBinaryDomainCombinationsPerGenome(gwcd);
        try {
            BufferedWriter out_dot = new BufferedWriter(new FileWriter(dc_outfile_dot));
            for (BinaryDomainCombination bdc : binary_combinations) {
                out_dot.write(bdc.toGraphDescribingLanguage(BinaryDomainCombination.OutputFormat.DOT, null, null).toString());
                out_dot.write(SurfacingConstants.NL);
            }
            out_dot.close();
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        if (input_file_properties[i].length == 3) {
            ForesterUtil.programMessage("surfacing", "Wrote binary domain combination for \"" + input_file_properties[i][0] + "\" (" + input_file_properties[i][1] + ", " + input_file_properties[i][2] + ") to: \"" + dc_outfile_dot + "\"");
        } else {
            ForesterUtil.programMessage("surfacing", "Wrote binary domain combination for \"" + input_file_properties[i][0] + "\" (" + input_file_properties[i][1] + ") to: \"" + dc_outfile_dot + "\"");
        }
    }

    public static void writeBinaryStatesMatrixAsListToFile(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> matrix, CharacterStateMatrix.GainLossStates state, String filename, String indentifier_characters_separator, String character_separator, Map<String, String> descriptions) {
        File outfile = new File(filename);
        SurfacingUtil.checkForOutputFileWriteability(outfile);
        TreeSet<String> sorted_ids = new TreeSet<String>();
        for (int i = 0; i < matrix.getNumberOfIdentifiers(); ++i) {
            sorted_ids.add(matrix.getIdentifier(i));
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
            for (String id : sorted_ids) {
                out.write(indentifier_characters_separator);
                out.write("#" + id);
                out.write(indentifier_characters_separator);
                for (int c = 0; c < matrix.getNumberOfCharacters(); ++c) {
                    if (matrix.getState(id, c) != state && (state != null || matrix.getState(id, c) != CharacterStateMatrix.GainLossStates.GAIN && matrix.getState(id, c) != CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT)) continue;
                    out.write(matrix.getCharacter(c));
                    if (descriptions != null && !descriptions.isEmpty() && descriptions.containsKey(matrix.getCharacter(c))) {
                        out.write("\t");
                        out.write(descriptions.get(matrix.getCharacter(c)));
                    }
                    out.write(character_separator);
                }
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote characters list: \"" + filename + "\"");
    }

    public static void writeBinaryStatesMatrixAsListToFileForBinaryCombinationsForGraphAnalysis(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> matrix, CharacterStateMatrix.GainLossStates state, String filename, String indentifier_characters_separator, String character_separator, BinaryDomainCombination.OutputFormat bc_output_format) {
        File outfile = new File(filename);
        SurfacingUtil.checkForOutputFileWriteability(outfile);
        TreeSet<String> sorted_ids = new TreeSet<String>();
        for (int i = 0; i < matrix.getNumberOfIdentifiers(); ++i) {
            sorted_ids.add(matrix.getIdentifier(i));
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
            for (String id : sorted_ids) {
                out.write(indentifier_characters_separator);
                out.write("#" + id);
                out.write(indentifier_characters_separator);
                for (int c = 0; c < matrix.getNumberOfCharacters(); ++c) {
                    if (matrix.getState(id, c) != state && (state != null || matrix.getState(id, c) != CharacterStateMatrix.GainLossStates.GAIN && matrix.getState(id, c) != CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT)) continue;
                    BinaryDomainCombination bdc = null;
                    try {
                        bdc = BasicBinaryDomainCombination.obtainInstance(matrix.getCharacter(c));
                    }
                    catch (Exception e) {
                        ForesterUtil.fatalError("surfacing", e.getLocalizedMessage());
                    }
                    out.write(bdc.toGraphDescribingLanguage(bc_output_format, null, null).toString());
                    out.write(character_separator);
                }
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote characters list: \"" + filename + "\"");
    }

    public static void writeBinaryStatesMatrixToList(Map<String, List<GoId>> domain_id_to_go_ids_map, Map<GoId, GoTerm> go_id_to_term_map, GoNameSpace go_namespace_limit, boolean domain_combinations, CharacterStateMatrix<CharacterStateMatrix.GainLossStates> matrix, CharacterStateMatrix.GainLossStates state, String filename, String indentifier_characters_separator, String character_separator, String title_for_html, String prefix_for_html, Map<String, Set<String>>[] domain_id_to_secondary_features_maps, SortedSet<String> all_pfams_encountered, SortedSet<String> pfams_gained_or_lost, String suffix_for_per_node_events_file, Map<String, Integer> tax_code_to_id_map) {
        if (go_namespace_limit != null && (go_id_to_term_map == null || go_id_to_term_map.size() < 1)) {
            throw new IllegalArgumentException("attempt to use GO namespace limit without a GO-id to term map");
        }
        if (domain_id_to_go_ids_map == null || domain_id_to_go_ids_map.size() < 1) {
            throw new IllegalArgumentException("attempt to output detailed HTML without a Pfam to GO map");
        }
        if (go_id_to_term_map == null || go_id_to_term_map.size() < 1) {
            throw new IllegalArgumentException("attempt to output detailed HTML without a GO-id to term map");
        }
        File outfile = new File(filename);
        SurfacingUtil.checkForOutputFileWriteability(outfile);
        TreeSet<String> sorted_ids = new TreeSet<String>();
        for (int i = 0; i < matrix.getNumberOfIdentifiers(); ++i) {
            sorted_ids.add(matrix.getIdentifier(i));
        }
        try {
            Matcher matcher;
            BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
            File per_node_go_mapped_domain_gain_loss_files_base_dir = SurfacingUtil.createBaseDirForPerNodeDomainFiles("PER_NODE_EVENTS", domain_combinations, state, filename);
            Writer per_node_go_mapped_domain_gain_loss_outfile_writer = null;
            File per_node_go_mapped_domain_gain_loss_outfile = null;
            int per_node_counter = 0;
            out.write("<html>");
            out.write(SurfacingConstants.NL);
            SurfacingUtil.writeHtmlHead(out, title_for_html);
            out.write(SurfacingConstants.NL);
            out.write("<body>");
            out.write(SurfacingConstants.NL);
            out.write("<h1>");
            out.write(SurfacingConstants.NL);
            out.write(title_for_html);
            out.write(SurfacingConstants.NL);
            out.write("</h1>");
            out.write(SurfacingConstants.NL);
            out.write("<table>");
            out.write(SurfacingConstants.NL);
            for (String id : sorted_ids) {
                matcher = PATTERN_SP_STYLE_TAXONOMY.matcher(id);
                if (matcher.matches()) continue;
                out.write("<tr>");
                out.write("<td>");
                out.write("<a href=\"#" + id + "\">" + id + "</a>");
                out.write("</td>");
                out.write("</tr>");
                out.write(SurfacingConstants.NL);
            }
            out.write("</table>");
            out.write(SurfacingConstants.NL);
            for (String id : sorted_ids) {
                matcher = PATTERN_SP_STYLE_TAXONOMY.matcher(id);
                if (matcher.matches()) continue;
                out.write(SurfacingConstants.NL);
                out.write("<h2>");
                out.write("<a name=\"" + id + "\">" + id + "</a>");
                SurfacingUtil.writeTaxonomyLinks(out, id, tax_code_to_id_map);
                out.write("</h2>");
                out.write(SurfacingConstants.NL);
                out.write("<table>");
                out.write(SurfacingConstants.NL);
                out.write("<tr>");
                out.write("<td><b>");
                out.write("Pfam domain(s)");
                out.write("</b></td><td><b>");
                out.write("GO term acc");
                out.write("</b></td><td><b>");
                out.write("GO term");
                out.write("</b></td><td><b>");
                out.write("GO namespace");
                out.write("</b></td>");
                out.write("</tr>");
                out.write(SurfacingConstants.NL);
                out.write("</tr>");
                out.write(SurfacingConstants.NL);
                per_node_counter = 0;
                if (matrix.getNumberOfCharacters() > 0) {
                    per_node_go_mapped_domain_gain_loss_outfile = new File(per_node_go_mapped_domain_gain_loss_files_base_dir + ForesterUtil.FILE_SEPARATOR + id + suffix_for_per_node_events_file);
                    SurfacingUtil.checkForOutputFileWriteability(per_node_go_mapped_domain_gain_loss_outfile);
                    per_node_go_mapped_domain_gain_loss_outfile_writer = ForesterUtil.createBufferedWriter(per_node_go_mapped_domain_gain_loss_outfile);
                } else {
                    per_node_go_mapped_domain_gain_loss_outfile = null;
                    per_node_go_mapped_domain_gain_loss_outfile_writer = null;
                }
                for (int c = 0; c < matrix.getNumberOfCharacters(); ++c) {
                    if (matrix.getState(id, c) != state && (state != null || matrix.getState(id, c) != CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT && matrix.getState(id, c) != CharacterStateMatrix.GainLossStates.GAIN)) continue;
                    String character = matrix.getCharacter(c);
                    String domain_0 = "";
                    String domain_1 = "";
                    if (character.indexOf("=") > 0) {
                        String[] s = character.split("=");
                        if (s.length != 2) {
                            throw new AssertionError((Object)("this should not have happened: unexpected format for domain combination: [" + character + "]"));
                        }
                        domain_0 = s[0];
                        domain_1 = s[1];
                    } else {
                        domain_0 = character;
                    }
                    SurfacingUtil.writeDomainData(domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, out, domain_0, domain_1, prefix_for_html, character_separator, domain_id_to_secondary_features_maps, null);
                    all_pfams_encountered.add(domain_0);
                    if (pfams_gained_or_lost != null) {
                        pfams_gained_or_lost.add(domain_0);
                    }
                    if (!ForesterUtil.isEmpty(domain_1)) {
                        all_pfams_encountered.add(domain_1);
                        if (pfams_gained_or_lost != null) {
                            pfams_gained_or_lost.add(domain_1);
                        }
                    }
                    if (per_node_go_mapped_domain_gain_loss_outfile_writer == null) continue;
                    SurfacingUtil.writeDomainsToIndividualFilePerTreeNode(per_node_go_mapped_domain_gain_loss_outfile_writer, domain_0, domain_1);
                    ++per_node_counter;
                }
                if (per_node_go_mapped_domain_gain_loss_outfile_writer != null) {
                    per_node_go_mapped_domain_gain_loss_outfile_writer.close();
                    if (per_node_counter < 1) {
                        per_node_go_mapped_domain_gain_loss_outfile.delete();
                    }
                    per_node_counter = 0;
                }
                out.write("</table>");
                out.write(SurfacingConstants.NL);
                out.write("<hr>");
                out.write(SurfacingConstants.NL);
            }
            out.write("</body>");
            out.write(SurfacingConstants.NL);
            out.write("</html>");
            out.write(SurfacingConstants.NL);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote characters detailed HTML list: \"" + filename + "\"");
    }

    public static void writeDomainCombinationsCountsFile(String[][] input_file_properties, File output_dir, Writer per_genome_domain_promiscuity_statistics_writer, GenomeWideCombinableDomains gwcd, int i, GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder dc_sort_order) {
        File dc_outfile = new File(input_file_properties[i][1] + ".dcc");
        if (output_dir != null) {
            dc_outfile = new File(output_dir + ForesterUtil.FILE_SEPARATOR + dc_outfile);
        }
        SurfacingUtil.checkForOutputFileWriteability(dc_outfile);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(dc_outfile));
            out.write(gwcd.toStringBuilder(dc_sort_order).toString());
            out.close();
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        DescriptiveStatistics stats = gwcd.getPerGenomeDomainPromiscuityStatistics();
        try {
            per_genome_domain_promiscuity_statistics_writer.write(input_file_properties[i][1] + "\t");
            per_genome_domain_promiscuity_statistics_writer.write(FORMATTER_3.format(stats.arithmeticMean()) + "\t");
            if (stats.getN() < 2) {
                per_genome_domain_promiscuity_statistics_writer.write("n/a\t");
            } else {
                per_genome_domain_promiscuity_statistics_writer.write(FORMATTER_3.format(stats.sampleStandardDeviation()) + "\t");
            }
            per_genome_domain_promiscuity_statistics_writer.write(FORMATTER_3.format(stats.median()) + "\t");
            per_genome_domain_promiscuity_statistics_writer.write((int)stats.getMin() + "\t");
            per_genome_domain_promiscuity_statistics_writer.write((int)stats.getMax() + "\t");
            per_genome_domain_promiscuity_statistics_writer.write(stats.getN() + "\t");
            SortedSet<String> mpds = gwcd.getMostPromiscuosDomain();
            for (String mpd : mpds) {
                per_genome_domain_promiscuity_statistics_writer.write(mpd + " ");
            }
            per_genome_domain_promiscuity_statistics_writer.write(ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        if (input_file_properties[i].length == 3) {
            ForesterUtil.programMessage("surfacing", "Wrote domain combination counts for \"" + input_file_properties[i][0] + "\" (" + input_file_properties[i][1] + ", " + input_file_properties[i][2] + ") to: \"" + dc_outfile + "\"");
        } else {
            ForesterUtil.programMessage("surfacing", "Wrote domain combination counts for \"" + input_file_properties[i][0] + "\" (" + input_file_properties[i][1] + ") to: \"" + dc_outfile + "\"");
        }
    }

    public static void writeDomainSimilaritiesToFile(StringBuilder html_desc, StringBuilder html_title, Writer simple_tab_writer, Writer single_writer, Map<Character, Writer> split_writers, SortedSet<DomainSimilarity> similarities, boolean treat_as_binary, List<Species> species_order, DomainSimilarity.PRINT_OPTION print_option, DomainSimilarity.DomainSimilarityScoring scoring, boolean verbose, Map<String, Integer> tax_code_to_id_map, Phylogeny phy, Set<String> pos_filter_doms) throws IOException {
        Writer local_writer;
        if (single_writer != null && (split_writers == null || split_writers.isEmpty())) {
            split_writers = new HashMap<Character, Writer>();
            split_writers.put(Character.valueOf('_'), single_writer);
        }
        switch (print_option) {
            case SIMPLE_TAB_DELIMITED: {
                break;
            }
            case HTML: {
                for (Character key : split_writers.keySet()) {
                    Writer w = split_writers.get(key);
                    w.write("<html>");
                    w.write(SurfacingConstants.NL);
                    if (key.charValue() != '_') {
                        SurfacingUtil.writeHtmlHead(w, "DC analysis (" + html_title + ") " + key.toString().toUpperCase());
                    } else {
                        SurfacingUtil.writeHtmlHead(w, "DC analysis (" + html_title + ")");
                    }
                    w.write(SurfacingConstants.NL);
                    w.write("<body>");
                    w.write(SurfacingConstants.NL);
                    w.write(html_desc.toString());
                    w.write(SurfacingConstants.NL);
                    w.write("<hr>");
                    w.write(SurfacingConstants.NL);
                    w.write("<br>");
                    w.write(SurfacingConstants.NL);
                    w.write("<table>");
                    w.write(SurfacingConstants.NL);
                    w.write("<tr><td><b>Domains:</b></td></tr>");
                    w.write(SurfacingConstants.NL);
                }
                break;
            }
        }
        for (DomainSimilarity similarity : similarities) {
            if (species_order != null && !species_order.isEmpty()) {
                similarity.setSpeciesOrder(species_order);
            }
            if (single_writer != null) {
                if (!ForesterUtil.isEmpty(pos_filter_doms) && pos_filter_doms.contains(similarity.getDomainId())) {
                    single_writer.write("<tr><td><b><a href=\"#" + similarity.getDomainId() + "\"><span style=\"color:#00ff00\">" + similarity.getDomainId() + "</span></a></b></td></tr>");
                } else {
                    single_writer.write("<tr><td><b><a href=\"#" + similarity.getDomainId() + "\">" + similarity.getDomainId() + "</a></b></td></tr>");
                }
                single_writer.write(SurfacingConstants.NL);
                continue;
            }
            local_writer = split_writers.get(Character.valueOf((similarity.getDomainId().charAt(0) + "").toLowerCase().charAt(0)));
            if (local_writer == null) {
                local_writer = split_writers.get(Character.valueOf('0'));
            }
            if (!ForesterUtil.isEmpty(pos_filter_doms) && pos_filter_doms.contains(similarity.getDomainId())) {
                local_writer.write("<tr><td><b><a href=\"#" + similarity.getDomainId() + "\"><span style=\"color:#00ff00\">" + similarity.getDomainId() + "</span></a></b></td></tr>");
            } else {
                local_writer.write("<tr><td><b><a href=\"#" + similarity.getDomainId() + "\">" + similarity.getDomainId() + "</a></b></td></tr>");
            }
            local_writer.write(SurfacingConstants.NL);
        }
        for (Writer w : split_writers.values()) {
            w.write("</table>");
            w.write(SurfacingConstants.NL);
            w.write("<hr>");
            w.write(SurfacingConstants.NL);
            w.write("<table>");
            w.write(SurfacingConstants.NL);
            w.write("<tr><td><b>");
            w.write("Species group colors:");
            w.write("</b></td></tr>");
            w.write(SurfacingConstants.NL);
            SurfacingUtil.writeColorLabels("Deuterostomia", TaxonomyColors.DEUTEROSTOMIA_COLOR, w);
            SurfacingUtil.writeColorLabels("Protostomia", TaxonomyColors.PROTOSTOMIA_COLOR, w);
            SurfacingUtil.writeColorLabels("Cnidaria", TaxonomyColors.CNIDARIA_COLOR, w);
            SurfacingUtil.writeColorLabels("Placozoa", TaxonomyColors.PLACOZOA_COLOR, w);
            SurfacingUtil.writeColorLabels("Ctenophora (comb jellies)", TaxonomyColors.CTENOPHORA_COLOR, w);
            SurfacingUtil.writeColorLabels("Porifera (sponges)", TaxonomyColors.PORIFERA_COLOR, w);
            SurfacingUtil.writeColorLabels("Choanoflagellida", TaxonomyColors.CHOANOFLAGELLIDA, w);
            SurfacingUtil.writeColorLabels("Ichthyosporea & Filasterea", TaxonomyColors.ICHTHYOSPOREA_AND_FILASTEREA, w);
            SurfacingUtil.writeColorLabels("Dikarya (Ascomycota & Basidiomycota, so-called \"higher fungi\")", TaxonomyColors.DIKARYA_COLOR, w);
            SurfacingUtil.writeColorLabels("other Fungi", TaxonomyColors.OTHER_FUNGI_COLOR, w);
            SurfacingUtil.writeColorLabels("Nucleariidae and Fonticula group", TaxonomyColors.NUCLEARIIDAE_AND_FONTICULA_GROUP_COLOR, w);
            SurfacingUtil.writeColorLabels("Amoebozoa", TaxonomyColors.AMOEBOZOA_COLOR, w);
            SurfacingUtil.writeColorLabels("Embryophyta (plants)", TaxonomyColors.EMBRYOPHYTA_COLOR, w);
            SurfacingUtil.writeColorLabels("Chlorophyta (green algae)", TaxonomyColors.CHLOROPHYTA_COLOR, w);
            SurfacingUtil.writeColorLabels("Rhodophyta (red algae)", TaxonomyColors.RHODOPHYTA_COLOR, w);
            SurfacingUtil.writeColorLabels("Glaucocystophyce (Glaucophyta)", TaxonomyColors.GLAUCOPHYTA_COLOR, w);
            SurfacingUtil.writeColorLabels("Hacrobia (Cryptophyta & Haptophyceae & Centroheliozoa)", TaxonomyColors.HACROBIA_COLOR, w);
            SurfacingUtil.writeColorLabels("Stramenopiles (Chromophyta, heterokonts)", TaxonomyColors.STRAMENOPILES_COLOR, w);
            SurfacingUtil.writeColorLabels("Alveolata", TaxonomyColors.ALVEOLATA_COLOR, w);
            SurfacingUtil.writeColorLabels("Rhizaria", TaxonomyColors.RHIZARIA_COLOR, w);
            SurfacingUtil.writeColorLabels("Excavata", TaxonomyColors.EXCAVATA_COLOR, w);
            SurfacingUtil.writeColorLabels("Apusozoa", TaxonomyColors.APUSOZOA_COLOR, w);
            SurfacingUtil.writeColorLabels("Archaea", TaxonomyColors.ARCHAEA_COLOR, w);
            SurfacingUtil.writeColorLabels("Bacteria", TaxonomyColors.BACTERIA_COLOR, w);
            w.write("</table>");
            w.write(SurfacingConstants.NL);
            w.write("<hr>");
            w.write(SurfacingConstants.NL);
            w.write("<table>");
            w.write(SurfacingConstants.NL);
        }
        for (DomainSimilarity similarity : similarities) {
            if (species_order != null && !species_order.isEmpty()) {
                similarity.setSpeciesOrder(species_order);
            }
            if (simple_tab_writer != null) {
                simple_tab_writer.write(similarity.toStringBuffer(DomainSimilarity.PRINT_OPTION.SIMPLE_TAB_DELIMITED, tax_code_to_id_map, null).toString());
            }
            if (single_writer != null) {
                single_writer.write(similarity.toStringBuffer(print_option, tax_code_to_id_map, phy).toString());
                single_writer.write(SurfacingConstants.NL);
                continue;
            }
            local_writer = split_writers.get(Character.valueOf((similarity.getDomainId().charAt(0) + "").toLowerCase().charAt(0)));
            if (local_writer == null) {
                local_writer = split_writers.get(Character.valueOf('0'));
            }
            local_writer.write(similarity.toStringBuffer(print_option, tax_code_to_id_map, phy).toString());
            local_writer.write(SurfacingConstants.NL);
        }
        switch (print_option) {
            case HTML: {
                for (Writer w : split_writers.values()) {
                    w.write(SurfacingConstants.NL);
                    w.write("</table>");
                    w.write(SurfacingConstants.NL);
                    w.write("</font>");
                    w.write(SurfacingConstants.NL);
                    w.write("</body>");
                    w.write(SurfacingConstants.NL);
                    w.write("</html>");
                    w.write(SurfacingConstants.NL);
                }
                break;
            }
        }
        for (Writer w : split_writers.values()) {
            w.close();
        }
    }

    public static void writeHtmlHead(Writer w, String title) throws IOException {
        w.write(SurfacingConstants.NL);
        w.write("<head>");
        w.write("<title>");
        w.write(title);
        w.write("</title>");
        w.write(SurfacingConstants.NL);
        w.write("<style>");
        w.write(SurfacingConstants.NL);
        w.write("a:visited { color : #000066; text-decoration : none; }");
        w.write(SurfacingConstants.NL);
        w.write("a:link { color : #000066; text-decoration : none; }");
        w.write(SurfacingConstants.NL);
        w.write("a:active { color : ##000066; text-decoration : none; }");
        w.write(SurfacingConstants.NL);
        w.write("a:hover { color : #FFFFFF; background-color : #000000; text-decoration : none; }");
        w.write(SurfacingConstants.NL);
        w.write("a.pl:visited { color : #505050; text-decoration : none; font-size: 7px;}");
        w.write(SurfacingConstants.NL);
        w.write("a.pl:link { color : #505050; text-decoration : none; font-size: 7px;}");
        w.write(SurfacingConstants.NL);
        w.write("a.pl:active { color : #505050; text-decoration : none; font-size: 7px;}");
        w.write(SurfacingConstants.NL);
        w.write("a.pl:hover { color : #FFFFFF; background-color : #000000; text-decoration : none; font-size: 7px;}");
        w.write(SurfacingConstants.NL);
        w.write("a.ps:visited { color : #707070; text-decoration : none; font-size: 7px;}");
        w.write(SurfacingConstants.NL);
        w.write("a.ps:link { color : #707070; text-decoration : none; font-size: 7px;}");
        w.write(SurfacingConstants.NL);
        w.write("a.ps:active { color : #707070; text-decoration : none; font-size: 7px;}");
        w.write(SurfacingConstants.NL);
        w.write("a.ps:hover { color : #FFFFFF; background-color : #000000; text-decoration : none; font-size: 7px;}");
        w.write(SurfacingConstants.NL);
        w.write("td { text-align: left; vertical-align: top; font-family: Verdana, Arial, Helvetica; font-size: 8pt}");
        w.write(SurfacingConstants.NL);
        w.write("h1 { color : #0000FF; font-family: Verdana, Arial, Helvetica; font-size: 18pt; font-weight: bold }");
        w.write(SurfacingConstants.NL);
        w.write("h2 { color : #0000FF; font-family: Verdana, Arial, Helvetica; font-size: 16pt; font-weight: bold }");
        w.write(SurfacingConstants.NL);
        w.write("</style>");
        w.write(SurfacingConstants.NL);
        w.write("</head>");
        w.write(SurfacingConstants.NL);
    }

    public static void writeMatrixToFile(CharacterStateMatrix<?> matrix, String filename, CharacterStateMatrix.Format format) {
        File outfile = new File(filename);
        SurfacingUtil.checkForOutputFileWriteability(outfile);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
            matrix.toWriter(out, format);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote matrix: \"" + filename + "\"");
    }

    public static void writeMatrixToFile(File matrix_outfile, List<DistanceMatrix> matrices) {
        SurfacingUtil.checkForOutputFileWriteability(matrix_outfile);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(matrix_outfile));
            for (DistanceMatrix distance_matrix : matrices) {
                out.write(distance_matrix.toStringBuffer(DistanceMatrix.Format.PHYLIP).toString());
                out.write(ForesterUtil.LINE_SEPARATOR);
                out.flush();
            }
            out.close();
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote distance matrices to \"" + matrix_outfile + "\"");
    }

    public static void writePhylogenyToFile(Phylogeny phylogeny, String filename) {
        PhylogenyWriter writer = new PhylogenyWriter();
        try {
            writer.toPhyloXML(new File(filename), phylogeny, 1);
        }
        catch (IOException e) {
            ForesterUtil.printWarningMessage("surfacing", "failed to write phylogeny to \"" + filename + "\": " + e);
        }
        ForesterUtil.programMessage("surfacing", "Wrote phylogeny to \"" + filename + "\"");
    }

    public static void writePresentToNexus(File output_file, File positive_filter_file, SortedSet<String> filter, List<GenomeWideCombinableDomains> gwcd_list) {
        try {
            SurfacingUtil.writeMatrixToFile(DomainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence(gwcd_list, positive_filter_file == null ? null : filter), output_file + "_dom.nex", CharacterStateMatrix.Format.NEXUS_BINARY);
            SurfacingUtil.writeMatrixToFile(DomainParsimonyCalculator.createMatrixOfBinaryDomainCombinationPresenceOrAbsence(gwcd_list), output_file + "_dc.nex", CharacterStateMatrix.Format.NEXUS_BINARY);
        }
        catch (Exception e) {
            ForesterUtil.fatalError("surfacing", e.getLocalizedMessage());
        }
    }

    public static void writeProteinListsForAllSpecies(File output_dir, SortedMap<Species, List<Protein>> protein_lists_per_species, List<GenomeWideCombinableDomains> gwcd_list, double domain_e_cutoff, Set<String> pos_filter_doms) {
        TreeSet<String> all_domains = new TreeSet<String>();
        for (GenomeWideCombinableDomains gwcd : gwcd_list) {
            all_domains.addAll(gwcd.getAllDomainIds());
        }
        for (String domain : all_domains) {
            if (!ForesterUtil.isEmpty(pos_filter_doms) && !pos_filter_doms.contains(domain)) continue;
            File out = new File(output_dir + ForesterUtil.FILE_SEPARATOR + domain + ".prot");
            SurfacingUtil.checkForOutputFileWriteability(out);
            try {
                BufferedWriter proteins_file_writer = new BufferedWriter(new FileWriter(out));
                SurfacingUtil.extractProteinNames(protein_lists_per_species, domain, proteins_file_writer, "\t", surfacing.LIMIT_SPEC_FOR_PROT_EX, domain_e_cutoff);
                ((Writer)proteins_file_writer).close();
            }
            catch (IOException e) {
                ForesterUtil.fatalError("surfacing", e.getLocalizedMessage());
            }
            ForesterUtil.programMessage("surfacing", "Wrote proteins list to \"" + out + "\"");
        }
    }

    public static void writeTaxonomyLinks(Writer writer, String species, Map<String, Integer> tax_code_to_id_map) throws IOException {
        if (species.length() > 1 && species.indexOf(95) < 1) {
            writer.write(" [");
            if (tax_code_to_id_map != null && tax_code_to_id_map.containsKey(species)) {
                writer.write("<a href=\"http://www.uniprot.org/taxonomy/" + tax_code_to_id_map.get(species) + "\" target=\"taxonomy_window\">uniprot</a>");
            } else {
                writer.write("<a href=\"http://www.eol.org/search?q=" + species + "\" target=\"taxonomy_window\">eol</a>");
                writer.write("|");
                writer.write("<a href=\"http://scholar.google.com/scholar?q=" + species + "\" target=\"taxonomy_window\">scholar</a>");
                writer.write("|");
                writer.write("<a href=\"http://www.google.com/search?q=" + species + "\" target=\"taxonomy_window\">google</a>");
            }
            writer.write("]");
        }
    }

    private static final void addToCountMap(Map<String, Integer> map, String s) {
        if (map.containsKey(s)) {
            map.put(s, map.get(s) + 1);
        } else {
            map.put(s, 1);
        }
    }

    private static void calculateIndependentDomainCombinationGains(Phylogeny local_phylogeny_l, String outfilename_for_counts, String outfilename_for_dc, String outfilename_for_dc_for_go_mapping, String outfilename_for_dc_for_go_mapping_unique, String outfilename_for_rank_counts, String outfilename_for_ancestor_species_counts, String outfilename_for_protein_stats, Map<String, DescriptiveStatistics> protein_length_stats_by_dc, Map<String, DescriptiveStatistics> domain_number_stats_by_dc, Map<String, DescriptiveStatistics> domain_length_stats_by_domain) {
        try {
            BufferedWriter out_counts = new BufferedWriter(new FileWriter(outfilename_for_counts));
            BufferedWriter out_dc = new BufferedWriter(new FileWriter(outfilename_for_dc));
            BufferedWriter out_dc_for_go_mapping = new BufferedWriter(new FileWriter(outfilename_for_dc_for_go_mapping));
            BufferedWriter out_dc_for_go_mapping_unique = new BufferedWriter(new FileWriter(outfilename_for_dc_for_go_mapping_unique));
            TreeMap<String, Integer> dc_gain_counts = new TreeMap<String, Integer>();
            PhylogenyNodeIterator it = local_phylogeny_l.iteratorPostorder();
            while (it.hasNext()) {
                PhylogenyNode n = it.next();
                SortedSet<String> gained_dc = n.getNodeData().getBinaryCharacters().getGainedCharacters();
                for (String dc : gained_dc) {
                    if (dc_gain_counts.containsKey(dc)) {
                        dc_gain_counts.put(dc, (Integer)dc_gain_counts.get(dc) + 1);
                        continue;
                    }
                    dc_gain_counts.put(dc, 1);
                }
            }
            TreeMap<Integer, Integer> histogram = new TreeMap<Integer, Integer>();
            TreeMap<Integer, StringBuilder> domain_lists = new TreeMap<Integer, StringBuilder>();
            TreeMap<Integer, BasicDescriptiveStatistics> dc_reapp_counts_to_protein_length_stats = new TreeMap<Integer, BasicDescriptiveStatistics>();
            TreeMap<Integer, BasicDescriptiveStatistics> dc_reapp_counts_to_domain_number_stats = new TreeMap<Integer, BasicDescriptiveStatistics>();
            TreeMap<Integer, BasicDescriptiveStatistics> dc_reapp_counts_to_domain_lengths_stats = new TreeMap<Integer, BasicDescriptiveStatistics>();
            TreeMap domain_lists_go = new TreeMap();
            TreeMap domain_lists_go_unique = new TreeMap();
            Set dcs = dc_gain_counts.keySet();
            TreeSet<Object> more_than_once = new TreeSet<Object>();
            BasicDescriptiveStatistics gained_once_lengths_stats = new BasicDescriptiveStatistics();
            BasicDescriptiveStatistics gained_once_domain_count_stats = new BasicDescriptiveStatistics();
            BasicDescriptiveStatistics gained_multiple_times_lengths_stats = new BasicDescriptiveStatistics();
            BasicDescriptiveStatistics gained_multiple_times_domain_count_stats = new BasicDescriptiveStatistics();
            long gained_multiple_times_domain_length_sum = 0L;
            long gained_once_domain_length_sum = 0L;
            long gained_multiple_times_domain_length_count = 0L;
            long gained_once_domain_length_count = 0L;
            for (Object dc : dcs) {
                double element;
                Object object;
                DescriptiveStatistics s;
                String[] ds;
                int count = (Integer)dc_gain_counts.get(dc);
                if (histogram.containsKey(count)) {
                    histogram.put(count, (Integer)histogram.get(count) + 1);
                    ((StringBuilder)domain_lists.get(count)).append(", " + (String)dc);
                    ((PriorityQueue)domain_lists_go.get(count)).addAll(SurfacingUtil.splitDomainCombination((String)dc));
                    ((SortedSet)domain_lists_go_unique.get(count)).addAll(SurfacingUtil.splitDomainCombination((String)dc));
                } else {
                    histogram.put(count, 1);
                    domain_lists.put(count, new StringBuilder((String)dc));
                    PriorityQueue<String> q = new PriorityQueue<String>();
                    q.addAll(SurfacingUtil.splitDomainCombination((String)dc));
                    domain_lists_go.put(count, q);
                    TreeSet<String> treeSet = new TreeSet<String>();
                    treeSet.addAll(SurfacingUtil.splitDomainCombination((String)dc));
                    domain_lists_go_unique.put(count, treeSet);
                }
                if (protein_length_stats_by_dc != null) {
                    if (!dc_reapp_counts_to_protein_length_stats.containsKey(count)) {
                        dc_reapp_counts_to_protein_length_stats.put(count, new BasicDescriptiveStatistics());
                    }
                    ((DescriptiveStatistics)dc_reapp_counts_to_protein_length_stats.get(count)).addValue(protein_length_stats_by_dc.get(dc).arithmeticMean());
                }
                if (domain_number_stats_by_dc != null) {
                    if (!dc_reapp_counts_to_domain_number_stats.containsKey(count)) {
                        dc_reapp_counts_to_domain_number_stats.put(count, new BasicDescriptiveStatistics());
                    }
                    ((DescriptiveStatistics)dc_reapp_counts_to_domain_number_stats.get(count)).addValue(domain_number_stats_by_dc.get(dc).arithmeticMean());
                }
                if (domain_length_stats_by_domain != null) {
                    if (!dc_reapp_counts_to_domain_lengths_stats.containsKey(count)) {
                        dc_reapp_counts_to_domain_lengths_stats.put(count, new BasicDescriptiveStatistics());
                    }
                    ds = ((String)dc).split("=");
                    ((DescriptiveStatistics)dc_reapp_counts_to_domain_lengths_stats.get(count)).addValue(domain_length_stats_by_domain.get(ds[0]).arithmeticMean());
                    ((DescriptiveStatistics)dc_reapp_counts_to_domain_lengths_stats.get(count)).addValue(domain_length_stats_by_domain.get(ds[1]).arithmeticMean());
                }
                if (count > 1) {
                    more_than_once.add(dc);
                    if (protein_length_stats_by_dc != null) {
                        s = protein_length_stats_by_dc.get(dc);
                        for (double element2 : s.getData()) {
                            gained_multiple_times_lengths_stats.addValue(element2);
                        }
                    }
                    if (domain_number_stats_by_dc != null) {
                        s = domain_number_stats_by_dc.get(dc);
                        for (double element2 : s.getData()) {
                            gained_multiple_times_domain_count_stats.addValue(element2);
                        }
                    }
                    if (domain_length_stats_by_domain == null) continue;
                    ds = ((String)dc).split("=");
                    DescriptiveStatistics descriptiveStatistics = domain_length_stats_by_domain.get(ds[0]);
                    DescriptiveStatistics s1 = domain_length_stats_by_domain.get(ds[1]);
                    object = descriptiveStatistics.getData().iterator();
                    while (object.hasNext()) {
                        element = (Double)object.next();
                        gained_multiple_times_domain_length_sum = (long)((double)gained_multiple_times_domain_length_sum + element);
                        ++gained_multiple_times_domain_length_count;
                    }
                    object = s1.getData().iterator();
                    while (object.hasNext()) {
                        element = (Double)object.next();
                        gained_multiple_times_domain_length_sum = (long)((double)gained_multiple_times_domain_length_sum + element);
                        ++gained_multiple_times_domain_length_count;
                    }
                    continue;
                }
                if (protein_length_stats_by_dc != null) {
                    s = protein_length_stats_by_dc.get(dc);
                    for (double element3 : s.getData()) {
                        gained_once_lengths_stats.addValue(element3);
                    }
                }
                if (domain_number_stats_by_dc != null) {
                    s = domain_number_stats_by_dc.get(dc);
                    for (double element4 : s.getData()) {
                        gained_once_domain_count_stats.addValue(element4);
                    }
                }
                if (domain_length_stats_by_domain == null) continue;
                ds = ((String)dc).split("=");
                DescriptiveStatistics descriptiveStatistics = domain_length_stats_by_domain.get(ds[0]);
                DescriptiveStatistics s1 = domain_length_stats_by_domain.get(ds[1]);
                object = descriptiveStatistics.getData().iterator();
                while (object.hasNext()) {
                    element = (Double)object.next();
                    gained_once_domain_length_sum = (long)((double)gained_once_domain_length_sum + element);
                    ++gained_once_domain_length_count;
                }
                object = s1.getData().iterator();
                while (object.hasNext()) {
                    element = (Double)object.next();
                    gained_once_domain_length_sum = (long)((double)gained_once_domain_length_sum + element);
                    ++gained_once_domain_length_count;
                }
            }
            Set histogram_keys = histogram.keySet();
            for (Integer histogram_key : histogram_keys) {
                int count = (Integer)histogram.get(histogram_key);
                StringBuilder stringBuilder = (StringBuilder)domain_lists.get(histogram_key);
                out_counts.write(histogram_key + "\t" + count + ForesterUtil.LINE_SEPARATOR);
                out_dc.write(histogram_key + "\t" + stringBuilder + ForesterUtil.LINE_SEPARATOR);
                out_dc_for_go_mapping.write("#" + histogram_key + ForesterUtil.LINE_SEPARATOR);
                Object[] sorted = ((PriorityQueue)domain_lists_go.get(histogram_key)).toArray();
                Arrays.sort(sorted);
                for (Object domain : sorted) {
                    out_dc_for_go_mapping.write(domain + ForesterUtil.LINE_SEPARATOR);
                }
                out_dc_for_go_mapping_unique.write("#" + histogram_key + ForesterUtil.LINE_SEPARATOR);
                for (String domain : (SortedSet)domain_lists_go_unique.get(histogram_key)) {
                    out_dc_for_go_mapping_unique.write(domain + ForesterUtil.LINE_SEPARATOR);
                }
            }
            out_counts.close();
            out_dc.close();
            out_dc_for_go_mapping.close();
            out_dc_for_go_mapping_unique.close();
            TreeMap<String, Integer> lca_rank_counts = new TreeMap<String, Integer>();
            TreeMap<String, Integer> lca_ancestor_species_counts = new TreeMap<String, Integer>();
            for (String string : more_than_once) {
                ArrayList<PhylogenyNode> nodes = new ArrayList<PhylogenyNode>();
                PhylogenyNodeIterator it2 = local_phylogeny_l.iteratorExternalForward();
                while (it2.hasNext()) {
                    PhylogenyNode n = it2.next();
                    if (!n.getNodeData().getBinaryCharacters().getGainedCharacters().contains(string)) continue;
                    nodes.add(n);
                }
                for (int i = 0; i < nodes.size() - 1; ++i) {
                    for (int j = i + 1; j < nodes.size(); ++j) {
                        PhylogenyNode lca = PhylogenyMethods.calculateLCA((PhylogenyNode)nodes.get(i), (PhylogenyNode)nodes.get(j));
                        String rank = "unknown";
                        if (lca.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(lca.getNodeData().getTaxonomy().getRank())) {
                            rank = lca.getNodeData().getTaxonomy().getRank();
                        }
                        SurfacingUtil.addToCountMap(lca_rank_counts, rank);
                        String lca_species = lca.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(lca.getNodeData().getTaxonomy().getScientificName()) ? lca.getNodeData().getTaxonomy().getScientificName() : (lca.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(lca.getNodeData().getTaxonomy().getCommonName()) ? lca.getNodeData().getTaxonomy().getCommonName() : lca.getName());
                        SurfacingUtil.addToCountMap(lca_ancestor_species_counts, lca_species);
                    }
                }
            }
            BufferedWriter out_for_rank_counts = new BufferedWriter(new FileWriter(outfilename_for_rank_counts));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(outfilename_for_ancestor_species_counts));
            ForesterUtil.map2writer(out_for_rank_counts, lca_rank_counts, "\t", ForesterUtil.LINE_SEPARATOR);
            ForesterUtil.map2writer(bufferedWriter, lca_ancestor_species_counts, "\t", ForesterUtil.LINE_SEPARATOR);
            out_for_rank_counts.close();
            bufferedWriter.close();
            if (!(ForesterUtil.isEmpty(outfilename_for_protein_stats) || domain_length_stats_by_domain == null && protein_length_stats_by_dc == null && domain_number_stats_by_dc == null)) {
                BufferedWriter w = new BufferedWriter(new FileWriter(outfilename_for_protein_stats));
                w.write("Domain Lengths: ");
                w.write("\n");
                if (domain_length_stats_by_domain != null) {
                    for (Map.Entry entry : dc_reapp_counts_to_domain_lengths_stats.entrySet()) {
                        w.write(((Integer)entry.getKey()).toString());
                        w.write("\t" + ((DescriptiveStatistics)entry.getValue()).arithmeticMean());
                        w.write("\t" + ((DescriptiveStatistics)entry.getValue()).median());
                        w.write("\n");
                    }
                }
                w.flush();
                w.write("\n");
                w.write("\n");
                w.write("Protein Lengths: ");
                w.write("\n");
                if (protein_length_stats_by_dc != null) {
                    for (Map.Entry entry : dc_reapp_counts_to_protein_length_stats.entrySet()) {
                        w.write(((Integer)entry.getKey()).toString());
                        w.write("\t" + ((DescriptiveStatistics)entry.getValue()).arithmeticMean());
                        w.write("\t" + ((DescriptiveStatistics)entry.getValue()).median());
                        w.write("\n");
                    }
                }
                w.flush();
                w.write("\n");
                w.write("\n");
                w.write("Number of domains: ");
                w.write("\n");
                if (domain_number_stats_by_dc != null) {
                    for (Map.Entry entry : dc_reapp_counts_to_domain_number_stats.entrySet()) {
                        w.write(((Integer)entry.getKey()).toString());
                        w.write("\t" + ((DescriptiveStatistics)entry.getValue()).arithmeticMean());
                        w.write("\t" + ((DescriptiveStatistics)entry.getValue()).median());
                        w.write("\n");
                    }
                }
                w.flush();
                w.write("\n");
                w.write("\n");
                w.write("Gained once, domain lengths:");
                w.write("\n");
                w.write("N: " + gained_once_domain_length_count);
                w.write("\n");
                w.write("Avg: " + (double)gained_once_domain_length_sum / (double)gained_once_domain_length_count);
                w.write("\n");
                w.write("\n");
                w.write("Gained multiple times, domain lengths:");
                w.write("\n");
                w.write("N: " + gained_multiple_times_domain_length_count);
                w.write("\n");
                w.write("Avg: " + (double)gained_multiple_times_domain_length_sum / (double)gained_multiple_times_domain_length_count);
                w.write("\n");
                w.write("\n");
                w.write("\n");
                w.write("\n");
                w.write("Gained once, protein lengths:");
                w.write("\n");
                w.write(gained_once_lengths_stats.toString());
                gained_once_lengths_stats = null;
                w.write("\n");
                w.write("\n");
                w.write("Gained once, domain counts:");
                w.write("\n");
                w.write(gained_once_domain_count_stats.toString());
                gained_once_domain_count_stats = null;
                w.write("\n");
                w.write("\n");
                w.write("Gained multiple times, protein lengths:");
                w.write("\n");
                w.write(gained_multiple_times_lengths_stats.toString());
                gained_multiple_times_lengths_stats = null;
                w.write("\n");
                w.write("\n");
                w.write("Gained multiple times, domain counts:");
                w.write("\n");
                w.write(gained_multiple_times_domain_count_stats.toString());
                w.flush();
                w.close();
            }
        }
        catch (IOException e) {
            ForesterUtil.printWarningMessage("surfacing", "Failure to write: " + e);
        }
        ForesterUtil.programMessage("surfacing", "Wrote independent domain combination gains fitch counts to [" + outfilename_for_counts + "]");
        ForesterUtil.programMessage("surfacing", "Wrote independent domain combination gains fitch lists to [" + outfilename_for_dc + "]");
        ForesterUtil.programMessage("surfacing", "Wrote independent domain combination gains fitch lists to (for GO mapping) [" + outfilename_for_dc_for_go_mapping + "]");
        ForesterUtil.programMessage("surfacing", "Wrote independent domain combination gains fitch lists to (for GO mapping, unique) [" + outfilename_for_dc_for_go_mapping_unique + "]");
    }

    private static SortedSet<String> collectAllDomainsChangedOnSubtree(PhylogenyNode subtree_root, boolean get_gains) {
        TreeSet<String> domains = new TreeSet<String>();
        for (PhylogenyNode descendant : PhylogenyMethods.getAllDescendants(subtree_root)) {
            BinaryCharacters chars = descendant.getNodeData().getBinaryCharacters();
            if (get_gains) {
                domains.addAll(chars.getGainedCharacters());
                continue;
            }
            domains.addAll(chars.getLostCharacters());
        }
        return domains;
    }

    private static File createBaseDirForPerNodeDomainFiles(String base_dir, boolean domain_combinations, CharacterStateMatrix.GainLossStates state, String outfile) {
        File per_node_go_mapped_domain_gain_loss_files_base_dir = new File(new File(outfile).getParent() + ForesterUtil.FILE_SEPARATOR + base_dir);
        if (!per_node_go_mapped_domain_gain_loss_files_base_dir.exists()) {
            per_node_go_mapped_domain_gain_loss_files_base_dir.mkdir();
        }
        if (!(per_node_go_mapped_domain_gain_loss_files_base_dir = domain_combinations ? new File(per_node_go_mapped_domain_gain_loss_files_base_dir + ForesterUtil.FILE_SEPARATOR + "DC") : new File(per_node_go_mapped_domain_gain_loss_files_base_dir + ForesterUtil.FILE_SEPARATOR + "DOMAINS")).exists()) {
            per_node_go_mapped_domain_gain_loss_files_base_dir.mkdir();
        }
        if (!(per_node_go_mapped_domain_gain_loss_files_base_dir = state == CharacterStateMatrix.GainLossStates.GAIN ? new File(per_node_go_mapped_domain_gain_loss_files_base_dir + ForesterUtil.FILE_SEPARATOR + "GAINS") : (state == CharacterStateMatrix.GainLossStates.LOSS ? new File(per_node_go_mapped_domain_gain_loss_files_base_dir + ForesterUtil.FILE_SEPARATOR + "LOSSES") : new File(per_node_go_mapped_domain_gain_loss_files_base_dir + ForesterUtil.FILE_SEPARATOR + "PRESENT"))).exists()) {
            per_node_go_mapped_domain_gain_loss_files_base_dir.mkdir();
        }
        return per_node_go_mapped_domain_gain_loss_files_base_dir;
    }

    private static SortedSet<BinaryDomainCombination> createSetOfAllBinaryDomainCombinationsPerGenome(GenomeWideCombinableDomains gwcd) {
        SortedMap<String, CombinableDomains> cds = gwcd.getAllCombinableDomainsIds();
        TreeSet<BinaryDomainCombination> binary_combinations = new TreeSet<BinaryDomainCombination>();
        for (String domain_id : cds.keySet()) {
            CombinableDomains cd = (CombinableDomains)cds.get(domain_id);
            binary_combinations.addAll(cd.toBinaryDomainCombinations());
        }
        return binary_combinations;
    }

    private static void printSomeStats(DescriptiveStatistics stats, AsciiHistogram histo, Writer w) throws IOException {
        w.write("<hr>");
        w.write("<br>");
        w.write(SurfacingConstants.NL);
        w.write("<tt><pre>");
        w.write(SurfacingConstants.NL);
        if (histo != null) {
            w.write(histo.toStringBuffer(20, '|', 40, 5).toString());
            w.write(SurfacingConstants.NL);
        }
        w.write("</pre></tt>");
        w.write(SurfacingConstants.NL);
        w.write("<table>");
        w.write(SurfacingConstants.NL);
        w.write("<tr><td>N: </td><td>" + stats.getN() + "</td></tr>");
        w.write(SurfacingConstants.NL);
        w.write("<tr><td>Min: </td><td>" + stats.getMin() + "</td></tr>");
        w.write(SurfacingConstants.NL);
        w.write("<tr><td>Max: </td><td>" + stats.getMax() + "</td></tr>");
        w.write(SurfacingConstants.NL);
        w.write("<tr><td>Mean: </td><td>" + stats.arithmeticMean() + "</td></tr>");
        w.write(SurfacingConstants.NL);
        if (stats.getN() > 1) {
            w.write("<tr><td>SD: </td><td>" + stats.sampleStandardDeviation() + "</td></tr>");
        } else {
            w.write("<tr><td>SD: </td><td>n/a</td></tr>");
        }
        w.write(SurfacingConstants.NL);
        w.write("</table>");
        w.write(SurfacingConstants.NL);
        w.write("<br>");
        w.write(SurfacingConstants.NL);
    }

    private static List<String> splitDomainCombination(String dc) {
        String[] s = dc.split("=");
        if (s.length != 2) {
            ForesterUtil.printErrorMessage("surfacing", "Stringyfied domain combination has illegal format: " + dc);
            System.exit(-1);
        }
        ArrayList<String> l = new ArrayList<String>(2);
        l.add(s[0]);
        l.add(s[1]);
        return l;
    }

    private static void writeAllEncounteredPfamsToFile(Map<String, List<GoId>> domain_id_to_go_ids_map, Map<GoId, GoTerm> go_id_to_term_map, String outfile_name, SortedSet<String> all_pfams_encountered) {
        File all_pfams_encountered_file = new File(outfile_name + "_all_encountered_pfams");
        File all_pfams_encountered_with_go_annotation_file = new File(outfile_name + "_all_encountered_pfams_with_go_annotation");
        File encountered_pfams_summary_file = new File(outfile_name + "_encountered_pfams_summary");
        int biological_process_counter = 0;
        int cellular_component_counter = 0;
        int molecular_function_counter = 0;
        int pfams_with_mappings_counter = 0;
        int pfams_without_mappings_counter = 0;
        int pfams_without_mappings_to_bp_or_mf_counter = 0;
        int pfams_with_mappings_to_bp_or_mf_counter = 0;
        try {
            BufferedWriter all_pfams_encountered_writer = new BufferedWriter(new FileWriter(all_pfams_encountered_file));
            BufferedWriter all_pfams_encountered_with_go_annotation_writer = new BufferedWriter(new FileWriter(all_pfams_encountered_with_go_annotation_file));
            BufferedWriter summary_writer = new BufferedWriter(new FileWriter(encountered_pfams_summary_file));
            summary_writer.write("# Pfam to GO mapping summary");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Actual summary is at the end of this file.");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Encountered Pfams without a GO mapping:");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            for (String pfam : all_pfams_encountered) {
                all_pfams_encountered_writer.write(pfam);
                all_pfams_encountered_writer.write(ForesterUtil.LINE_SEPARATOR);
                String domain_id = new String(pfam);
                if (domain_id_to_go_ids_map.containsKey(domain_id)) {
                    ++pfams_with_mappings_counter;
                    all_pfams_encountered_with_go_annotation_writer.write(pfam);
                    all_pfams_encountered_with_go_annotation_writer.write(ForesterUtil.LINE_SEPARATOR);
                    List<GoId> go_ids = domain_id_to_go_ids_map.get(domain_id);
                    boolean maps_to_bp = false;
                    boolean maps_to_cc = false;
                    boolean maps_to_mf = false;
                    for (GoId go_id : go_ids) {
                        GoTerm go_term = go_id_to_term_map.get(go_id);
                        if (go_term.getGoNameSpace().isBiologicalProcess()) {
                            maps_to_bp = true;
                            continue;
                        }
                        if (go_term.getGoNameSpace().isCellularComponent()) {
                            maps_to_cc = true;
                            continue;
                        }
                        if (!go_term.getGoNameSpace().isMolecularFunction()) continue;
                        maps_to_mf = true;
                    }
                    if (maps_to_bp) {
                        ++biological_process_counter;
                    }
                    if (maps_to_cc) {
                        ++cellular_component_counter;
                    }
                    if (maps_to_mf) {
                        ++molecular_function_counter;
                    }
                    if (maps_to_bp || maps_to_mf) {
                        ++pfams_with_mappings_to_bp_or_mf_counter;
                        continue;
                    }
                    ++pfams_without_mappings_to_bp_or_mf_counter;
                    continue;
                }
                ++pfams_without_mappings_to_bp_or_mf_counter;
                ++pfams_without_mappings_counter;
                summary_writer.write(pfam);
                summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            }
            ((Writer)all_pfams_encountered_writer).close();
            ((Writer)all_pfams_encountered_with_go_annotation_writer).close();
            ForesterUtil.programMessage("surfacing", "Wrote all [" + all_pfams_encountered.size() + "] encountered Pfams to: \"" + all_pfams_encountered_file + "\"");
            ForesterUtil.programMessage("surfacing", "Wrote all [" + pfams_with_mappings_counter + "] encountered Pfams with GO mappings to: \"" + all_pfams_encountered_with_go_annotation_file + "\"");
            ForesterUtil.programMessage("surfacing", "Wrote summary (including all [" + pfams_without_mappings_counter + "] encountered Pfams without GO mappings) to: \"" + encountered_pfams_summary_file + "\"");
            ForesterUtil.programMessage("surfacing", "Sum of Pfams encountered                : " + all_pfams_encountered.size());
            ForesterUtil.programMessage("surfacing", "Pfams without a mapping                 : " + pfams_without_mappings_counter + " [" + 100 * pfams_without_mappings_counter / all_pfams_encountered.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams without mapping to proc. or func. : " + pfams_without_mappings_to_bp_or_mf_counter + " [" + 100 * pfams_without_mappings_to_bp_or_mf_counter / all_pfams_encountered.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with a mapping                    : " + pfams_with_mappings_counter + " [" + 100 * pfams_with_mappings_counter / all_pfams_encountered.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with a mapping to proc. or func.  : " + pfams_with_mappings_to_bp_or_mf_counter + " [" + 100 * pfams_with_mappings_to_bp_or_mf_counter / all_pfams_encountered.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with mapping to biological process: " + biological_process_counter + " [" + 100 * biological_process_counter / all_pfams_encountered.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with mapping to molecular function: " + molecular_function_counter + " [" + 100 * molecular_function_counter / all_pfams_encountered.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with mapping to cellular component: " + cellular_component_counter + " [" + 100 * cellular_component_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Sum of Pfams encountered                : " + all_pfams_encountered.size());
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Pfams without a mapping                 : " + pfams_without_mappings_counter + " [" + 100 * pfams_without_mappings_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Pfams without mapping to proc. or func. : " + pfams_without_mappings_to_bp_or_mf_counter + " [" + 100 * pfams_without_mappings_to_bp_or_mf_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Pfams with a mapping                    : " + pfams_with_mappings_counter + " [" + 100 * pfams_with_mappings_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Pfams with a mapping to proc. or func.  : " + pfams_with_mappings_to_bp_or_mf_counter + " [" + 100 * pfams_with_mappings_to_bp_or_mf_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Pfams with mapping to biological process: " + biological_process_counter + " [" + 100 * biological_process_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Pfams with mapping to molecular function: " + molecular_function_counter + " [" + 100 * molecular_function_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Pfams with mapping to cellular component: " + cellular_component_counter + " [" + 100 * cellular_component_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            ((Writer)summary_writer).close();
        }
        catch (IOException e) {
            ForesterUtil.printWarningMessage("surfacing", "Failure to write: " + e);
        }
    }

    private static final void writeColorLabels(String l, Color c, Writer w) throws IOException {
        w.write("<tr><td><b><span style=\"color:");
        w.write(String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue()));
        w.write("\">");
        w.write(l);
        w.write("</span></b></td></tr>");
        w.write(SurfacingConstants.NL);
    }

    private static void writeDomainData(Map<String, List<GoId>> domain_id_to_go_ids_map, Map<GoId, GoTerm> go_id_to_term_map, GoNameSpace go_namespace_limit, Writer out, String domain_0, String domain_1, String prefix_for_html, String character_separator_for_non_html_output, Map<String, Set<String>>[] domain_id_to_secondary_features_maps, Set<GoId> all_go_ids) throws IOException {
        boolean any_go_annotation_present = false;
        boolean first_has_no_go = false;
        int domain_count = 2;
        if (ForesterUtil.isEmpty(domain_1)) {
            domain_count = 1;
        }
        for (int d = 0; d < domain_count; ++d) {
            List<GoId> go_ids = null;
            boolean go_annotation_present = false;
            if (d == 0) {
                if (domain_id_to_go_ids_map.containsKey(domain_0)) {
                    go_annotation_present = true;
                    any_go_annotation_present = true;
                    go_ids = domain_id_to_go_ids_map.get(domain_0);
                } else {
                    first_has_no_go = true;
                }
            } else if (domain_id_to_go_ids_map.containsKey(domain_1)) {
                go_annotation_present = true;
                any_go_annotation_present = true;
                go_ids = domain_id_to_go_ids_map.get(domain_1);
            }
            if (!go_annotation_present) continue;
            boolean first = d == 0 || d == 1 && first_has_no_go;
            for (GoId go_id : go_ids) {
                out.write("<tr>");
                if (first) {
                    first = false;
                    SurfacingUtil.writeDomainIdsToHtml(out, domain_0, domain_1, prefix_for_html, domain_id_to_secondary_features_maps);
                } else {
                    out.write("<td></td>");
                }
                if (!go_id_to_term_map.containsKey(go_id)) {
                    throw new IllegalArgumentException("GO-id [" + go_id + "] not found in GO-id to GO-term map");
                }
                GoTerm go_term = go_id_to_term_map.get(go_id);
                if (go_namespace_limit == null || go_namespace_limit.equals(go_term.getGoNameSpace())) {
                    String go_id_str = go_id.getId();
                    out.write("<td>");
                    out.write("<a href=\"http://amigo.geneontology.org/cgi-bin/amigo/go.cgi?view=details&search_constraint=terms&query=" + go_id_str + "\" target=\"amigo_window\">" + go_id_str + "</a>");
                    out.write("</td><td>");
                    out.write(go_term.getName());
                    if (domain_count == 2) {
                        out.write(" (" + d + ")");
                    }
                    out.write("</td><td>");
                    out.write("[");
                    out.write(go_term.getGoNameSpace().toShortString());
                    out.write("]");
                    out.write("</td>");
                    if (all_go_ids != null) {
                        all_go_ids.add(go_id);
                    }
                } else {
                    out.write("<td>");
                    out.write("</td><td>");
                    out.write("</td><td>");
                    out.write("</td><td>");
                    out.write("</td>");
                }
                out.write("</tr>");
                out.write(SurfacingConstants.NL);
            }
        }
        if (!any_go_annotation_present) {
            out.write("<tr>");
            SurfacingUtil.writeDomainIdsToHtml(out, domain_0, domain_1, prefix_for_html, domain_id_to_secondary_features_maps);
            out.write("<td>");
            out.write("</td><td>");
            out.write("</td><td>");
            out.write("</td><td>");
            out.write("</td>");
            out.write("</tr>");
            out.write(SurfacingConstants.NL);
        }
    }

    private static void writeDomainIdsToHtml(Writer out, String domain_0, String domain_1, String prefix_for_detailed_html, Map<String, Set<String>>[] domain_id_to_secondary_features_maps) throws IOException {
        out.write("<td>");
        if (!ForesterUtil.isEmpty(prefix_for_detailed_html)) {
            out.write(prefix_for_detailed_html);
            out.write(" ");
        }
        out.write("<a href=\"http://pfam.xfam.org/family/" + domain_0 + "\">" + domain_0 + "</a>");
        out.write("</td>");
    }

    private static void writeDomainsToIndividualFilePerTreeNode(Writer individual_files_writer, String domain_0, String domain_1) throws IOException {
        individual_files_writer.write(domain_0);
        individual_files_writer.write(ForesterUtil.LINE_SEPARATOR);
        if (!ForesterUtil.isEmpty(domain_1)) {
            individual_files_writer.write(domain_1);
            individual_files_writer.write(ForesterUtil.LINE_SEPARATOR);
        }
    }

    private static void writePfamsToFile(String outfile_name, SortedSet<String> pfams) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outfile_name)));
            for (String pfam : pfams) {
                writer.write(pfam);
                writer.write(ForesterUtil.LINE_SEPARATOR);
            }
            ((Writer)writer).close();
            ForesterUtil.programMessage("surfacing", "Wrote " + pfams.size() + " pfams to [" + outfile_name + "]");
        }
        catch (IOException e) {
            ForesterUtil.printWarningMessage("surfacing", "Failure to write: " + e);
        }
    }

    private static void writeToNexus(String outfile_name, CharacterStateMatrix<CharacterStateMatrix.BinaryStates> matrix, Phylogeny phylogeny) {
        if (!(matrix instanceof BasicCharacterStateMatrix)) {
            throw new IllegalArgumentException("can only write matrices of type [" + BasicCharacterStateMatrix.class + "] to nexus");
        }
        BasicCharacterStateMatrix my_matrix = (BasicCharacterStateMatrix)matrix;
        ArrayList<Phylogeny> phylogenies = new ArrayList<Phylogeny>(1);
        phylogenies.add(phylogeny);
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter(outfile_name));
            w.write("#NEXUS");
            w.write(ForesterUtil.LINE_SEPARATOR);
            my_matrix.writeNexusTaxaBlock(w);
            my_matrix.writeNexusBinaryChractersBlock(w);
            PhylogenyWriter.writeNexusTreesBlock(w, phylogenies, PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.NONE);
            w.flush();
            w.close();
            ForesterUtil.programMessage("surfacing", "Wrote Nexus file: \"" + outfile_name + "\"");
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
    }

    private static void writeToNexus(String outfile_name, DomainParsimonyCalculator domain_parsimony, Phylogeny phylogeny) {
        SurfacingUtil.writeToNexus(outfile_name + "_dom.nex", domain_parsimony.createMatrixOfDomainPresenceOrAbsence(), phylogeny);
        SurfacingUtil.writeToNexus(outfile_name + "_dc.nex", domain_parsimony.createMatrixOfBinaryDomainCombinationPresenceOrAbsence(), phylogeny);
    }

    static final class DomainComparator
    implements Comparator<Domain> {
        private final boolean _ascending;

        public DomainComparator(boolean ascending) {
            this._ascending = ascending;
        }

        @Override
        public final int compare(Domain d0, Domain d1) {
            if (d0.getFrom() < d1.getFrom()) {
                return this._ascending ? -1 : 1;
            }
            if (d0.getFrom() > d1.getFrom()) {
                return this._ascending ? 1 : -1;
            }
            return 0;
        }
    }
}

