/*
 * Decompiled with CFR 0.152.
 */
package org.forester.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class TreeSplitMatrix {
    private final SortedMap<PhylogenyNode, List<Boolean>> _data;
    private final Map<Integer, Integer> _positive_counts;
    private final boolean _strict;

    public TreeSplitMatrix(Phylogeny evaluator, boolean strict, Phylogeny target) {
        HashSet<PhylogenyNode> target_external_nodes = null;
        if (!strict) {
            if (target == null || target.isEmpty()) {
                throw new IllegalArgumentException("target must not be null or empty if non-strict evalution is expected");
            }
            target_external_nodes = new HashSet<PhylogenyNode>();
            PhylogenyNodeIterator it = target.iteratorExternalForward();
            while (it.hasNext()) {
                PhylogenyNode n = it.next();
                if (target_external_nodes.contains(n)) {
                    throw new IllegalArgumentException("node [" + n.toString() + "] of target is not unique");
                }
                target_external_nodes.add(n);
            }
        }
        this._data = new TreeMap<PhylogenyNode, List<Boolean>>();
        this._positive_counts = new HashMap<Integer, Integer>();
        this._strict = strict;
        this.decompose(evaluator, target_external_nodes);
    }

    public TreeSplitMatrix(Phylogeny evaluator, boolean strict, Set<PhylogenyNode> target_external_nodes) {
        if (!strict && (target_external_nodes == null || target_external_nodes.isEmpty())) {
            throw new IllegalArgumentException("target nodes list must not be null or empty if non-strict evalution is expected");
        }
        this._data = new TreeMap<PhylogenyNode, List<Boolean>>();
        this._positive_counts = new HashMap<Integer, Integer>();
        this._strict = strict;
        this.decompose(evaluator, target_external_nodes);
    }

    private boolean contains(PhylogenyNode node) {
        return this._data.keySet().contains(node);
    }

    private void decompose(Phylogeny phy, Set<PhylogenyNode> target_external_nodes) {
        this.setUpKeys(phy, target_external_nodes);
        this.setUpValues(phy, target_external_nodes);
        this.sanityCheck();
    }

    private int getNumberOfTrueValuesAt(int index) {
        if (this._positive_counts.containsKey(index)) {
            return this._positive_counts.get(index);
        }
        return 0;
    }

    private boolean getValue(PhylogenyNode node, int index) {
        if (this._data.containsKey(node)) {
            return (Boolean)((List)this._data.get(node)).get(index);
        }
        return false;
    }

    private char getValueAsChar(PhylogenyNode node, int index) {
        if (this.getValue(node, index)) {
            return '.';
        }
        return ' ';
    }

    private Set<PhylogenyNode> keySet() {
        return this._data.keySet();
    }

    public boolean match(Set<PhylogenyNode> query_nodes) {
        Set<PhylogenyNode> my_query_nodes = query_nodes;
        if (this._strict && !this.keySet().containsAll(my_query_nodes)) {
            throw new IllegalArgumentException("external nodes of target and evaluator do not match");
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!this.match(my_query_nodes, i)) continue;
            return true;
        }
        return false;
    }

    private boolean match(Set<PhylogenyNode> query_nodes, int i) {
        int counts = this.getNumberOfTrueValuesAt(i);
        int q_counts = query_nodes.size();
        boolean positive_matches = true;
        boolean negative_matches = true;
        if (q_counts != counts) {
            positive_matches = false;
        }
        if (q_counts != this.keySet().size() - counts) {
            negative_matches = false;
        }
        if (!positive_matches && !negative_matches) {
            return false;
        }
        for (PhylogenyNode query_node : query_nodes) {
            if (!this.contains(query_node)) {
                if (this._strict) {
                    throw new RuntimeException("this should not have happened, for query " + query_node + ":\n" + this.toString());
                }
                return false;
            }
            if (this.getValue(query_node, i)) {
                negative_matches = false;
            } else {
                positive_matches = false;
            }
            if (positive_matches || negative_matches) continue;
            return false;
        }
        return true;
    }

    private void sanityCheck() {
        int size = -1;
        for (PhylogenyNode key : this.keySet()) {
            if (size < 0) {
                size = this.size(key);
                continue;
            }
            if (size == this.size(key)) continue;
            throw new RuntimeException("this should not have happened: failed to build split matrix");
        }
    }

    private void setUpKeys(Phylogeny phy, Set<PhylogenyNode> target_external_nodes) {
        PhylogenyNodeIterator it = phy.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (!this._strict && !target_external_nodes.contains(n)) continue;
            if (this._data.containsKey(n)) {
                throw new IllegalArgumentException("node '" + n.toString() + "' of evaluator is not unique");
            }
            this._data.put(n, new ArrayList());
        }
    }

    private void setUpValues(Phylogeny phy, Set<PhylogenyNode> target_external_nodes) {
        int index = 0;
        PhylogenyNodeIterator it = phy.iteratorPreorder();
        while (it.hasNext()) {
            PhylogenyNode node = it.next();
            List<PhylogenyNode> current_ext_descs = node.getAllExternalDescendants();
            for (PhylogenyNode key : this.keySet()) {
                if (current_ext_descs.contains(key)) {
                    ((List)this._data.get(key)).add(index, true);
                    if (!this._positive_counts.containsKey(index)) {
                        this._positive_counts.put(index, 1);
                        continue;
                    }
                    this._positive_counts.put(index, this._positive_counts.get(index) + 1);
                    continue;
                }
                ((List)this._data.get(key)).add(index, false);
            }
            ++index;
        }
    }

    private int size() {
        Iterator<PhylogenyNode> iterator = this.keySet().iterator();
        if (iterator.hasNext()) {
            PhylogenyNode key = iterator.next();
            return this.size(key);
        }
        return 0;
    }

    private int size(PhylogenyNode node) {
        return ((List)this._data.get(node)).size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (PhylogenyNode key : this.keySet()) {
            sb.append(key.getName());
            sb.append(":");
            for (int i = 0; i < this.size(key); ++i) {
                sb.append(" ");
                sb.append(this.getValueAsChar(key, i));
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

