/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class BasicDescriptiveStatistics
implements DescriptiveStatistics {
    private List<Double> _data;
    private double _sum;
    private double _min;
    private double _max;
    private double _sigma;
    private boolean _recalc_sigma;
    private String _desc;

    public BasicDescriptiveStatistics() {
        this.init();
    }

    public BasicDescriptiveStatistics(String desc) {
        this.init();
        this.setDescription(desc);
    }

    @Override
    public void addValue(double d) {
        this._recalc_sigma = true;
        this._sum += d;
        this._data.add(new Double(d));
        if (d < this._min) {
            this._min = d;
        }
        if (d > this._max) {
            this._max = d;
        }
    }

    @Override
    public double arithmeticMean() {
        this.validate();
        return this.getSum() / (double)this.getN();
    }

    @Override
    public String asSummary() {
        if (this.getN() > 1) {
            return this.arithmeticMean() + "\u00b1" + this.sampleStandardDeviation() + " [" + this.getMin() + "..." + this.getMax() + "]";
        }
        return "" + this.arithmeticMean();
    }

    @Override
    public double coefficientOfVariation() {
        this.validate();
        return this.sampleStandardDeviation() / this.arithmeticMean();
    }

    @Override
    public List<Double> getData() {
        return this._data;
    }

    @Override
    public double[] getDataAsDoubleArray() {
        this.validate();
        double[] data_array = new double[this.getN()];
        for (int i = 0; i < this.getN(); ++i) {
            data_array[i] = this.getValue(i);
        }
        return data_array;
    }

    @Override
    public String getDescription() {
        return this._desc;
    }

    @Override
    public double getMax() {
        this.validate();
        return this._max;
    }

    @Override
    public double getMin() {
        this.validate();
        return this._min;
    }

    @Override
    public int getN() {
        return this._data.size();
    }

    @Override
    public double getSum() {
        this.validate();
        return this._sum;
    }

    @Override
    public String getSummaryAsString() {
        this.validate();
        double mean = this.arithmeticMean();
        double sd = this.sampleStandardDeviation();
        return "" + mean + '\u00b1' + sd + " [" + this.getN() + "] [" + this.getMin() + "-" + this.getMax() + "]";
    }

    @Override
    public double getValue(int index) {
        this.validate();
        return this._data.get(index);
    }

    @Override
    public double median() {
        this.validate();
        double median = 0.0;
        if (this.getN() == 1) {
            median = this.getValue(0);
        } else {
            int index = this.getN() / 2;
            double[] data_array = this.getDataAsDoubleArray();
            Arrays.sort(data_array);
            median = data_array.length % 2 == 0 ? (data_array[index - 1] + data_array[index]) / 2.0 : data_array[index];
        }
        return median;
    }

    @Override
    public double midrange() {
        this.validate();
        return (this._min + this._max) / 2.0;
    }

    @Override
    public double pearsonianSkewness() {
        this.validate();
        double mean = this.arithmeticMean();
        double median = this.median();
        double sd = this.sampleStandardDeviation();
        return 3.0 * (mean - median) / sd;
    }

    @Override
    public double sampleStandardDeviation() {
        return Math.sqrt(this.sampleVariance());
    }

    @Override
    public double sampleStandardUnit(double value) {
        this.validate();
        return BasicDescriptiveStatistics.sampleStandardUnit(value, this.arithmeticMean(), this.sampleStandardDeviation());
    }

    @Override
    public double sampleVariance() {
        this.validate();
        if (this.getN() < 2) {
            return 0.0;
        }
        return this.sumDeviations() / (double)(this.getN() - 1);
    }

    @Override
    public void setDescription(String desc) {
        this._desc = desc;
    }

    @Override
    public double standardErrorOfMean() {
        this.validate();
        return this.sampleStandardDeviation() / Math.sqrt(this.getN());
    }

    @Override
    public double sumDeviations() {
        this.validate();
        if (this._recalc_sigma) {
            this._recalc_sigma = false;
            this._sigma = 0.0;
            double mean = this.arithmeticMean();
            for (int i = 0; i < this.getN(); ++i) {
                this._sigma += Math.pow(this.getValue(i) - mean, 2.0);
            }
        }
        return this._sigma;
    }

    @Override
    public String toString() {
        if (this.getN() < 1) {
            return "empty data set statistics";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Descriptive statistics:");
        sb.append(ForesterUtil.getLineSeparator());
        sb.append("n                       : " + this.getN());
        if (this.getN() > 1) {
            sb.append(ForesterUtil.getLineSeparator());
            sb.append("min                     : " + this.getMin());
            sb.append(ForesterUtil.getLineSeparator());
            sb.append("max                     : " + this.getMax());
            sb.append(ForesterUtil.getLineSeparator());
            sb.append("midrange                : " + this.midrange());
            sb.append(ForesterUtil.getLineSeparator());
            sb.append("median                  : " + this.median());
            sb.append(ForesterUtil.getLineSeparator());
            sb.append("mean                    : " + this.arithmeticMean());
            sb.append(ForesterUtil.getLineSeparator());
            sb.append("sd                      : " + this.sampleStandardDeviation());
            sb.append(ForesterUtil.getLineSeparator());
            sb.append("variance                : " + this.sampleVariance());
            sb.append(ForesterUtil.getLineSeparator());
            sb.append("standard error of mean  : " + this.standardErrorOfMean());
            sb.append(ForesterUtil.getLineSeparator());
            sb.append("coefficient of variation: " + this.coefficientOfVariation());
            sb.append(ForesterUtil.getLineSeparator());
            sb.append("pearsonian skewness     : " + this.pearsonianSkewness());
        }
        return sb.toString();
    }

    private void init() {
        this._data = new ArrayList<Double>();
        this._sum = 0.0;
        this._min = Double.MAX_VALUE;
        this._max = -1.7976931348623157E308;
        this._sigma = 0.0;
        this._recalc_sigma = true;
        this._desc = "";
    }

    private void validate() throws ArithmeticException {
        if (this.getN() < 1) {
            throw new ArithmeticException("attempt to get a result from empty data set statistics");
        }
    }

    public static int[] performBinning(double[] values, double min, double max, int number_of_bins) {
        if (min >= max) {
            throw new IllegalArgumentException("min [" + min + "] is larger than or equal to max [" + max + "]");
        }
        if (number_of_bins < 3) {
            throw new IllegalArgumentException("number of bins is smaller than 3");
        }
        int[] bins = new int[number_of_bins];
        double binning_factor = (double)number_of_bins / (max - min);
        int last_index = number_of_bins - 1;
        for (double d : values) {
            if (d > max || d < min) continue;
            int bin = (int)((d - min) * binning_factor);
            if (bin > last_index) {
                int n = last_index;
                bins[n] = bins[n] + 1;
                continue;
            }
            int n = bin;
            bins[n] = bins[n] + 1;
        }
        return bins;
    }

    public static double sampleStandardUnit(double value, double mean, double sd) {
        return (value - mean) / sd;
    }
}

