/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.seqdb;

import java.util.ArrayList;
import java.util.List;
import org.forester.util.ForesterUtil;

public final class UniProtTaxonomy {
    public static final String ARCHAEA = "Archaea";
    public static final String BACTERIA = "Bacteria";
    public static final String EUKARYOTA = "Eukaryota";
    private final List<String> _lineage;
    private final String _code;
    private final String _scientific_name;
    private final String _common_name;
    private final String _synonym;
    private final String _rank;
    private final String _id;
    public static final String CELLULAR_ORGANISMS = "cellular organisms";
    public static final String VIRUSES = "Viruses";
    public static final String X = "x";

    public UniProtTaxonomy(String line) {
        String[] items = line.split("\t");
        if (items.length < 5) {
            throw new IllegalArgumentException("cannot parse uniprot taxonomy from: " + line);
        }
        this._id = items[0].trim();
        this._code = items[1].trim();
        this._scientific_name = items[2].trim();
        this._common_name = items[3].trim();
        this._synonym = items[4].trim();
        this._rank = items.length > 6 ? items[7].trim() : "";
        String[] lin = null;
        if (items.length > 8) {
            lin = items[8].split("; ");
        }
        this._lineage = new ArrayList<String>();
        if (lin != null && lin.length > 0) {
            ArrayList<String> temp = new ArrayList<String>();
            for (String t : lin) {
                if (ForesterUtil.isEmpty(t)) continue;
                temp.add(t.trim());
            }
            for (int i = 0; i < temp.size(); ++i) {
                if (i == 0 && (((String)temp.get(i)).equalsIgnoreCase(EUKARYOTA) || ((String)temp.get(i)).equalsIgnoreCase(BACTERIA) || ((String)temp.get(i)).equalsIgnoreCase(ARCHAEA))) {
                    this._lineage.add(CELLULAR_ORGANISMS);
                }
                this._lineage.add((String)temp.get(i));
            }
        }
        if (this._lineage.isEmpty() && (this._scientific_name.equalsIgnoreCase(EUKARYOTA) || this._scientific_name.equalsIgnoreCase(BACTERIA) || this._scientific_name.equalsIgnoreCase(ARCHAEA))) {
            this._lineage.add(CELLULAR_ORGANISMS);
        }
        this._lineage.add(this._scientific_name);
        if (this._lineage.isEmpty()) {
            throw new IllegalArgumentException("lineage in a UniProt taxonomy can not be empty\n: " + line);
        }
    }

    public UniProtTaxonomy(List<String> lineage, String code, String common_name, String scientific_name, String synonym, String rank, String id) {
        this._lineage = lineage;
        this._code = code;
        this._scientific_name = scientific_name;
        this._common_name = common_name;
        this._synonym = synonym;
        this._rank = rank;
        this._id = id;
        if (this._lineage != null && this._lineage.isEmpty() || !ForesterUtil.isEmpty(this._lineage) && !this._lineage.get(this._lineage.size() - 1).equalsIgnoreCase(this._scientific_name)) {
            this._lineage.add(this._scientific_name);
        }
    }

    public UniProtTaxonomy copy() {
        return new UniProtTaxonomy(this.getLineage(), this.getCode() != null ? new String(this.getCode()) : null, this.getCommonName() != null ? new String(this.getCommonName()) : null, this.getScientificName() != null ? new String(this.getScientificName()) : null, this.getSynonym() != null ? new String(this.getSynonym()) : null, this.getRank() != null ? new String(this.getRank()) : null, this.getId() != null ? new String(this.getId()) : null);
    }

    public String getCode() {
        return this._code;
    }

    public String getCommonName() {
        return this._common_name;
    }

    public String getId() {
        return this._id;
    }

    public List<String> getLineage() {
        return this._lineage;
    }

    public String getRank() {
        return this._rank;
    }

    public String getScientificName() {
        return this._scientific_name;
    }

    public String getSynonym() {
        return this._synonym;
    }

    public static final UniProtTaxonomy createSpecialFromScientificName(String sn) {
        ArrayList<String> lineage = new ArrayList<String>();
        String code = "";
        String common_name = "";
        String scientific_name = "";
        String synonym = "";
        String rank = "";
        String id = "";
        if (sn.equalsIgnoreCase(BACTERIA)) {
            scientific_name = BACTERIA;
            lineage.add(CELLULAR_ORGANISMS);
            rank = "superkingdom";
            id = "2";
        } else if (sn.equalsIgnoreCase(ARCHAEA)) {
            scientific_name = ARCHAEA;
            lineage.add(CELLULAR_ORGANISMS);
            rank = "superkingdom";
            id = "2157";
        } else if (sn.equalsIgnoreCase(EUKARYOTA)) {
            scientific_name = EUKARYOTA;
            lineage.add(CELLULAR_ORGANISMS);
            rank = "superkingdom";
            id = "2759";
        } else if (sn.equalsIgnoreCase(VIRUSES)) {
            scientific_name = VIRUSES;
            rank = "superkingdom";
            id = "10239";
        } else if (sn.equalsIgnoreCase(X)) {
            scientific_name = X;
        } else {
            throw new IllegalArgumentException("illegal attempt to make UniProt taxonomy for :" + sn);
        }
        return new UniProtTaxonomy(lineage, "", "", scientific_name, "", rank, id);
    }
}

