/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class AggregateQuantitationTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/dps/msq/AggregateQuantitation";
    private String m_version = "1.0";
    private Long[] m_quantiResult = null;
    private final String m_quantiDSName;
    private final Long m_pId;
    private final Map<String, Object> m_quantParams;
    private final Map<String, Object> m_expDesignParams;

    public AggregateQuantitationTask(AbstractJMSCallback callback, Long projectId, String quantDSName, Map<String, Object> quantParams, Map<String, Object> expDesignParams, Long[] retValue) {
        super(callback, new TaskInfo("Run Aggregate Quantitation for " + quantDSName, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_quantiResult = retValue;
        this.m_expDesignParams = expDesignParams;
        this.m_quantiDSName = quantDSName;
        this.m_pId = projectId;
        this.m_quantParams = quantParams;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = AccessJMSManagerThread.getAccessJMSManagerThread().getSession().createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        this.addSourceToMessage((Message)message);
        this.addDescriptionToMessage((Message)message);
        message.setStringProperty("Proline_ServiceVersion", this.m_version);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", this.m_quantiDSName);
        params.put("description", this.m_quantiDSName);
        params.put("project_id", this.m_pId);
        params.put("method_id", 1);
        params.put("experimental_design", this.m_expDesignParams);
        params.put("quantitation_config", this.m_quantParams);
        return params;
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null || !Long.class.isInstance(result)) {
                m_loggerProline.debug("Invalid result: No returned Quantitation dataset Id");
                throw new Exception("Invalid result " + result);
            }
            m_loggerProline.debug("Result :\n" + result);
            this.m_quantiResult[0] = (Long)result;
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }
}

