/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.profi.util.security.EncryptionManager;
import fr.profi.util.security.SecurityUtils;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class AuthenticateUserTask
extends AbstractJMSTask {
    private String m_userName;
    private String m_password;
    private String[] m_databasePassword;
    private static int TASK_TIMEOUT_MS = 20000;

    public AuthenticateUserTask(AbstractJMSCallback callback, String m_userName, String m_password, String[] m_databasePassword) {
        super(callback, true, new TaskInfo("Check User " + m_userName, false, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_userName = m_userName;
        this.m_password = m_password;
        this.m_databasePassword = m_databasePassword;
        super.setResponseTimeout(TASK_TIMEOUT_MS);
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("authenticate", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = AccessJMSManagerThread.getAccessJMSManagerThread().getSession().createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/admin/UserAccount");
        this.addSourceToMessage((Message)message);
        this.addDescriptionToMessage((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.debug("Message AuthenticateUserTask [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("login", this.m_userName);
        params.put("password_hash", SecurityUtils.sha256Hex((String)this.m_password));
        params.put("return_db_password", Boolean.TRUE);
        EncryptionManager encryptionMgr = EncryptionManager.getEncryptionManager();
        params.put("public_key", encryptionMgr.getPublicKeyAsString());
        return params;
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                int jsonErrCode = jsonError.getCode();
                if (jsonErrCode == -32003 && this.m_taskInfo.getDuration() <= (long)TASK_TIMEOUT_MS) {
                    jsonError = jsonError.appendMessage("\n Your clock should not be synchronized with Proline Server's one !! ");
                }
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null) {
                m_loggerProline.debug("Internal Error : No DB password received");
                throw new Exception("Internal Error : No DB password received ");
            }
            String dbPwd = result.toString();
            this.m_databasePassword[0] = EncryptionManager.getEncryptionManager().decrypt(dbPwd);
            m_loggerProline.debug("Result :\n" + this.m_databasePassword[0]);
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }
}

