/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.HashMap;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class MergeTask
extends AbstractJMSTask {
    private List<Long> m_rsetOrRsmIdList = null;
    private long m_projectId = -1L;
    private final Config m_configuration;
    private Long[] m_resultSetId = null;
    private Long[] m_resultSummaryId = null;
    private int m_action;
    private static final int MERGE_RSM = 0;
    private static final int MERGE_RSET = 1;

    public MergeTask(AbstractJMSCallback callback, long projectId) {
        this(callback, projectId, Config.AGGREGATION);
    }

    public MergeTask(AbstractJMSCallback callback, long projectId, Config configuration) {
        super(callback, null);
        this.m_projectId = projectId;
        this.m_configuration = configuration;
    }

    public void initMergeRset(List<Long> resultSetIdList, String parentName, Long[] resultSetId) {
        this.setTaskInfo(new TaskInfo("Merge Search Results on " + parentName, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_rsetOrRsmIdList = resultSetIdList;
        this.m_resultSetId = resultSetId;
        this.m_action = 1;
    }

    public void initMergeRsm(List<Long> resultSummaryIdList, String parentName, Long[] resultSetId, Long[] resultSummaryId) {
        this.setTaskInfo(new TaskInfo("Merge Identification Summaries on " + parentName, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_rsetOrRsmIdList = resultSummaryIdList;
        this.m_resultSetId = resultSetId;
        this.m_resultSummaryId = resultSummaryId;
        this.m_action = 0;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = this.m_action == 1 ? new JSONRPC2Request("merge_result_sets", (Object)this.m_taskInfo.getId()) : new JSONRPC2Request("merge_result_summaries", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = AccessJMSManagerThread.getAccessJMSManagerThread().getSession().createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/dps/msi/MergeResults");
        message.setStringProperty("Proline_ServiceVersion", "2.0");
        this.addSourceToMessage((Message)message);
        this.addDescriptionToMessage((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project_id", this.m_projectId);
        params.put("aggregation_mode", this.m_configuration.value);
        if (this.m_action == 1) {
            params.put("result_set_ids", this.m_rsetOrRsmIdList);
        } else {
            params.put("result_summary_ids", this.m_rsetOrRsmIdList);
        }
        return params;
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null) {
                m_loggerProline.debug("No returned ResultSet Id");
                throw new Exception("JMS Result : No returned ResultSet Id");
            }
            if (this.m_action == 1) {
                Long resultSetId;
                this.m_resultSetId[0] = resultSetId = (Long)result;
            } else {
                HashMap resultIds = (HashMap)result;
                Long resultSetId = (Long)resultIds.get("target_result_set_id");
                if (resultSetId == null) {
                    m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No returned ResultSet Id");
                    throw new Exception("No returned ResultSet Id");
                }
                this.m_resultSetId[0] = resultSetId;
                Long resultSummaryId = (Long)resultIds.get("target_result_summary_id");
                if (resultSummaryId == null) {
                    m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No returned ResultSummary Id");
                    throw new Exception("No returned ResultSummary Id");
                }
                this.m_resultSummaryId[0] = resultSummaryId;
            }
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }

    public static enum Config {
        AGGREGATION("aggregation"),
        UNION("union");

        String value;

        private Config(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

