/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.vertica;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.SqlStatementBuilder;
import org.flywaydb.core.internal.dbsupport.vertica.VerticaSchema;
import org.flywaydb.core.internal.dbsupport.vertica.VerticaStatementBuilder;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.jdbc.RowMapper;

public class VerticaDbSupport
extends DbSupport {
    public VerticaDbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 0));
    }

    @Override
    public String getDbName() {
        return "vertica";
    }

    @Override
    public String getCurrentUserFunction() {
        return "current_user";
    }

    @Override
    protected String doGetCurrentSchema() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT current_schema()", new String[0]);
    }

    @Override
    protected void doSetCurrentSchema(Schema schema) throws SQLException {
        if (schema == null) {
            this.jdbcTemplate.execute("SET search_path = v_catalog", new Object[0]);
            return;
        }
        String searchPath = this.doGetSearchPath();
        if (StringUtils.hasText(searchPath)) {
            this.jdbcTemplate.execute("SET search_path = " + schema + "," + searchPath, new Object[0]);
        } else {
            this.jdbcTemplate.execute("SET search_path = " + schema, new Object[0]);
        }
    }

    String doGetSearchPath() throws SQLException {
        String searchPath = this.jdbcTemplate.query("SHOW search_path", new RowMapper<String>(){

            @Override
            public String mapRow(ResultSet rs) throws SQLException {
                return rs.getString("setting");
            }
        }).get(0);
        return searchPath;
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new VerticaStatementBuilder();
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + StringUtils.replaceAll(identifier, "\"", "\"\"") + "\"";
    }

    @Override
    public Schema getSchema(String name) {
        return new VerticaSchema(this.jdbcTemplate, this, name);
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

