/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.util.exception.SerializableStackTraceElement;
import fr.profi.util.exception.SerializableStackTraceElement$;
import fr.proline.jms.ServiceRegistry$;
import fr.proline.jms.service.api.IRemoteServiceIdentity;
import fr.proline.jms.service.api.ISingleThreadedService;
import fr.proline.jms.util.JMSConstants$;
import fr.proline.jms.util.NodeConfig$;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ServiceRunner$
implements LazyLogging {
    public static final ServiceRunner$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ServiceRunner$();
    }

    private Logger logger$lzycompute() {
        ServiceRunner$ serviceRunner$ = this;
        synchronized (serviceRunner$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Message buildJMSMsgFromJSONRPC2Response(Session session, JSONRPC2Response jsonResponse, Map<String, Object> jmsMessageContext) {
        TextMessage responseJMSMessage = session.createTextMessage();
        responseJMSMessage.setJMSCorrelationID(jmsMessageContext.get((Object)JMSConstants$.MODULE$.JMSCorrelationID()).toString());
        responseJMSMessage.setText(jsonResponse.toJSONString());
        return responseJMSMessage;
    }

    public JSONRPC2Error buildJSONRPC2Error(int code, Throwable t) {
        SerializableStackTraceElement[] stackTrace = (SerializableStackTraceElement[])Predef$.MODULE$.refArrayOps((Object[])t.getStackTrace()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SerializableStackTraceElement apply(StackTraceElement traceElem) {
                return SerializableStackTraceElement$.MODULE$.apply(traceElem);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SerializableStackTraceElement.class)));
        return new JSONRPC2Error(code, t.getMessage(), (Object)stackTrace);
    }

    public String buildConcreteSelectorString(Seq<IRemoteServiceIdentity> handledServices, boolean parallelizableRunner) {
        Predef$.MODULE$.require(handledServices != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "handledServices List is null";
            }
        });
        StringBuilder buff = new StringBuilder();
        BooleanRef first = BooleanRef.create((boolean)true);
        if (parallelizableRunner) {
            buff.append("((").append(JMSConstants$.MODULE$.PROLINE_SERVICE_NAME_KEY());
            buff.append(" = '").append(ServiceRegistry$.MODULE$.resourceService().serviceName()).append("') AND (");
            buff.append(JMSConstants$.MODULE$.PROLINE_NODE_ID_KEY());
            buff.append(" = '").append(NodeConfig$.MODULE$.NODE_ID()).append("'))");
            first.elem = false;
        }
        handledServices.foreach((Function1)new Serializable(parallelizableRunner, buff, first){
            public static final long serialVersionUID = 0L;
            private final boolean parallelizableRunner$1;
            private final StringBuilder buff$1;
            private final BooleanRef first$1;

            public final Object apply(IRemoteServiceIdentity service2) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                StringBuilder stringBuilder;
                if (this.parallelizableRunner$1 && service2 instanceof ISingleThreadedService) {
                    throw new RuntimeException("Parallelizable ServiceRunner does not accept ISingleThreadedService");
                }
                if (this.first$1.elem) {
                    this.first$1.elem = false;
                    stringBuilder = BoxedUnit.UNIT;
                } else {
                    stringBuilder = this.buff$1.append("\n OR ");
                }
                this.buff$1.append("((").append(JMSConstants$.MODULE$.PROLINE_SERVICE_NAME_KEY());
                this.buff$1.append(" = '").append(service2.serviceName()).append("') AND (");
                this.buff$1.append(JMSConstants$.MODULE$.PROLINE_SERVICE_VERSION_KEY());
                this.buff$1.append(" = '").append(service2.serviceVersion()).append("')");
                if (service2.isNodeSpecific()) {
                    this.buff$1.append(" AND (").append(JMSConstants$.MODULE$.PROLINE_NODE_ID_KEY());
                    boxedUnit2 = this.buff$1.append(" = '").append(NodeConfig$.MODULE$.NODE_ID()).append("')");
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.buff$1.append(")");
                if (service2.isDefaultVersion()) {
                    BoxedUnit boxedUnit3;
                    this.buff$1.append(" OR ");
                    this.buff$1.append("((").append(JMSConstants$.MODULE$.PROLINE_SERVICE_NAME_KEY());
                    this.buff$1.append(" = '").append(service2.serviceName()).append("') AND (");
                    this.buff$1.append(JMSConstants$.MODULE$.PROLINE_SERVICE_VERSION_KEY());
                    this.buff$1.append(" IS NULL)");
                    if (service2.isNodeSpecific()) {
                        this.buff$1.append(" AND (").append(JMSConstants$.MODULE$.PROLINE_NODE_ID_KEY());
                        boxedUnit3 = this.buff$1.append(" = '").append(NodeConfig$.MODULE$.NODE_ID()).append("')");
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    boxedUnit = this.buff$1.append(")");
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.parallelizableRunner$1 = parallelizableRunner$1;
                this.buff$1 = buff$1;
                this.first$1 = first$1;
            }
        });
        return buff.toString();
    }

    public Map<String, Object> buildJMSMessageContext(Message message) {
        Predef$.MODULE$.require(message != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "message is null";
            }
        });
        scala.collection.mutable.Map mutableMap = Map$.MODULE$.empty();
        String jmsMessageId = message.getJMSMessageID();
        mutableMap.put((Object)JMSConstants$.MODULE$.JMSMessageID(), (Object)jmsMessageId);
        String jmsCorrelationId = message.getJMSCorrelationID();
        Object object = jmsCorrelationId == null ? BoxedUnit.UNIT : mutableMap.put((Object)JMSConstants$.MODULE$.JMSCorrelationID(), (Object)jmsCorrelationId);
        long jmsTimestamp = message.getJMSTimestamp();
        mutableMap.put((Object)JMSConstants$.MODULE$.JMSTimestamp(), (Object)BoxesRunTime.boxToLong((long)jmsTimestamp));
        Destination jmsDestination = message.getJMSDestination();
        mutableMap.put((Object)JMSConstants$.MODULE$.JMSDestination(), (Object)jmsDestination);
        Destination jmsReplyTo = message.getJMSReplyTo();
        Object object2 = jmsReplyTo == null ? BoxedUnit.UNIT : mutableMap.put((Object)JMSConstants$.MODULE$.JMSReplyTo(), (Object)jmsReplyTo);
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Object elem = propertyNames.nextElement();
            Object e = elem;
            if (e instanceof String) {
                BoxedUnit boxedUnit3;
                String string = (String)e;
                Object value = message.getObjectProperty(string);
                Option oldValue = mutableMap.put((Object)string, value);
                if (oldValue.isDefined()) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("JMS Message property [{}] overridden", new Object[]{string});
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                boxedUnit2 = boxedUnit3;
                continue;
            }
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Invalid JMS Message property name");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            boxedUnit2 = boxedUnit;
        }
        return mutableMap.toMap(Predef$.MODULE$.$conforms());
    }

    private ServiceRunner$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

