/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.jms.util;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.util.StringUtils;
import fr.profi.util.ThreadLogger;
import fr.proline.jms.util.IServiceMonitoringNotifier;
import fr.proline.jms.util.IServiceMonitoringNotifier$class;
import fr.proline.jms.util.JMSConstants$;
import fr.proline.jms.util.NodeConfig$;
import fr.proline.jms.util.TopicMessage;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.hornetq.api.jms.HornetQJMSClient;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001\u0017\tqRj\u001c8ji>\u0014\u0018N\\4U_BL7\rU;cY&\u001c\b.\u001a:Sk:tWM\u001d\u0006\u0003\u0007\u0011\tA!\u001e;jY*\u0011QAB\u0001\u0004U6\u001c(BA\u0004\t\u0003\u001d\u0001(o\u001c7j]\u0016T\u0011!C\u0001\u0003MJ\u001c\u0001aE\u0003\u0001\u0019I1b\u0004\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011!$S*feZL7-Z'p]&$xN]5oO:{G/\u001b4jKJ\u0004\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\t1\fgn\u001a\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002D\u0001\u0005Sk:t\u0017M\u00197f!\tyb%D\u0001!\u0015\t\t#%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002$I\u0005AA/\u001f9fg\u00064WMC\u0001&\u0003\r\u0019w.\\\u0005\u0003O\u0001\u00121\u0002T1{s2{wmZ5oO\"A\u0011\u0006\u0001B\u0001B\u0003%!&\u0001\u0006d_:tWm\u0019;j_:\u0004\"aK\u0018\u000e\u00031R!!B\u0017\u000b\u00039\nQA[1wCbL!\u0001\r\u0017\u0003\u0015\r{gN\\3di&|g\u000eC\u00033\u0001\u0011\u00051'\u0001\u0004=S:LGO\u0010\u000b\u0003iU\u0002\"a\u0005\u0001\t\u000b%\n\u0004\u0019\u0001\u0016\t\u000f]\u0002!\u0019!C\u0005q\u00051Rn\u00189f]\u0012Lgn\u001a+pa&\u001cW*Z:tC\u001e,7/F\u0001:!\rQd\bQ\u0007\u0002w)\u0011A(P\u0001\u000bG>t7-\u001e:sK:$(BA\u0002\u001b\u0013\ty4HA\nMS:\\W\r\u001a\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0002\u0014\u0003&\u0011!I\u0001\u0002\r)>\u0004\u0018nY'fgN\fw-\u001a\u0005\u0007\t\u0002\u0001\u000b\u0011B\u001d\u0002/5|\u0006/\u001a8eS:<Gk\u001c9jG6+7o]1hKN\u0004\u0003\"\u0002$\u0001\t\u00039\u0015a\u0001:v]R\t\u0001\n\u0005\u0002\u000e\u0013&\u0011!J\u0004\u0002\u0005+:LG\u000fC\u0003M\u0001\u0011\u0005Q*\u0001\ttK:$gj\u001c;jM&\u001c\u0017\r^5p]R\u0019\u0001JT,\t\u000b=[\u0005\u0019\u0001)\u0002\u000f\r|g\u000e^3oiB\u0011\u0011\u000b\u0016\b\u0003\u001bIK!a\u0015\b\u0002\rA\u0013X\rZ3g\u0013\t)fK\u0001\u0004TiJLgn\u001a\u0006\u0003':AQ\u0001W&A\u0002A\u000b\u0001C[7t\u0007>\u0014(/\u001a7bi&|g.\u00133")
public class MonitoringTopicPublisherRunner
implements IServiceMonitoringNotifier,
Runnable,
LazyLogging {
    private final Connection connection;
    private final LinkedBlockingQueue<TopicMessage> m_pendingTopicMessages;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        MonitoringTopicPublisherRunner monitoringTopicPublisherRunner = this;
        synchronized (monitoringTopicPublisherRunner) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public void sendNotification(JSONRPC2Message jsonRPCContent, String jmsCorrelationId) {
        IServiceMonitoringNotifier$class.sendNotification(this, jsonRPCContent, jmsCorrelationId);
    }

    private LinkedBlockingQueue<TopicMessage> m_pendingTopicMessages() {
        return this.m_pendingTopicMessages;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        if (!(currentThread.getUncaughtExceptionHandler() instanceof ThreadLogger)) {
            currentThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadLogger(this.logger().underlying().getName()));
        }
        Topic prolineNotificationTopic = HornetQJMSClient.createTopic((String)JMSConstants$.MODULE$.SERVICE_MONITORING_NOTIFICATION_TOPIC_NAME());
        Session session = this.connection.createSession(false, 1);
        try {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            MessageProducer topicPublisher = session.createProducer((Destination)prolineNotificationTopic);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder().append((Object)"Entering Notification Topic Publisher send loop [").append((Object)currentThread.getName()).append((Object)BoxesRunTime.boxToCharacter((char)']')).append((Object)" for topic ").append((Object)prolineNotificationTopic).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            String nodeId = NodeConfig$.MODULE$.NODE_ID();
            boolean goOn = true;
            while (goOn) {
                BoxedUnit boxedUnit3;
                try {
                    TopicMessage topicMessage = this.m_pendingTopicMessages().take();
                    TextMessage message = session.createTextMessage();
                    if (!StringUtils.isEmpty((String)topicMessage.jmsCorrelationId())) {
                        message.setJMSCorrelationID(topicMessage.jmsCorrelationId());
                    }
                    message.setStringProperty(JMSConstants$.MODULE$.PROLINE_NODE_ID_KEY(), nodeId);
                    message.setText(topicMessage.content());
                    {
                        topicPublisher.send((Message)message);
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                }
                catch (Throwable throwable) {
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Error running Notification Topic Publisher send loop", throwable);
                        boxedUnit3 = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                catch (InterruptedException interruptedException) {
                    goOn = false;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Topic Publisher Monitoring was interrupted");
                        boxedUnit3 = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit3 = BoxedUnit.UNIT;
                }
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Exiting MonitoringTopicPublisherRunner loop");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        catch (Throwable throwable) {
            if (session == null) throw throwable;
            try {
                BoxedUnit boxedUnit;
                session.close();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("JMS Session closed");
                    boxedUnit = BoxedUnit.UNIT;
                    throw throwable;
                }
                boxedUnit = BoxedUnit.UNIT;
                throw throwable;
            }
            catch (JMSException jMSException) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Error closing JMS Session", (Throwable)jMSException);
                    boxedUnit = BoxedUnit.UNIT;
                    throw throwable;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        if (session == null) return;
        try {
            BoxedUnit boxedUnit;
            session.close();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("JMS Session closed");
                boxedUnit = BoxedUnit.UNIT;
                return;
            }
            boxedUnit = BoxedUnit.UNIT;
            return;
        }
        catch (JMSException jMSException) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Error closing JMS Session", (Throwable)jMSException);
                boxedUnit = BoxedUnit.UNIT;
                return;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void sendNotification(String content, String jmsCorrelationId) {
        Predef$.MODULE$.require(!StringUtils.isEmpty((String)content), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid content";
            }
        });
        TopicMessage topicMessage = new TopicMessage(content, jmsCorrelationId);
        this.m_pendingTopicMessages().put(topicMessage);
    }

    public MonitoringTopicPublisherRunner(Connection connection) {
        this.connection = connection;
        IServiceMonitoringNotifier$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.m_pendingTopicMessages = new LinkedBlockingQueue();
        Predef$.MODULE$.require(connection != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Connection is null";
            }
        });
    }
}

