/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.jms.util;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.util.StringUtils;
import fr.profi.util.ThreadLogger;
import fr.proline.jms.util.JMSConstants$;
import java.util.UUID;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class NodeConfig$
implements LazyLogging {
    public static final NodeConfig$ MODULE$;
    private final Thread m_currentThread;
    private ClassLoader classLoader;
    private Config _jmsConfParams;
    private final String NODE_ID;
    private final String NODE_CONFIG_KEY;
    private final String fr$proline$jms$util$NodeConfig$$JMS_SERVER_HOST_KEY;
    private final String fr$proline$jms$util$NodeConfig$$JMS_SERVER_PORT_KEY;
    private final String PROLINE_SERVICE_REQUEST_QUEUE_KEY;
    private final String SERVICE_THREAD_POOL_SIZE_KEY;
    private final String MZDB_MAX_PARALLELISM_KEY;
    private final String PEAKELDB_TEMP_DIRECTORY_KEY;
    private final String ENABLE_IMPORTS_KEY;
    private final int DEFAULT_MZDB_MAX_PARALLELISM;
    private final String DEFAULT_PEAKELDB_TEMP_DIRECTORY;
    private final String DEFAULT_PROLINE_SERVICE_REQUEST_QUEUE_NAME;
    private final int ABSOLUTE_MAX_N_THREADS;
    private final int AUTO_MAX_N_THREAD;
    private final Config m_jmsConfig;
    private final String m_jmsServerHost;
    private final int m_jmsServerPort;
    private final String PROLINE_EXPIRED_MESSAGE_QUEUE_NAME;
    private final String PROLINE_SERVICE_REQUEST_QUEUE_NAME;
    private final int SERVICE_THREAD_POOL_SIZE;
    private final boolean ENABLE_IMPORTS;
    private final int MZDB_MAX_PARALLELISM;
    private final String PEAKELDB_TEMP_DIRECTORY;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new NodeConfig$();
    }

    private Logger logger$lzycompute() {
        NodeConfig$ nodeConfig$ = this;
        synchronized (nodeConfig$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private Thread m_currentThread() {
        return this.m_currentThread;
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public void classLoader_$eq(ClassLoader x$1) {
        this.classLoader = x$1;
    }

    private Config _jmsConfParams() {
        return this._jmsConfParams;
    }

    private void _jmsConfParams_$eq(Config x$1) {
        this._jmsConfParams = x$1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Config getJMSConfigParams() {
        BoxedUnit boxedUnit;
        if (this._jmsConfParams() != null) {
            boxedUnit = BoxedUnit.UNIT;
            return this._jmsConfParams();
        }
        NodeConfig$ nodeConfig$ = this;
        synchronized (nodeConfig$) {
            this._jmsConfParams_$eq(ConfigFactory.load((String)"jms-node"));
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : nodeConfig$
            boxedUnit = boxedUnit2;
            return this._jmsConfParams();
        }
    }

    public String NODE_ID() {
        return this.NODE_ID;
    }

    private String NODE_CONFIG_KEY() {
        return this.NODE_CONFIG_KEY;
    }

    public String fr$proline$jms$util$NodeConfig$$JMS_SERVER_HOST_KEY() {
        return this.fr$proline$jms$util$NodeConfig$$JMS_SERVER_HOST_KEY;
    }

    public String fr$proline$jms$util$NodeConfig$$JMS_SERVER_PORT_KEY() {
        return this.fr$proline$jms$util$NodeConfig$$JMS_SERVER_PORT_KEY;
    }

    private String PROLINE_SERVICE_REQUEST_QUEUE_KEY() {
        return this.PROLINE_SERVICE_REQUEST_QUEUE_KEY;
    }

    private String SERVICE_THREAD_POOL_SIZE_KEY() {
        return this.SERVICE_THREAD_POOL_SIZE_KEY;
    }

    private String MZDB_MAX_PARALLELISM_KEY() {
        return this.MZDB_MAX_PARALLELISM_KEY;
    }

    private String PEAKELDB_TEMP_DIRECTORY_KEY() {
        return this.PEAKELDB_TEMP_DIRECTORY_KEY;
    }

    private String ENABLE_IMPORTS_KEY() {
        return this.ENABLE_IMPORTS_KEY;
    }

    private int DEFAULT_MZDB_MAX_PARALLELISM() {
        return this.DEFAULT_MZDB_MAX_PARALLELISM;
    }

    private String DEFAULT_PEAKELDB_TEMP_DIRECTORY() {
        return this.DEFAULT_PEAKELDB_TEMP_DIRECTORY;
    }

    private String DEFAULT_PROLINE_SERVICE_REQUEST_QUEUE_NAME() {
        return this.DEFAULT_PROLINE_SERVICE_REQUEST_QUEUE_NAME;
    }

    private int ABSOLUTE_MAX_N_THREADS() {
        return this.ABSOLUTE_MAX_N_THREADS;
    }

    private int AUTO_MAX_N_THREAD() {
        return this.AUTO_MAX_N_THREAD;
    }

    private Config m_jmsConfig() {
        return this.m_jmsConfig;
    }

    private String m_jmsServerHost() {
        return this.m_jmsServerHost;
    }

    public String getJMSServerHost() {
        return this.m_jmsServerHost();
    }

    private int m_jmsServerPort() {
        return this.m_jmsServerPort;
    }

    public int getJMSServerPort() {
        return this.m_jmsServerPort();
    }

    public String PROLINE_EXPIRED_MESSAGE_QUEUE_NAME() {
        return this.PROLINE_EXPIRED_MESSAGE_QUEUE_NAME;
    }

    public String PROLINE_SERVICE_REQUEST_QUEUE_NAME() {
        return this.PROLINE_SERVICE_REQUEST_QUEUE_NAME;
    }

    public int SERVICE_THREAD_POOL_SIZE() {
        return this.SERVICE_THREAD_POOL_SIZE;
    }

    public boolean ENABLE_IMPORTS() {
        return this.ENABLE_IMPORTS;
    }

    public int MZDB_MAX_PARALLELISM() {
        return this.MZDB_MAX_PARALLELISM;
    }

    public String PEAKELDB_TEMP_DIRECTORY() {
        return this.PEAKELDB_TEMP_DIRECTORY;
    }

    /*
     * WARNING - void declaration
     */
    private String retrieveQueueName(Config config) {
        void var2_2;
        String queueName = null;
        if (config.hasPath(this.PROLINE_SERVICE_REQUEST_QUEUE_KEY())) {
            queueName = config.getString(this.PROLINE_SERVICE_REQUEST_QUEUE_KEY());
        }
        if (StringUtils.isEmpty(queueName)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder().append((Object)"Invalid \"").append((Object)this.PROLINE_SERVICE_REQUEST_QUEUE_KEY()).append((Object)"\" using DEFAULT : ").append((Object)this.DEFAULT_PROLINE_SERVICE_REQUEST_QUEUE_NAME()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            queueName = this.DEFAULT_PROLINE_SERVICE_REQUEST_QUEUE_NAME();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int retrieveThreadPoolSize(Config config) {
        void var2_2;
        BoxedUnit boxedUnit;
        int nThreads = -1;
        if (config.hasPath(this.SERVICE_THREAD_POOL_SIZE_KEY())) {
            nThreads = config.getInt(this.SERVICE_THREAD_POOL_SIZE_KEY());
        }
        if (nThreads < 1) {
            nThreads = package$.MODULE$.min(Runtime.getRuntime().availableProcessors() / 2 + 1, this.AUTO_MAX_N_THREAD());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder().append((Object)"Invalid \"").append((Object)this.SERVICE_THREAD_POOL_SIZE_KEY()).append((Object)"\" using AUTO : ").append((Object)BoxesRunTime.boxToInteger((int)nThreads)).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (nThreads > this.ABSOLUTE_MAX_N_THREADS()) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder().append((Object)"Invalid \"").append((Object)this.SERVICE_THREAD_POOL_SIZE_KEY()).append((Object)"\" using ABSOLUTE MAX : ").append((Object)BoxesRunTime.boxToInteger((int)nThreads)).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                nThreads = this.ABSOLUTE_MAX_N_THREADS();
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int retrieveMzdbMaxParallelism(Config config) {
        void var2_2;
        BoxedUnit boxedUnit;
        int maxParallelism;
        int n = maxParallelism = config.hasPath(this.MZDB_MAX_PARALLELISM_KEY()) ? config.getInt(this.MZDB_MAX_PARALLELISM_KEY()) : this.DEFAULT_MZDB_MAX_PARALLELISM();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{}={}", new Object[]{this.MZDB_MAX_PARALLELISM_KEY(), BoxesRunTime.boxToInteger((int)maxParallelism)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private String retrievePeakeldbTempDirectory(Config config) {
        void var2_2;
        BoxedUnit boxedUnit;
        String peakeldbTempDirectory;
        String string = peakeldbTempDirectory = config.hasPath(this.PEAKELDB_TEMP_DIRECTORY_KEY()) ? config.getString(this.PEAKELDB_TEMP_DIRECTORY_KEY()) : this.DEFAULT_PEAKELDB_TEMP_DIRECTORY();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{}={}", (Object[])new String[]{this.PEAKELDB_TEMP_DIRECTORY_KEY(), peakeldbTempDirectory});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean retrieveEnableImports(Config config) {
        void var2_2;
        boolean enableImports = false;
        if (config.hasPath(this.ENABLE_IMPORTS_KEY())) {
            enableImports = config.getBoolean(this.ENABLE_IMPORTS_KEY());
        }
        return (boolean)var2_2;
    }

    private NodeConfig$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.m_currentThread = Thread.currentThread();
        if (!(this.m_currentThread().getUncaughtExceptionHandler() instanceof ThreadLogger)) {
            this.m_currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadLogger(this.logger().underlying().getName()));
        }
        this.classLoader = this.getClass().getClassLoader();
        this._jmsConfParams = null;
        this.NODE_ID = UUID.randomUUID().toString();
        this.NODE_CONFIG_KEY = "node_config";
        this.fr$proline$jms$util$NodeConfig$$JMS_SERVER_HOST_KEY = "jms_server_host";
        this.fr$proline$jms$util$NodeConfig$$JMS_SERVER_PORT_KEY = "jms_server_port";
        this.PROLINE_SERVICE_REQUEST_QUEUE_KEY = "proline_service_request_queue_name";
        this.SERVICE_THREAD_POOL_SIZE_KEY = "service_thread_pool_size";
        this.MZDB_MAX_PARALLELISM_KEY = "mzdb_max_parallelism";
        this.PEAKELDB_TEMP_DIRECTORY_KEY = "peakeldb_temp_directory";
        this.ENABLE_IMPORTS_KEY = "enable_imports";
        this.DEFAULT_MZDB_MAX_PARALLELISM = 2;
        this.DEFAULT_PEAKELDB_TEMP_DIRECTORY = System.getProperty("java.io.tmpdir");
        this.DEFAULT_PROLINE_SERVICE_REQUEST_QUEUE_NAME = "ProlineServiceRequestQueue";
        this.ABSOLUTE_MAX_N_THREADS = 1000;
        this.AUTO_MAX_N_THREAD = 20;
        this.m_jmsConfig = this.getJMSConfigParams().getConfig(this.NODE_CONFIG_KEY());
        this.m_jmsServerHost = this.m_jmsConfig().getString(this.fr$proline$jms$util$NodeConfig$$JMS_SERVER_HOST_KEY());
        Predef$.MODULE$.require(!StringUtils.isEmpty((String)this.getJMSServerHost()), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)"Invalid \"").append((Object)NodeConfig$.MODULE$.fr$proline$jms$util$NodeConfig$$JMS_SERVER_HOST_KEY()).append((Object)"\" value").toString();
            }
        });
        this.m_jmsServerPort = this.m_jmsConfig().getInt(this.fr$proline$jms$util$NodeConfig$$JMS_SERVER_PORT_KEY());
        Predef$.MODULE$.require(0 < this.getJMSServerPort() && this.getJMSServerPort() <= JMSConstants$.MODULE$.MAX_JMS_SERVER_PORT(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)"Invalid \"").append((Object)NodeConfig$.MODULE$.fr$proline$jms$util$NodeConfig$$JMS_SERVER_PORT_KEY()).append((Object)"\" value").toString();
            }
        });
        this.PROLINE_EXPIRED_MESSAGE_QUEUE_NAME = "ExpiryQueue";
        this.PROLINE_SERVICE_REQUEST_QUEUE_NAME = this.retrieveQueueName(this.m_jmsConfig());
        this.SERVICE_THREAD_POOL_SIZE = this.retrieveThreadPoolSize(this.m_jmsConfig());
        this.ENABLE_IMPORTS = this.retrieveEnableImports(this.m_jmsConfig());
        this.MZDB_MAX_PARALLELISM = this.retrieveMzdbMaxParallelism(this.m_jmsConfig());
        this.PEAKELDB_TEMP_DIRECTORY = this.retrievePeakeldbTempDirectory(this.m_jmsConfig());
    }
}

