/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Event;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.LocalAddress;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyHelper;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.StackType;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

public class Configurator {
    protected static final Log log = LogFactory.getLog(Configurator.class);
    private final ProtocolStack stack;

    public Configurator() {
        this.stack = null;
    }

    public Configurator(ProtocolStack protocolStack) {
        this.stack = protocolStack;
    }

    public Protocol setupProtocolStack(List<ProtocolConfiguration> config) throws Exception {
        return Configurator.setupProtocolStack(config, this.stack);
    }

    public Protocol setupProtocolStack(ProtocolStack copySource) throws Exception {
        List<Protocol> protocols = copySource.copyProtocols(this.stack);
        Collections.reverse(protocols);
        return Configurator.connectProtocols(protocols);
    }

    private static Protocol setupProtocolStack(List<ProtocolConfiguration> protocol_configs, ProtocolStack st) throws Exception {
        List<Protocol> protocols = Configurator.createProtocols(protocol_configs, st);
        if (protocols == null) {
            return null;
        }
        Map<String, Map<String, InetAddressInfo>> inetAddressMap = Configurator.createInetAddressMap(protocol_configs, protocols);
        Collection<InetAddress> addrs = Configurator.getAddresses(inetAddressMap);
        StackType ip_version = Util.getIpStackType();
        if (!addrs.isEmpty()) {
            for (InetAddress addr : addrs) {
                if (addr instanceof Inet6Address && ip_version == StackType.IPv4) {
                    throw new IllegalArgumentException("found IPv6 address " + addr + " in an IPv4 stack");
                }
                if (!(addr instanceof Inet4Address) || !addr.isMulticastAddress() || ip_version != StackType.IPv6) continue;
                throw new Exception("found IPv4 multicast address " + addr + " in an IPv6 stack");
            }
        }
        Configurator.setDefaultValues(protocol_configs, protocols, ip_version);
        Configurator.ensureValidBindAddresses(protocols);
        Protocol top_protocol = protocols.get(protocols.size() - 1);
        top_protocol.setUpProtocol(st);
        return Configurator.connectProtocols(protocols);
    }

    public static void setDefaultValues(List<Protocol> protocols) throws Exception {
        if (protocols == null) {
            return;
        }
        List<InetAddress> addrs = Configurator.getInetAddresses(protocols);
        StackType ip_version = Util.getIpStackType();
        if (!addrs.isEmpty()) {
            for (InetAddress addr : addrs) {
                if (addr instanceof Inet6Address && ip_version == StackType.IPv4) {
                    throw new IllegalArgumentException("found IPv6 address " + addr + " in an IPv4 stack");
                }
                if (!(addr instanceof Inet4Address) || !addr.isMulticastAddress() || ip_version != StackType.IPv6) continue;
                throw new Exception("found IPv4 multicast address " + addr + " in an IPv6 stack");
            }
        }
        Configurator.setDefaultValues(protocols, ip_version);
    }

    public static Protocol createProtocol(String prot_spec, ProtocolStack stack) throws Exception {
        if (prot_spec == null) {
            throw new Exception("Configurator.createProtocol(): prot_spec is null");
        }
        ProtocolConfiguration config = new ProtocolConfiguration(prot_spec);
        Protocol prot = Configurator.createLayer(stack, config);
        prot.init();
        return prot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Protocol connectProtocols(List<Protocol> protocol_list) throws Exception {
        Protocol current_layer = null;
        Protocol next_layer = null;
        for (int i = 0; i < protocol_list.size(); ++i) {
            ConcurrentMap<String, Protocol> up_prots;
            TP transport;
            current_layer = protocol_list.get(i);
            if (i + 1 >= protocol_list.size()) break;
            next_layer = protocol_list.get(i + 1);
            next_layer.setDownProtocol(current_layer);
            current_layer.setUpProtocol(next_layer);
            if (!(current_layer instanceof TP) || !(transport = (TP)current_layer).isSingleton()) continue;
            ConcurrentMap<String, Protocol> concurrentMap = up_prots = transport.getUpProtocols();
            synchronized (concurrentMap) {
                String key;
                while (up_prots.containsKey(key = "dummy-" + System.currentTimeMillis())) {
                }
                up_prots.put(key, next_layer);
            }
            current_layer.setUpProtocol(null);
        }
        Configurator.sanityCheck(protocol_list);
        return current_layer;
    }

    private static List<String> parseProtocols(String config_str) throws IOException {
        LinkedList<String> retval = new LinkedList<String>();
        PushbackReader reader = new PushbackReader(new StringReader(config_str));
        boolean running = true;
        block0: while (running) {
            String protocol_name = Configurator.readWord(reader);
            StringBuilder sb = new StringBuilder();
            sb.append(protocol_name);
            int ch = Configurator.read(reader);
            if (ch == -1) {
                retval.add(sb.toString());
                break;
            }
            if (ch == 58) {
                retval.add(sb.toString());
                continue;
            }
            if (ch == 40) {
                reader.unread(ch);
                String attrs = Configurator.readUntil(reader, ')');
                sb.append(attrs);
                retval.add(sb.toString());
            } else {
                retval.add(sb.toString());
            }
            while ((ch = Configurator.read(reader)) != 58) {
                if (ch != -1) continue;
                running = false;
                continue block0;
            }
        }
        reader.close();
        return retval;
    }

    private static int read(Reader reader) throws IOException {
        int ch = -1;
        while ((ch = reader.read()) != -1) {
            if (Character.isWhitespace(ch)) continue;
            return ch;
        }
        return ch;
    }

    public static List<ProtocolConfiguration> parseConfigurations(String configuration) throws Exception {
        ArrayList<ProtocolConfiguration> retval = new ArrayList<ProtocolConfiguration>();
        List<String> protocol_string = Configurator.parseProtocols(configuration);
        if (protocol_string == null) {
            return null;
        }
        for (String component_string : protocol_string) {
            retval.add(new ProtocolConfiguration(component_string));
        }
        return retval;
    }

    public static String printConfigurations(Collection<ProtocolConfiguration> configs) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ProtocolConfiguration config : configs) {
            if (first) {
                first = false;
            } else {
                sb.append(":");
            }
            sb.append(config.getProtocolName());
            if (config.getProperties().isEmpty()) continue;
            sb.append('(').append(config.propertiesToString()).append(')');
        }
        return sb.toString();
    }

    private static String readUntil(Reader reader, char c) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = Configurator.read(reader)) != -1) {
            sb.append((char)ch);
            if (ch != c) continue;
            break;
        }
        return sb.toString();
    }

    private static String readWord(PushbackReader reader) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = Configurator.read(reader)) != -1) {
            if (Character.isLetterOrDigit(ch) || ch == 95 || ch == 46 || ch == 36) {
                sb.append((char)ch);
                continue;
            }
            reader.unread(ch);
            break;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Protocol> createProtocols(List<ProtocolConfiguration> protocol_configs, ProtocolStack stack) throws Exception {
        LinkedList<Protocol> retval = new LinkedList<Protocol>();
        for (int i = 0; i < protocol_configs.size(); ++i) {
            Protocol layer;
            ProtocolConfiguration protocol_config = protocol_configs.get(i);
            String singleton_name = protocol_config.getProperties().get("singleton_name");
            if (singleton_name != null && !singleton_name.trim().isEmpty()) {
                ConcurrentMap<String, Tuple<TP, ProtocolStack.RefCounter>> singleton_transports;
                ConcurrentMap<String, Tuple<TP, ProtocolStack.RefCounter>> concurrentMap = singleton_transports = ProtocolStack.getSingletonTransports();
                synchronized (concurrentMap) {
                    if (i > 0) {
                        throw new IllegalArgumentException("Property 'singleton_name' can only be used in a transport protocol (was used in " + protocol_config.getProtocolName() + ")");
                    }
                    Tuple val = (Tuple)singleton_transports.get(singleton_name);
                    Protocol protocol = layer = val != null ? (TP)val.getVal1() : null;
                    if (layer != null) {
                        retval.add(layer);
                    } else {
                        layer = Configurator.createLayer(stack, protocol_config);
                        if (layer == null) {
                            return null;
                        }
                        singleton_transports.put(singleton_name, new Tuple<TP, ProtocolStack.RefCounter>((TP)layer, new ProtocolStack.RefCounter(0, 0)));
                        retval.add(layer);
                    }
                    continue;
                }
            }
            layer = Configurator.createLayer(stack, protocol_config);
            if (layer == null) {
                return null;
            }
            retval.add(layer);
        }
        return retval;
    }

    protected static Protocol createLayer(ProtocolStack stack, ProtocolConfiguration config) throws Exception {
        String protocol_name = config.getProtocolName();
        HashMap<String, String> properties = new HashMap<String, String>(config.getProperties());
        Protocol retval = null;
        if (protocol_name == null || properties == null) {
            return null;
        }
        String defaultProtocolName = "org.jgroups.protocols." + protocol_name;
        Class clazz = null;
        try {
            clazz = Util.loadClass(defaultProtocolName, stack.getClass());
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = Util.loadClass(protocol_name, stack.getClass());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (clazz == null) {
                throw new Exception(String.format(Util.getMessage("ProtocolLoadError"), protocol_name, defaultProtocolName));
            }
        }
        try {
            AccessibleObject[] dependencyOrderedFieldsAndMethods;
            retval = (Protocol)clazz.newInstance();
            retval.setProtocolStack(stack);
            Configurator.removeDeprecatedProperties(retval, properties);
            for (AccessibleObject ordered : dependencyOrderedFieldsAndMethods = Configurator.computePropertyDependencies(retval, properties)) {
                if (ordered instanceof Field) {
                    Configurator.resolveAndAssignField(retval, (Field)ordered, properties);
                    continue;
                }
                if (!(ordered instanceof Method)) continue;
                Configurator.resolveAndInvokePropertyMethod(retval, (Method)ordered, properties);
            }
            List<Object> additional_objects = retval.getConfigurableObjects();
            if (additional_objects != null && !additional_objects.isEmpty()) {
                for (Object obj : additional_objects) {
                    Configurator.resolveAndAssignFields(obj, properties);
                    Configurator.resolveAndInvokePropertyMethods(obj, properties);
                }
            }
            if (!properties.isEmpty()) {
                throw new IllegalArgumentException(String.format(Util.getMessage("ConfigurationError"), protocol_name, properties));
            }
        }
        catch (InstantiationException inst_ex) {
            throw new InstantiationException(String.format(Util.getMessage("ProtocolCreateError"), protocol_name, inst_ex.getLocalizedMessage()));
        }
        return retval;
    }

    public static void sanityCheck(List<Protocol> protocols) throws Exception {
        HashSet<Short> ids = new HashSet<Short>();
        for (Protocol protocol : protocols) {
            short id = protocol.getId();
            if (id <= 0 || ids.add(id)) continue;
            throw new Exception("Protocol ID " + id + " (name=" + protocol.getName() + ") is duplicate; protocol IDs have to be unique");
        }
        for (Protocol protocol : protocols) {
            ArrayList<Integer> tmp;
            List<Integer> required_down_services = protocol.requiredDownServices();
            List<Integer> required_up_services = protocol.requiredUpServices();
            if (required_down_services != null && !required_down_services.isEmpty()) {
                tmp = new ArrayList<Integer>(required_down_services);
                Configurator.removeProvidedUpServices(protocol, tmp);
                if (!tmp.isEmpty()) {
                    throw new Exception("events " + Configurator.printEvents(tmp) + " are required by " + protocol.getName() + ", but not provided by any of the protocols below it");
                }
            }
            if (required_up_services == null || required_up_services.isEmpty()) continue;
            tmp = new ArrayList<Integer>(required_up_services);
            Configurator.removeProvidedDownServices(protocol, tmp);
            if (tmp.isEmpty()) continue;
            throw new Exception("events " + Configurator.printEvents(tmp) + " are required by " + protocol.getName() + ", but not provided by any of the protocols above it");
        }
    }

    protected static String printEvents(List<Integer> events) {
        StringBuilder sb = new StringBuilder("[");
        for (int evt : events) {
            sb.append(Event.type2String(evt)).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    protected static void removeProvidedUpServices(Protocol protocol, List<Integer> events) {
        if (protocol == null || events == null) {
            return;
        }
        for (Protocol prot = protocol.getDownProtocol(); prot != null && !events.isEmpty(); prot = prot.getDownProtocol()) {
            List<Integer> provided_up_services = prot.providedUpServices();
            if (provided_up_services == null || provided_up_services.isEmpty()) continue;
            events.removeAll(provided_up_services);
        }
    }

    protected static void removeProvidedDownServices(Protocol protocol, List<Integer> events) {
        if (protocol == null || events == null) {
            return;
        }
        for (Protocol prot = protocol.getUpProtocol(); prot != null && !events.isEmpty(); prot = prot.getUpProtocol()) {
            List<Integer> provided_down_services = prot.providedDownServices();
            if (provided_down_services == null || provided_down_services.isEmpty()) continue;
            events.removeAll(provided_down_services);
        }
    }

    public static Collection<InetAddress> getAddresses(Map<String, Map<String, InetAddressInfo>> inetAddressMap) throws Exception {
        HashSet<InetAddress> addrs = new HashSet<InetAddress>();
        for (Map.Entry<String, Map<String, InetAddressInfo>> inetAddressMapEntry : inetAddressMap.entrySet()) {
            Map<String, InetAddressInfo> protocolInetAddressMap = inetAddressMapEntry.getValue();
            for (Map.Entry<String, InetAddressInfo> protocolInetAddressMapEntry : protocolInetAddressMap.entrySet()) {
                InetAddressInfo inetAddressInfo = protocolInetAddressMapEntry.getValue();
                List<InetAddress> addresses = inetAddressInfo.getInetAddresses();
                for (InetAddress address : addresses) {
                    if (address == null) {
                        throw new RuntimeException("failed converting address info to IP address: " + inetAddressInfo);
                    }
                    addrs.add(address);
                }
            }
        }
        return addrs;
    }

    public static StackType determineIpVersionFromAddresses(Collection<InetAddress> addrs) throws Exception {
        HashSet<InetAddress> ipv4_addrs = new HashSet<InetAddress>();
        HashSet<InetAddress> ipv6_addrs = new HashSet<InetAddress>();
        for (InetAddress address : addrs) {
            if (address instanceof Inet4Address) {
                ipv4_addrs.add(address);
                continue;
            }
            ipv6_addrs.add(address);
        }
        if (log.isTraceEnabled()) {
            log.trace("all addrs=" + addrs + ", IPv4 addrs=" + ipv4_addrs + ", IPv6 addrs=" + ipv6_addrs);
        }
        if (!addrs.isEmpty()) {
            if (!ipv4_addrs.isEmpty() && !ipv6_addrs.isEmpty()) {
                throw new RuntimeException("all addresses have to be either IPv4 or IPv6: IPv4 addresses=" + ipv4_addrs + ", IPv6 addresses=" + ipv6_addrs);
            }
            return !ipv6_addrs.isEmpty() ? StackType.IPv6 : StackType.IPv4;
        }
        return StackType.Unknown;
    }

    public static Map<String, Map<String, InetAddressInfo>> createInetAddressMap(List<ProtocolConfiguration> protocol_configs, List<Protocol> protocols) throws Exception {
        HashMap<String, Map<String, InetAddressInfo>> inetAddressMap = new HashMap<String, Map<String, InetAddressInfo>>();
        for (int i = 0; i < protocol_configs.size(); ++i) {
            ProtocolConfiguration protocol_config = protocol_configs.get(i);
            Protocol protocol = protocols.get(i);
            String protocolName = protocol.getName();
            HashMap<String, String> properties = new HashMap<String, String>(protocol_config.getProperties());
            Method[] methods = Util.getAllDeclaredMethodsWithAnnotations(protocol.getClass(), Property.class);
            for (int j = 0; j < methods.length; ++j) {
                if (!methods[j].isAnnotationPresent(Property.class) || !Configurator.isSetPropertyMethod(methods[j])) continue;
                String propertyName = PropertyHelper.getPropertyName(methods[j]);
                String propertyValue = (String)properties.get(propertyName);
                String tmp = Configurator.grabSystemProp(methods[j].getAnnotation(Property.class));
                if (tmp != null) {
                    propertyValue = tmp;
                }
                if (propertyValue == null || !InetAddressInfo.isInetAddressRelated(methods[j])) continue;
                Object converted = null;
                try {
                    converted = PropertyHelper.getConvertedValue((Object)protocol, methods[j], properties, propertyValue, false);
                }
                catch (Exception e) {
                    throw new Exception("String value could not be converted for method " + propertyName + " in " + protocolName + " with default value " + propertyValue + ".Exception is " + e, e);
                }
                InetAddressInfo inetinfo = new InetAddressInfo(protocol, methods[j], properties, propertyValue, converted);
                HashMap<String, InetAddressInfo> protocolInetAddressMap = (HashMap<String, InetAddressInfo>)inetAddressMap.get(protocolName);
                if (protocolInetAddressMap == null) {
                    protocolInetAddressMap = new HashMap<String, InetAddressInfo>();
                    inetAddressMap.put(protocolName, protocolInetAddressMap);
                }
                protocolInetAddressMap.put(propertyName, inetinfo);
            }
            for (Class<?> clazz = protocol.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                Field[] fields = clazz.getDeclaredFields();
                for (int j = 0; j < fields.length; ++j) {
                    if (!fields[j].isAnnotationPresent(Property.class)) continue;
                    String propertyName = PropertyHelper.getPropertyName(fields[j], properties);
                    String propertyValue = (String)properties.get(propertyName);
                    String tmp = Configurator.grabSystemProp(fields[j].getAnnotation(Property.class));
                    if (tmp != null) {
                        propertyValue = tmp;
                    }
                    if (propertyValue == null && PropertyHelper.usesDefaultConverter(fields[j]) || !InetAddressInfo.isInetAddressRelated(protocol, fields[j])) continue;
                    Object converted = null;
                    try {
                        converted = PropertyHelper.getConvertedValue((Object)protocol, fields[j], properties, propertyValue, false);
                    }
                    catch (Exception e) {
                        throw new Exception("String value could not be converted for method " + propertyName + " in " + protocolName + " with default value " + propertyValue + ".Exception is " + e, e);
                    }
                    InetAddressInfo inetinfo = new InetAddressInfo(protocol, fields[j], properties, propertyValue, converted);
                    HashMap<String, InetAddressInfo> protocolInetAddressMap = (HashMap<String, InetAddressInfo>)inetAddressMap.get(protocolName);
                    if (protocolInetAddressMap == null) {
                        protocolInetAddressMap = new HashMap<String, InetAddressInfo>();
                        inetAddressMap.put(protocolName, protocolInetAddressMap);
                    }
                    protocolInetAddressMap.put(propertyName, inetinfo);
                }
            }
        }
        return inetAddressMap;
    }

    public static List<InetAddress> getInetAddresses(List<Protocol> protocols) throws Exception {
        LinkedList<InetAddress> retval = new LinkedList<InetAddress>();
        for (Protocol protocol : protocols) {
            for (Class<?> clazz = protocol.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                Field[] fields = clazz.getDeclaredFields();
                for (int j = 0; j < fields.length; ++j) {
                    if (!fields[j].isAnnotationPresent(Property.class) || !InetAddressInfo.isInetAddressRelated(protocol, fields[j])) continue;
                    Object value = Configurator.getValueFromProtocol(protocol, fields[j]);
                    if (value instanceof InetAddress) {
                        retval.add((InetAddress)value);
                        continue;
                    }
                    if (value instanceof IpAddress) {
                        retval.add(((IpAddress)value).getIpAddress());
                        continue;
                    }
                    if (!(value instanceof InetSocketAddress)) continue;
                    retval.add(((InetSocketAddress)value).getAddress());
                }
            }
        }
        return retval;
    }

    public static void setDefaultValues(List<ProtocolConfiguration> protocol_configs, List<Protocol> protocols, StackType ip_version) throws Exception {
        InetAddress default_ip_address = Util.getNonLoopbackAddress();
        if (default_ip_address == null) {
            log.warn("unable to find an address other than loopback for IP version " + (Object)((Object)ip_version));
            default_ip_address = Util.getLocalhost(ip_version);
        }
        for (int i = 0; i < protocol_configs.size(); ++i) {
            ProtocolConfiguration protocol_config = protocol_configs.get(i);
            Protocol protocol = protocols.get(i);
            String protocolName = protocol.getName();
            HashMap<String, String> properties = new HashMap<String, String>(protocol_config.getProperties());
            Method[] methods = Util.getAllDeclaredMethodsWithAnnotations(protocol.getClass(), Property.class);
            for (int j = 0; j < methods.length; ++j) {
                String propertyName;
                Object propertyValue;
                if (!Configurator.isSetPropertyMethod(methods[j]) || (propertyValue = Configurator.getValueFromProtocol(protocol, propertyName = PropertyHelper.getPropertyName(methods[j]))) != null) continue;
                Property annotation = methods[j].getAnnotation(Property.class);
                String defaultValue = null;
                if (!InetAddressInfo.isInetAddressRelated(methods[j])) continue;
                String string = defaultValue = ip_version == StackType.IPv4 ? annotation.defaultValueIPv4() : annotation.defaultValueIPv6();
                if (defaultValue == null || defaultValue.isEmpty()) continue;
                Object converted = null;
                try {
                    converted = defaultValue.equalsIgnoreCase("NON_LOOPBACK_ADDRESS") ? default_ip_address : PropertyHelper.getConvertedValue((Object)protocol, methods[j], properties, defaultValue, true);
                    methods[j].invoke((Object)protocol, converted);
                }
                catch (Exception e) {
                    throw new Exception("default could not be assigned for method " + propertyName + " in " + protocolName + " with default " + defaultValue, e);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("set property " + protocolName + "." + propertyName + " to default value " + converted);
            }
            Field[] fields = Util.getAllDeclaredFieldsWithAnnotations(protocol.getClass(), Property.class);
            for (int j = 0; j < fields.length; ++j) {
                String propertyName = PropertyHelper.getPropertyName(fields[j], properties);
                Object propertyValue = Configurator.getValueFromProtocol(protocol, fields[j]);
                if (propertyValue != null) continue;
                Property annotation = fields[j].getAnnotation(Property.class);
                String defaultValue = null;
                if (!InetAddressInfo.isInetAddressRelated(protocol, fields[j])) continue;
                String string = defaultValue = ip_version == StackType.IPv4 ? annotation.defaultValueIPv4() : annotation.defaultValueIPv6();
                if (defaultValue == null || defaultValue.isEmpty() || defaultValue == null && PropertyHelper.usesDefaultConverter(fields[j])) continue;
                Object converted = null;
                try {
                    converted = defaultValue.equalsIgnoreCase("NON_LOOPBACK_ADDRESS") ? default_ip_address : PropertyHelper.getConvertedValue((Object)protocol, fields[j], properties, defaultValue, true);
                    if (converted != null) {
                        Util.setField(fields[j], protocol, converted);
                    }
                }
                catch (Exception e) {
                    throw new Exception("default could not be assigned for field " + propertyName + " in " + protocolName + " with default value " + defaultValue, e);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("set property " + protocolName + "." + propertyName + " to default value " + converted);
            }
        }
    }

    public static void setDefaultValues(List<Protocol> protocols, StackType ip_version) throws Exception {
        InetAddress default_ip_address = Util.getNonLoopbackAddress();
        if (default_ip_address == null) {
            log.warn("unable to find an address other than loopback for IP version " + (Object)((Object)ip_version));
            default_ip_address = Util.getLocalhost(ip_version);
        }
        for (Protocol protocol : protocols) {
            String protocolName = protocol.getName();
            Field[] fields = Util.getAllDeclaredFieldsWithAnnotations(protocol.getClass(), Property.class);
            for (int j = 0; j < fields.length; ++j) {
                String defaultValue;
                Object propertyValue;
                if (!InetAddressInfo.isInetAddressRelated(protocol, fields[j]) || (propertyValue = Configurator.getValueFromProtocol(protocol, fields[j])) != null) continue;
                Property annotation = fields[j].getAnnotation(Property.class);
                String string = defaultValue = ip_version == StackType.IPv4 ? annotation.defaultValueIPv4() : annotation.defaultValueIPv6();
                if (defaultValue == null || defaultValue.isEmpty()) continue;
                Object converted = null;
                try {
                    converted = defaultValue.equalsIgnoreCase("NON_LOOPBACK_ADDRESS") ? default_ip_address : PropertyHelper.getConvertedValue(protocol, fields[j], defaultValue, true);
                    if (converted != null) {
                        Util.setField(fields[j], protocol, converted);
                    }
                }
                catch (Exception e) {
                    throw new Exception("default could not be assigned for field " + fields[j].getName() + " in " + protocolName + " with default value " + defaultValue, e);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("set property " + protocolName + "." + fields[j].getName() + " to default value " + converted);
            }
        }
    }

    public static void ensureValidBindAddresses(List<Protocol> protocols) throws Exception {
        for (Protocol protocol : protocols) {
            String protocolName = protocol.getName();
            Field[] fields = Util.getAllDeclaredFieldsWithAnnotations(protocol.getClass(), LocalAddress.class);
            for (int i = 0; i < fields.length; ++i) {
                Object val = Configurator.getValueFromProtocol(protocol, fields[i]);
                if (val == null) continue;
                if (!(val instanceof InetAddress)) {
                    throw new Exception("field " + protocolName + "." + fields[i].getName() + " is not an InetAddress");
                }
                Util.checkIfValidAddress((InetAddress)val, protocolName);
            }
        }
    }

    public static Object getValueFromProtocol(Protocol protocol, Field field) throws IllegalAccessException {
        if (protocol == null || field == null) {
            return null;
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            field.setAccessible(true);
        }
        return field.get(protocol);
    }

    public static Object getValueFromProtocol(Protocol protocol, String field_name) throws IllegalAccessException {
        if (protocol == null || field_name == null) {
            return null;
        }
        Field field = Util.getField(protocol.getClass(), field_name);
        return field != null ? Configurator.getValueFromProtocol(protocol, field) : null;
    }

    static AccessibleObject[] computePropertyDependencies(Object obj, Map<String, String> properties) {
        LinkedList<AccessibleObject> unorderedFieldsAndMethods = new LinkedList<AccessibleObject>();
        List<Object> orderedFieldsAndMethods = new LinkedList();
        HashMap<String, AccessibleObject> propertiesInventory = new HashMap<String, AccessibleObject>();
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].isAnnotationPresent(Property.class) || !Configurator.isSetPropertyMethod(methods[i])) continue;
            String propertyName = PropertyHelper.getPropertyName(methods[i]);
            unorderedFieldsAndMethods.add(methods[i]);
            propertiesInventory.put(propertyName, methods[i]);
        }
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].isAnnotationPresent(Property.class)) continue;
                String propertyName = PropertyHelper.getPropertyName(fields[i], properties);
                unorderedFieldsAndMethods.add(fields[i]);
                propertiesInventory.put(propertyName, fields[i]);
            }
        }
        Configurator.checkDependencyReferencesPresent(unorderedFieldsAndMethods, propertiesInventory);
        orderedFieldsAndMethods = Configurator.orderFieldsAndMethodsByDependency(unorderedFieldsAndMethods, propertiesInventory);
        AccessibleObject[] result = new AccessibleObject[orderedFieldsAndMethods.size()];
        for (int i = 0; i < orderedFieldsAndMethods.size(); ++i) {
            result[i] = (AccessibleObject)orderedFieldsAndMethods.get(i);
        }
        return result;
    }

    static List<AccessibleObject> orderFieldsAndMethodsByDependency(List<AccessibleObject> unorderedList, Map<String, AccessibleObject> propertiesMap) {
        Stack<AccessibleObject> stack = new Stack<AccessibleObject>();
        LinkedList<AccessibleObject> orderedList = new LinkedList<AccessibleObject>();
        for (int i = 0; i < unorderedList.size(); ++i) {
            AccessibleObject obj = unorderedList.get(i);
            Configurator.addPropertyToDependencyList(orderedList, propertiesMap, stack, obj);
        }
        return orderedList;
    }

    static void addPropertyToDependencyList(List<AccessibleObject> orderedList, Map<String, AccessibleObject> props, Stack<AccessibleObject> stack, AccessibleObject obj) {
        if (orderedList.contains(obj)) {
            return;
        }
        if (stack.search(obj) > 0) {
            throw new RuntimeException("Deadlock in @Property dependency processing");
        }
        stack.push(obj);
        Property annotation = obj.getAnnotation(Property.class);
        String dependsClause = annotation.dependsUpon();
        StringTokenizer st = new StringTokenizer(dependsClause, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            AccessibleObject dep = props.get(token);
            Configurator.addPropertyToDependencyList(orderedList, props, stack, dep);
        }
        stack.pop();
        orderedList.add(obj);
    }

    static void checkDependencyReferencesPresent(List<AccessibleObject> objects, Map<String, AccessibleObject> props) {
        for (int i = 0; i < objects.size(); ++i) {
            AccessibleObject ao = objects.get(i);
            Property annotation = ao.getAnnotation(Property.class);
            if (annotation == null) {
                throw new IllegalArgumentException("@Property annotation is required for checking dependencies; annotation is missing for Field/Method " + ao.toString());
            }
            String dependsClause = annotation.dependsUpon();
            if (dependsClause.trim().isEmpty()) continue;
            StringTokenizer st = new StringTokenizer(dependsClause, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                boolean found = false;
                Set<String> keyset = props.keySet();
                Iterator<String> iter = keyset.iterator();
                while (iter.hasNext()) {
                    if (!iter.next().equals(token)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("@Property annotation " + annotation.name() + " has an unresolved dependsUpon property: " + token);
            }
        }
    }

    public static void resolveAndInvokePropertyMethods(Object obj, Map<String, String> props) throws Exception {
        Method[] methods;
        for (Method method : methods = obj.getClass().getMethods()) {
            Configurator.resolveAndInvokePropertyMethod(obj, method, props);
        }
    }

    public static void resolveAndInvokePropertyMethod(Object obj, Method method, Map<String, String> props) throws Exception {
        String methodName = method.getName();
        Property annotation = method.getAnnotation(Property.class);
        if (annotation != null && Configurator.isSetPropertyMethod(method)) {
            String deprecated_msg;
            String propertyName = PropertyHelper.getPropertyName(method);
            String propertyValue = props.get(propertyName);
            String tmp = Configurator.grabSystemProp(method.getAnnotation(Property.class));
            if (tmp != null) {
                propertyValue = tmp;
            }
            if (propertyName != null && propertyValue != null && (deprecated_msg = annotation.deprecatedMessage()) != null && !deprecated_msg.isEmpty()) {
                log.warn(Util.getMessage("Deprecated"), method.getDeclaringClass().getSimpleName() + "." + methodName, deprecated_msg);
            }
            if (propertyValue != null) {
                Object converted = null;
                try {
                    converted = PropertyHelper.getConvertedValue(obj, method, props, propertyValue, true);
                    method.invoke(obj, converted);
                }
                catch (Exception e) {
                    String name = obj instanceof Protocol ? ((Protocol)obj).getName() : obj.getClass().getName();
                    throw new Exception("Could not assign property " + propertyName + " in " + name + ", method is " + methodName + ", converted value is " + converted, e);
                }
            }
            props.remove(propertyName);
        }
    }

    public static void resolveAndAssignFields(Object obj, Map<String, String> props) throws Exception {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Configurator.resolveAndAssignField(obj, field, props);
            }
        }
    }

    public static void resolveAndAssignField(Object obj, Field field, Map<String, String> props) throws Exception {
        Property annotation = field.getAnnotation(Property.class);
        if (annotation != null) {
            String deprecated_msg;
            String propertyName = PropertyHelper.getPropertyName(field, props);
            String propertyValue = props.get(propertyName);
            String tmp = Configurator.grabSystemProp(field.getAnnotation(Property.class));
            if (tmp != null) {
                propertyValue = tmp;
            }
            if (propertyName != null && propertyValue != null && (deprecated_msg = annotation.deprecatedMessage()) != null && !deprecated_msg.isEmpty()) {
                log.warn(Util.getMessage("Deprecated"), field.getDeclaringClass().getSimpleName() + "." + field.getName(), deprecated_msg);
            }
            if (propertyValue != null || !PropertyHelper.usesDefaultConverter(field)) {
                Object converted = null;
                try {
                    converted = PropertyHelper.getConvertedValue(obj, field, props, propertyValue, true);
                    if (converted != null) {
                        Util.setField(field, obj, converted);
                    }
                }
                catch (Exception e) {
                    String name = obj instanceof Protocol ? ((Protocol)obj).getName() : obj.getClass().getName();
                    throw new Exception("Property assignment of " + propertyName + " in " + name + " with original property value " + propertyValue + " and converted to " + converted + " could not be assigned", e);
                }
            }
            props.remove(propertyName);
        }
    }

    public static void removeDeprecatedProperties(Object obj, Map<String, String> props) throws Exception {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            String[] deprecatedProperties;
            if (!clazz.isAnnotationPresent(DeprecatedProperty.class)) continue;
            DeprecatedProperty declaredAnnotation = clazz.getAnnotation(DeprecatedProperty.class);
            for (String propertyName : deprecatedProperties = declaredAnnotation.names()) {
                String propertyValue = props.get(propertyName);
                if (propertyValue == null) continue;
                if (log.isWarnEnabled()) {
                    String name = obj instanceof Protocol ? ((Protocol)obj).getName() : obj.getClass().getName();
                    log.warn(name + " property " + propertyName + " was deprecated and is ignored");
                }
                props.remove(propertyName);
            }
        }
    }

    public static boolean isSetPropertyMethod(Method method) {
        return method.getName().startsWith("set") && method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 1;
    }

    private static String grabSystemProp(Property annotation) {
        String[] system_property_names = annotation.systemProperty();
        String retval = null;
        for (String system_property_name : system_property_names) {
            if (system_property_name == null || system_property_name.isEmpty() || system_property_name.equals("jgroups.bind_addr") && Util.isBindAddressPropertyIgnored()) continue;
            try {
                retval = System.getProperty(system_property_name);
                if (retval == null) continue;
                return retval;
            }
            catch (SecurityException ex) {
                log.error("failed getting system property for " + system_property_name, ex);
            }
        }
        return retval;
    }

    public static class InetAddressInfo {
        Protocol protocol;
        AccessibleObject fieldOrMethod;
        Map<String, String> properties;
        String propertyName;
        String stringValue;
        Object convertedValue;
        boolean isField;
        boolean isParameterized;
        Object baseType;

        InetAddressInfo(Protocol protocol, AccessibleObject fieldOrMethod, Map<String, String> properties, String stringValue, Object convertedValue) {
            if (protocol == null) {
                throw new IllegalArgumentException("Protocol for Field/Method must be non-null");
            }
            if (fieldOrMethod instanceof Field) {
                this.isField = true;
            } else if (fieldOrMethod instanceof Method) {
                this.isField = false;
            } else {
                throw new IllegalArgumentException("AccesibleObject is neither Field nor Method");
            }
            if (properties == null) {
                throw new IllegalArgumentException("Properties for Field/Method must be non-null");
            }
            this.protocol = protocol;
            this.fieldOrMethod = fieldOrMethod;
            this.properties = properties;
            this.stringValue = stringValue;
            this.convertedValue = convertedValue;
            this.propertyName = this.isField() ? PropertyHelper.getPropertyName((Field)fieldOrMethod, properties) : PropertyHelper.getPropertyName((Method)fieldOrMethod);
            this.isParameterized = false;
            this.isParameterized = this.isField() ? InetAddressInfo.hasParameterizedType((Field)fieldOrMethod) : InetAddressInfo.hasParameterizedType((Method)fieldOrMethod);
            this.baseType = null;
            if (this.isField() && this.isParameterized) {
                ParameterizedType fpt = (ParameterizedType)((Field)fieldOrMethod).getGenericType();
                this.baseType = fpt.getActualTypeArguments()[0];
            } else if (!this.isField() && this.isParameterized) {
                Type[] types = ((Method)fieldOrMethod).getGenericParameterTypes();
                ParameterizedType mpt = (ParameterizedType)types[0];
                this.baseType = mpt.getActualTypeArguments()[0];
            }
        }

        Object getProtocol() {
            return this.protocol;
        }

        AccessibleObject getFieldOrMethod() {
            return this.fieldOrMethod;
        }

        boolean isField() {
            return this.isField;
        }

        String getStringValue() {
            return this.stringValue;
        }

        String getPropertyName() {
            return this.propertyName;
        }

        Map<String, String> getProperties() {
            return this.properties;
        }

        Object getConvertedValue() {
            return this.convertedValue;
        }

        boolean isParameterized() {
            return this.isParameterized;
        }

        Object getBaseType() {
            return this.baseType;
        }

        static boolean hasParameterizedType(Field f) {
            if (f == null) {
                throw new IllegalArgumentException("Field argument is null");
            }
            Type type = f.getGenericType();
            return type instanceof ParameterizedType;
        }

        static boolean hasParameterizedType(Method m) throws IllegalArgumentException {
            if (m == null) {
                throw new IllegalArgumentException("Method argument is null");
            }
            Type[] types = m.getGenericParameterTypes();
            return types[0] instanceof ParameterizedType;
        }

        static boolean isInetAddressRelated(Protocol prot, Field f) {
            if (InetAddressInfo.hasParameterizedType(f)) {
                ParameterizedType fieldtype = (ParameterizedType)f.getGenericType();
                try {
                    InetAddressInfo.parameterizedTypeSanityCheck(fieldtype);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
                Class listType = (Class)fieldtype.getActualTypeArguments()[0];
                return InetAddressInfo.isInetAddressOrCompatibleType(listType);
            }
            Class<?> fieldtype = f.getType();
            return InetAddressInfo.isInetAddressOrCompatibleType(fieldtype);
        }

        static boolean isInetAddressRelated(Method m) {
            if (InetAddressInfo.hasParameterizedType(m)) {
                Type[] types = m.getGenericParameterTypes();
                ParameterizedType methodParamType = (ParameterizedType)types[0];
                try {
                    InetAddressInfo.parameterizedTypeSanityCheck(methodParamType);
                }
                catch (IllegalArgumentException e) {
                    if (log.isErrorEnabled()) {
                        log.error("Method " + m.getName() + " failed paramaterizedTypeSanityCheck()");
                    }
                    return false;
                }
                Class listType = (Class)methodParamType.getActualTypeArguments()[0];
                return InetAddressInfo.isInetAddressOrCompatibleType(listType);
            }
            Class<?> methodParamType = m.getParameterTypes()[0];
            return InetAddressInfo.isInetAddressOrCompatibleType(methodParamType);
        }

        static boolean isInetAddressOrCompatibleType(Class<?> c) {
            return c.equals(InetAddress.class) || c.equals(InetSocketAddress.class) || c.equals(IpAddress.class);
        }

        static void parameterizedTypeSanityCheck(ParameterizedType pt) throws IllegalArgumentException {
            Type rawType = pt.getRawType();
            Type[] actualTypes = pt.getActualTypeArguments();
            if (!(rawType instanceof Class) || !rawType.equals(List.class)) {
                throw new IllegalArgumentException("Invalid parameterized type definition - parameterized type must be a List");
            }
            if (!(actualTypes[0] instanceof Class)) {
                throw new IllegalArgumentException("Invalid parameterized type - List must not contain a parameterized type");
            }
        }

        public List<InetAddress> getInetAddresses() {
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            if (this.getConvertedValue() == null) {
                return addresses;
            }
            if (!this.isParameterized()) {
                addresses.add(InetAddressInfo.getInetAddress(this.getConvertedValue()));
                return addresses;
            }
            List values = (List)this.getConvertedValue();
            if (values.isEmpty()) {
                return addresses;
            }
            for (int i = 0; i < values.size(); ++i) {
                addresses.add(InetAddressInfo.getInetAddress(values.get(i)));
            }
            return addresses;
        }

        private static InetAddress getInetAddress(Object obj) throws IllegalArgumentException {
            if (obj == null) {
                throw new IllegalArgumentException("Input argument must represent a non-null IP address");
            }
            if (obj instanceof InetAddress) {
                return (InetAddress)obj;
            }
            if (obj instanceof IpAddress) {
                return ((IpAddress)obj).getIpAddress();
            }
            if (obj instanceof InetSocketAddress) {
                return ((InetSocketAddress)obj).getAddress();
            }
            if (log.isWarnEnabled()) {
                log.warn("Input argument does not represent one of InetAddress...: class=" + obj.getClass().getName());
            }
            throw new IllegalArgumentException("Input argument does not represent one of InetAddress. IpAddress not InetSocketAddress");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("InetAddressInfo(");
            sb.append("protocol=" + this.protocol.getName());
            sb.append(", propertyName=" + this.getPropertyName());
            sb.append(", string value=" + this.getStringValue());
            sb.append(", parameterized=" + this.isParameterized());
            if (this.isParameterized()) {
                sb.append(", baseType=" + this.getBaseType());
            }
            sb.append(")");
            return sb.toString();
        }
    }
}

