/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewActionHandler;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.DataViewTableUIModel;
import org.netbeans.modules.db.dataview.table.JXTableRowHeader;
import org.netbeans.modules.db.dataview.table.MultiColPatternFilter;
import org.netbeans.modules.db.dataview.table.SuperPatternFilter;
import org.openide.awt.MouseUtils;
import org.openide.util.NbBundle;

class DataViewUI
extends JXPanel {
    private JXButton commit;
    private JXButton refreshButton;
    private JXButton truncateButton;
    private JXButton next;
    private JXButton last;
    private JXButton previous;
    private JXButton first;
    private JXButton deleteRow;
    private JXButton insert;
    private JTextField refreshField;
    private JTextField matchBoxField;
    private JXLabel totalRowsLabel;
    private JXLabel limitRow;
    private JXButton[] editButtons = new JXButton[5];
    private DataViewTableUI dataPanel;
    private JScrollPane dataPanelScrollPane;
    private final DataViewPageContext pageContext;
    private JXButton cancel;
    private DataViewActionHandler actionHandler;
    private String imgPrefix = "/org/netbeans/modules/db/dataview/images/";
    private static final int MAX_TAB_LENGTH = 25;
    private final PropertyChangeListener pageContextListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DataViewUI.this.updateTotalCountLabel();
        }
    };
    private static final MouseListener sharedMouseListener = new MouseUtils.PopupMouseAdapter(){

        public void mouseEntered(MouseEvent evt) {
            AbstractButton button;
            Object src = evt.getSource();
            if (src instanceof AbstractButton && (button = (AbstractButton)evt.getSource()).isEnabled()) {
                button.setContentAreaFilled(true);
                button.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent evt) {
            Object src = evt.getSource();
            if (src instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)evt.getSource();
                button.setContentAreaFilled(false);
                button.setBorderPainted(false);
            }
        }

        protected void showPopup(MouseEvent evt) {
        }
    };
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);

    DataViewUI(DataView dataView, DataViewPageContext pageContext, boolean nbOutputComponent) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT thread";
        this.pageContext = pageContext;
        this.putClientProperty("TabPolicy", "HideWhenAlone");
        this.putClientProperty("PersistenceType", "Never");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        JPanel panel = this.initializeMainPanel(nbOutputComponent);
        this.add(panel, "North");
        this.actionHandler = new DataViewActionHandler(this, dataView, pageContext);
        this.dataPanel = new DataViewTableUI(this, this.actionHandler, dataView, pageContext);
        this.dataPanelScrollPane = new JScrollPane((Component)((Object)this.dataPanel));
        JXTableRowHeader rowHeader = new JXTableRowHeader(this.dataPanel);
        this.dataPanelScrollPane.setRowHeaderView(rowHeader);
        this.dataPanelScrollPane.setCorner("UPPER_LEFT_CORNER", rowHeader.getTableHeader());
        this.add(this.dataPanelScrollPane, "Center");
        this.dataPanel.revalidate();
        this.dataPanel.repaint();
        this.dataPanel.setModel(pageContext.getModel());
        pageContext.addPropertyChangeListener(this.pageContextListener);
        this.updateTotalCountLabel();
    }

    void handleColumnUpdated() {
        boolean editMode = this.dataPanel.getModel().hasUpdates();
        this.commit.setEnabled(editMode);
        this.cancel.setEnabled(editMode);
        this.insert.setEnabled(!editMode);
        this.deleteRow.setEnabled(!editMode);
        this.truncateButton.setEnabled(!editMode);
    }

    JButton[] getEditButtons() {
        return this.editButtons;
    }

    final void updateTotalCountLabel() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT thread";
        if (this.pageContext.isTotalRowCountAvailable()) {
            this.totalRowsLabel.setText(this.pageContext.getTotalRows() + "   " + this.pageContext.pageOf());
        } else {
            this.totalRowsLabel.setText(NbBundle.getMessage(DataViewUI.class, (String)"LBL_not_available") + " " + this.pageContext.pageOf());
        }
    }

    boolean isCommitEnabled() {
        return this.commit.isEnabled();
    }

    DataViewTableUI getDataViewTableUI() {
        return this.dataPanel;
    }

    DataViewTableUIModel getDataViewTableUIModel() {
        return this.dataPanel.getModel();
    }

    void setCommitEnabled(boolean flag) {
        this.commit.setEnabled(flag);
    }

    void setCancelEnabled(boolean flag) {
        this.cancel.setEnabled(flag);
    }

    void disableButtons() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT thread";
        this.truncateButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.refreshField.setEnabled(false);
        this.matchBoxField.setEditable(false);
        this.first.setEnabled(false);
        this.previous.setEnabled(false);
        this.next.setEnabled(false);
        this.last.setEnabled(false);
        this.deleteRow.setEnabled(false);
        this.commit.setEnabled(false);
        this.cancel.setEnabled(false);
        this.insert.setEnabled(false);
        this.dataPanel.revalidate();
        this.dataPanel.repaint();
    }

    int getPageSize() {
        int pageSize = this.pageContext.getPageSize();
        int totalCount = this.pageContext.getTotalRows();
        try {
            int count = Integer.parseInt(this.refreshField.getText().trim());
            return count < 0 ? pageSize : count;
        }
        catch (NumberFormatException ex) {
            return totalCount < pageSize ? totalCount : pageSize;
        }
    }

    boolean isDirty() {
        return this.dataPanel.getModel().hasUpdates();
    }

    void resetToolbar(boolean wasError) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT thread";
        this.refreshButton.setEnabled(true);
        this.refreshField.setEnabled(true);
        this.matchBoxField.setEditable(true);
        this.deleteRow.setEnabled(false);
        if (!wasError) {
            if (this.pageContext.hasPrevious()) {
                this.first.setEnabled(true);
                this.previous.setEnabled(true);
            }
            if (this.pageContext.hasNext()) {
                this.next.setEnabled(true);
                if (this.pageContext.getTotalRows() >= 0) {
                    this.last.setEnabled(true);
                }
            }
            if (this.pageContext.hasOnePageOnly()) {
                this.first.setEnabled(false);
                this.previous.setEnabled(false);
            }
            if (this.pageContext.isLastPage()) {
                this.next.setEnabled(false);
                this.last.setEnabled(false);
            }
            if (!this.dataPanel.getModel().isEditable()) {
                this.commit.setEnabled(false);
                this.cancel.setEnabled(false);
                this.deleteRow.setEnabled(false);
                this.insert.setEnabled(false);
                this.truncateButton.setEnabled(false);
            } else {
                if (this.pageContext.hasRows()) {
                    this.truncateButton.setEnabled(true);
                } else {
                    this.deleteRow.setEnabled(false);
                    this.truncateButton.setEnabled(false);
                    this.pageContext.first();
                }
                this.insert.setEnabled(true);
                if (this.getDataViewTableUIModel().getUpdateKeys().isEmpty()) {
                    this.commit.setEnabled(false);
                    this.cancel.setEnabled(false);
                } else {
                    this.commit.setEnabled(true);
                    this.cancel.setEnabled(true);
                }
            }
        } else {
            this.disableButtons();
        }
        this.refreshField.setText("" + this.pageContext.getPageSize());
        if (this.dataPanel != null) {
            this.dataPanel.revalidate();
            this.dataPanel.repaint();
        }
    }

    private ActionListener createOutputListener() {
        ActionListener outputListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                if (src.equals(DataViewUI.this.refreshButton)) {
                    DataViewUI.this.actionHandler.refreshActionPerformed();
                } else if (src.equals(DataViewUI.this.first)) {
                    DataViewUI.this.actionHandler.firstActionPerformed();
                } else if (src.equals(DataViewUI.this.last)) {
                    DataViewUI.this.actionHandler.lastActionPerformed();
                } else if (src.equals(DataViewUI.this.next)) {
                    DataViewUI.this.actionHandler.nextActionPerformed();
                } else if (src.equals(DataViewUI.this.previous)) {
                    DataViewUI.this.actionHandler.previousActionPerformed();
                } else if (src.equals(DataViewUI.this.refreshField)) {
                    DataViewUI.this.actionHandler.updateActionPerformed();
                } else if (src.equals(DataViewUI.this.commit)) {
                    DataViewUI.this.actionHandler.commitActionPerformed(false);
                } else if (src.equals(DataViewUI.this.cancel)) {
                    DataViewUI.this.actionHandler.cancelEditPerformed(false);
                } else if (src.equals(DataViewUI.this.deleteRow)) {
                    DataViewUI.this.actionHandler.deleteRecordActionPerformed();
                } else if (src.equals(DataViewUI.this.insert)) {
                    DataViewUI.this.actionHandler.insertActionPerformed();
                } else if (src.equals(DataViewUI.this.truncateButton)) {
                    DataViewUI.this.actionHandler.truncateActionPerformed();
                }
            }
        };
        return outputListener;
    }

    private void processButton(AbstractButton button) {
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setMargin(BUTTON_INSETS);
        if (button instanceof AbstractButton) {
            button.addMouseListener(sharedMouseListener);
        }
        button.setFocusable(false);
    }

    private void initToolbarWest(JToolBar toolbar, ActionListener outputListener, boolean nbOutputComponent) {
        if (!nbOutputComponent) {
            JButton[] btns;
            for (JButton btn : btns = this.getEditButtons()) {
                if (btn == null) continue;
                toolbar.add(btn);
            }
        }
        toolbar.addSeparator(new Dimension(10, 10));
        URL url = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "refresh.png");
        this.refreshButton = new JXButton((Icon)new ImageIcon(url));
        this.refreshButton.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_refresh"));
        this.refreshButton.addActionListener(outputListener);
        this.processButton((AbstractButton)this.refreshButton);
        toolbar.add((Component)this.refreshButton);
        url = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "navigate_beginning.png");
        this.first = new JXButton((Icon)new ImageIcon(url));
        this.first.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_first"));
        this.first.addActionListener(outputListener);
        this.first.setEnabled(false);
        this.processButton((AbstractButton)this.first);
        toolbar.add((Component)this.first);
        url = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "navigate_left.png");
        this.previous = new JXButton((Icon)new ImageIcon(url));
        this.previous.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_previous"));
        this.previous.addActionListener(outputListener);
        this.previous.setEnabled(false);
        this.processButton((AbstractButton)this.previous);
        toolbar.add((Component)this.previous);
        url = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "navigate_right.png");
        this.next = new JXButton((Icon)new ImageIcon(url));
        this.next.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_next"));
        this.next.addActionListener(outputListener);
        this.next.setEnabled(false);
        this.processButton((AbstractButton)this.next);
        toolbar.add((Component)this.next);
        url = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "navigate_end.png");
        this.last = new JXButton((Icon)new ImageIcon(url));
        this.last.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_last"));
        this.last.addActionListener(outputListener);
        this.last.setEnabled(false);
        toolbar.add((Component)this.last);
        this.processButton((AbstractButton)this.last);
        toolbar.addSeparator(new Dimension(10, 10));
        this.limitRow = new JXLabel(NbBundle.getMessage(DataViewUI.class, (String)"LBL_max_rows"));
        this.limitRow.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 8));
        toolbar.add((Component)this.limitRow);
        this.refreshField = new JTextField(5);
        this.refreshField.setMinimumSize(this.refreshField.getPreferredSize());
        this.refreshField.setMaximumSize(this.refreshField.getPreferredSize());
        this.refreshField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DataViewUI.this.refreshField.selectAll();
            }
        });
        this.refreshField.addActionListener(outputListener);
        toolbar.add(this.refreshField);
        toolbar.addSeparator(new Dimension(10, 10));
        JXLabel totalRowsNameLabel = new JXLabel(NbBundle.getMessage(DataViewUI.class, (String)"LBL_total_rows"));
        totalRowsNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DataViewUI.class, (String)"LBL_total_rows"));
        totalRowsNameLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        toolbar.add((Component)totalRowsNameLabel);
        this.totalRowsLabel = new JXLabel();
        toolbar.add((Component)this.totalRowsLabel);
        toolbar.addSeparator(new Dimension(10, 10));
    }

    private void initToolbarEast(JToolBar toolbar) {
        JXLabel matchBoxRow = new JXLabel(NbBundle.getMessage(DataViewUI.class, (String)"LBL_matchbox"));
        matchBoxRow.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 8));
        toolbar.add((Component)matchBoxRow);
        this.matchBoxField = new JTextField(10);
        this.matchBoxField.setText("");
        this.matchBoxField.setMinimumSize(new Dimension(35, this.matchBoxField.getHeight()));
        this.matchBoxField.setSize(35, this.matchBoxField.getHeight());
        this.matchBoxField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                DataViewUI.this.processKeyEvents();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                DataViewUI.this.processKeyEvents();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DataViewUI.this.processKeyEvents();
            }
        });
        toolbar.add(this.matchBoxField);
    }

    private void processKeyEvents() {
        DataViewTableUI table = this.getDataViewTableUI();
        int[] rows = new int[table.getColumnCount()];
        for (int i = 0; i < table.getColumnCount(); ++i) {
            rows[i] = i;
        }
        MultiColPatternFilter filterP = new MultiColPatternFilter(rows);
        filterP.setFilterStr(this.matchBoxField.getText(), SuperPatternFilter.MODE.LITERAL_FIND);
        table.setRowFilter(filterP);
    }

    private void initVerticalToolbar(ActionListener outputListener) {
        URL url = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "row_add.png");
        this.insert = new JXButton((Icon)new ImageIcon(url));
        this.insert.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_insert") + " (Alt+I)");
        this.insert.setMnemonic('I');
        this.insert.addActionListener(outputListener);
        this.insert.setEnabled(false);
        this.processButton((AbstractButton)this.insert);
        this.editButtons[0] = this.insert;
        url = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "row_delete.png");
        this.deleteRow = new JXButton((Icon)new ImageIcon(url));
        this.deleteRow.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_deleterow"));
        this.deleteRow.addActionListener(outputListener);
        this.deleteRow.setEnabled(false);
        this.processButton((AbstractButton)this.deleteRow);
        this.editButtons[1] = this.deleteRow;
        url = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "row_commit.png");
        this.commit = new JXButton((Icon)new ImageIcon(url));
        this.commit.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_commit_all"));
        this.commit.addActionListener(outputListener);
        this.commit.setEnabled(false);
        this.processButton((AbstractButton)this.commit);
        this.editButtons[2] = this.commit;
        url = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "cancel_edits.png");
        this.cancel = new JXButton((Icon)new ImageIcon(url));
        this.cancel.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_cancel_edits"));
        this.cancel.addActionListener(outputListener);
        this.cancel.setEnabled(false);
        this.processButton((AbstractButton)this.cancel);
        this.editButtons[3] = this.cancel;
        url = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "table_truncate.png");
        this.truncateButton = new JXButton((Icon)new ImageIcon(url));
        this.truncateButton.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_truncate_table") + " (Alt+T)");
        this.truncateButton.setMnemonic('T');
        this.truncateButton.addActionListener(outputListener);
        this.truncateButton.setEnabled(false);
        this.processButton((AbstractButton)this.truncateButton);
        this.editButtons[4] = this.truncateButton;
    }

    private JPanel initializeMainPanel(boolean nbOutputComponent) {
        JXPanel panel = new JXPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout((LayoutManager)new BoxLayout((Container)panel, 2));
        ActionListener outputListener = this.createOutputListener();
        this.initVerticalToolbar(outputListener);
        JToolBar toolbarWest = new JToolBar();
        toolbarWest.setFloatable(false);
        toolbarWest.setRollover(true);
        this.initToolbarWest(toolbarWest, outputListener, nbOutputComponent);
        JToolBar toolbarEast = new JToolBar();
        toolbarEast.setFloatable(false);
        toolbarEast.setRollover(true);
        this.initToolbarEast(toolbarEast);
        toolbarEast.setMinimumSize(toolbarWest.getPreferredSize());
        toolbarEast.setSize(toolbarWest.getPreferredSize());
        toolbarEast.setMaximumSize(toolbarWest.getPreferredSize());
        panel.add((Component)toolbarWest);
        panel.add(Box.createHorizontalGlue());
        panel.add((Component)toolbarEast);
        return panel;
    }

    public void enableDeleteBtn(boolean value) {
        this.deleteRow.setEnabled(value);
    }
}

