/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Component;
import java.sql.Blob;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.FormatStringValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.netbeans.modules.db.dataview.table.BlobCellRenderer;
import org.netbeans.modules.db.dataview.table.BooleanCellRenderer;
import org.netbeans.modules.db.dataview.table.CellFocusCustomRenderer;
import org.netbeans.modules.db.dataview.table.ClobCellRenderer;
import org.netbeans.modules.db.dataview.table.NullObjectCellRenderer;
import org.netbeans.modules.db.dataview.table.NumberObjectCellRenderer;
import org.netbeans.modules.db.dataview.table.SQLConstantsCellRenderer;
import org.netbeans.modules.db.dataview.util.DataViewUtils;

public class ResultSetCellRenderer
extends DefaultTableRenderer {
    protected static final FormatStringValue DATETIME_TO_STRING = new FormatStringValue(){

        public String getString(Object value) {
            if (this.format == null) {
                this.format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            }
            return super.getString(value);
        }
    };
    protected static final FormatStringValue TIME_TO_STRING = new FormatStringValue(){

        public String getString(Object value) {
            if (this.format == null) {
                this.format = new SimpleDateFormat("HH:mm:ss");
            }
            return super.getString(value);
        }
    };
    private final TableCellRenderer NULL_RENDERER = new NullObjectCellRenderer();
    private final TableCellRenderer DEFAULT_RENDERER = new SQLConstantsCellRenderer();
    private final TableCellRenderer NUMNBER_RENDERER = new NumberObjectCellRenderer();
    private final TableCellRenderer BOOLEAN_RENDERER = new BooleanCellRenderer();
    private final TableCellRenderer CELL_FOCUS_RENDERER = new CellFocusCustomRenderer();
    private final TableCellRenderer BLOB_RENDERER = new BlobCellRenderer();
    private final TableCellRenderer CLOB_RENDERER = new ClobCellRenderer();

    public ResultSetCellRenderer() {
        super(new StringValue(){

            public String getString(Object o) {
                return o == null ? "null" : o.toString();
            }
        });
    }

    public ResultSetCellRenderer(ComponentProvider<? extends JComponent> componentProvider) {
        super(componentProvider);
    }

    public ResultSetCellRenderer(StringValue converter, int alignment) {
        super(converter, alignment);
    }

    public ResultSetCellRenderer(StringValue converter) {
        super(converter, 10);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (null == value) {
            return this.NULL_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (value instanceof Number) {
            return this.NUMNBER_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (DataViewUtils.isSQLConstantString(value, null)) {
            Component c = this.DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setTableCellToolTip(c, value);
            return c;
        }
        if (value instanceof Boolean) {
            return this.BOOLEAN_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (value instanceof Blob) {
            return this.BLOB_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (value instanceof Clob) {
            return this.CLOB_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        Component c = this.CELL_FOCUS_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setTableCellToolTip(c, value);
        return c;
    }

    protected void setTableCellToolTip(Component c, Object value) {
        if (c instanceof JComponent) {
            if (value instanceof String) {
                String tooltip = "<html><table border=0 cellspacing=0 cellpadding=0 width=40><tr><td>";
                tooltip = tooltip + DataViewUtils.escapeHTML(value.toString()).replaceAll("\\n", "<br>").replaceAll(" ", "&nbsp;");
                tooltip = tooltip + "</td></tr></table></html>";
                ((JComponent)c).setToolTipText(tooltip);
            } else {
                ((JComponent)c).setToolTipText(value.toString());
            }
        }
    }
}

