/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope;

import fr.proline.mzscope.IMzScope;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.ui.MzScopePanel;
import fr.proline.mzscope.ui.RawFileManager;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzScope
implements IMzScope {
    private static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.mzScope");
    private MzScopePanel mzScopePanel;

    public JPanel createMzScopePanel(Frame frame) {
        this.mzScopePanel = new MzScopePanel(frame);
        return this.mzScopePanel;
    }

    @Override
    public void openRawAndExtract(File file, double moz, double elutionTime, double firstScanTime, double lastScanTime) {
        this.mzScopePanel.openRawAndExtract(file, moz, elutionTime, firstScanTime, lastScanTime);
    }

    @Override
    public void openRaw(File file, boolean display) {
        logger.debug("openRaw for " + file.getName());
        this.mzScopePanel.openRaw(Collections.singletonList(file), display);
    }

    @Override
    public void openRaw(List<File> files, boolean display) {
        logger.debug("openRaw for list");
        this.mzScopePanel.openRaw(files, display);
    }

    @Override
    public void detectPeakels(File file) {
        logger.debug("detectPeakel on " + file.getName());
        this.mzScopePanel.detectPeakels(Collections.singletonList(RawFileManager.getInstance().getFile(file.getName())));
    }

    @Override
    public void detectPeakels(List<File> fileList) {
        ArrayList<IRawFile> listRawFile = new ArrayList<IRawFile>();
        for (File file : fileList) {
            IRawFile rawFile = RawFileManager.getInstance().getFile(file.getName());
            listRawFile.add(rawFile);
        }
        this.mzScopePanel.detectPeakels(listRawFile);
    }
}

