/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.map.ui;

import fr.proline.mzscope.map.LcMsMapChunk;
import fr.proline.mzscope.map.LcMsViewport;
import fr.proline.mzscope.map.ui.LcMsViewerUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class JLcMsMapPanel
extends JPanel {
    private LcMsMapChunk chunk = null;
    private LcMsViewport viewport = null;
    private LcMsViewerUI ui = null;
    private static final int CELLSIZE = 10;
    private static final Color CELLCOLOR1 = new Color(250, 250, 250);
    private static final Color CELLCOLOR2 = new Color(230, 230, 240);

    public JLcMsMapPanel(LcMsViewerUI ui) {
        this.ui = ui;
    }

    public LcMsViewerUI getViewerUI() {
        return this.ui;
    }

    public LcMsMapChunk getChunk() {
        return this.chunk;
    }

    public void setChunk(LcMsMapChunk chunk) {
        this.chunk = chunk;
    }

    public LcMsViewport getViewport() {
        return this.viewport;
    }

    public void setViewport(LcMsViewport viewport) {
        this.viewport = this.getViewerUI().clampViewport(viewport);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paintComponent(g);
        for (int y = 0; y < this.getHeight(); y += 10) {
            for (int x = 0; x < this.getWidth(); x += 10) {
                g.setColor((x / 10 + y / 10) % 2 == 0 ? CELLCOLOR1 : CELLCOLOR2);
                g2.fillRect(x, y, 10, 10);
            }
        }
        if (this.chunk == null) {
            g2.drawString("no map to display", 10, 10);
            return;
        }
        if (this.viewport == null) {
            g2.drawString("no viewport set", 10, 10);
            return;
        }
        BufferedImage img = this.chunk.getLastImage();
        LcMsViewport chunkViewport = this.getChunk().getViewport();
        LcMsViewport displayViewport = this.getViewport();
        Point2D pMin = displayViewport.value2pixel(chunkViewport.minMz, chunkViewport.minRt, this.getWidth(), this.getHeight());
        double sx = (chunkViewport.maxRt - chunkViewport.minRt) / (displayViewport.maxRt - displayViewport.minRt);
        double sy = (chunkViewport.maxMz - chunkViewport.minMz) / (displayViewport.maxMz - displayViewport.minMz);
        AffineTransform transform = new AffineTransform();
        transform.translate(pMin.getX(), pMin.getY());
        transform.scale(sx, sy);
        g2.drawImage(img, transform, null);
        if (this.getViewerUI().getCurrentManipulator() != null) {
            this.getViewerUI().getCurrentManipulator().paintComponent(g2);
        }
    }
}

