/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.map.ui;

import fr.profi.mzdb.util.concurrent.Callback;
import fr.proline.mzscope.map.LcMsMapChunk;
import fr.proline.mzscope.map.LcMsViewer;
import fr.proline.mzscope.map.LcMsViewerEvent;
import fr.proline.mzscope.map.LcMsViewerListener;
import fr.proline.mzscope.map.LcMsViewport;
import fr.proline.mzscope.map.color.IntensityFirePainter;
import fr.proline.mzscope.map.color.IntensityPainter;
import fr.proline.mzscope.map.control.AbstractLcMsViewerManipulator;
import fr.proline.mzscope.map.control.LcMsViewerController;
import fr.proline.mzscope.map.control.LcMsViewerExtractorManipulator;
import fr.proline.mzscope.map.control.LcMsViewerManipulator;
import fr.proline.mzscope.map.control.LcMsViewerNavigateManipulator;
import fr.proline.mzscope.map.control.LcMsViewerSelectionManipulator;
import fr.proline.mzscope.map.math.Function1D;
import fr.proline.mzscope.map.math.Function1DComposite;
import fr.proline.mzscope.map.math.Function1DLinear;
import fr.proline.mzscope.map.math.Function1DLog;
import fr.proline.mzscope.map.ui.JLcMsMapPanel;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LcMsViewerUI
implements LcMsViewerListener,
ComponentListener,
ChangeListener,
KeyListener,
Callback<LcMsMapChunk> {
    private static final Insets INSETS = new Insets(2, 2, 2, 2);
    private static final int PADDING = 2;
    private static final int MAX_LUMINOSITY_FACTOR = 100;
    private static final NumberFormat viewportFormatter = new DecimalFormat("##0.####");
    private static final double MIN_MZ_ZOOM = 1.0;
    private static final double MIN_RT_ZOOM = 1.0;
    private LcMsViewer viewer = null;
    private LcMsViewerController controller = null;
    private LcMsMapChunk currentChunk = null;
    private JPanel root = null;
    private JToolBar toolbar = null;
    private JTextField minRtTextField = null;
    private JTextField maxRtTextField = null;
    private JTextField minMzTextField = null;
    private JTextField maxMzTextField = null;
    private List<LcMsViewerManipulator> manipulators = new ArrayList<LcMsViewerManipulator>();
    private IntensityPainter painter = new IntensityFirePainter();
    private JSlider luminosityFactorSlider = null;
    private JLabel updateLabel = null;
    private JLabel mouseInformationLabel = null;
    private LcMsViewport displayViewport = null;
    private JLcMsMapPanel canvas = null;
    private Function1D selectedFunction = null;
    private Action reinitViewportAction = null;
    private Action updateImageAction = null;
    private ImageIcon loadingIcon = IconManager.getIcon((IconManager.IconType)IconManager.IconType.PROGRESS);
    private ImageIcon fullscreenIcon = IconManager.getIcon((IconManager.IconType)IconManager.IconType.FULL_SCREEN);
    private ImageIcon updateIcon = IconManager.getIcon((IconManager.IconType)IconManager.IconType.UPDATE);

    public LcMsViewerUI() {
        this.controller = new LcMsViewerController();
        this.controller.setUI(this);
        this.manipulators.add(new LcMsViewerNavigateManipulator(this.controller));
        this.manipulators.add(new LcMsViewerSelectionManipulator(this.controller));
        this.manipulators.add(new LcMsViewerExtractorManipulator(this.controller));
    }

    public LcMsViewerUI(LcMsViewer viewer) {
        this();
        this.setViewer(viewer);
    }

    public LcMsViewer getViewer() {
        return this.viewer;
    }

    public LcMsViewerController getController() {
        return this.controller;
    }

    public void setViewer(LcMsViewer viewer) {
        if (this.viewer != null) {
            this.viewer.removeLcMsViewerListener(this);
        }
        this.viewer = viewer;
        if (this.viewer != null) {
            this.controller.setViewer(viewer);
            this.viewer.addLcMsViewerListener(this);
        }
    }

    private void updateUI() {
        if (this.getViewer() == null) {
            return;
        }
        this.updateViewportUI();
        this.updateProgressUI();
        if (this.getViewer().getMap() == null) {
            return;
        }
        this.getViewer().requestNewImage(this.getCanvas().getWidth(), this.getCanvas().getHeight(), this.getLuminosityFunction(), new LcMsViewport(this.getDisplayViewport()), this, this.painter);
    }

    public IntensityPainter getPainter() {
        return this.painter;
    }

    public LcMsMapChunk getChunk() {
        return this.currentChunk;
    }

    public void setChunk(LcMsMapChunk currentChunk) {
        this.currentChunk = currentChunk;
        this.getCanvas().setChunk(currentChunk);
    }

    private void displayChunk() {
        this.updateViewportUI();
        this.getCanvas().repaint();
    }

    public LcMsViewport getDisplayViewport() {
        return this.displayViewport;
    }

    public void setDisplayViewport(LcMsViewport viewport) {
        this.displayViewport = this.clampViewport(viewport);
        this.getCanvas().setViewport(this.displayViewport);
        this.displayChunk();
    }

    public LcMsViewport clampViewport(LcMsViewport viewport) {
        LcMsViewport clampedViewport = new LcMsViewport(viewport);
        clampedViewport.minMz = Math.max(clampedViewport.minMz, this.getViewer().getMapViewport().minMz);
        clampedViewport.minRt = Math.max(clampedViewport.minRt, this.getViewer().getMapViewport().minRt);
        clampedViewport.maxMz = Math.min(clampedViewport.maxMz, this.getViewer().getMapViewport().maxMz);
        clampedViewport.maxRt = Math.min(clampedViewport.maxRt, this.getViewer().getMapViewport().maxRt);
        if (clampedViewport.maxMz - clampedViewport.minMz < 1.0) {
            clampedViewport.minMz = (clampedViewport.maxMz + clampedViewport.minMz) / 2.0 - 0.5;
            clampedViewport.maxMz = (clampedViewport.maxMz + clampedViewport.minMz) / 2.0 + 0.5;
        }
        if (clampedViewport.maxRt - clampedViewport.minRt < 1.0) {
            clampedViewport.minRt = (clampedViewport.maxRt + clampedViewport.minRt) / 2.0 - 0.5;
            clampedViewport.maxRt = (clampedViewport.maxRt + clampedViewport.minRt) / 2.0 + 0.5;
        }
        return clampedViewport;
    }

    public void updateMouseInformationUI(final int x, final int y) {
        if (this.getDisplayViewport() == null) {
            return;
        }
        if (this.getCanvas() == null) {
            return;
        }
        Point2D cursorValues = this.getDisplayViewport().pixel2value(x, y, this.getCanvas().getWidth(), this.getCanvas().getHeight());
        final double rt = cursorValues.getY();
        final double mz = cursorValues.getX();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LcMsViewerUI.this.getMouseInformationLabel().setText("pixel: " + x + "x" + y + " on " + LcMsViewerUI.this.getCanvas().getWidth() + "x" + LcMsViewerUI.this.getCanvas().getHeight() + "\nrt: " + rt + " m/z:" + mz);
            }
        });
    }

    private void updateProgressUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LcMsViewerUI.this.getUpdateLabel().setVisible(LcMsViewerUI.this.getViewer().getRunningTaskCount() != 0);
            }
        });
    }

    private void updateViewportUI() {
        if (this.getViewer() == null) {
            return;
        }
        final LcMsViewport viewport = this.getDisplayViewport();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (viewport == null) {
                    LcMsViewerUI.this.getMinMzTextField().setText("-");
                    LcMsViewerUI.this.getMaxMzTextField().setText("-");
                    LcMsViewerUI.this.getMinRtTextField().setText("-");
                    LcMsViewerUI.this.getMaxRtTextField().setText("-");
                    return;
                }
                LcMsViewerUI.this.getMinMzTextField().setText(viewportFormatter.format(viewport.minMz));
                LcMsViewerUI.this.getMaxMzTextField().setText(viewportFormatter.format(viewport.maxMz));
                LcMsViewerUI.this.getMinRtTextField().setText(viewportFormatter.format(viewport.minRt));
                LcMsViewerUI.this.getMaxRtTextField().setText(viewportFormatter.format(viewport.maxRt));
            }
        });
    }

    public JComponent getGui() {
        return this.getRoot();
    }

    private JPanel getRoot() {
        if (this.root == null) {
            this.root = new JPanel(new BorderLayout());
            this.root.add(this.getViewPanel(), "Center");
            this.root.add(this.getToolPanel(), "East");
            this.root.add(this.getInfoPanel(), "South");
            this.root.addComponentListener(this);
        }
        return this.root;
    }

    private Component getViewPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEtchedBorder(1));
        panel.add((Component)this.getUpdateLabel(), Util.dc(0, 0, 1, 1, 0.0f, 0.0f));
        panel.add((Component)this.getMinRtTextField(), Util.dc(1, 0, 1, 1, 0.0f, 0.0f));
        panel.add((Component)this.getToolbar(), Util.dc(2, 0, 1, 1, 1.0f, 0.0f));
        panel.add((Component)this.getMaxRtTextField(), Util.dc(3, 0, 1, 1, 0.0f, 0.0f));
        panel.add((Component)this.getMinMzTextField(), Util.dc(0, 1, 1, 1, 0.0f, 0.0f));
        panel.add(Box.createVerticalGlue(), Util.dc(0, 2, 1, 1, 0.0f, 1.0f));
        panel.add((Component)this.getMaxMzTextField(), Util.dc(0, 3, 1, 1, 0.0f, 0.0f));
        panel.add((Component)this.getCanvas(), Util.dc(1, 1, 3, 3, 1.0f, 1.0f));
        return panel;
    }

    private Component getToolPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEtchedBorder(1));
        panel.add((Component)this.getLuminosityFactorSlider(), Util.dc(0, 0, 1, 1, 0.0f, 1.0f));
        final JComboBox<Function1D> logScaleComboBox = new JComboBox<Function1D>();
        this.selectedFunction = new Function1DLinear(1.0, 0.0);
        logScaleComboBox.addItem(this.selectedFunction);
        logScaleComboBox.addItem(new Function1DComposite(new Function1DLog(10.0), new Function1DLinear(1.0, 1.0)));
        logScaleComboBox.addItem(new Function1DComposite(new Function1DLog(2.0), new Function1DLinear(1.0, 1.0)));
        panel.add(logScaleComboBox, Util.dc(0, 1, 1, 1, 0.0f, 0.0f));
        logScaleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LcMsViewerUI.this.selectedFunction = (Function1D)logScaleComboBox.getSelectedItem();
                LcMsViewerUI.this.getController().updateImageColor(LcMsViewerUI.this.getDisplayViewport());
            }
        });
        return panel;
    }

    private Component getInfoPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEtchedBorder(1));
        panel.add((Component)this.getMouseInformationLabel(), Util.dc(0, 0, 1, 1, 1.0f, 0.0f));
        return panel;
    }

    public JSlider getLuminosityFactorSlider() {
        if (this.luminosityFactorSlider == null) {
            this.luminosityFactorSlider = new JSlider();
            this.luminosityFactorSlider.setOrientation(1);
            this.luminosityFactorSlider.setMinimum(-100);
            this.luminosityFactorSlider.setMaximum(100);
            this.luminosityFactorSlider.setValue(0);
            this.luminosityFactorSlider.setMajorTickSpacing(100);
            this.luminosityFactorSlider.setMinorTickSpacing(10);
            this.luminosityFactorSlider.setPaintTicks(true);
            this.luminosityFactorSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    LcMsViewerUI.this.getController().updateImageColor(LcMsViewerUI.this.getDisplayViewport());
                }
            });
        }
        return this.luminosityFactorSlider;
    }

    public double getLuminosityFactor() {
        return 1.0 + Math.tan(1.57 * (double)this.getLuminosityFactorSlider().getValue() / 100.0);
    }

    public Function1D getSelectedFunction() {
        return this.selectedFunction;
    }

    public Function1D getLuminosityFunction() {
        return new Function1DComposite(new Function1DLinear(this.getLuminosityFactor(), 0.0), this.getSelectedFunction());
    }

    private JToolBar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
            this.toolbar.setRollover(true);
            this.toolbar.setOrientation(0);
            JButton initButton = new JButton();
            initButton.setAction(this.getInitViewportAction());
            initButton.setIcon(this.fullscreenIcon);
            this.toolbar.add(initButton);
            JButton updateButton = new JButton();
            updateButton.setAction(this.getUpdateViewportAction());
            updateButton.setIcon(this.updateIcon);
            this.toolbar.add(updateButton);
            ButtonGroup group = new ButtonGroup();
            for (final LcMsViewerManipulator manipulator : this.manipulators) {
                group.add(manipulator.getUIButton());
                this.toolbar.add(manipulator.getUIButton());
                ((AbstractLcMsViewerManipulator)manipulator).setDrawingPanel(this.getCanvas());
                manipulator.getUIButton().addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        if (manipulator.getUIButton().isSelected()) {
                            LcMsViewerUI.this.getController().setManipulator(manipulator);
                            LcMsViewerUI.this.getCanvas().repaint();
                        }
                    }
                });
            }
            this.manipulators.get(0).getUIButton().setSelected(true);
        }
        return this.toolbar;
    }

    public LcMsViewerManipulator getCurrentManipulator() {
        for (LcMsViewerManipulator manipulator : this.manipulators) {
            if (!manipulator.getUIButton().isSelected()) continue;
            return manipulator;
        }
        return null;
    }

    private JTextField getMinRtTextField() {
        if (this.minRtTextField == null) {
            this.minRtTextField = new JTextField("0000.0000");
            this.minRtTextField.setPreferredSize(new Dimension(80, 25));
            this.minRtTextField.addKeyListener(this);
        }
        return this.minRtTextField;
    }

    private JTextField getMaxRtTextField() {
        if (this.maxRtTextField == null) {
            this.maxRtTextField = new JTextField("0000.0000");
            this.maxRtTextField.setPreferredSize(new Dimension(80, 25));
            this.maxRtTextField.addKeyListener(this);
        }
        return this.maxRtTextField;
    }

    private JTextField getMinMzTextField() {
        if (this.minMzTextField == null) {
            this.minMzTextField = new JTextField("0000.0000");
            this.minMzTextField.setPreferredSize(new Dimension(80, 25));
            this.minMzTextField.addKeyListener(this);
        }
        return this.minMzTextField;
    }

    private JTextField getMaxMzTextField() {
        if (this.maxMzTextField == null) {
            this.maxMzTextField = new JTextField("0000.0000");
            this.maxMzTextField.setPreferredSize(new Dimension(80, 25));
            this.maxMzTextField.addKeyListener(this);
        }
        return this.maxMzTextField;
    }

    public JLcMsMapPanel getCanvas() {
        if (this.canvas == null) {
            this.canvas = new JLcMsMapPanel(this);
            this.canvas.setBorder(BorderFactory.createEtchedBorder(1));
            this.canvas.addMouseListener(this.controller);
            this.canvas.addMouseMotionListener(this.controller);
            this.canvas.addMouseWheelListener(this.controller);
        }
        return this.canvas;
    }

    private JLabel getUpdateLabel() {
        if (this.updateLabel == null) {
            this.updateLabel = new JLabel(this.loadingIcon);
            this.updateLabel.setVisible(false);
        }
        return this.updateLabel;
    }

    private JLabel getMouseInformationLabel() {
        if (this.mouseInformationLabel == null) {
            this.mouseInformationLabel = new JLabel("no mouse information");
        }
        return this.mouseInformationLabel;
    }

    @Override
    public void onLcMsViewerEvent(LcMsViewerEvent e) {
        switch (e.getType()) {
            case MAP_CHANGED: {
                this.viewerMapChanged();
                break;
            }
            case VIEWPORT_CHANGED: {
                this.viewerViewportChanged();
                break;
            }
            case IMAGE_PROCESS_ADDED: {
                this.getUpdateLabel().setVisible(true);
                break;
            }
        }
        throw new UnsupportedOperationException("event not handled");
    }

    private void viewerViewportChanged() {
        throw new UnsupportedOperationException("viewport changed. Update view");
    }

    private void viewerMapChanged() {
        throw new UnsupportedOperationException("map changed. Update view");
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getComponent() == this.getRoot()) {
            this.updateUI();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    public LcMsMapChunk getCurrentChunk() {
        return this.currentChunk;
    }

    @Override
    public void onCompletion(LcMsMapChunk chunk) {
        if (chunk != null) {
            this.updateProgressUI();
            if (this.getCurrentChunk() != null && this.getCurrentChunk().getCreationTime().getTime() > chunk.getCreationTime().getTime()) {
                return;
            }
            this.setChunk(chunk);
            this.displayChunk();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if ((e.getSource() == this.getMinMzTextField() || e.getSource() == this.getMaxMzTextField() || e.getSource() == this.getMinRtTextField() || e.getSource() == this.getMaxRtTextField()) && e.getKeyCode() == 10) {
            double maxRt;
            double minRt;
            double maxMz;
            double minMz;
            System.out.println("update view");
            try {
                minMz = this.parseDouble(this.getMinMzTextField().getText());
            }
            catch (NumberFormatException e1) {
                minMz = this.getDisplayViewport().minMz;
                this.logError(e1.getMessage());
            }
            try {
                maxMz = this.parseDouble(this.getMaxMzTextField().getText());
            }
            catch (NumberFormatException e1) {
                maxMz = this.getDisplayViewport().maxMz;
                this.logError(e1.getMessage());
            }
            try {
                minRt = this.parseDouble(this.getMinRtTextField().getText());
            }
            catch (NumberFormatException e1) {
                minRt = this.getDisplayViewport().minRt;
                this.logError(e1.getMessage());
            }
            try {
                maxRt = this.parseDouble(this.getMaxRtTextField().getText());
            }
            catch (NumberFormatException e1) {
                maxRt = this.getDisplayViewport().maxRt;
                this.logError(e1.getMessage());
            }
            this.getController().changeViewport(minMz, maxMz, minRt, maxRt);
        }
    }

    private void logError(String message) {
        System.err.println(message);
    }

    private double parseDouble(String str) throws NumberFormatException {
        try {
            NumberFormat format = NumberFormat.getInstance(Locale.FRANCE);
            return format.parse(str).doubleValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
            try {
                NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);
                return format.parse(str).doubleValue();
            }
            catch (ParseException e2) {
                e2.printStackTrace();
                throw new NumberFormatException("String '" + str + "' is not a valid number");
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private Action getInitViewportAction() {
        if (this.reinitViewportAction == null) {
            this.reinitViewportAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LcMsViewerUI.this.getController().reinitViewport();
                }
            };
        }
        return this.reinitViewportAction;
    }

    private Action getUpdateViewportAction() {
        if (this.updateImageAction == null) {
            this.updateImageAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LcMsViewerUI.this.getController().updateViewport();
                }
            };
        }
        return this.updateImageAction;
    }

    public static class Util {
        private static GridBagConstraints dc(int gridx, int gridy, int gridwidth, int gridheight, float weightx, float weighty) {
            return new GridBagConstraints(gridx, gridy, gridwidth, gridheight, weightx, weighty, 10, 1, INSETS, 2, 2);
        }
    }
}

