/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.model;

import fr.profi.mzdb.model.SpectrumData;

public class Spectrum {
    private String title;
    private Integer index;
    private int msLevel;
    private ScanType dataType;
    private float retentionTime;
    private double[] masses;
    private float[] intensities;
    private SpectrumData spectrumData;
    private Double precursorMz;
    private Integer precursorCharge;

    public Spectrum(Integer index, float rt, double[] masses, float[] intensities, int msLevel) {
        this(index, rt, masses, intensities, msLevel, msLevel == 2 ? ScanType.CENTROID : ScanType.PROFILE);
    }

    public Spectrum(Integer index, float rt, double[] masses, float[] intensities, int msLevel, ScanType type) {
        this.index = index;
        this.masses = masses;
        this.intensities = intensities;
        this.retentionTime = rt;
        this.msLevel = msLevel;
        this.dataType = type;
        this.spectrumData = new SpectrumData(this.masses, this.intensities);
    }

    public double[] getMasses() {
        return this.masses;
    }

    public float[] getIntensities() {
        return this.intensities;
    }

    public Integer getIndex() {
        return this.index;
    }

    public float getRetentionTime() {
        return this.retentionTime;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getMsLevel() {
        return this.msLevel;
    }

    public SpectrumData getSpectrumData() {
        return this.spectrumData;
    }

    public void setSpectrumData(SpectrumData spectrumData) {
        this.spectrumData = spectrumData;
    }

    public ScanType getDataType() {
        return this.dataType;
    }

    public Double getPrecursorMz() {
        return this.precursorMz;
    }

    public void setPrecursorMz(Double precursorMz) {
        this.precursorMz = precursorMz;
    }

    public Integer getPrecursorCharge() {
        return this.precursorCharge;
    }

    public void setPrecursorCharge(Integer precursorCharge) {
        this.precursorCharge = precursorCharge;
    }

    public static enum ScanType {
        CENTROID,
        PROFILE;

    }
}

