/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.mzdb;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.profi.mzdb.FeatureDetectorConfig;
import fr.profi.mzdb.MzDbFeatureDetector;
import fr.profi.mzdb.MzDbFeatureExtractor;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.PeakelFinderConfig;
import fr.profi.mzdb.SmartPeakelFinderConfig;
import fr.profi.mzdb.XicMethod;
import fr.profi.mzdb.algo.feature.extraction.FeatureExtractorConfig;
import fr.profi.mzdb.io.reader.provider.RunSliceDataProvider;
import fr.profi.mzdb.model.AcquisitionMode;
import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PutativeFeature;
import fr.profi.mzdb.model.RunSlice;
import fr.profi.mzdb.model.SpectrumHeader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import scala.Option;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class Main {
    public static void main(String[] args) {
        String filepath = "D:\\DEV\\TimsTof\\example_data\\200ngHeLaPASEF_2min_compressed.mzdb";
        try {
            long start = System.currentTimeMillis();
            MzDbReader reader = new MzDbReader(filepath, true);
            System.out.println("Ohh ... File mzDb read in :: " + (System.currentTimeMillis() - start) + " ms");
            int[] range = reader.getMzRange(1);
            System.out.println("MS mz Range :: " + range[0] + "-" + range[1]);
            range = reader.getMzRange(2);
            System.out.println("MS2 mz Range :: " + range[0] + "-" + range[1]);
            start = System.currentTimeMillis();
            AcquisitionMode acqMode = reader.getAcquisitionMode();
            if (acqMode != null && acqMode.equals((Object)AcquisitionMode.SWATH)) {
                System.out.println("this is a DIA file");
            }
            float tolPPM = 5.0f;
            Iterator<RunSlice> runSlices = reader.getLcMsnRunSliceIterator(450.0, 455.0, 200.0, 1000.0);
            FeatureDetectorConfig detectorConfig = new FeatureDetectorConfig(2, tolPPM, 5, 0.9f, 3, (PeakelFinderConfig)new SmartPeakelFinderConfig(5, 3, 0.75f, false, 10, false, false, true));
            MzDbFeatureDetector detector = new MzDbFeatureDetector(reader, detectorConfig);
            Peakel[] peakels = detector.detectPeakels(runSlices, Option.apply((Object)1));
            FeatureExtractorConfig extractorConfig = new FeatureExtractorConfig(tolPPM, 5, 1, 3, 1200.0f, 0.05f, Option.empty(), 90, Option.empty());
            MzDbFeatureExtractor extractor = new MzDbFeatureExtractor(reader, 5, 5, extractorConfig);
            System.out.println("retrieve scan headers  ...");
            Object[] spectrumHeaders = reader.getSpectrumHeaders();
            UnmodifiableIterator ms2SpectrumHeaders = Iterators.filter((Iterator)Iterators.forArray((Object[])spectrumHeaders), (Predicate)new Predicate<SpectrumHeader>(){

                public boolean apply(SpectrumHeader sh) {
                    return sh.getMsLevel() == 2;
                }
            });
            ArrayList<PutativeFeature> pfs = new ArrayList<PutativeFeature>();
            System.out.println("building putative features list from MS2 scan events...");
            while (ms2SpectrumHeaders.hasNext()) {
                SpectrumHeader scanH = (SpectrumHeader)ms2SpectrumHeaders.next();
                if (!(scanH.getElutionTime() > 1800.0f) || !(scanH.getElutionTime() > 1980.0f)) continue;
                pfs.add(new PutativeFeature(PutativeFeature.generateNewId(), scanH.getPrecursorMz(), scanH.getPrecursorCharge(), scanH.getId(), 2));
            }
            RunSliceDataProvider rsdProv = new RunSliceDataProvider(reader.getLcMsRunSliceIterator());
            List mzDbFts = JavaConversions.seqAsJavaList((Seq)extractor.extractFeatures(rsdProv, (Seq)JavaConversions.asScalaBuffer(pfs), tolPPM));
            System.out.println("Elapsed time (ms) = " + (System.currentTimeMillis() - start));
            for (Feature f : mzDbFts) {
                System.out.println(f.getMz() + " - " + f.getArea());
            }
            System.out.println("Select feature number 4 = ");
            Feature f = (Feature)mzDbFts.get(4);
            System.out.println("Feature m/z: " + f.getMz());
            System.out.println("Feature range: " + (f.getMz() - f.getMz() * (double)tolPPM / 1000000.0) + "-" + (f.getMz() + f.getMz() * (double)tolPPM / 1000000.0));
            System.out.println("Feature retentionTime: " + (double)f.getElutionTime() / 60.0);
            System.out.println("Feature intentitySum: " + f.getIntensitySum());
            System.out.println("Feature area: " + f.getArea());
            System.out.println("Extract IChromatogram from selected feature ...");
            Peak[] chromato = reader.getMsXicInMzRange(f.getMz() - f.getMz() * (double)tolPPM / 1000000.0, f.getMz() + f.getMz() * (double)tolPPM / 1000000.0, XicMethod.SUM);
            System.out.println("Chromato length: " + chromato.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            System.load("D:\\DEV\\sqlite4java-win32-x64-1.0.392.dll");
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Native code library failed to load.\n" + e);
            System.exit(1);
        }
    }
}

